/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.honeycode.model.HoneycodeRequest;
import software.amazon.awssdk.services.honeycode.model.UpdateRowData;
import software.amazon.awssdk.services.honeycode.model.UpdateRowDataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdateTableRowsRequest
extends HoneycodeRequest
implements ToCopyableBuilder<Builder, BatchUpdateTableRowsRequest> {
    private static final SdkField<String> WORKBOOK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workbookId").getter(BatchUpdateTableRowsRequest.getter(BatchUpdateTableRowsRequest::workbookId)).setter(BatchUpdateTableRowsRequest.setter(Builder::workbookId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workbookId").build()}).build();
    private static final SdkField<String> TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tableId").getter(BatchUpdateTableRowsRequest.getter(BatchUpdateTableRowsRequest::tableId)).setter(BatchUpdateTableRowsRequest.setter(Builder::tableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("tableId").build()}).build();
    private static final SdkField<List<UpdateRowData>> ROWS_TO_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rowsToUpdate").getter(BatchUpdateTableRowsRequest.getter(BatchUpdateTableRowsRequest::rowsToUpdate)).setter(BatchUpdateTableRowsRequest.setter(Builder::rowsToUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rowsToUpdate").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpdateRowData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(BatchUpdateTableRowsRequest.getter(BatchUpdateTableRowsRequest::clientRequestToken)).setter(BatchUpdateTableRowsRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKBOOK_ID_FIELD, TABLE_ID_FIELD, ROWS_TO_UPDATE_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private final String workbookId;
    private final String tableId;
    private final List<UpdateRowData> rowsToUpdate;
    private final String clientRequestToken;

    private BatchUpdateTableRowsRequest(BuilderImpl builder) {
        super(builder);
        this.workbookId = builder.workbookId;
        this.tableId = builder.tableId;
        this.rowsToUpdate = builder.rowsToUpdate;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public final String workbookId() {
        return this.workbookId;
    }

    public final String tableId() {
        return this.tableId;
    }

    public final boolean hasRowsToUpdate() {
        return this.rowsToUpdate != null && !(this.rowsToUpdate instanceof SdkAutoConstructList);
    }

    public final List<UpdateRowData> rowsToUpdate() {
        return this.rowsToUpdate;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workbookId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRowsToUpdate() ? this.rowsToUpdate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateTableRowsRequest)) {
            return false;
        }
        BatchUpdateTableRowsRequest other = (BatchUpdateTableRowsRequest)((Object)obj);
        return Objects.equals(this.workbookId(), other.workbookId()) && Objects.equals(this.tableId(), other.tableId()) && this.hasRowsToUpdate() == other.hasRowsToUpdate() && Objects.equals(this.rowsToUpdate(), other.rowsToUpdate()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public final String toString() {
        return ToString.builder((String)"BatchUpdateTableRowsRequest").add("WorkbookId", (Object)this.workbookId()).add("TableId", (Object)this.tableId()).add("RowsToUpdate", this.hasRowsToUpdate() ? this.rowsToUpdate() : null).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workbookId": {
                return Optional.ofNullable(clazz.cast(this.workbookId()));
            }
            case "tableId": {
                return Optional.ofNullable(clazz.cast(this.tableId()));
            }
            case "rowsToUpdate": {
                return Optional.ofNullable(clazz.cast(this.rowsToUpdate()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateTableRowsRequest, T> g) {
        return obj -> g.apply((BatchUpdateTableRowsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends HoneycodeRequest.BuilderImpl
    implements Builder {
        private String workbookId;
        private String tableId;
        private List<UpdateRowData> rowsToUpdate = DefaultSdkAutoConstructList.getInstance();
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateTableRowsRequest model) {
            super(model);
            this.workbookId(model.workbookId);
            this.tableId(model.tableId);
            this.rowsToUpdate(model.rowsToUpdate);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getWorkbookId() {
            return this.workbookId;
        }

        public final void setWorkbookId(String workbookId) {
            this.workbookId = workbookId;
        }

        @Override
        @Transient
        public final Builder workbookId(String workbookId) {
            this.workbookId = workbookId;
            return this;
        }

        public final String getTableId() {
            return this.tableId;
        }

        public final void setTableId(String tableId) {
            this.tableId = tableId;
        }

        @Override
        @Transient
        public final Builder tableId(String tableId) {
            this.tableId = tableId;
            return this;
        }

        public final List<UpdateRowData.Builder> getRowsToUpdate() {
            List<UpdateRowData.Builder> result = UpdateRowDataListCopier.copyToBuilder(this.rowsToUpdate);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRowsToUpdate(Collection<UpdateRowData.BuilderImpl> rowsToUpdate) {
            this.rowsToUpdate = UpdateRowDataListCopier.copyFromBuilder(rowsToUpdate);
        }

        @Override
        @Transient
        public final Builder rowsToUpdate(Collection<UpdateRowData> rowsToUpdate) {
            this.rowsToUpdate = UpdateRowDataListCopier.copy(rowsToUpdate);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder rowsToUpdate(UpdateRowData ... rowsToUpdate) {
            this.rowsToUpdate(Arrays.asList(rowsToUpdate));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder rowsToUpdate(Consumer<UpdateRowData.Builder> ... rowsToUpdate) {
            this.rowsToUpdate(Stream.of(rowsToUpdate).map(c -> (UpdateRowData)((UpdateRowData.Builder)UpdateRowData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        @Transient
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateTableRowsRequest build() {
            return new BatchUpdateTableRowsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends HoneycodeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchUpdateTableRowsRequest> {
        public Builder workbookId(String var1);

        public Builder tableId(String var1);

        public Builder rowsToUpdate(Collection<UpdateRowData> var1);

        public Builder rowsToUpdate(UpdateRowData ... var1);

        public Builder rowsToUpdate(Consumer<UpdateRowData.Builder> ... var1);

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

