/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.honeycode.model.DataItem;
import software.amazon.awssdk.services.honeycode.model.DataItemsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResultRow
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResultRow> {
    private static final SdkField<String> ROW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rowId").getter(ResultRow.getter(ResultRow::rowId)).setter(ResultRow.setter(Builder::rowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rowId").build()}).build();
    private static final SdkField<List<DataItem>> DATA_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dataItems").getter(ResultRow.getter(ResultRow::dataItems)).setter(ResultRow.setter(Builder::dataItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROW_ID_FIELD, DATA_ITEMS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String rowId;
    private final List<DataItem> dataItems;

    private ResultRow(BuilderImpl builder) {
        this.rowId = builder.rowId;
        this.dataItems = builder.dataItems;
    }

    public final String rowId() {
        return this.rowId;
    }

    public final boolean hasDataItems() {
        return this.dataItems != null && !(this.dataItems instanceof SdkAutoConstructList);
    }

    public final List<DataItem> dataItems() {
        return this.dataItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataItems() ? this.dataItems() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultRow)) {
            return false;
        }
        ResultRow other = (ResultRow)obj;
        return Objects.equals(this.rowId(), other.rowId()) && this.hasDataItems() == other.hasDataItems() && Objects.equals(this.dataItems(), other.dataItems());
    }

    public final String toString() {
        return ToString.builder((String)"ResultRow").add("RowId", (Object)this.rowId()).add("DataItems", (Object)(this.dataItems() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "rowId": {
                return Optional.ofNullable(clazz.cast(this.rowId()));
            }
            case "dataItems": {
                return Optional.ofNullable(clazz.cast(this.dataItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResultRow, T> g) {
        return obj -> g.apply((ResultRow)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String rowId;
        private List<DataItem> dataItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResultRow model) {
            this.rowId(model.rowId);
            this.dataItems(model.dataItems);
        }

        public final String getRowId() {
            return this.rowId;
        }

        public final void setRowId(String rowId) {
            this.rowId = rowId;
        }

        @Override
        @Transient
        public final Builder rowId(String rowId) {
            this.rowId = rowId;
            return this;
        }

        public final List<DataItem.Builder> getDataItems() {
            List<DataItem.Builder> result = DataItemsCopier.copyToBuilder(this.dataItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataItems(Collection<DataItem.BuilderImpl> dataItems) {
            this.dataItems = DataItemsCopier.copyFromBuilder(dataItems);
        }

        @Override
        @Transient
        public final Builder dataItems(Collection<DataItem> dataItems) {
            this.dataItems = DataItemsCopier.copy(dataItems);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dataItems(DataItem ... dataItems) {
            this.dataItems(Arrays.asList(dataItems));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dataItems(Consumer<DataItem.Builder> ... dataItems) {
            this.dataItems(Stream.of(dataItems).map(c -> (DataItem)((DataItem.Builder)DataItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ResultRow build() {
            return new ResultRow(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResultRow> {
        public Builder rowId(String var1);

        public Builder dataItems(Collection<DataItem> var1);

        public Builder dataItems(DataItem ... var1);

        public Builder dataItems(Consumer<DataItem.Builder> ... var1);
    }
}

