/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input variables to the app to be used by the InvokeScreenAutomation action request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VariableValue implements SdkPojo, Serializable, ToCopyableBuilder<VariableValue.Builder, VariableValue> {
    private static final SdkField<String> RAW_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("rawValue").getter(getter(VariableValue::rawValue)).setter(setter(Builder::rawValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rawValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RAW_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String rawValue;

    private VariableValue(BuilderImpl builder) {
        this.rawValue = builder.rawValue;
    }

    /**
     * <p>
     * Raw value of the variable.
     * </p>
     * 
     * @return Raw value of the variable.
     */
    public final String rawValue() {
        return rawValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rawValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VariableValue)) {
            return false;
        }
        VariableValue other = (VariableValue) obj;
        return Objects.equals(rawValue(), other.rawValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VariableValue").add("RawValue", rawValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "rawValue":
            return Optional.ofNullable(clazz.cast(rawValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VariableValue, T> g) {
        return obj -> g.apply((VariableValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VariableValue> {
        /**
         * <p>
         * Raw value of the variable.
         * </p>
         * 
         * @param rawValue
         *        Raw value of the variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rawValue(String rawValue);
    }

    static final class BuilderImpl implements Builder {
        private String rawValue;

        private BuilderImpl() {
        }

        private BuilderImpl(VariableValue model) {
            rawValue(model.rawValue);
        }

        public final String getRawValue() {
            return rawValue;
        }

        public final void setRawValue(String rawValue) {
            this.rawValue = rawValue;
        }

        @Override
        @Transient
        public final Builder rawValue(String rawValue) {
            this.rawValue = rawValue;
            return this;
        }

        @Override
        public VariableValue build() {
            return new VariableValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
