/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.honeycode.model.RowIdListCopier;
import software.amazon.awssdk.services.honeycode.model.UpsertAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpsertRowsResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpsertRowsResult> {
    private static final SdkField<List<String>> ROW_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rowIds").getter(UpsertRowsResult.getter(UpsertRowsResult::rowIds)).setter(UpsertRowsResult.setter(Builder::rowIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rowIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> UPSERT_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("upsertAction").getter(UpsertRowsResult.getter(UpsertRowsResult::upsertActionAsString)).setter(UpsertRowsResult.setter(Builder::upsertAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upsertAction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROW_IDS_FIELD, UPSERT_ACTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> rowIds;
    private final String upsertAction;

    private UpsertRowsResult(BuilderImpl builder) {
        this.rowIds = builder.rowIds;
        this.upsertAction = builder.upsertAction;
    }

    public final boolean hasRowIds() {
        return this.rowIds != null && !(this.rowIds instanceof SdkAutoConstructList);
    }

    public final List<String> rowIds() {
        return this.rowIds;
    }

    public final UpsertAction upsertAction() {
        return UpsertAction.fromValue(this.upsertAction);
    }

    public final String upsertActionAsString() {
        return this.upsertAction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRowIds() ? this.rowIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.upsertActionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpsertRowsResult)) {
            return false;
        }
        UpsertRowsResult other = (UpsertRowsResult)obj;
        return this.hasRowIds() == other.hasRowIds() && Objects.equals(this.rowIds(), other.rowIds()) && Objects.equals(this.upsertActionAsString(), other.upsertActionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpsertRowsResult").add("RowIds", this.hasRowIds() ? this.rowIds() : null).add("UpsertAction", (Object)this.upsertActionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "rowIds": {
                return Optional.ofNullable(clazz.cast(this.rowIds()));
            }
            case "upsertAction": {
                return Optional.ofNullable(clazz.cast(this.upsertActionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpsertRowsResult, T> g) {
        return obj -> g.apply((UpsertRowsResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> rowIds = DefaultSdkAutoConstructList.getInstance();
        private String upsertAction;

        private BuilderImpl() {
        }

        private BuilderImpl(UpsertRowsResult model) {
            this.rowIds(model.rowIds);
            this.upsertAction(model.upsertAction);
        }

        public final Collection<String> getRowIds() {
            if (this.rowIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.rowIds;
        }

        public final void setRowIds(Collection<String> rowIds) {
            this.rowIds = RowIdListCopier.copy(rowIds);
        }

        @Override
        @Transient
        public final Builder rowIds(Collection<String> rowIds) {
            this.rowIds = RowIdListCopier.copy(rowIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder rowIds(String ... rowIds) {
            this.rowIds(Arrays.asList(rowIds));
            return this;
        }

        public final String getUpsertAction() {
            return this.upsertAction;
        }

        public final void setUpsertAction(String upsertAction) {
            this.upsertAction = upsertAction;
        }

        @Override
        @Transient
        public final Builder upsertAction(String upsertAction) {
            this.upsertAction = upsertAction;
            return this;
        }

        @Override
        @Transient
        public final Builder upsertAction(UpsertAction upsertAction) {
            this.upsertAction(upsertAction == null ? null : upsertAction.toString());
            return this;
        }

        public UpsertRowsResult build() {
            return new UpsertRowsResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpsertRowsResult> {
        public Builder rowIds(Collection<String> var1);

        public Builder rowIds(String ... var1);

        public Builder upsertAction(String var1);

        public Builder upsertAction(UpsertAction var1);
    }
}

