/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * ResultSet contains the results of the request for a single block or list defined on the screen.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResultSet implements SdkPojo, Serializable, ToCopyableBuilder<ResultSet.Builder, ResultSet> {
    private static final SdkField<List<ColumnMetadata>> HEADERS_FIELD = SdkField
            .<List<ColumnMetadata>> builder(MarshallingType.LIST)
            .memberName("headers")
            .getter(getter(ResultSet::headers))
            .setter(setter(Builder::headers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ResultRow>> ROWS_FIELD = SdkField
            .<List<ResultRow>> builder(MarshallingType.LIST)
            .memberName("rows")
            .getter(getter(ResultSet::rows))
            .setter(setter(Builder::rows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResultRow> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResultRow::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADERS_FIELD, ROWS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ColumnMetadata> headers;

    private final List<ResultRow> rows;

    private ResultSet(BuilderImpl builder) {
        this.headers = builder.headers;
        this.rows = builder.rows;
    }

    /**
     * For responses, this returns true if the service returned a value for the Headers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasHeaders() {
        return headers != null && !(headers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of headers for all the data cells in the block. The header identifies the name and default format of the
     * data cell. Data cells appear in the same order in all rows as defined in the header. The names and formats are
     * not repeated in the rows. If a particular row does not have a value for a data cell, a blank value is used.
     * </p>
     * <p>
     * For example, a task list that displays the task name, due date and assigned person might have headers [ { "name":
     * "Task Name"}, {"name": "Due Date", "format": "DATE"}, {"name": "Assigned", "format": "CONTACT"} ]. Every row in
     * the result will have the task name as the first item, due date as the second item and assigned person as the
     * third item. If a particular task does not have a due date, that row will still have a blank value in the second
     * element and the assigned person will still be in the third element.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHeaders} method.
     * </p>
     * 
     * @return List of headers for all the data cells in the block. The header identifies the name and default format of
     *         the data cell. Data cells appear in the same order in all rows as defined in the header. The names and
     *         formats are not repeated in the rows. If a particular row does not have a value for a data cell, a blank
     *         value is used. </p>
     *         <p>
     *         For example, a task list that displays the task name, due date and assigned person might have headers [ {
     *         "name": "Task Name"}, {"name": "Due Date", "format": "DATE"}, {"name": "Assigned", "format": "CONTACT"}
     *         ]. Every row in the result will have the task name as the first item, due date as the second item and
     *         assigned person as the third item. If a particular task does not have a due date, that row will still
     *         have a blank value in the second element and the assigned person will still be in the third element.
     */
    public final List<ColumnMetadata> headers() {
        return headers;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rows property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRows() {
        return rows != null && !(rows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of rows returned by the request. Each row has a row Id and a list of data cells in that row. The data cells
     * will be present in the same order as they are defined in the header.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRows} method.
     * </p>
     * 
     * @return List of rows returned by the request. Each row has a row Id and a list of data cells in that row. The
     *         data cells will be present in the same order as they are defined in the header.
     */
    public final List<ResultRow> rows() {
        return rows;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasHeaders() ? headers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRows() ? rows() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultSet)) {
            return false;
        }
        ResultSet other = (ResultSet) obj;
        return hasHeaders() == other.hasHeaders() && Objects.equals(headers(), other.headers()) && hasRows() == other.hasRows()
                && Objects.equals(rows(), other.rows());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResultSet").add("Headers", hasHeaders() ? headers() : null)
                .add("Rows", hasRows() ? rows() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "headers":
            return Optional.ofNullable(clazz.cast(headers()));
        case "rows":
            return Optional.ofNullable(clazz.cast(rows()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResultSet, T> g) {
        return obj -> g.apply((ResultSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResultSet> {
        /**
         * <p>
         * List of headers for all the data cells in the block. The header identifies the name and default format of the
         * data cell. Data cells appear in the same order in all rows as defined in the header. The names and formats
         * are not repeated in the rows. If a particular row does not have a value for a data cell, a blank value is
         * used.
         * </p>
         * <p>
         * For example, a task list that displays the task name, due date and assigned person might have headers [ {
         * "name": "Task Name"}, {"name": "Due Date", "format": "DATE"}, {"name": "Assigned", "format": "CONTACT"} ].
         * Every row in the result will have the task name as the first item, due date as the second item and assigned
         * person as the third item. If a particular task does not have a due date, that row will still have a blank
         * value in the second element and the assigned person will still be in the third element.
         * </p>
         * 
         * @param headers
         *        List of headers for all the data cells in the block. The header identifies the name and default format
         *        of the data cell. Data cells appear in the same order in all rows as defined in the header. The names
         *        and formats are not repeated in the rows. If a particular row does not have a value for a data cell, a
         *        blank value is used. </p>
         *        <p>
         *        For example, a task list that displays the task name, due date and assigned person might have headers
         *        [ { "name": "Task Name"}, {"name": "Due Date", "format": "DATE"}, {"name": "Assigned", "format":
         *        "CONTACT"} ]. Every row in the result will have the task name as the first item, due date as the
         *        second item and assigned person as the third item. If a particular task does not have a due date, that
         *        row will still have a blank value in the second element and the assigned person will still be in the
         *        third element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(Collection<ColumnMetadata> headers);

        /**
         * <p>
         * List of headers for all the data cells in the block. The header identifies the name and default format of the
         * data cell. Data cells appear in the same order in all rows as defined in the header. The names and formats
         * are not repeated in the rows. If a particular row does not have a value for a data cell, a blank value is
         * used.
         * </p>
         * <p>
         * For example, a task list that displays the task name, due date and assigned person might have headers [ {
         * "name": "Task Name"}, {"name": "Due Date", "format": "DATE"}, {"name": "Assigned", "format": "CONTACT"} ].
         * Every row in the result will have the task name as the first item, due date as the second item and assigned
         * person as the third item. If a particular task does not have a due date, that row will still have a blank
         * value in the second element and the assigned person will still be in the third element.
         * </p>
         * 
         * @param headers
         *        List of headers for all the data cells in the block. The header identifies the name and default format
         *        of the data cell. Data cells appear in the same order in all rows as defined in the header. The names
         *        and formats are not repeated in the rows. If a particular row does not have a value for a data cell, a
         *        blank value is used. </p>
         *        <p>
         *        For example, a task list that displays the task name, due date and assigned person might have headers
         *        [ { "name": "Task Name"}, {"name": "Due Date", "format": "DATE"}, {"name": "Assigned", "format":
         *        "CONTACT"} ]. Every row in the result will have the task name as the first item, due date as the
         *        second item and assigned person as the third item. If a particular task does not have a due date, that
         *        row will still have a blank value in the second element and the assigned person will still be in the
         *        third element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(ColumnMetadata... headers);

        /**
         * <p>
         * List of headers for all the data cells in the block. The header identifies the name and default format of the
         * data cell. Data cells appear in the same order in all rows as defined in the header. The names and formats
         * are not repeated in the rows. If a particular row does not have a value for a data cell, a blank value is
         * used.
         * </p>
         * <p>
         * For example, a task list that displays the task name, due date and assigned person might have headers [ {
         * "name": "Task Name"}, {"name": "Due Date", "format": "DATE"}, {"name": "Assigned", "format": "CONTACT"} ].
         * Every row in the result will have the task name as the first item, due date as the second item and assigned
         * person as the third item. If a particular task does not have a due date, that row will still have a blank
         * value in the second element and the assigned person will still be in the third element.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.honeycode.model.ColumnMetadata.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.honeycode.model.ColumnMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.honeycode.model.ColumnMetadata.Builder#build()} is called immediately
         * and its result is passed to {@link #headers(List<ColumnMetadata>)}.
         * 
         * @param headers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.honeycode.model.ColumnMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #headers(java.util.Collection<ColumnMetadata>)
         */
        Builder headers(Consumer<ColumnMetadata.Builder>... headers);

        /**
         * <p>
         * List of rows returned by the request. Each row has a row Id and a list of data cells in that row. The data
         * cells will be present in the same order as they are defined in the header.
         * </p>
         * 
         * @param rows
         *        List of rows returned by the request. Each row has a row Id and a list of data cells in that row. The
         *        data cells will be present in the same order as they are defined in the header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rows(Collection<ResultRow> rows);

        /**
         * <p>
         * List of rows returned by the request. Each row has a row Id and a list of data cells in that row. The data
         * cells will be present in the same order as they are defined in the header.
         * </p>
         * 
         * @param rows
         *        List of rows returned by the request. Each row has a row Id and a list of data cells in that row. The
         *        data cells will be present in the same order as they are defined in the header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rows(ResultRow... rows);

        /**
         * <p>
         * List of rows returned by the request. Each row has a row Id and a list of data cells in that row. The data
         * cells will be present in the same order as they are defined in the header.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.honeycode.model.ResultRow.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.honeycode.model.ResultRow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.honeycode.model.ResultRow.Builder#build()} is called immediately and
         * its result is passed to {@link #rows(List<ResultRow>)}.
         * 
         * @param rows
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.honeycode.model.ResultRow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rows(java.util.Collection<ResultRow>)
         */
        Builder rows(Consumer<ResultRow.Builder>... rows);
    }

    static final class BuilderImpl implements Builder {
        private List<ColumnMetadata> headers = DefaultSdkAutoConstructList.getInstance();

        private List<ResultRow> rows = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResultSet model) {
            headers(model.headers);
            rows(model.rows);
        }

        public final List<ColumnMetadata.Builder> getHeaders() {
            List<ColumnMetadata.Builder> result = ResultHeaderCopier.copyToBuilder(this.headers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHeaders(Collection<ColumnMetadata.BuilderImpl> headers) {
            this.headers = ResultHeaderCopier.copyFromBuilder(headers);
        }

        @Override
        public final Builder headers(Collection<ColumnMetadata> headers) {
            this.headers = ResultHeaderCopier.copy(headers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(ColumnMetadata... headers) {
            headers(Arrays.asList(headers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(Consumer<ColumnMetadata.Builder>... headers) {
            headers(Stream.of(headers).map(c -> ColumnMetadata.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ResultRow.Builder> getRows() {
            List<ResultRow.Builder> result = ResultRowsCopier.copyToBuilder(this.rows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRows(Collection<ResultRow.BuilderImpl> rows) {
            this.rows = ResultRowsCopier.copyFromBuilder(rows);
        }

        @Override
        public final Builder rows(Collection<ResultRow> rows) {
            this.rows = ResultRowsCopier.copy(rows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(ResultRow... rows) {
            rows(Arrays.asList(rows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(Consumer<ResultRow.Builder>... rows) {
            rows(Stream.of(rows).map(c -> ResultRow.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ResultSet build() {
            return new ResultSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
