/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.honeycode.model.ColumnMetadata;
import software.amazon.awssdk.services.honeycode.model.ResultHeaderCopier;
import software.amazon.awssdk.services.honeycode.model.ResultRow;
import software.amazon.awssdk.services.honeycode.model.ResultRowsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResultSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResultSet> {
    private static final SdkField<List<ColumnMetadata>> HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("headers").getter(ResultSet.getter(ResultSet::headers)).setter(ResultSet.setter(Builder::headers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResultRow>> ROWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rows").getter(ResultSet.getter(ResultSet::rows)).setter(ResultSet.setter(Builder::rows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResultRow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADERS_FIELD, ROWS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ColumnMetadata> headers;
    private final List<ResultRow> rows;

    private ResultSet(BuilderImpl builder) {
        this.headers = builder.headers;
        this.rows = builder.rows;
    }

    public final boolean hasHeaders() {
        return this.headers != null && !(this.headers instanceof SdkAutoConstructList);
    }

    public final List<ColumnMetadata> headers() {
        return this.headers;
    }

    public final boolean hasRows() {
        return this.rows != null && !(this.rows instanceof SdkAutoConstructList);
    }

    public final List<ResultRow> rows() {
        return this.rows;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHeaders() ? this.headers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRows() ? this.rows() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultSet)) {
            return false;
        }
        ResultSet other = (ResultSet)obj;
        return this.hasHeaders() == other.hasHeaders() && Objects.equals(this.headers(), other.headers()) && this.hasRows() == other.hasRows() && Objects.equals(this.rows(), other.rows());
    }

    public final String toString() {
        return ToString.builder((String)"ResultSet").add("Headers", this.hasHeaders() ? this.headers() : null).add("Rows", this.hasRows() ? this.rows() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "headers": {
                return Optional.ofNullable(clazz.cast(this.headers()));
            }
            case "rows": {
                return Optional.ofNullable(clazz.cast(this.rows()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResultSet, T> g) {
        return obj -> g.apply((ResultSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ColumnMetadata> headers = DefaultSdkAutoConstructList.getInstance();
        private List<ResultRow> rows = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResultSet model) {
            this.headers(model.headers);
            this.rows(model.rows);
        }

        public final List<ColumnMetadata.Builder> getHeaders() {
            List<ColumnMetadata.Builder> result = ResultHeaderCopier.copyToBuilder(this.headers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHeaders(Collection<ColumnMetadata.BuilderImpl> headers) {
            this.headers = ResultHeaderCopier.copyFromBuilder(headers);
        }

        @Override
        public final Builder headers(Collection<ColumnMetadata> headers) {
            this.headers = ResultHeaderCopier.copy(headers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(ColumnMetadata ... headers) {
            this.headers(Arrays.asList(headers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(Consumer<ColumnMetadata.Builder> ... headers) {
            this.headers(Stream.of(headers).map(c -> (ColumnMetadata)((ColumnMetadata.Builder)ColumnMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ResultRow.Builder> getRows() {
            List<ResultRow.Builder> result = ResultRowsCopier.copyToBuilder(this.rows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRows(Collection<ResultRow.BuilderImpl> rows) {
            this.rows = ResultRowsCopier.copyFromBuilder(rows);
        }

        @Override
        public final Builder rows(Collection<ResultRow> rows) {
            this.rows = ResultRowsCopier.copy(rows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(ResultRow ... rows) {
            this.rows(Arrays.asList(rows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(Consumer<ResultRow.Builder> ... rows) {
            this.rows(Stream.of(rows).map(c -> (ResultRow)((ResultRow.Builder)ResultRow.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ResultSet build() {
            return new ResultSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResultSet> {
        public Builder headers(Collection<ColumnMetadata> var1);

        public Builder headers(ColumnMetadata ... var1);

        public Builder headers(Consumer<ColumnMetadata.Builder> ... var1);

        public Builder rows(Collection<ResultRow> var1);

        public Builder rows(ResultRow ... var1);

        public Builder rows(Consumer<ResultRow.Builder> ... var1);
    }
}

