/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains the options relating to the destination of the import request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DestinationOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<DestinationOptions.Builder, DestinationOptions> {
    private static final SdkField<Map<String, SourceDataColumnProperties>> COLUMN_MAP_FIELD = SdkField
            .<Map<String, SourceDataColumnProperties>> builder(MarshallingType.MAP)
            .memberName("columnMap")
            .getter(getter(DestinationOptions::columnMap))
            .setter(setter(Builder::columnMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<SourceDataColumnProperties> builder(MarshallingType.SDK_POJO)
                                            .constructor(SourceDataColumnProperties::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_MAP_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, SourceDataColumnProperties> columnMap;

    private DestinationOptions(BuilderImpl builder) {
        this.columnMap = builder.columnMap;
    }

    /**
     * For responses, this returns true if the service returned a value for the ColumnMap property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasColumnMap() {
        return columnMap != null && !(columnMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of the column id to the import properties for each column.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumnMap} method.
     * </p>
     * 
     * @return A map of the column id to the import properties for each column.
     */
    public final Map<String, SourceDataColumnProperties> columnMap() {
        return columnMap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasColumnMap() ? columnMap() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationOptions)) {
            return false;
        }
        DestinationOptions other = (DestinationOptions) obj;
        return hasColumnMap() == other.hasColumnMap() && Objects.equals(columnMap(), other.columnMap());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DestinationOptions").add("ColumnMap", hasColumnMap() ? columnMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "columnMap":
            return Optional.ofNullable(clazz.cast(columnMap()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DestinationOptions, T> g) {
        return obj -> g.apply((DestinationOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DestinationOptions> {
        /**
         * <p>
         * A map of the column id to the import properties for each column.
         * </p>
         * 
         * @param columnMap
         *        A map of the column id to the import properties for each column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnMap(Map<String, SourceDataColumnProperties> columnMap);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, SourceDataColumnProperties> columnMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationOptions model) {
            columnMap(model.columnMap);
        }

        public final Map<String, SourceDataColumnProperties.Builder> getColumnMap() {
            Map<String, SourceDataColumnProperties.Builder> result = ImportColumnMapCopier.copyToBuilder(this.columnMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setColumnMap(Map<String, SourceDataColumnProperties.BuilderImpl> columnMap) {
            this.columnMap = ImportColumnMapCopier.copyFromBuilder(columnMap);
        }

        @Override
        public final Builder columnMap(Map<String, SourceDataColumnProperties> columnMap) {
            this.columnMap = ImportColumnMapCopier.copy(columnMap);
            return this;
        }

        @Override
        public DestinationOptions build() {
            return new DestinationOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
