/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.honeycode.model.CellInput;
import software.amazon.awssdk.services.honeycode.model.RowDataInputCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRowData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateRowData> {
    private static final SdkField<String> ROW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rowId").getter(UpdateRowData.getter(UpdateRowData::rowId)).setter(UpdateRowData.setter(Builder::rowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rowId").build()}).build();
    private static final SdkField<Map<String, CellInput>> CELLS_TO_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("cellsToUpdate").getter(UpdateRowData.getter(UpdateRowData::cellsToUpdate)).setter(UpdateRowData.setter(Builder::cellsToUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cellsToUpdate").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CellInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROW_ID_FIELD, CELLS_TO_UPDATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String rowId;
    private final Map<String, CellInput> cellsToUpdate;

    private UpdateRowData(BuilderImpl builder) {
        this.rowId = builder.rowId;
        this.cellsToUpdate = builder.cellsToUpdate;
    }

    public final String rowId() {
        return this.rowId;
    }

    public final boolean hasCellsToUpdate() {
        return this.cellsToUpdate != null && !(this.cellsToUpdate instanceof SdkAutoConstructMap);
    }

    public final Map<String, CellInput> cellsToUpdate() {
        return this.cellsToUpdate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCellsToUpdate() ? this.cellsToUpdate() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRowData)) {
            return false;
        }
        UpdateRowData other = (UpdateRowData)obj;
        return Objects.equals(this.rowId(), other.rowId()) && this.hasCellsToUpdate() == other.hasCellsToUpdate() && Objects.equals(this.cellsToUpdate(), other.cellsToUpdate());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRowData").add("RowId", (Object)this.rowId()).add("CellsToUpdate", this.hasCellsToUpdate() ? this.cellsToUpdate() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "rowId": {
                return Optional.ofNullable(clazz.cast(this.rowId()));
            }
            case "cellsToUpdate": {
                return Optional.ofNullable(clazz.cast(this.cellsToUpdate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRowData, T> g) {
        return obj -> g.apply((UpdateRowData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String rowId;
        private Map<String, CellInput> cellsToUpdate = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRowData model) {
            this.rowId(model.rowId);
            this.cellsToUpdate(model.cellsToUpdate);
        }

        public final String getRowId() {
            return this.rowId;
        }

        public final void setRowId(String rowId) {
            this.rowId = rowId;
        }

        @Override
        public final Builder rowId(String rowId) {
            this.rowId = rowId;
            return this;
        }

        public final Map<String, CellInput.Builder> getCellsToUpdate() {
            Map<String, CellInput.Builder> result = RowDataInputCopier.copyToBuilder(this.cellsToUpdate);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCellsToUpdate(Map<String, CellInput.BuilderImpl> cellsToUpdate) {
            this.cellsToUpdate = RowDataInputCopier.copyFromBuilder(cellsToUpdate);
        }

        @Override
        public final Builder cellsToUpdate(Map<String, CellInput> cellsToUpdate) {
            this.cellsToUpdate = RowDataInputCopier.copy(cellsToUpdate);
            return this;
        }

        public UpdateRowData build() {
            return new UpdateRowData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateRowData> {
        public Builder rowId(String var1);

        public Builder cellsToUpdate(Map<String, CellInput> var1);
    }
}

