/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.honeycode.HoneycodeAsyncClient;
import software.amazon.awssdk.services.honeycode.internal.UserAgentUtils;
import software.amazon.awssdk.services.honeycode.model.ListTableColumnsRequest;
import software.amazon.awssdk.services.honeycode.model.ListTableColumnsResponse;
import software.amazon.awssdk.services.honeycode.model.TableColumn;

public class ListTableColumnsPublisher
implements SdkPublisher<ListTableColumnsResponse> {
    private final HoneycodeAsyncClient client;
    private final ListTableColumnsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTableColumnsPublisher(HoneycodeAsyncClient client, ListTableColumnsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTableColumnsPublisher(HoneycodeAsyncClient client, ListTableColumnsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTableColumnsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTableColumnsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TableColumn> tableColumns() {
        Function<ListTableColumnsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tableColumns() != null) {
                return response.tableColumns().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTableColumnsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTableColumnsResponseFetcher
    implements AsyncPageFetcher<ListTableColumnsResponse> {
        private ListTableColumnsResponseFetcher() {
        }

        public boolean hasNextPage(ListTableColumnsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTableColumnsResponse> nextPage(ListTableColumnsResponse previousPage) {
            if (previousPage == null) {
                return ListTableColumnsPublisher.this.client.listTableColumns(ListTableColumnsPublisher.this.firstRequest);
            }
            return ListTableColumnsPublisher.this.client.listTableColumns((ListTableColumnsRequest)((Object)ListTableColumnsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

