/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UpsertAction {
    UPDATED("UPDATED"),
    APPENDED("APPENDED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UpsertAction> VALUE_MAP;
    private final String value;

    private UpsertAction(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UpsertAction fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UpsertAction> knownValues() {
        EnumSet<UpsertAction> knownValues = EnumSet.allOf(UpsertAction.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UpsertAction.class, UpsertAction::toString);
    }
}

