/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.honeycode.model.HoneycodeResponse;
import software.amazon.awssdk.services.honeycode.model.TableColumn;
import software.amazon.awssdk.services.honeycode.model.TableColumnsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTableColumnsResponse
extends HoneycodeResponse
implements ToCopyableBuilder<Builder, ListTableColumnsResponse> {
    private static final SdkField<List<TableColumn>> TABLE_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tableColumns").getter(ListTableColumnsResponse.getter(ListTableColumnsResponse::tableColumns)).setter(ListTableColumnsResponse.setter(Builder::tableColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TableColumn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTableColumnsResponse.getter(ListTableColumnsResponse::nextToken)).setter(ListTableColumnsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Long> WORKBOOK_CURSOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("workbookCursor").getter(ListTableColumnsResponse.getter(ListTableColumnsResponse::workbookCursor)).setter(ListTableColumnsResponse.setter(Builder::workbookCursor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workbookCursor").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_COLUMNS_FIELD, NEXT_TOKEN_FIELD, WORKBOOK_CURSOR_FIELD));
    private final List<TableColumn> tableColumns;
    private final String nextToken;
    private final Long workbookCursor;

    private ListTableColumnsResponse(BuilderImpl builder) {
        super(builder);
        this.tableColumns = builder.tableColumns;
        this.nextToken = builder.nextToken;
        this.workbookCursor = builder.workbookCursor;
    }

    public final boolean hasTableColumns() {
        return this.tableColumns != null && !(this.tableColumns instanceof SdkAutoConstructList);
    }

    public final List<TableColumn> tableColumns() {
        return this.tableColumns;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Long workbookCursor() {
        return this.workbookCursor;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTableColumns() ? this.tableColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.workbookCursor());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTableColumnsResponse)) {
            return false;
        }
        ListTableColumnsResponse other = (ListTableColumnsResponse)((Object)obj);
        return this.hasTableColumns() == other.hasTableColumns() && Objects.equals(this.tableColumns(), other.tableColumns()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.workbookCursor(), other.workbookCursor());
    }

    public final String toString() {
        return ToString.builder((String)"ListTableColumnsResponse").add("TableColumns", this.hasTableColumns() ? this.tableColumns() : null).add("NextToken", (Object)this.nextToken()).add("WorkbookCursor", (Object)this.workbookCursor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tableColumns": {
                return Optional.ofNullable(clazz.cast(this.tableColumns()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "workbookCursor": {
                return Optional.ofNullable(clazz.cast(this.workbookCursor()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTableColumnsResponse, T> g) {
        return obj -> g.apply((ListTableColumnsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends HoneycodeResponse.BuilderImpl
    implements Builder {
        private List<TableColumn> tableColumns = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Long workbookCursor;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTableColumnsResponse model) {
            super(model);
            this.tableColumns(model.tableColumns);
            this.nextToken(model.nextToken);
            this.workbookCursor(model.workbookCursor);
        }

        public final List<TableColumn.Builder> getTableColumns() {
            List<TableColumn.Builder> result = TableColumnsCopier.copyToBuilder(this.tableColumns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTableColumns(Collection<TableColumn.BuilderImpl> tableColumns) {
            this.tableColumns = TableColumnsCopier.copyFromBuilder(tableColumns);
        }

        @Override
        public final Builder tableColumns(Collection<TableColumn> tableColumns) {
            this.tableColumns = TableColumnsCopier.copy(tableColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableColumns(TableColumn ... tableColumns) {
            this.tableColumns(Arrays.asList(tableColumns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableColumns(Consumer<TableColumn.Builder> ... tableColumns) {
            this.tableColumns(Stream.of(tableColumns).map(c -> (TableColumn)((TableColumn.Builder)TableColumn.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Long getWorkbookCursor() {
            return this.workbookCursor;
        }

        public final void setWorkbookCursor(Long workbookCursor) {
            this.workbookCursor = workbookCursor;
        }

        @Override
        public final Builder workbookCursor(Long workbookCursor) {
            this.workbookCursor = workbookCursor;
            return this;
        }

        @Override
        public ListTableColumnsResponse build() {
            return new ListTableColumnsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends HoneycodeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTableColumnsResponse> {
        public Builder tableColumns(Collection<TableColumn> var1);

        public Builder tableColumns(TableColumn ... var1);

        public Builder tableColumns(Consumer<TableColumn.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder workbookCursor(Long var1);
    }
}

