/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ImportSourceDataFormat {
    DELIMITED_TEXT("DELIMITED_TEXT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ImportSourceDataFormat> VALUE_MAP;
    private final String value;

    private ImportSourceDataFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ImportSourceDataFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ImportSourceDataFormat> knownValues() {
        EnumSet<ImportSourceDataFormat> knownValues = EnumSet.allOf(ImportSourceDataFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ImportSourceDataFormat.class, ImportSourceDataFormat::toString);
    }
}

