/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.http.DefaultSdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

@SdkPublicApi
@Immutable
public interface SdkHttpFullRequest
extends SdkHttpRequest,
ToCopyableBuilder<Builder, SdkHttpFullRequest> {
    public static Builder builder() {
        return new DefaultSdkHttpFullRequest.Builder();
    }

    public Optional<InputStream> content();

    public static interface Builder
    extends CopyableBuilder<Builder, SdkHttpFullRequest> {
        public String protocol();

        public Builder protocol(String var1);

        public String host();

        public Builder host(String var1);

        public Integer port();

        public Builder port(Integer var1);

        public String encodedPath();

        public Builder encodedPath(String var1);

        public Map<String, List<String>> rawQueryParameters();

        default public Builder rawQueryParameter(String paramName, String paramValue) {
            return this.rawQueryParameter(paramName, Collections.singletonList(paramValue));
        }

        public Builder rawQueryParameter(String var1, List<String> var2);

        public Builder rawQueryParameters(Map<String, List<String>> var1);

        public Builder removeQueryParameter(String var1);

        public Builder clearQueryParameters();

        public SdkHttpMethod method();

        public Builder method(SdkHttpMethod var1);

        default public Optional<String> firstMatchingHeader(String header) {
            return SdkHttpUtils.firstMatchingHeader(this.headers(), (String)header);
        }

        public Map<String, List<String>> headers();

        default public Builder header(String headerName, String headerValue) {
            return this.header(headerName, Collections.singletonList(headerValue));
        }

        public Builder header(String var1, List<String> var2);

        public Builder headers(Map<String, List<String>> var1);

        public Builder removeHeader(String var1);

        public Builder clearHeaders();

        public InputStream content();

        public Builder content(InputStream var1);
    }
}

