/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import software.amazon.awssdk.annotation.Immutable;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.utils.CollectionUtils;

@SdkInternalApi
@Immutable
class DefaultSdkHttpFullResponse
implements SdkHttpFullResponse {
    private final String statusText;
    private final int statusCode;
    private final AbortableInputStream content;
    private final Map<String, List<String>> headers;

    DefaultSdkHttpFullResponse(Builder builder) {
        this.statusCode = builder.statusCode;
        this.statusText = builder.statusText;
        this.content = builder.content;
        this.headers = CollectionUtils.deepUnmodifiableMap((Map)builder.headers, () -> new TreeMap(String.CASE_INSENSITIVE_ORDER));
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Override
    public Collection<String> getValuesForHeader(String header) {
        List<String> values = this.headers.get(header);
        return values != null ? values : Collections.emptyList();
    }

    @Override
    public AbortableInputStream getContent() {
        return this.content;
    }

    @Override
    public String getStatusText() {
        return this.statusText;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    public SdkHttpFullResponse.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    implements SdkHttpFullResponse.Builder {
        private String statusText;
        private int statusCode;
        private AbortableInputStream content;
        private Map<String, List<String>> headers = new HashMap<String, List<String>>();

        Builder() {
        }

        private Builder(DefaultSdkHttpFullResponse defaultSdkHttpFullResponse) {
            this.statusText = defaultSdkHttpFullResponse.statusText;
            this.statusCode = defaultSdkHttpFullResponse.statusCode;
            this.content = defaultSdkHttpFullResponse.content;
            this.headers = CollectionUtils.deepCopyMap((Map)defaultSdkHttpFullResponse.headers);
        }

        @Override
        public Builder statusText(String statusText) {
            this.statusText = statusText;
            return this;
        }

        @Override
        public Builder statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public Builder content(AbortableInputStream content) {
            this.content = content;
            return this;
        }

        @Override
        @ReviewBeforeRelease(value="Should we only allow setting the AbortableInputStream?")
        public Builder content(InputStream content) {
            return this.content(new AbortableInputStream(content, () -> {}));
        }

        @Override
        public Builder headers(Map<String, List<String>> headers) {
            this.headers = CollectionUtils.deepCopyMap(headers);
            return this;
        }

        @Override
        public Builder addHeader(String headerName, List<String> headerValues) {
            this.headers.put(headerName, headerValues);
            return this;
        }

        public SdkHttpFullResponse build() {
            return new DefaultSdkHttpFullResponse(this);
        }
    }
}

