/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iam.model.PolicyOwnerEntityType;
import software.amazon.awssdk.services.iam.model.PolicyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PolicyGrantingServiceAccess
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PolicyGrantingServiceAccess> {
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PolicyGrantingServiceAccess.getter(PolicyGrantingServiceAccess::policyName)).setter(PolicyGrantingServiceAccess.setter(Builder::policyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()}).build();
    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PolicyGrantingServiceAccess.getter(PolicyGrantingServiceAccess::policyTypeAsString)).setter(PolicyGrantingServiceAccess.setter(Builder::policyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()}).build();
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PolicyGrantingServiceAccess.getter(PolicyGrantingServiceAccess::policyArn)).setter(PolicyGrantingServiceAccess.setter(Builder::policyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyArn").build()}).build();
    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PolicyGrantingServiceAccess.getter(PolicyGrantingServiceAccess::entityTypeAsString)).setter(PolicyGrantingServiceAccess.setter(Builder::entityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityType").build()}).build();
    private static final SdkField<String> ENTITY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PolicyGrantingServiceAccess.getter(PolicyGrantingServiceAccess::entityName)).setter(PolicyGrantingServiceAccess.setter(Builder::entityName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_NAME_FIELD, POLICY_TYPE_FIELD, POLICY_ARN_FIELD, ENTITY_TYPE_FIELD, ENTITY_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String policyName;
    private final String policyType;
    private final String policyArn;
    private final String entityType;
    private final String entityName;

    private PolicyGrantingServiceAccess(BuilderImpl builder) {
        this.policyName = builder.policyName;
        this.policyType = builder.policyType;
        this.policyArn = builder.policyArn;
        this.entityType = builder.entityType;
        this.entityName = builder.entityName;
    }

    public String policyName() {
        return this.policyName;
    }

    public PolicyType policyType() {
        return PolicyType.fromValue(this.policyType);
    }

    public String policyTypeAsString() {
        return this.policyType;
    }

    public String policyArn() {
        return this.policyArn;
    }

    public PolicyOwnerEntityType entityType() {
        return PolicyOwnerEntityType.fromValue(this.entityType);
    }

    public String entityTypeAsString() {
        return this.entityType;
    }

    public String entityName() {
        return this.entityName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyGrantingServiceAccess)) {
            return false;
        }
        PolicyGrantingServiceAccess other = (PolicyGrantingServiceAccess)obj;
        return Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.policyTypeAsString(), other.policyTypeAsString()) && Objects.equals(this.policyArn(), other.policyArn()) && Objects.equals(this.entityTypeAsString(), other.entityTypeAsString()) && Objects.equals(this.entityName(), other.entityName());
    }

    public String toString() {
        return ToString.builder((String)"PolicyGrantingServiceAccess").add("PolicyName", (Object)this.policyName()).add("PolicyType", (Object)this.policyTypeAsString()).add("PolicyArn", (Object)this.policyArn()).add("EntityType", (Object)this.entityTypeAsString()).add("EntityName", (Object)this.entityName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "PolicyType": {
                return Optional.ofNullable(clazz.cast(this.policyTypeAsString()));
            }
            case "PolicyArn": {
                return Optional.ofNullable(clazz.cast(this.policyArn()));
            }
            case "EntityType": {
                return Optional.ofNullable(clazz.cast(this.entityTypeAsString()));
            }
            case "EntityName": {
                return Optional.ofNullable(clazz.cast(this.entityName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PolicyGrantingServiceAccess, T> g) {
        return obj -> g.apply((PolicyGrantingServiceAccess)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyName;
        private String policyType;
        private String policyArn;
        private String entityType;
        private String entityName;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyGrantingServiceAccess model) {
            this.policyName(model.policyName);
            this.policyType(model.policyType);
            this.policyArn(model.policyArn);
            this.entityType(model.entityType);
            this.entityName(model.entityName);
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicyTypeAsString() {
            return this.policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(PolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        public final String getEntityTypeAsString() {
            return this.entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        @Override
        public final Builder entityType(PolicyOwnerEntityType entityType) {
            this.entityType(entityType == null ? null : entityType.toString());
            return this;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        public final String getEntityName() {
            return this.entityName;
        }

        @Override
        public final Builder entityName(String entityName) {
            this.entityName = entityName;
            return this;
        }

        public final void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        public PolicyGrantingServiceAccess build() {
            return new PolicyGrantingServiceAccess(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PolicyGrantingServiceAccess> {
        public Builder policyName(String var1);

        public Builder policyType(String var1);

        public Builder policyType(PolicyType var1);

        public Builder policyArn(String var1);

        public Builder entityType(String var1);

        public Builder entityType(PolicyOwnerEntityType var1);

        public Builder entityName(String var1);
    }
}

