/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the permissions policies that are attached to the specified identity (user, group, or role).
 * </p>
 * <p>
 * This data type is used as a response element in the <a>ListPoliciesGrantingServiceAccess</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPoliciesGrantingServiceAccessEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<ListPoliciesGrantingServiceAccessEntry.Builder, ListPoliciesGrantingServiceAccessEntry> {
    private static final SdkField<String> SERVICE_NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListPoliciesGrantingServiceAccessEntry::serviceNamespace)).setter(setter(Builder::serviceNamespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNamespace").build()).build();

    private static final SdkField<List<PolicyGrantingServiceAccess>> POLICIES_FIELD = SdkField
            .<List<PolicyGrantingServiceAccess>> builder(MarshallingType.LIST)
            .getter(getter(ListPoliciesGrantingServiceAccessEntry::policies))
            .setter(setter(Builder::policies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PolicyGrantingServiceAccess> builder(MarshallingType.SDK_POJO)
                                            .constructor(PolicyGrantingServiceAccess::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAMESPACE_FIELD,
            POLICIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serviceNamespace;

    private final List<PolicyGrantingServiceAccess> policies;

    private ListPoliciesGrantingServiceAccessEntry(BuilderImpl builder) {
        this.serviceNamespace = builder.serviceNamespace;
        this.policies = builder.policies;
    }

    /**
     * <p>
     * The namespace of the service that was accessed.
     * </p>
     * <p>
     * To learn the service namespace of a service, go to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_actions-resources-contextkeys.html"
     * >Actions, Resources, and Condition Keys for AWS Services</a> in the <i>IAM User Guide</i>. Choose the name of the
     * service to view details for that service. In the first paragraph, find the service prefix. For example,
     * <code>(service prefix: a4b)</code>. For more information about service namespaces, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces"
     * >AWS Service Namespaces</a> in the <i>AWS General Reference</i>.
     * </p>
     * 
     * @return The namespace of the service that was accessed.</p>
     *         <p>
     *         To learn the service namespace of a service, go to <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_actions-resources-contextkeys.html"
     *         >Actions, Resources, and Condition Keys for AWS Services</a> in the <i>IAM User Guide</i>. Choose the
     *         name of the service to view details for that service. In the first paragraph, find the service prefix.
     *         For example, <code>(service prefix: a4b)</code>. For more information about service namespaces, see <a
     *         href=
     *         "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces"
     *         >AWS Service Namespaces</a> in the <i>AWS General Reference</i>.
     */
    public String serviceNamespace() {
        return serviceNamespace;
    }

    /**
     * Returns true if the Policies property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasPolicies() {
        return policies != null && !(policies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <code>PoliciesGrantingServiceAccess</code> object that contains details about the policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPolicies()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The <code>PoliciesGrantingServiceAccess</code> object that contains details about the policy.
     */
    public List<PolicyGrantingServiceAccess> policies() {
        return policies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(policies());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPoliciesGrantingServiceAccessEntry)) {
            return false;
        }
        ListPoliciesGrantingServiceAccessEntry other = (ListPoliciesGrantingServiceAccessEntry) obj;
        return Objects.equals(serviceNamespace(), other.serviceNamespace()) && Objects.equals(policies(), other.policies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListPoliciesGrantingServiceAccessEntry").add("ServiceNamespace", serviceNamespace())
                .add("Policies", policies()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceNamespace":
            return Optional.ofNullable(clazz.cast(serviceNamespace()));
        case "Policies":
            return Optional.ofNullable(clazz.cast(policies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPoliciesGrantingServiceAccessEntry, T> g) {
        return obj -> g.apply((ListPoliciesGrantingServiceAccessEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListPoliciesGrantingServiceAccessEntry> {
        /**
         * <p>
         * The namespace of the service that was accessed.
         * </p>
         * <p>
         * To learn the service namespace of a service, go to <a href=
         * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_actions-resources-contextkeys.html"
         * >Actions, Resources, and Condition Keys for AWS Services</a> in the <i>IAM User Guide</i>. Choose the name of
         * the service to view details for that service. In the first paragraph, find the service prefix. For example,
         * <code>(service prefix: a4b)</code>. For more information about service namespaces, see <a href=
         * "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces"
         * >AWS Service Namespaces</a> in the <i>AWS General Reference</i>.
         * </p>
         * 
         * @param serviceNamespace
         *        The namespace of the service that was accessed.</p>
         *        <p>
         *        To learn the service namespace of a service, go to <a href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_actions-resources-contextkeys.html"
         *        >Actions, Resources, and Condition Keys for AWS Services</a> in the <i>IAM User Guide</i>. Choose the
         *        name of the service to view details for that service. In the first paragraph, find the service prefix.
         *        For example, <code>(service prefix: a4b)</code>. For more information about service namespaces, see <a
         *        href=
         *        "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces"
         *        >AWS Service Namespaces</a> in the <i>AWS General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNamespace(String serviceNamespace);

        /**
         * <p>
         * The <code>PoliciesGrantingServiceAccess</code> object that contains details about the policy.
         * </p>
         * 
         * @param policies
         *        The <code>PoliciesGrantingServiceAccess</code> object that contains details about the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policies(Collection<PolicyGrantingServiceAccess> policies);

        /**
         * <p>
         * The <code>PoliciesGrantingServiceAccess</code> object that contains details about the policy.
         * </p>
         * 
         * @param policies
         *        The <code>PoliciesGrantingServiceAccess</code> object that contains details about the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policies(PolicyGrantingServiceAccess... policies);

        /**
         * <p>
         * The <code>PoliciesGrantingServiceAccess</code> object that contains details about the policy.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PolicyGrantingServiceAccess>.Builder}
         * avoiding the need to create one manually via {@link List<PolicyGrantingServiceAccess>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PolicyGrantingServiceAccess>.Builder#build()} is called
         * immediately and its result is passed to {@link #policies(List<PolicyGrantingServiceAccess>)}.
         * 
         * @param policies
         *        a consumer that will call methods on {@link List<PolicyGrantingServiceAccess>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policies(List<PolicyGrantingServiceAccess>)
         */
        Builder policies(Consumer<PolicyGrantingServiceAccess.Builder>... policies);
    }

    static final class BuilderImpl implements Builder {
        private String serviceNamespace;

        private List<PolicyGrantingServiceAccess> policies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPoliciesGrantingServiceAccessEntry model) {
            serviceNamespace(model.serviceNamespace);
            policies(model.policies);
        }

        public final String getServiceNamespace() {
            return serviceNamespace;
        }

        @Override
        public final Builder serviceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        public final void setServiceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
        }

        public final Collection<PolicyGrantingServiceAccess.Builder> getPolicies() {
            return policies != null ? policies.stream().map(PolicyGrantingServiceAccess::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder policies(Collection<PolicyGrantingServiceAccess> policies) {
            this.policies = _policyGrantingServiceAccessListTypeCopier.copy(policies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(PolicyGrantingServiceAccess... policies) {
            policies(Arrays.asList(policies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(Consumer<PolicyGrantingServiceAccess.Builder>... policies) {
            policies(Stream.of(policies).map(c -> PolicyGrantingServiceAccess.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPolicies(Collection<PolicyGrantingServiceAccess.BuilderImpl> policies) {
            this.policies = _policyGrantingServiceAccessListTypeCopier.copyFromBuilder(policies);
        }

        @Override
        public ListPoliciesGrantingServiceAccessEntry build() {
            return new ListPoliciesGrantingServiceAccessEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
