/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a server certificate without its certificate body, certificate chain, and private key.
 * </p>
 * <p>
 * This data type is used as a response element in the <a>UploadServerCertificate</a> and <a>ListServerCertificates</a>
 * operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServerCertificateMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<ServerCertificateMetadata.Builder, ServerCertificateMetadata> {
    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServerCertificateMetadata::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final SdkField<String> SERVER_CERTIFICATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServerCertificateMetadata::serverCertificateName)).setter(setter(Builder::serverCertificateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerCertificateName").build())
            .build();

    private static final SdkField<String> SERVER_CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServerCertificateMetadata::serverCertificateId)).setter(setter(Builder::serverCertificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerCertificateId").build())
            .build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServerCertificateMetadata::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Instant> UPLOAD_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ServerCertificateMetadata::uploadDate)).setter(setter(Builder::uploadDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadDate").build()).build();

    private static final SdkField<Instant> EXPIRATION_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ServerCertificateMetadata::expiration)).setter(setter(Builder::expiration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expiration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD,
            SERVER_CERTIFICATE_NAME_FIELD, SERVER_CERTIFICATE_ID_FIELD, ARN_FIELD, UPLOAD_DATE_FIELD, EXPIRATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String path;

    private final String serverCertificateName;

    private final String serverCertificateId;

    private final String arn;

    private final Instant uploadDate;

    private final Instant expiration;

    private ServerCertificateMetadata(BuilderImpl builder) {
        this.path = builder.path;
        this.serverCertificateName = builder.serverCertificateName;
        this.serverCertificateId = builder.serverCertificateId;
        this.arn = builder.arn;
        this.uploadDate = builder.uploadDate;
        this.expiration = builder.expiration;
    }

    /**
     * <p>
     * The path to the server certificate. For more information about paths, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>IAM
     * User Guide</i>.
     * </p>
     * 
     * @return The path to the server certificate. For more information about paths, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the
     *         <i>IAM User Guide</i>.
     */
    public String path() {
        return path;
    }

    /**
     * <p>
     * The name that identifies the server certificate.
     * </p>
     * 
     * @return The name that identifies the server certificate.
     */
    public String serverCertificateName() {
        return serverCertificateName;
    }

    /**
     * <p>
     * The stable and unique string identifying the server certificate. For more information about IDs, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>IAM
     * User Guide</i>.
     * </p>
     * 
     * @return The stable and unique string identifying the server certificate. For more information about IDs, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the
     *         <i>IAM User Guide</i>.
     */
    public String serverCertificateId() {
        return serverCertificateId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) specifying the server certificate. For more information about ARNs and how to use
     * them in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
     * Identifiers</a> in the <i>IAM User Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) specifying the server certificate. For more information about ARNs and how
     *         to use them in policies, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the
     *         <i>IAM User Guide</i>.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The date when the server certificate was uploaded.
     * </p>
     * 
     * @return The date when the server certificate was uploaded.
     */
    public Instant uploadDate() {
        return uploadDate;
    }

    /**
     * <p>
     * The date on which the certificate is set to expire.
     * </p>
     * 
     * @return The date on which the certificate is set to expire.
     */
    public Instant expiration() {
        return expiration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(serverCertificateName());
        hashCode = 31 * hashCode + Objects.hashCode(serverCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(uploadDate());
        hashCode = 31 * hashCode + Objects.hashCode(expiration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerCertificateMetadata)) {
            return false;
        }
        ServerCertificateMetadata other = (ServerCertificateMetadata) obj;
        return Objects.equals(path(), other.path()) && Objects.equals(serverCertificateName(), other.serverCertificateName())
                && Objects.equals(serverCertificateId(), other.serverCertificateId()) && Objects.equals(arn(), other.arn())
                && Objects.equals(uploadDate(), other.uploadDate()) && Objects.equals(expiration(), other.expiration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ServerCertificateMetadata").add("Path", path())
                .add("ServerCertificateName", serverCertificateName()).add("ServerCertificateId", serverCertificateId())
                .add("Arn", arn()).add("UploadDate", uploadDate()).add("Expiration", expiration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "ServerCertificateName":
            return Optional.ofNullable(clazz.cast(serverCertificateName()));
        case "ServerCertificateId":
            return Optional.ofNullable(clazz.cast(serverCertificateId()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "UploadDate":
            return Optional.ofNullable(clazz.cast(uploadDate()));
        case "Expiration":
            return Optional.ofNullable(clazz.cast(expiration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServerCertificateMetadata, T> g) {
        return obj -> g.apply((ServerCertificateMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServerCertificateMetadata> {
        /**
         * <p>
         * The path to the server certificate. For more information about paths, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the
         * <i>IAM User Guide</i>.
         * </p>
         * 
         * @param path
         *        The path to the server certificate. For more information about paths, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in
         *        the <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The name that identifies the server certificate.
         * </p>
         * 
         * @param serverCertificateName
         *        The name that identifies the server certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverCertificateName(String serverCertificateName);

        /**
         * <p>
         * The stable and unique string identifying the server certificate. For more information about IDs, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the
         * <i>IAM User Guide</i>.
         * </p>
         * 
         * @param serverCertificateId
         *        The stable and unique string identifying the server certificate. For more information about IDs, see
         *        <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a>
         *        in the <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverCertificateId(String serverCertificateId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) specifying the server certificate. For more information about ARNs and how to
         * use them in policies, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the
         * <i>IAM User Guide</i>.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) specifying the server certificate. For more information about ARNs and
         *        how to use them in policies, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in
         *        the <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date when the server certificate was uploaded.
         * </p>
         * 
         * @param uploadDate
         *        The date when the server certificate was uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadDate(Instant uploadDate);

        /**
         * <p>
         * The date on which the certificate is set to expire.
         * </p>
         * 
         * @param expiration
         *        The date on which the certificate is set to expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiration(Instant expiration);
    }

    static final class BuilderImpl implements Builder {
        private String path;

        private String serverCertificateName;

        private String serverCertificateId;

        private String arn;

        private Instant uploadDate;

        private Instant expiration;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerCertificateMetadata model) {
            path(model.path);
            serverCertificateName(model.serverCertificateName);
            serverCertificateId(model.serverCertificateId);
            arn(model.arn);
            uploadDate(model.uploadDate);
            expiration(model.expiration);
        }

        public final String getPath() {
            return path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getServerCertificateName() {
            return serverCertificateName;
        }

        @Override
        public final Builder serverCertificateName(String serverCertificateName) {
            this.serverCertificateName = serverCertificateName;
            return this;
        }

        public final void setServerCertificateName(String serverCertificateName) {
            this.serverCertificateName = serverCertificateName;
        }

        public final String getServerCertificateId() {
            return serverCertificateId;
        }

        @Override
        public final Builder serverCertificateId(String serverCertificateId) {
            this.serverCertificateId = serverCertificateId;
            return this;
        }

        public final void setServerCertificateId(String serverCertificateId) {
            this.serverCertificateId = serverCertificateId;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getUploadDate() {
            return uploadDate;
        }

        @Override
        public final Builder uploadDate(Instant uploadDate) {
            this.uploadDate = uploadDate;
            return this;
        }

        public final void setUploadDate(Instant uploadDate) {
            this.uploadDate = uploadDate;
        }

        public final Instant getExpiration() {
            return expiration;
        }

        @Override
        public final Builder expiration(Instant expiration) {
            this.expiration = expiration;
            return this;
        }

        public final void setExpiration(Instant expiration) {
            this.expiration = expiration;
        }

        @Override
        public ServerCertificateMetadata build() {
            return new ServerCertificateMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
