/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the most recent attempt to access the service.
 * </p>
 * <p>
 * This data type is used as a response element in the <a>GetServiceLastAccessedDetails</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceLastAccessed implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceLastAccessed.Builder, ServiceLastAccessed> {
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceLastAccessed::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()).build();

    private static final SdkField<Instant> LAST_AUTHENTICATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ServiceLastAccessed::lastAuthenticated)).setter(setter(Builder::lastAuthenticated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAuthenticated").build()).build();

    private static final SdkField<String> SERVICE_NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceLastAccessed::serviceNamespace)).setter(setter(Builder::serviceNamespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNamespace").build()).build();

    private static final SdkField<String> LAST_AUTHENTICATED_ENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceLastAccessed::lastAuthenticatedEntity)).setter(setter(Builder::lastAuthenticatedEntity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAuthenticatedEntity").build())
            .build();

    private static final SdkField<Integer> TOTAL_AUTHENTICATED_ENTITIES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ServiceLastAccessed::totalAuthenticatedEntities))
            .setter(setter(Builder::totalAuthenticatedEntities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalAuthenticatedEntities").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAME_FIELD,
            LAST_AUTHENTICATED_FIELD, SERVICE_NAMESPACE_FIELD, LAST_AUTHENTICATED_ENTITY_FIELD,
            TOTAL_AUTHENTICATED_ENTITIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serviceName;

    private final Instant lastAuthenticated;

    private final String serviceNamespace;

    private final String lastAuthenticatedEntity;

    private final Integer totalAuthenticatedEntities;

    private ServiceLastAccessed(BuilderImpl builder) {
        this.serviceName = builder.serviceName;
        this.lastAuthenticated = builder.lastAuthenticated;
        this.serviceNamespace = builder.serviceNamespace;
        this.lastAuthenticatedEntity = builder.lastAuthenticatedEntity;
        this.totalAuthenticatedEntities = builder.totalAuthenticatedEntities;
    }

    /**
     * <p>
     * The name of the service in which access was attempted.
     * </p>
     * 
     * @return The name of the service in which access was attempted.
     */
    public String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when an
     * authenticated entity most recently attempted to access the service. AWS does not report unauthenticated requests.
     * </p>
     * <p>
     * This field is null if no IAM entities attempted to access the service within the <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period"
     * >reporting period</a>.
     * </p>
     * 
     * @return The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when an
     *         authenticated entity most recently attempted to access the service. AWS does not report unauthenticated
     *         requests.</p>
     *         <p>
     *         This field is null if no IAM entities attempted to access the service within the <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period"
     *         >reporting period</a>.
     */
    public Instant lastAuthenticated() {
        return lastAuthenticated;
    }

    /**
     * <p>
     * The namespace of the service in which access was attempted.
     * </p>
     * <p>
     * To learn the service namespace of a service, go to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_actions-resources-contextkeys.html"
     * >Actions, Resources, and Condition Keys for AWS Services</a> in the <i>IAM User Guide</i>. Choose the name of the
     * service to view details for that service. In the first paragraph, find the service prefix. For example,
     * <code>(service prefix: a4b)</code>. For more information about service namespaces, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces"
     * >AWS Service Namespaces</a> in the <i>AWS General Reference</i>.
     * </p>
     * 
     * @return The namespace of the service in which access was attempted.</p>
     *         <p>
     *         To learn the service namespace of a service, go to <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_actions-resources-contextkeys.html"
     *         >Actions, Resources, and Condition Keys for AWS Services</a> in the <i>IAM User Guide</i>. Choose the
     *         name of the service to view details for that service. In the first paragraph, find the service prefix.
     *         For example, <code>(service prefix: a4b)</code>. For more information about service namespaces, see <a
     *         href=
     *         "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces"
     *         >AWS Service Namespaces</a> in the <i>AWS General Reference</i>.
     */
    public String serviceNamespace() {
        return serviceNamespace;
    }

    /**
     * <p>
     * The ARN of the authenticated entity (user or role) that last attempted to access the service. AWS does not report
     * unauthenticated requests.
     * </p>
     * <p>
     * This field is null if no IAM entities attempted to access the service within the <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period"
     * >reporting period</a>.
     * </p>
     * 
     * @return The ARN of the authenticated entity (user or role) that last attempted to access the service. AWS does
     *         not report unauthenticated requests.</p>
     *         <p>
     *         This field is null if no IAM entities attempted to access the service within the <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period"
     *         >reporting period</a>.
     */
    public String lastAuthenticatedEntity() {
        return lastAuthenticatedEntity;
    }

    /**
     * <p>
     * The total number of authenticated principals (root user, IAM users, or IAM roles) that have attempted to access
     * the service.
     * </p>
     * <p>
     * This field is null if no principals attempted to access the service within the <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period"
     * >reporting period</a>.
     * </p>
     * 
     * @return The total number of authenticated principals (root user, IAM users, or IAM roles) that have attempted to
     *         access the service.</p>
     *         <p>
     *         This field is null if no principals attempted to access the service within the <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period"
     *         >reporting period</a>.
     */
    public Integer totalAuthenticatedEntities() {
        return totalAuthenticatedEntities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(lastAuthenticated());
        hashCode = 31 * hashCode + Objects.hashCode(serviceNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(lastAuthenticatedEntity());
        hashCode = 31 * hashCode + Objects.hashCode(totalAuthenticatedEntities());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceLastAccessed)) {
            return false;
        }
        ServiceLastAccessed other = (ServiceLastAccessed) obj;
        return Objects.equals(serviceName(), other.serviceName())
                && Objects.equals(lastAuthenticated(), other.lastAuthenticated())
                && Objects.equals(serviceNamespace(), other.serviceNamespace())
                && Objects.equals(lastAuthenticatedEntity(), other.lastAuthenticatedEntity())
                && Objects.equals(totalAuthenticatedEntities(), other.totalAuthenticatedEntities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ServiceLastAccessed").add("ServiceName", serviceName())
                .add("LastAuthenticated", lastAuthenticated()).add("ServiceNamespace", serviceNamespace())
                .add("LastAuthenticatedEntity", lastAuthenticatedEntity())
                .add("TotalAuthenticatedEntities", totalAuthenticatedEntities()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "LastAuthenticated":
            return Optional.ofNullable(clazz.cast(lastAuthenticated()));
        case "ServiceNamespace":
            return Optional.ofNullable(clazz.cast(serviceNamespace()));
        case "LastAuthenticatedEntity":
            return Optional.ofNullable(clazz.cast(lastAuthenticatedEntity()));
        case "TotalAuthenticatedEntities":
            return Optional.ofNullable(clazz.cast(totalAuthenticatedEntities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceLastAccessed, T> g) {
        return obj -> g.apply((ServiceLastAccessed) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceLastAccessed> {
        /**
         * <p>
         * The name of the service in which access was attempted.
         * </p>
         * 
         * @param serviceName
         *        The name of the service in which access was attempted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when an
         * authenticated entity most recently attempted to access the service. AWS does not report unauthenticated
         * requests.
         * </p>
         * <p>
         * This field is null if no IAM entities attempted to access the service within the <a href=
         * "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period"
         * >reporting period</a>.
         * </p>
         * 
         * @param lastAuthenticated
         *        The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when an
         *        authenticated entity most recently attempted to access the service. AWS does not report
         *        unauthenticated requests.</p>
         *        <p>
         *        This field is null if no IAM entities attempted to access the service within the <a href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period"
         *        >reporting period</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAuthenticated(Instant lastAuthenticated);

        /**
         * <p>
         * The namespace of the service in which access was attempted.
         * </p>
         * <p>
         * To learn the service namespace of a service, go to <a href=
         * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_actions-resources-contextkeys.html"
         * >Actions, Resources, and Condition Keys for AWS Services</a> in the <i>IAM User Guide</i>. Choose the name of
         * the service to view details for that service. In the first paragraph, find the service prefix. For example,
         * <code>(service prefix: a4b)</code>. For more information about service namespaces, see <a href=
         * "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces"
         * >AWS Service Namespaces</a> in the <i>AWS General Reference</i>.
         * </p>
         * 
         * @param serviceNamespace
         *        The namespace of the service in which access was attempted.</p>
         *        <p>
         *        To learn the service namespace of a service, go to <a href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_actions-resources-contextkeys.html"
         *        >Actions, Resources, and Condition Keys for AWS Services</a> in the <i>IAM User Guide</i>. Choose the
         *        name of the service to view details for that service. In the first paragraph, find the service prefix.
         *        For example, <code>(service prefix: a4b)</code>. For more information about service namespaces, see <a
         *        href=
         *        "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces"
         *        >AWS Service Namespaces</a> in the <i>AWS General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNamespace(String serviceNamespace);

        /**
         * <p>
         * The ARN of the authenticated entity (user or role) that last attempted to access the service. AWS does not
         * report unauthenticated requests.
         * </p>
         * <p>
         * This field is null if no IAM entities attempted to access the service within the <a href=
         * "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period"
         * >reporting period</a>.
         * </p>
         * 
         * @param lastAuthenticatedEntity
         *        The ARN of the authenticated entity (user or role) that last attempted to access the service. AWS does
         *        not report unauthenticated requests.</p>
         *        <p>
         *        This field is null if no IAM entities attempted to access the service within the <a href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period"
         *        >reporting period</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAuthenticatedEntity(String lastAuthenticatedEntity);

        /**
         * <p>
         * The total number of authenticated principals (root user, IAM users, or IAM roles) that have attempted to
         * access the service.
         * </p>
         * <p>
         * This field is null if no principals attempted to access the service within the <a href=
         * "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period"
         * >reporting period</a>.
         * </p>
         * 
         * @param totalAuthenticatedEntities
         *        The total number of authenticated principals (root user, IAM users, or IAM roles) that have attempted
         *        to access the service.</p>
         *        <p>
         *        This field is null if no principals attempted to access the service within the <a href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period"
         *        >reporting period</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalAuthenticatedEntities(Integer totalAuthenticatedEntities);
    }

    static final class BuilderImpl implements Builder {
        private String serviceName;

        private Instant lastAuthenticated;

        private String serviceNamespace;

        private String lastAuthenticatedEntity;

        private Integer totalAuthenticatedEntities;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceLastAccessed model) {
            serviceName(model.serviceName);
            lastAuthenticated(model.lastAuthenticated);
            serviceNamespace(model.serviceNamespace);
            lastAuthenticatedEntity(model.lastAuthenticatedEntity);
            totalAuthenticatedEntities(model.totalAuthenticatedEntities);
        }

        public final String getServiceName() {
            return serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final Instant getLastAuthenticated() {
            return lastAuthenticated;
        }

        @Override
        public final Builder lastAuthenticated(Instant lastAuthenticated) {
            this.lastAuthenticated = lastAuthenticated;
            return this;
        }

        public final void setLastAuthenticated(Instant lastAuthenticated) {
            this.lastAuthenticated = lastAuthenticated;
        }

        public final String getServiceNamespace() {
            return serviceNamespace;
        }

        @Override
        public final Builder serviceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        public final void setServiceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
        }

        public final String getLastAuthenticatedEntity() {
            return lastAuthenticatedEntity;
        }

        @Override
        public final Builder lastAuthenticatedEntity(String lastAuthenticatedEntity) {
            this.lastAuthenticatedEntity = lastAuthenticatedEntity;
            return this;
        }

        public final void setLastAuthenticatedEntity(String lastAuthenticatedEntity) {
            this.lastAuthenticatedEntity = lastAuthenticatedEntity;
        }

        public final Integer getTotalAuthenticatedEntities() {
            return totalAuthenticatedEntities;
        }

        @Override
        public final Builder totalAuthenticatedEntities(Integer totalAuthenticatedEntities) {
            this.totalAuthenticatedEntities = totalAuthenticatedEntities;
            return this;
        }

        public final void setTotalAuthenticatedEntities(Integer totalAuthenticatedEntities) {
            this.totalAuthenticatedEntities = totalAuthenticatedEntities;
        }

        @Override
        public ServiceLastAccessed build() {
            return new ServiceLastAccessed(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
