/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SimulateCustomPolicyRequest extends IamRequest implements
        ToCopyableBuilder<SimulateCustomPolicyRequest.Builder, SimulateCustomPolicyRequest> {
    private static final SdkField<List<String>> POLICY_INPUT_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(SimulateCustomPolicyRequest::policyInputList))
            .setter(setter(Builder::policyInputList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyInputList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PERMISSIONS_BOUNDARY_POLICY_INPUT_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(SimulateCustomPolicyRequest::permissionsBoundaryPolicyInputList))
            .setter(setter(Builder::permissionsBoundaryPolicyInputList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsBoundaryPolicyInputList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ACTION_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(SimulateCustomPolicyRequest::actionNames))
            .setter(setter(Builder::actionNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RESOURCE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(SimulateCustomPolicyRequest::resourceArns))
            .setter(setter(Builder::resourceArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SimulateCustomPolicyRequest::resourcePolicy)).setter(setter(Builder::resourcePolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcePolicy").build()).build();

    private static final SdkField<String> RESOURCE_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SimulateCustomPolicyRequest::resourceOwner)).setter(setter(Builder::resourceOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceOwner").build()).build();

    private static final SdkField<String> CALLER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SimulateCustomPolicyRequest::callerArn)).setter(setter(Builder::callerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallerArn").build()).build();

    private static final SdkField<List<ContextEntry>> CONTEXT_ENTRIES_FIELD = SdkField
            .<List<ContextEntry>> builder(MarshallingType.LIST)
            .getter(getter(SimulateCustomPolicyRequest::contextEntries))
            .setter(setter(Builder::contextEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextEntries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContextEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContextEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_HANDLING_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SimulateCustomPolicyRequest::resourceHandlingOption)).setter(setter(Builder::resourceHandlingOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceHandlingOption").build())
            .build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(SimulateCustomPolicyRequest::maxItems)).setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SimulateCustomPolicyRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_INPUT_LIST_FIELD,
            PERMISSIONS_BOUNDARY_POLICY_INPUT_LIST_FIELD, ACTION_NAMES_FIELD, RESOURCE_ARNS_FIELD, RESOURCE_POLICY_FIELD,
            RESOURCE_OWNER_FIELD, CALLER_ARN_FIELD, CONTEXT_ENTRIES_FIELD, RESOURCE_HANDLING_OPTION_FIELD, MAX_ITEMS_FIELD,
            MARKER_FIELD));

    private final List<String> policyInputList;

    private final List<String> permissionsBoundaryPolicyInputList;

    private final List<String> actionNames;

    private final List<String> resourceArns;

    private final String resourcePolicy;

    private final String resourceOwner;

    private final String callerArn;

    private final List<ContextEntry> contextEntries;

    private final String resourceHandlingOption;

    private final Integer maxItems;

    private final String marker;

    private SimulateCustomPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.policyInputList = builder.policyInputList;
        this.permissionsBoundaryPolicyInputList = builder.permissionsBoundaryPolicyInputList;
        this.actionNames = builder.actionNames;
        this.resourceArns = builder.resourceArns;
        this.resourcePolicy = builder.resourcePolicy;
        this.resourceOwner = builder.resourceOwner;
        this.callerArn = builder.callerArn;
        this.contextEntries = builder.contextEntries;
        this.resourceHandlingOption = builder.resourceHandlingOption;
        this.maxItems = builder.maxItems;
        this.marker = builder.marker;
    }

    /**
     * Returns true if the PolicyInputList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasPolicyInputList() {
        return policyInputList != null && !(policyInputList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of policy documents to include in the simulation. Each document is specified as a string containing the
     * complete, valid JSON text of an IAM policy. Do not include any resource-based policies in this parameter. Any
     * resource-based policy must be submitted with the <code>ResourcePolicy</code> parameter. The policies cannot be
     * "scope-down" policies, such as you could include in a call to <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetFederationToken.html">GetFederationToken</a> or
     * one of the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_AssumeRole.html">AssumeRole</a> API
     * operations. In other words, do not use policies designed to restrict what a user can do while using the temporary
     * credentials.
     * </p>
     * <p>
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of
     * characters consisting of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the ASCII
     * character range
     * </p>
     * </li>
     * <li>
     * <p>
     * The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>
     * )
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPolicyInputList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of policy documents to include in the simulation. Each document is specified as a string
     *         containing the complete, valid JSON text of an IAM policy. Do not include any resource-based policies in
     *         this parameter. Any resource-based policy must be submitted with the <code>ResourcePolicy</code>
     *         parameter. The policies cannot be "scope-down" policies, such as you could include in a call to <a
     *         href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetFederationToken.html"
     *         >GetFederationToken</a> or one of the <a
     *         href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_AssumeRole.html">AssumeRole</a> API
     *         operations. In other words, do not use policies designed to restrict what a user can do while using the
     *         temporary credentials.</p>
     *         <p>
     *         The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a
     *         string of characters consisting of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of
     *         the ASCII character range
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The printable characters in the Basic Latin and Latin-1 Supplement character set (through
     *         <code>\u00FF</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (
     *         <code>\u000D</code>)
     *         </p>
     *         </li>
     */
    public List<String> policyInputList() {
        return policyInputList;
    }

    /**
     * Returns true if the PermissionsBoundaryPolicyInputList property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasPermissionsBoundaryPolicyInputList() {
        return permissionsBoundaryPolicyInputList != null
                && !(permissionsBoundaryPolicyInputList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IAM permissions boundary policy to simulate. The permissions boundary sets the maximum permissions that an
     * IAM entity can have. You can input only one permissions boundary when you pass a policy to this operation. For
     * more information about permissions boundaries, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions Boundaries
     * for IAM Entities</a> in the <i>IAM User Guide</i>. The policy input is specified as a string that contains the
     * complete, valid JSON text of a permissions boundary policy.
     * </p>
     * <p>
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of
     * characters consisting of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the ASCII
     * character range
     * </p>
     * </li>
     * <li>
     * <p>
     * The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>
     * )
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPermissionsBoundaryPolicyInputList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IAM permissions boundary policy to simulate. The permissions boundary sets the maximum permissions
     *         that an IAM entity can have. You can input only one permissions boundary when you pass a policy to this
     *         operation. For more information about permissions boundaries, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions
     *         Boundaries for IAM Entities</a> in the <i>IAM User Guide</i>. The policy input is specified as a string
     *         that contains the complete, valid JSON text of a permissions boundary policy.</p>
     *         <p>
     *         The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a
     *         string of characters consisting of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of
     *         the ASCII character range
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The printable characters in the Basic Latin and Latin-1 Supplement character set (through
     *         <code>\u00FF</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (
     *         <code>\u000D</code>)
     *         </p>
     *         </li>
     */
    public List<String> permissionsBoundaryPolicyInputList() {
        return permissionsBoundaryPolicyInputList;
    }

    /**
     * Returns true if the ActionNames property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasActionNames() {
        return actionNames != null && !(actionNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of names of API operations to evaluate in the simulation. Each operation is evaluated against each
     * resource. Each operation must include the service identifier, such as <code>iam:CreateUser</code>. This operation
     * does not support using wildcards (*) in an action name.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasActionNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of names of API operations to evaluate in the simulation. Each operation is evaluated against each
     *         resource. Each operation must include the service identifier, such as <code>iam:CreateUser</code>. This
     *         operation does not support using wildcards (*) in an action name.
     */
    public List<String> actionNames() {
        return actionNames;
    }

    /**
     * Returns true if the ResourceArns property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasResourceArns() {
        return resourceArns != null && !(resourceArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of ARNs of AWS resources to include in the simulation. If this parameter is not provided, then the value
     * defaults to <code>*</code> (all resources). Each API in the <code>ActionNames</code> parameter is evaluated for
     * each resource in this list. The simulation determines the access result (allowed or denied) of each combination
     * and reports it in the response.
     * </p>
     * <p>
     * The simulation does not automatically retrieve policies for the specified resources. If you want to include a
     * resource policy in the simulation, then you must include the policy as a string in the
     * <code>ResourcePolicy</code> parameter.
     * </p>
     * <p>
     * If you include a <code>ResourcePolicy</code>, then it must be applicable to all of the resources included in the
     * simulation or you receive an invalid input error.
     * </p>
     * <p>
     * For more information about ARNs, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)
     * and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of ARNs of AWS resources to include in the simulation. If this parameter is not provided, then the
     *         value defaults to <code>*</code> (all resources). Each API in the <code>ActionNames</code> parameter is
     *         evaluated for each resource in this list. The simulation determines the access result (allowed or denied)
     *         of each combination and reports it in the response.</p>
     *         <p>
     *         The simulation does not automatically retrieve policies for the specified resources. If you want to
     *         include a resource policy in the simulation, then you must include the policy as a string in the
     *         <code>ResourcePolicy</code> parameter.
     *         </p>
     *         <p>
     *         If you include a <code>ResourcePolicy</code>, then it must be applicable to all of the resources included
     *         in the simulation or you receive an invalid input error.
     *         </p>
     *         <p>
     *         For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *         (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.
     */
    public List<String> resourceArns() {
        return resourceArns;
    }

    /**
     * <p>
     * A resource-based policy to include in the simulation provided as a string. Each resource in the simulation is
     * treated as if it had this policy attached. You can include only one resource-based policy in a simulation.
     * </p>
     * <p>
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of
     * characters consisting of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the ASCII
     * character range
     * </p>
     * </li>
     * <li>
     * <p>
     * The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>
     * )
     * </p>
     * </li>
     * </ul>
     * 
     * @return A resource-based policy to include in the simulation provided as a string. Each resource in the
     *         simulation is treated as if it had this policy attached. You can include only one resource-based policy
     *         in a simulation.</p>
     *         <p>
     *         The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a
     *         string of characters consisting of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of
     *         the ASCII character range
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The printable characters in the Basic Latin and Latin-1 Supplement character set (through
     *         <code>\u00FF</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (
     *         <code>\u000D</code>)
     *         </p>
     *         </li>
     */
    public String resourcePolicy() {
        return resourcePolicy;
    }

    /**
     * <p>
     * An ARN representing the AWS account ID that specifies the owner of any simulated resource that does not identify
     * its owner in the resource ARN. Examples of resource ARNs include an S3 bucket or object. If
     * <code>ResourceOwner</code> is specified, it is also used as the account owner of any <code>ResourcePolicy</code>
     * included in the simulation. If the <code>ResourceOwner</code> parameter is not specified, then the owner of the
     * resources and the resource policy defaults to the account of the identity provided in <code>CallerArn</code>.
     * This parameter is required only if you specify a resource-based policy and account that owns the resource is
     * different from the account that owns the simulated calling user <code>CallerArn</code>.
     * </p>
     * <p>
     * The ARN for an account uses the following syntax: <code>arn:aws:iam::<i>AWS-account-ID</i>:root</code>. For
     * example, to represent the account with the 112233445566 ID, use the following ARN:
     * <code>arn:aws:iam::112233445566-ID:root</code>.
     * </p>
     * 
     * @return An ARN representing the AWS account ID that specifies the owner of any simulated resource that does not
     *         identify its owner in the resource ARN. Examples of resource ARNs include an S3 bucket or object. If
     *         <code>ResourceOwner</code> is specified, it is also used as the account owner of any
     *         <code>ResourcePolicy</code> included in the simulation. If the <code>ResourceOwner</code> parameter is
     *         not specified, then the owner of the resources and the resource policy defaults to the account of the
     *         identity provided in <code>CallerArn</code>. This parameter is required only if you specify a
     *         resource-based policy and account that owns the resource is different from the account that owns the
     *         simulated calling user <code>CallerArn</code>.</p>
     *         <p>
     *         The ARN for an account uses the following syntax: <code>arn:aws:iam::<i>AWS-account-ID</i>:root</code>.
     *         For example, to represent the account with the 112233445566 ID, use the following ARN:
     *         <code>arn:aws:iam::112233445566-ID:root</code>.
     */
    public String resourceOwner() {
        return resourceOwner;
    }

    /**
     * <p>
     * The ARN of the IAM user that you want to use as the simulated caller of the API operations.
     * <code>CallerArn</code> is required if you include a <code>ResourcePolicy</code> so that the policy's
     * <code>Principal</code> element has a value to use in evaluating the policy.
     * </p>
     * <p>
     * You can specify only the ARN of an IAM user. You cannot specify the ARN of an assumed role, federated user, or a
     * service principal.
     * </p>
     * 
     * @return The ARN of the IAM user that you want to use as the simulated caller of the API operations.
     *         <code>CallerArn</code> is required if you include a <code>ResourcePolicy</code> so that the policy's
     *         <code>Principal</code> element has a value to use in evaluating the policy.</p>
     *         <p>
     *         You can specify only the ARN of an IAM user. You cannot specify the ARN of an assumed role, federated
     *         user, or a service principal.
     */
    public String callerArn() {
        return callerArn;
    }

    /**
     * Returns true if the ContextEntries property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasContextEntries() {
        return contextEntries != null && !(contextEntries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of context keys and corresponding values for the simulation to use. Whenever a context key is evaluated in
     * one of the simulated IAM permissions policies, the corresponding value is supplied.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasContextEntries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of context keys and corresponding values for the simulation to use. Whenever a context key is
     *         evaluated in one of the simulated IAM permissions policies, the corresponding value is supplied.
     */
    public List<ContextEntry> contextEntries() {
        return contextEntries;
    }

    /**
     * <p>
     * Specifies the type of simulation to run. Different API operations that support resource-based policies require
     * different combinations of resources. By specifying the type of simulation to run, you enable the policy simulator
     * to enforce the presence of the required resources to ensure reliable simulation results. If your simulation does
     * not match one of the following scenarios, then you can omit this parameter. The following list shows each of the
     * supported scenario values and the resources that you must define to run the simulation.
     * </p>
     * <p>
     * Each of the EC2 scenarios requires that you specify instance, image, and security-group resources. If your
     * scenario includes an EBS volume, then you must specify that volume as a resource. If the EC2 scenario includes
     * VPC, then you must supply the network-interface resource. If it includes an IP subnet, then you must specify the
     * subnet resource. For more information on the EC2 scenario options, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported Platforms</a>
     * in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>EC2-Classic-InstanceStore</b>
     * </p>
     * <p>
     * instance, image, security-group
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>EC2-Classic-EBS</b>
     * </p>
     * <p>
     * instance, image, security-group, volume
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>EC2-VPC-InstanceStore</b>
     * </p>
     * <p>
     * instance, image, security-group, network-interface
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>EC2-VPC-InstanceStore-Subnet</b>
     * </p>
     * <p>
     * instance, image, security-group, network-interface, subnet
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>EC2-VPC-EBS</b>
     * </p>
     * <p>
     * instance, image, security-group, network-interface, volume
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>EC2-VPC-EBS-Subnet</b>
     * </p>
     * <p>
     * instance, image, security-group, network-interface, subnet, volume
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies the type of simulation to run. Different API operations that support resource-based policies
     *         require different combinations of resources. By specifying the type of simulation to run, you enable the
     *         policy simulator to enforce the presence of the required resources to ensure reliable simulation results.
     *         If your simulation does not match one of the following scenarios, then you can omit this parameter. The
     *         following list shows each of the supported scenario values and the resources that you must define to run
     *         the simulation.</p>
     *         <p>
     *         Each of the EC2 scenarios requires that you specify instance, image, and security-group resources. If
     *         your scenario includes an EBS volume, then you must specify that volume as a resource. If the EC2
     *         scenario includes VPC, then you must supply the network-interface resource. If it includes an IP subnet,
     *         then you must specify the subnet resource. For more information on the EC2 scenario options, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported
     *         Platforms</a> in the <i>Amazon EC2 User Guide</i>.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>EC2-Classic-InstanceStore</b>
     *         </p>
     *         <p>
     *         instance, image, security-group
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>EC2-Classic-EBS</b>
     *         </p>
     *         <p>
     *         instance, image, security-group, volume
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>EC2-VPC-InstanceStore</b>
     *         </p>
     *         <p>
     *         instance, image, security-group, network-interface
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>EC2-VPC-InstanceStore-Subnet</b>
     *         </p>
     *         <p>
     *         instance, image, security-group, network-interface, subnet
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>EC2-VPC-EBS</b>
     *         </p>
     *         <p>
     *         instance, image, security-group, network-interface, volume
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>EC2-VPC-EBS-Subnet</b>
     *         </p>
     *         <p>
     *         instance, image, security-group, network-interface, subnet, volume
     *         </p>
     *         </li>
     */
    public String resourceHandlingOption() {
        return resourceHandlingOption;
    }

    /**
     * <p>
     * Use this only when paginating results to indicate the maximum number of items you want in the response. If
     * additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is
     * <code>true</code>.
     * </p>
     * <p>
     * If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer
     * results, even when there are more results available. In that case, the <code>IsTruncated</code> response element
     * returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells
     * the service where to continue from.
     * </p>
     * 
     * @return Use this only when paginating results to indicate the maximum number of items you want in the response.
     *         If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element
     *         is <code>true</code>.</p>
     *         <p>
     *         If you do not include this parameter, the number of items defaults to 100. Note that IAM might return
     *         fewer results, even when there are more results available. In that case, the <code>IsTruncated</code>
     *         response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the
     *         subsequent call that tells the service where to continue from.
     */
    public Integer maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * Use this parameter only when paginating results and only after you receive a response indicating that the results
     * are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to
     * indicate where the next call should start.
     * </p>
     * 
     * @return Use this parameter only when paginating results and only after you receive a response indicating that the
     *         results are truncated. Set it to the value of the <code>Marker</code> element in the response that you
     *         received to indicate where the next call should start.
     */
    public String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyInputList());
        hashCode = 31 * hashCode + Objects.hashCode(permissionsBoundaryPolicyInputList());
        hashCode = 31 * hashCode + Objects.hashCode(actionNames());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArns());
        hashCode = 31 * hashCode + Objects.hashCode(resourcePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(resourceOwner());
        hashCode = 31 * hashCode + Objects.hashCode(callerArn());
        hashCode = 31 * hashCode + Objects.hashCode(contextEntries());
        hashCode = 31 * hashCode + Objects.hashCode(resourceHandlingOption());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimulateCustomPolicyRequest)) {
            return false;
        }
        SimulateCustomPolicyRequest other = (SimulateCustomPolicyRequest) obj;
        return Objects.equals(policyInputList(), other.policyInputList())
                && Objects.equals(permissionsBoundaryPolicyInputList(), other.permissionsBoundaryPolicyInputList())
                && Objects.equals(actionNames(), other.actionNames()) && Objects.equals(resourceArns(), other.resourceArns())
                && Objects.equals(resourcePolicy(), other.resourcePolicy())
                && Objects.equals(resourceOwner(), other.resourceOwner()) && Objects.equals(callerArn(), other.callerArn())
                && Objects.equals(contextEntries(), other.contextEntries())
                && Objects.equals(resourceHandlingOption(), other.resourceHandlingOption())
                && Objects.equals(maxItems(), other.maxItems()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SimulateCustomPolicyRequest").add("PolicyInputList", policyInputList())
                .add("PermissionsBoundaryPolicyInputList", permissionsBoundaryPolicyInputList())
                .add("ActionNames", actionNames()).add("ResourceArns", resourceArns()).add("ResourcePolicy", resourcePolicy())
                .add("ResourceOwner", resourceOwner()).add("CallerArn", callerArn()).add("ContextEntries", contextEntries())
                .add("ResourceHandlingOption", resourceHandlingOption()).add("MaxItems", maxItems()).add("Marker", marker())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyInputList":
            return Optional.ofNullable(clazz.cast(policyInputList()));
        case "PermissionsBoundaryPolicyInputList":
            return Optional.ofNullable(clazz.cast(permissionsBoundaryPolicyInputList()));
        case "ActionNames":
            return Optional.ofNullable(clazz.cast(actionNames()));
        case "ResourceArns":
            return Optional.ofNullable(clazz.cast(resourceArns()));
        case "ResourcePolicy":
            return Optional.ofNullable(clazz.cast(resourcePolicy()));
        case "ResourceOwner":
            return Optional.ofNullable(clazz.cast(resourceOwner()));
        case "CallerArn":
            return Optional.ofNullable(clazz.cast(callerArn()));
        case "ContextEntries":
            return Optional.ofNullable(clazz.cast(contextEntries()));
        case "ResourceHandlingOption":
            return Optional.ofNullable(clazz.cast(resourceHandlingOption()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SimulateCustomPolicyRequest, T> g) {
        return obj -> g.apply((SimulateCustomPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamRequest.Builder, SdkPojo, CopyableBuilder<Builder, SimulateCustomPolicyRequest> {
        /**
         * <p>
         * A list of policy documents to include in the simulation. Each document is specified as a string containing
         * the complete, valid JSON text of an IAM policy. Do not include any resource-based policies in this parameter.
         * Any resource-based policy must be submitted with the <code>ResourcePolicy</code> parameter. The policies
         * cannot be "scope-down" policies, such as you could include in a call to <a
         * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetFederationToken.html">GetFederationToken</a>
         * or one of the <a
         * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_AssumeRole.html">AssumeRole</a> API operations.
         * In other words, do not use policies designed to restrict what a user can do while using the temporary
         * credentials.
         * </p>
         * <p>
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string
         * of characters consisting of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the
         * ASCII character range
         * </p>
         * </li>
         * <li>
         * <p>
         * The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>
         * )
         * </p>
         * </li>
         * <li>
         * <p>
         * The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (
         * <code>\u000D</code>)
         * </p>
         * </li>
         * </ul>
         * 
         * @param policyInputList
         *        A list of policy documents to include in the simulation. Each document is specified as a string
         *        containing the complete, valid JSON text of an IAM policy. Do not include any resource-based policies
         *        in this parameter. Any resource-based policy must be submitted with the <code>ResourcePolicy</code>
         *        parameter. The policies cannot be "scope-down" policies, such as you could include in a call to <a
         *        href
         *        ="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetFederationToken.html">GetFederationToken
         *        </a> or one of the <a
         *        href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_AssumeRole.html">AssumeRole</a> API
         *        operations. In other words, do not use policies designed to restrict what a user can do while using
         *        the temporary credentials.</p>
         *        <p>
         *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a
         *        string of characters consisting of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end
         *        of the ASCII character range
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The printable characters in the Basic Latin and Latin-1 Supplement character set (through
         *        <code>\u00FF</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return
         *        (<code>\u000D</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyInputList(Collection<String> policyInputList);

        /**
         * <p>
         * A list of policy documents to include in the simulation. Each document is specified as a string containing
         * the complete, valid JSON text of an IAM policy. Do not include any resource-based policies in this parameter.
         * Any resource-based policy must be submitted with the <code>ResourcePolicy</code> parameter. The policies
         * cannot be "scope-down" policies, such as you could include in a call to <a
         * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetFederationToken.html">GetFederationToken</a>
         * or one of the <a
         * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_AssumeRole.html">AssumeRole</a> API operations.
         * In other words, do not use policies designed to restrict what a user can do while using the temporary
         * credentials.
         * </p>
         * <p>
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string
         * of characters consisting of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the
         * ASCII character range
         * </p>
         * </li>
         * <li>
         * <p>
         * The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>
         * )
         * </p>
         * </li>
         * <li>
         * <p>
         * The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (
         * <code>\u000D</code>)
         * </p>
         * </li>
         * </ul>
         * 
         * @param policyInputList
         *        A list of policy documents to include in the simulation. Each document is specified as a string
         *        containing the complete, valid JSON text of an IAM policy. Do not include any resource-based policies
         *        in this parameter. Any resource-based policy must be submitted with the <code>ResourcePolicy</code>
         *        parameter. The policies cannot be "scope-down" policies, such as you could include in a call to <a
         *        href
         *        ="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetFederationToken.html">GetFederationToken
         *        </a> or one of the <a
         *        href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_AssumeRole.html">AssumeRole</a> API
         *        operations. In other words, do not use policies designed to restrict what a user can do while using
         *        the temporary credentials.</p>
         *        <p>
         *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a
         *        string of characters consisting of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end
         *        of the ASCII character range
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The printable characters in the Basic Latin and Latin-1 Supplement character set (through
         *        <code>\u00FF</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return
         *        (<code>\u000D</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyInputList(String... policyInputList);

        /**
         * <p>
         * The IAM permissions boundary policy to simulate. The permissions boundary sets the maximum permissions that
         * an IAM entity can have. You can input only one permissions boundary when you pass a policy to this operation.
         * For more information about permissions boundaries, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions
         * Boundaries for IAM Entities</a> in the <i>IAM User Guide</i>. The policy input is specified as a string that
         * contains the complete, valid JSON text of a permissions boundary policy.
         * </p>
         * <p>
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string
         * of characters consisting of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the
         * ASCII character range
         * </p>
         * </li>
         * <li>
         * <p>
         * The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>
         * )
         * </p>
         * </li>
         * <li>
         * <p>
         * The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (
         * <code>\u000D</code>)
         * </p>
         * </li>
         * </ul>
         * 
         * @param permissionsBoundaryPolicyInputList
         *        The IAM permissions boundary policy to simulate. The permissions boundary sets the maximum permissions
         *        that an IAM entity can have. You can input only one permissions boundary when you pass a policy to
         *        this operation. For more information about permissions boundaries, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions
         *        Boundaries for IAM Entities</a> in the <i>IAM User Guide</i>. The policy input is specified as a
         *        string that contains the complete, valid JSON text of a permissions boundary policy.</p>
         *        <p>
         *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a
         *        string of characters consisting of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end
         *        of the ASCII character range
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The printable characters in the Basic Latin and Latin-1 Supplement character set (through
         *        <code>\u00FF</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return
         *        (<code>\u000D</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsBoundaryPolicyInputList(Collection<String> permissionsBoundaryPolicyInputList);

        /**
         * <p>
         * The IAM permissions boundary policy to simulate. The permissions boundary sets the maximum permissions that
         * an IAM entity can have. You can input only one permissions boundary when you pass a policy to this operation.
         * For more information about permissions boundaries, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions
         * Boundaries for IAM Entities</a> in the <i>IAM User Guide</i>. The policy input is specified as a string that
         * contains the complete, valid JSON text of a permissions boundary policy.
         * </p>
         * <p>
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string
         * of characters consisting of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the
         * ASCII character range
         * </p>
         * </li>
         * <li>
         * <p>
         * The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>
         * )
         * </p>
         * </li>
         * <li>
         * <p>
         * The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (
         * <code>\u000D</code>)
         * </p>
         * </li>
         * </ul>
         * 
         * @param permissionsBoundaryPolicyInputList
         *        The IAM permissions boundary policy to simulate. The permissions boundary sets the maximum permissions
         *        that an IAM entity can have. You can input only one permissions boundary when you pass a policy to
         *        this operation. For more information about permissions boundaries, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions
         *        Boundaries for IAM Entities</a> in the <i>IAM User Guide</i>. The policy input is specified as a
         *        string that contains the complete, valid JSON text of a permissions boundary policy.</p>
         *        <p>
         *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a
         *        string of characters consisting of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end
         *        of the ASCII character range
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The printable characters in the Basic Latin and Latin-1 Supplement character set (through
         *        <code>\u00FF</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return
         *        (<code>\u000D</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsBoundaryPolicyInputList(String... permissionsBoundaryPolicyInputList);

        /**
         * <p>
         * A list of names of API operations to evaluate in the simulation. Each operation is evaluated against each
         * resource. Each operation must include the service identifier, such as <code>iam:CreateUser</code>. This
         * operation does not support using wildcards (*) in an action name.
         * </p>
         * 
         * @param actionNames
         *        A list of names of API operations to evaluate in the simulation. Each operation is evaluated against
         *        each resource. Each operation must include the service identifier, such as <code>iam:CreateUser</code>
         *        . This operation does not support using wildcards (*) in an action name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionNames(Collection<String> actionNames);

        /**
         * <p>
         * A list of names of API operations to evaluate in the simulation. Each operation is evaluated against each
         * resource. Each operation must include the service identifier, such as <code>iam:CreateUser</code>. This
         * operation does not support using wildcards (*) in an action name.
         * </p>
         * 
         * @param actionNames
         *        A list of names of API operations to evaluate in the simulation. Each operation is evaluated against
         *        each resource. Each operation must include the service identifier, such as <code>iam:CreateUser</code>
         *        . This operation does not support using wildcards (*) in an action name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionNames(String... actionNames);

        /**
         * <p>
         * A list of ARNs of AWS resources to include in the simulation. If this parameter is not provided, then the
         * value defaults to <code>*</code> (all resources). Each API in the <code>ActionNames</code> parameter is
         * evaluated for each resource in this list. The simulation determines the access result (allowed or denied) of
         * each combination and reports it in the response.
         * </p>
         * <p>
         * The simulation does not automatically retrieve policies for the specified resources. If you want to include a
         * resource policy in the simulation, then you must include the policy as a string in the
         * <code>ResourcePolicy</code> parameter.
         * </p>
         * <p>
         * If you include a <code>ResourcePolicy</code>, then it must be applicable to all of the resources included in
         * the simulation or you receive an invalid input error.
         * </p>
         * <p>
         * For more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.
         * </p>
         * 
         * @param resourceArns
         *        A list of ARNs of AWS resources to include in the simulation. If this parameter is not provided, then
         *        the value defaults to <code>*</code> (all resources). Each API in the <code>ActionNames</code>
         *        parameter is evaluated for each resource in this list. The simulation determines the access result
         *        (allowed or denied) of each combination and reports it in the response.</p>
         *        <p>
         *        The simulation does not automatically retrieve policies for the specified resources. If you want to
         *        include a resource policy in the simulation, then you must include the policy as a string in the
         *        <code>ResourcePolicy</code> parameter.
         *        </p>
         *        <p>
         *        If you include a <code>ResourcePolicy</code>, then it must be applicable to all of the resources
         *        included in the simulation or you receive an invalid input error.
         *        </p>
         *        <p>
         *        For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArns(Collection<String> resourceArns);

        /**
         * <p>
         * A list of ARNs of AWS resources to include in the simulation. If this parameter is not provided, then the
         * value defaults to <code>*</code> (all resources). Each API in the <code>ActionNames</code> parameter is
         * evaluated for each resource in this list. The simulation determines the access result (allowed or denied) of
         * each combination and reports it in the response.
         * </p>
         * <p>
         * The simulation does not automatically retrieve policies for the specified resources. If you want to include a
         * resource policy in the simulation, then you must include the policy as a string in the
         * <code>ResourcePolicy</code> parameter.
         * </p>
         * <p>
         * If you include a <code>ResourcePolicy</code>, then it must be applicable to all of the resources included in
         * the simulation or you receive an invalid input error.
         * </p>
         * <p>
         * For more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.
         * </p>
         * 
         * @param resourceArns
         *        A list of ARNs of AWS resources to include in the simulation. If this parameter is not provided, then
         *        the value defaults to <code>*</code> (all resources). Each API in the <code>ActionNames</code>
         *        parameter is evaluated for each resource in this list. The simulation determines the access result
         *        (allowed or denied) of each combination and reports it in the response.</p>
         *        <p>
         *        The simulation does not automatically retrieve policies for the specified resources. If you want to
         *        include a resource policy in the simulation, then you must include the policy as a string in the
         *        <code>ResourcePolicy</code> parameter.
         *        </p>
         *        <p>
         *        If you include a <code>ResourcePolicy</code>, then it must be applicable to all of the resources
         *        included in the simulation or you receive an invalid input error.
         *        </p>
         *        <p>
         *        For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArns(String... resourceArns);

        /**
         * <p>
         * A resource-based policy to include in the simulation provided as a string. Each resource in the simulation is
         * treated as if it had this policy attached. You can include only one resource-based policy in a simulation.
         * </p>
         * <p>
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string
         * of characters consisting of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the
         * ASCII character range
         * </p>
         * </li>
         * <li>
         * <p>
         * The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>
         * )
         * </p>
         * </li>
         * <li>
         * <p>
         * The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (
         * <code>\u000D</code>)
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourcePolicy
         *        A resource-based policy to include in the simulation provided as a string. Each resource in the
         *        simulation is treated as if it had this policy attached. You can include only one resource-based
         *        policy in a simulation.</p>
         *        <p>
         *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a
         *        string of characters consisting of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end
         *        of the ASCII character range
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The printable characters in the Basic Latin and Latin-1 Supplement character set (through
         *        <code>\u00FF</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return
         *        (<code>\u000D</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcePolicy(String resourcePolicy);

        /**
         * <p>
         * An ARN representing the AWS account ID that specifies the owner of any simulated resource that does not
         * identify its owner in the resource ARN. Examples of resource ARNs include an S3 bucket or object. If
         * <code>ResourceOwner</code> is specified, it is also used as the account owner of any
         * <code>ResourcePolicy</code> included in the simulation. If the <code>ResourceOwner</code> parameter is not
         * specified, then the owner of the resources and the resource policy defaults to the account of the identity
         * provided in <code>CallerArn</code>. This parameter is required only if you specify a resource-based policy
         * and account that owns the resource is different from the account that owns the simulated calling user
         * <code>CallerArn</code>.
         * </p>
         * <p>
         * The ARN for an account uses the following syntax: <code>arn:aws:iam::<i>AWS-account-ID</i>:root</code>. For
         * example, to represent the account with the 112233445566 ID, use the following ARN:
         * <code>arn:aws:iam::112233445566-ID:root</code>.
         * </p>
         * 
         * @param resourceOwner
         *        An ARN representing the AWS account ID that specifies the owner of any simulated resource that does
         *        not identify its owner in the resource ARN. Examples of resource ARNs include an S3 bucket or object.
         *        If <code>ResourceOwner</code> is specified, it is also used as the account owner of any
         *        <code>ResourcePolicy</code> included in the simulation. If the <code>ResourceOwner</code> parameter is
         *        not specified, then the owner of the resources and the resource policy defaults to the account of the
         *        identity provided in <code>CallerArn</code>. This parameter is required only if you specify a
         *        resource-based policy and account that owns the resource is different from the account that owns the
         *        simulated calling user <code>CallerArn</code>.</p>
         *        <p>
         *        The ARN for an account uses the following syntax: <code>arn:aws:iam::<i>AWS-account-ID</i>:root</code>
         *        . For example, to represent the account with the 112233445566 ID, use the following ARN:
         *        <code>arn:aws:iam::112233445566-ID:root</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceOwner(String resourceOwner);

        /**
         * <p>
         * The ARN of the IAM user that you want to use as the simulated caller of the API operations.
         * <code>CallerArn</code> is required if you include a <code>ResourcePolicy</code> so that the policy's
         * <code>Principal</code> element has a value to use in evaluating the policy.
         * </p>
         * <p>
         * You can specify only the ARN of an IAM user. You cannot specify the ARN of an assumed role, federated user,
         * or a service principal.
         * </p>
         * 
         * @param callerArn
         *        The ARN of the IAM user that you want to use as the simulated caller of the API operations.
         *        <code>CallerArn</code> is required if you include a <code>ResourcePolicy</code> so that the policy's
         *        <code>Principal</code> element has a value to use in evaluating the policy.</p>
         *        <p>
         *        You can specify only the ARN of an IAM user. You cannot specify the ARN of an assumed role, federated
         *        user, or a service principal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callerArn(String callerArn);

        /**
         * <p>
         * A list of context keys and corresponding values for the simulation to use. Whenever a context key is
         * evaluated in one of the simulated IAM permissions policies, the corresponding value is supplied.
         * </p>
         * 
         * @param contextEntries
         *        A list of context keys and corresponding values for the simulation to use. Whenever a context key is
         *        evaluated in one of the simulated IAM permissions policies, the corresponding value is supplied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextEntries(Collection<ContextEntry> contextEntries);

        /**
         * <p>
         * A list of context keys and corresponding values for the simulation to use. Whenever a context key is
         * evaluated in one of the simulated IAM permissions policies, the corresponding value is supplied.
         * </p>
         * 
         * @param contextEntries
         *        A list of context keys and corresponding values for the simulation to use. Whenever a context key is
         *        evaluated in one of the simulated IAM permissions policies, the corresponding value is supplied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextEntries(ContextEntry... contextEntries);

        /**
         * <p>
         * A list of context keys and corresponding values for the simulation to use. Whenever a context key is
         * evaluated in one of the simulated IAM permissions policies, the corresponding value is supplied.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ContextEntry>.Builder} avoiding the need to
         * create one manually via {@link List<ContextEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ContextEntry>.Builder#build()} is called immediately and its
         * result is passed to {@link #contextEntries(List<ContextEntry>)}.
         * 
         * @param contextEntries
         *        a consumer that will call methods on {@link List<ContextEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contextEntries(List<ContextEntry>)
         */
        Builder contextEntries(Consumer<ContextEntry.Builder>... contextEntries);

        /**
         * <p>
         * Specifies the type of simulation to run. Different API operations that support resource-based policies
         * require different combinations of resources. By specifying the type of simulation to run, you enable the
         * policy simulator to enforce the presence of the required resources to ensure reliable simulation results. If
         * your simulation does not match one of the following scenarios, then you can omit this parameter. The
         * following list shows each of the supported scenario values and the resources that you must define to run the
         * simulation.
         * </p>
         * <p>
         * Each of the EC2 scenarios requires that you specify instance, image, and security-group resources. If your
         * scenario includes an EBS volume, then you must specify that volume as a resource. If the EC2 scenario
         * includes VPC, then you must supply the network-interface resource. If it includes an IP subnet, then you must
         * specify the subnet resource. For more information on the EC2 scenario options, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported
         * Platforms</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>EC2-Classic-InstanceStore</b>
         * </p>
         * <p>
         * instance, image, security-group
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>EC2-Classic-EBS</b>
         * </p>
         * <p>
         * instance, image, security-group, volume
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>EC2-VPC-InstanceStore</b>
         * </p>
         * <p>
         * instance, image, security-group, network-interface
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>EC2-VPC-InstanceStore-Subnet</b>
         * </p>
         * <p>
         * instance, image, security-group, network-interface, subnet
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>EC2-VPC-EBS</b>
         * </p>
         * <p>
         * instance, image, security-group, network-interface, volume
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>EC2-VPC-EBS-Subnet</b>
         * </p>
         * <p>
         * instance, image, security-group, network-interface, subnet, volume
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceHandlingOption
         *        Specifies the type of simulation to run. Different API operations that support resource-based policies
         *        require different combinations of resources. By specifying the type of simulation to run, you enable
         *        the policy simulator to enforce the presence of the required resources to ensure reliable simulation
         *        results. If your simulation does not match one of the following scenarios, then you can omit this
         *        parameter. The following list shows each of the supported scenario values and the resources that you
         *        must define to run the simulation.</p>
         *        <p>
         *        Each of the EC2 scenarios requires that you specify instance, image, and security-group resources. If
         *        your scenario includes an EBS volume, then you must specify that volume as a resource. If the EC2
         *        scenario includes VPC, then you must supply the network-interface resource. If it includes an IP
         *        subnet, then you must specify the subnet resource. For more information on the EC2 scenario options,
         *        see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported
         *        Platforms</a> in the <i>Amazon EC2 User Guide</i>.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>EC2-Classic-InstanceStore</b>
         *        </p>
         *        <p>
         *        instance, image, security-group
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>EC2-Classic-EBS</b>
         *        </p>
         *        <p>
         *        instance, image, security-group, volume
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>EC2-VPC-InstanceStore</b>
         *        </p>
         *        <p>
         *        instance, image, security-group, network-interface
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>EC2-VPC-InstanceStore-Subnet</b>
         *        </p>
         *        <p>
         *        instance, image, security-group, network-interface, subnet
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>EC2-VPC-EBS</b>
         *        </p>
         *        <p>
         *        instance, image, security-group, network-interface, volume
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>EC2-VPC-EBS-Subnet</b>
         *        </p>
         *        <p>
         *        instance, image, security-group, network-interface, subnet, volume
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceHandlingOption(String resourceHandlingOption);

        /**
         * <p>
         * Use this only when paginating results to indicate the maximum number of items you want in the response. If
         * additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is
         * <code>true</code>.
         * </p>
         * <p>
         * If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer
         * results, even when there are more results available. In that case, the <code>IsTruncated</code> response
         * element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call
         * that tells the service where to continue from.
         * </p>
         * 
         * @param maxItems
         *        Use this only when paginating results to indicate the maximum number of items you want in the
         *        response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code>
         *        response element is <code>true</code>.</p>
         *        <p>
         *        If you do not include this parameter, the number of items defaults to 100. Note that IAM might return
         *        fewer results, even when there are more results available. In that case, the <code>IsTruncated</code>
         *        response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the
         *        subsequent call that tells the service where to continue from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        /**
         * <p>
         * Use this parameter only when paginating results and only after you receive a response indicating that the
         * results are truncated. Set it to the value of the <code>Marker</code> element in the response that you
         * received to indicate where the next call should start.
         * </p>
         * 
         * @param marker
         *        Use this parameter only when paginating results and only after you receive a response indicating that
         *        the results are truncated. Set it to the value of the <code>Marker</code> element in the response that
         *        you received to indicate where the next call should start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private List<String> policyInputList = DefaultSdkAutoConstructList.getInstance();

        private List<String> permissionsBoundaryPolicyInputList = DefaultSdkAutoConstructList.getInstance();

        private List<String> actionNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> resourceArns = DefaultSdkAutoConstructList.getInstance();

        private String resourcePolicy;

        private String resourceOwner;

        private String callerArn;

        private List<ContextEntry> contextEntries = DefaultSdkAutoConstructList.getInstance();

        private String resourceHandlingOption;

        private Integer maxItems;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(SimulateCustomPolicyRequest model) {
            super(model);
            policyInputList(model.policyInputList);
            permissionsBoundaryPolicyInputList(model.permissionsBoundaryPolicyInputList);
            actionNames(model.actionNames);
            resourceArns(model.resourceArns);
            resourcePolicy(model.resourcePolicy);
            resourceOwner(model.resourceOwner);
            callerArn(model.callerArn);
            contextEntries(model.contextEntries);
            resourceHandlingOption(model.resourceHandlingOption);
            maxItems(model.maxItems);
            marker(model.marker);
        }

        public final Collection<String> getPolicyInputList() {
            return policyInputList;
        }

        @Override
        public final Builder policyInputList(Collection<String> policyInputList) {
            this.policyInputList = SimulationPolicyListTypeCopier.copy(policyInputList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyInputList(String... policyInputList) {
            policyInputList(Arrays.asList(policyInputList));
            return this;
        }

        public final void setPolicyInputList(Collection<String> policyInputList) {
            this.policyInputList = SimulationPolicyListTypeCopier.copy(policyInputList);
        }

        public final Collection<String> getPermissionsBoundaryPolicyInputList() {
            return permissionsBoundaryPolicyInputList;
        }

        @Override
        public final Builder permissionsBoundaryPolicyInputList(Collection<String> permissionsBoundaryPolicyInputList) {
            this.permissionsBoundaryPolicyInputList = SimulationPolicyListTypeCopier.copy(permissionsBoundaryPolicyInputList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionsBoundaryPolicyInputList(String... permissionsBoundaryPolicyInputList) {
            permissionsBoundaryPolicyInputList(Arrays.asList(permissionsBoundaryPolicyInputList));
            return this;
        }

        public final void setPermissionsBoundaryPolicyInputList(Collection<String> permissionsBoundaryPolicyInputList) {
            this.permissionsBoundaryPolicyInputList = SimulationPolicyListTypeCopier.copy(permissionsBoundaryPolicyInputList);
        }

        public final Collection<String> getActionNames() {
            return actionNames;
        }

        @Override
        public final Builder actionNames(Collection<String> actionNames) {
            this.actionNames = ActionNameListTypeCopier.copy(actionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionNames(String... actionNames) {
            actionNames(Arrays.asList(actionNames));
            return this;
        }

        public final void setActionNames(Collection<String> actionNames) {
            this.actionNames = ActionNameListTypeCopier.copy(actionNames);
        }

        public final Collection<String> getResourceArns() {
            return resourceArns;
        }

        @Override
        public final Builder resourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceNameListTypeCopier.copy(resourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArns(String... resourceArns) {
            resourceArns(Arrays.asList(resourceArns));
            return this;
        }

        public final void setResourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceNameListTypeCopier.copy(resourceArns);
        }

        public final String getResourcePolicy() {
            return resourcePolicy;
        }

        @Override
        public final Builder resourcePolicy(String resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
            return this;
        }

        public final void setResourcePolicy(String resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
        }

        public final String getResourceOwner() {
            return resourceOwner;
        }

        @Override
        public final Builder resourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
            return this;
        }

        public final void setResourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
        }

        public final String getCallerArn() {
            return callerArn;
        }

        @Override
        public final Builder callerArn(String callerArn) {
            this.callerArn = callerArn;
            return this;
        }

        public final void setCallerArn(String callerArn) {
            this.callerArn = callerArn;
        }

        public final Collection<ContextEntry.Builder> getContextEntries() {
            return contextEntries != null ? contextEntries.stream().map(ContextEntry::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder contextEntries(Collection<ContextEntry> contextEntries) {
            this.contextEntries = ContextEntryListTypeCopier.copy(contextEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contextEntries(ContextEntry... contextEntries) {
            contextEntries(Arrays.asList(contextEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contextEntries(Consumer<ContextEntry.Builder>... contextEntries) {
            contextEntries(Stream.of(contextEntries).map(c -> ContextEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setContextEntries(Collection<ContextEntry.BuilderImpl> contextEntries) {
            this.contextEntries = ContextEntryListTypeCopier.copyFromBuilder(contextEntries);
        }

        public final String getResourceHandlingOption() {
            return resourceHandlingOption;
        }

        @Override
        public final Builder resourceHandlingOption(String resourceHandlingOption) {
            this.resourceHandlingOption = resourceHandlingOption;
            return this;
        }

        public final void setResourceHandlingOption(String resourceHandlingOption) {
            this.resourceHandlingOption = resourceHandlingOption;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SimulateCustomPolicyRequest build() {
            return new SimulateCustomPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
