/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class _userDetailListTypeCopier {
    static List<UserDetail> copy(Collection<UserDetail> userDetailListTypeParam) {
        if (userDetailListTypeParam == null || userDetailListTypeParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<UserDetail> userDetailListTypeParamCopy = new ArrayList<>(userDetailListTypeParam);
        return Collections.unmodifiableList(userDetailListTypeParamCopy);
    }

    static List<UserDetail> copyFromBuilder(Collection<? extends UserDetail.Builder> userDetailListTypeParam) {
        if (userDetailListTypeParam == null) {
            return null;
        }
        return copy(userDetailListTypeParam.stream().map(UserDetail.Builder::build).collect(toList()));
    }
}
