/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.ContextKeyTypeEnum;
import software.amazon.awssdk.services.iam.model.ContextKeyValueListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContextEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContextEntry> {
    private static final SdkField<String> CONTEXT_KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContextKeyName").getter(ContextEntry.getter(ContextEntry::contextKeyName)).setter(ContextEntry.setter(Builder::contextKeyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextKeyName").build()}).build();
    private static final SdkField<List<String>> CONTEXT_KEY_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContextKeyValues").getter(ContextEntry.getter(ContextEntry::contextKeyValues)).setter(ContextEntry.setter(Builder::contextKeyValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextKeyValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONTEXT_KEY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContextKeyType").getter(ContextEntry.getter(ContextEntry::contextKeyTypeAsString)).setter(ContextEntry.setter(Builder::contextKeyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextKeyType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTEXT_KEY_NAME_FIELD, CONTEXT_KEY_VALUES_FIELD, CONTEXT_KEY_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String contextKeyName;
    private final List<String> contextKeyValues;
    private final String contextKeyType;

    private ContextEntry(BuilderImpl builder) {
        this.contextKeyName = builder.contextKeyName;
        this.contextKeyValues = builder.contextKeyValues;
        this.contextKeyType = builder.contextKeyType;
    }

    public String contextKeyName() {
        return this.contextKeyName;
    }

    public boolean hasContextKeyValues() {
        return this.contextKeyValues != null && !(this.contextKeyValues instanceof SdkAutoConstructList);
    }

    public List<String> contextKeyValues() {
        return this.contextKeyValues;
    }

    public ContextKeyTypeEnum contextKeyType() {
        return ContextKeyTypeEnum.fromValue(this.contextKeyType);
    }

    public String contextKeyTypeAsString() {
        return this.contextKeyType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contextKeyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.contextKeyValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.contextKeyTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContextEntry)) {
            return false;
        }
        ContextEntry other = (ContextEntry)obj;
        return Objects.equals(this.contextKeyName(), other.contextKeyName()) && Objects.equals(this.contextKeyValues(), other.contextKeyValues()) && Objects.equals(this.contextKeyTypeAsString(), other.contextKeyTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"ContextEntry").add("ContextKeyName", (Object)this.contextKeyName()).add("ContextKeyValues", this.contextKeyValues()).add("ContextKeyType", (Object)this.contextKeyTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContextKeyName": {
                return Optional.ofNullable(clazz.cast(this.contextKeyName()));
            }
            case "ContextKeyValues": {
                return Optional.ofNullable(clazz.cast(this.contextKeyValues()));
            }
            case "ContextKeyType": {
                return Optional.ofNullable(clazz.cast(this.contextKeyTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContextEntry, T> g) {
        return obj -> g.apply((ContextEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String contextKeyName;
        private List<String> contextKeyValues = DefaultSdkAutoConstructList.getInstance();
        private String contextKeyType;

        private BuilderImpl() {
        }

        private BuilderImpl(ContextEntry model) {
            this.contextKeyName(model.contextKeyName);
            this.contextKeyValues(model.contextKeyValues);
            this.contextKeyType(model.contextKeyType);
        }

        public final String getContextKeyName() {
            return this.contextKeyName;
        }

        @Override
        public final Builder contextKeyName(String contextKeyName) {
            this.contextKeyName = contextKeyName;
            return this;
        }

        public final void setContextKeyName(String contextKeyName) {
            this.contextKeyName = contextKeyName;
        }

        public final Collection<String> getContextKeyValues() {
            return this.contextKeyValues;
        }

        @Override
        public final Builder contextKeyValues(Collection<String> contextKeyValues) {
            this.contextKeyValues = ContextKeyValueListTypeCopier.copy(contextKeyValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contextKeyValues(String ... contextKeyValues) {
            this.contextKeyValues(Arrays.asList(contextKeyValues));
            return this;
        }

        public final void setContextKeyValues(Collection<String> contextKeyValues) {
            this.contextKeyValues = ContextKeyValueListTypeCopier.copy(contextKeyValues);
        }

        public final String getContextKeyType() {
            return this.contextKeyType;
        }

        @Override
        public final Builder contextKeyType(String contextKeyType) {
            this.contextKeyType = contextKeyType;
            return this;
        }

        @Override
        public final Builder contextKeyType(ContextKeyTypeEnum contextKeyType) {
            this.contextKeyType(contextKeyType == null ? null : contextKeyType.toString());
            return this;
        }

        public final void setContextKeyType(String contextKeyType) {
            this.contextKeyType = contextKeyType;
        }

        public ContextEntry build() {
            return new ContextEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContextEntry> {
        public Builder contextKeyName(String var1);

        public Builder contextKeyValues(Collection<String> var1);

        public Builder contextKeyValues(String ... var1);

        public Builder contextKeyType(String var1);

        public Builder contextKeyType(ContextKeyTypeEnum var1);
    }
}

