/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.iam.model.AddClientIdToOpenIdConnectProviderRequest;
import software.amazon.awssdk.services.iam.model.AddClientIdToOpenIdConnectProviderResponse;
import software.amazon.awssdk.services.iam.model.AddRoleToInstanceProfileRequest;
import software.amazon.awssdk.services.iam.model.AddRoleToInstanceProfileResponse;
import software.amazon.awssdk.services.iam.model.AddUserToGroupRequest;
import software.amazon.awssdk.services.iam.model.AddUserToGroupResponse;
import software.amazon.awssdk.services.iam.model.AttachGroupPolicyRequest;
import software.amazon.awssdk.services.iam.model.AttachGroupPolicyResponse;
import software.amazon.awssdk.services.iam.model.AttachRolePolicyRequest;
import software.amazon.awssdk.services.iam.model.AttachRolePolicyResponse;
import software.amazon.awssdk.services.iam.model.AttachUserPolicyRequest;
import software.amazon.awssdk.services.iam.model.AttachUserPolicyResponse;
import software.amazon.awssdk.services.iam.model.ChangePasswordRequest;
import software.amazon.awssdk.services.iam.model.ChangePasswordResponse;
import software.amazon.awssdk.services.iam.model.ConcurrentModificationException;
import software.amazon.awssdk.services.iam.model.CreateAccessKeyRequest;
import software.amazon.awssdk.services.iam.model.CreateAccessKeyResponse;
import software.amazon.awssdk.services.iam.model.CreateAccountAliasRequest;
import software.amazon.awssdk.services.iam.model.CreateAccountAliasResponse;
import software.amazon.awssdk.services.iam.model.CreateGroupRequest;
import software.amazon.awssdk.services.iam.model.CreateGroupResponse;
import software.amazon.awssdk.services.iam.model.CreateInstanceProfileRequest;
import software.amazon.awssdk.services.iam.model.CreateInstanceProfileResponse;
import software.amazon.awssdk.services.iam.model.CreateLoginProfileRequest;
import software.amazon.awssdk.services.iam.model.CreateLoginProfileResponse;
import software.amazon.awssdk.services.iam.model.CreateOpenIdConnectProviderRequest;
import software.amazon.awssdk.services.iam.model.CreateOpenIdConnectProviderResponse;
import software.amazon.awssdk.services.iam.model.CreatePolicyRequest;
import software.amazon.awssdk.services.iam.model.CreatePolicyResponse;
import software.amazon.awssdk.services.iam.model.CreatePolicyVersionRequest;
import software.amazon.awssdk.services.iam.model.CreatePolicyVersionResponse;
import software.amazon.awssdk.services.iam.model.CreateRoleRequest;
import software.amazon.awssdk.services.iam.model.CreateRoleResponse;
import software.amazon.awssdk.services.iam.model.CreateSamlProviderRequest;
import software.amazon.awssdk.services.iam.model.CreateSamlProviderResponse;
import software.amazon.awssdk.services.iam.model.CreateServiceLinkedRoleRequest;
import software.amazon.awssdk.services.iam.model.CreateServiceLinkedRoleResponse;
import software.amazon.awssdk.services.iam.model.CreateServiceSpecificCredentialRequest;
import software.amazon.awssdk.services.iam.model.CreateServiceSpecificCredentialResponse;
import software.amazon.awssdk.services.iam.model.CreateUserRequest;
import software.amazon.awssdk.services.iam.model.CreateUserResponse;
import software.amazon.awssdk.services.iam.model.CreateVirtualMfaDeviceRequest;
import software.amazon.awssdk.services.iam.model.CreateVirtualMfaDeviceResponse;
import software.amazon.awssdk.services.iam.model.CredentialReportExpiredException;
import software.amazon.awssdk.services.iam.model.CredentialReportNotPresentException;
import software.amazon.awssdk.services.iam.model.CredentialReportNotReadyException;
import software.amazon.awssdk.services.iam.model.DeactivateMfaDeviceRequest;
import software.amazon.awssdk.services.iam.model.DeactivateMfaDeviceResponse;
import software.amazon.awssdk.services.iam.model.DeleteAccessKeyRequest;
import software.amazon.awssdk.services.iam.model.DeleteAccessKeyResponse;
import software.amazon.awssdk.services.iam.model.DeleteAccountAliasRequest;
import software.amazon.awssdk.services.iam.model.DeleteAccountAliasResponse;
import software.amazon.awssdk.services.iam.model.DeleteAccountPasswordPolicyRequest;
import software.amazon.awssdk.services.iam.model.DeleteAccountPasswordPolicyResponse;
import software.amazon.awssdk.services.iam.model.DeleteConflictException;
import software.amazon.awssdk.services.iam.model.DeleteGroupPolicyRequest;
import software.amazon.awssdk.services.iam.model.DeleteGroupPolicyResponse;
import software.amazon.awssdk.services.iam.model.DeleteGroupRequest;
import software.amazon.awssdk.services.iam.model.DeleteGroupResponse;
import software.amazon.awssdk.services.iam.model.DeleteInstanceProfileRequest;
import software.amazon.awssdk.services.iam.model.DeleteInstanceProfileResponse;
import software.amazon.awssdk.services.iam.model.DeleteLoginProfileRequest;
import software.amazon.awssdk.services.iam.model.DeleteLoginProfileResponse;
import software.amazon.awssdk.services.iam.model.DeleteOpenIdConnectProviderRequest;
import software.amazon.awssdk.services.iam.model.DeleteOpenIdConnectProviderResponse;
import software.amazon.awssdk.services.iam.model.DeletePolicyRequest;
import software.amazon.awssdk.services.iam.model.DeletePolicyResponse;
import software.amazon.awssdk.services.iam.model.DeletePolicyVersionRequest;
import software.amazon.awssdk.services.iam.model.DeletePolicyVersionResponse;
import software.amazon.awssdk.services.iam.model.DeleteRolePermissionsBoundaryRequest;
import software.amazon.awssdk.services.iam.model.DeleteRolePermissionsBoundaryResponse;
import software.amazon.awssdk.services.iam.model.DeleteRolePolicyRequest;
import software.amazon.awssdk.services.iam.model.DeleteRolePolicyResponse;
import software.amazon.awssdk.services.iam.model.DeleteRoleRequest;
import software.amazon.awssdk.services.iam.model.DeleteRoleResponse;
import software.amazon.awssdk.services.iam.model.DeleteSamlProviderRequest;
import software.amazon.awssdk.services.iam.model.DeleteSamlProviderResponse;
import software.amazon.awssdk.services.iam.model.DeleteServerCertificateRequest;
import software.amazon.awssdk.services.iam.model.DeleteServerCertificateResponse;
import software.amazon.awssdk.services.iam.model.DeleteServiceLinkedRoleRequest;
import software.amazon.awssdk.services.iam.model.DeleteServiceLinkedRoleResponse;
import software.amazon.awssdk.services.iam.model.DeleteServiceSpecificCredentialRequest;
import software.amazon.awssdk.services.iam.model.DeleteServiceSpecificCredentialResponse;
import software.amazon.awssdk.services.iam.model.DeleteSigningCertificateRequest;
import software.amazon.awssdk.services.iam.model.DeleteSigningCertificateResponse;
import software.amazon.awssdk.services.iam.model.DeleteSshPublicKeyRequest;
import software.amazon.awssdk.services.iam.model.DeleteSshPublicKeyResponse;
import software.amazon.awssdk.services.iam.model.DeleteUserPermissionsBoundaryRequest;
import software.amazon.awssdk.services.iam.model.DeleteUserPermissionsBoundaryResponse;
import software.amazon.awssdk.services.iam.model.DeleteUserPolicyRequest;
import software.amazon.awssdk.services.iam.model.DeleteUserPolicyResponse;
import software.amazon.awssdk.services.iam.model.DeleteUserRequest;
import software.amazon.awssdk.services.iam.model.DeleteUserResponse;
import software.amazon.awssdk.services.iam.model.DeleteVirtualMfaDeviceRequest;
import software.amazon.awssdk.services.iam.model.DeleteVirtualMfaDeviceResponse;
import software.amazon.awssdk.services.iam.model.DetachGroupPolicyRequest;
import software.amazon.awssdk.services.iam.model.DetachGroupPolicyResponse;
import software.amazon.awssdk.services.iam.model.DetachRolePolicyRequest;
import software.amazon.awssdk.services.iam.model.DetachRolePolicyResponse;
import software.amazon.awssdk.services.iam.model.DetachUserPolicyRequest;
import software.amazon.awssdk.services.iam.model.DetachUserPolicyResponse;
import software.amazon.awssdk.services.iam.model.DuplicateCertificateException;
import software.amazon.awssdk.services.iam.model.DuplicateSshPublicKeyException;
import software.amazon.awssdk.services.iam.model.EnableMfaDeviceRequest;
import software.amazon.awssdk.services.iam.model.EnableMfaDeviceResponse;
import software.amazon.awssdk.services.iam.model.EntityAlreadyExistsException;
import software.amazon.awssdk.services.iam.model.EntityTemporarilyUnmodifiableException;
import software.amazon.awssdk.services.iam.model.GenerateCredentialReportRequest;
import software.amazon.awssdk.services.iam.model.GenerateCredentialReportResponse;
import software.amazon.awssdk.services.iam.model.GenerateOrganizationsAccessReportRequest;
import software.amazon.awssdk.services.iam.model.GenerateOrganizationsAccessReportResponse;
import software.amazon.awssdk.services.iam.model.GenerateServiceLastAccessedDetailsRequest;
import software.amazon.awssdk.services.iam.model.GenerateServiceLastAccessedDetailsResponse;
import software.amazon.awssdk.services.iam.model.GetAccessKeyLastUsedRequest;
import software.amazon.awssdk.services.iam.model.GetAccessKeyLastUsedResponse;
import software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsRequest;
import software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsResponse;
import software.amazon.awssdk.services.iam.model.GetAccountPasswordPolicyRequest;
import software.amazon.awssdk.services.iam.model.GetAccountPasswordPolicyResponse;
import software.amazon.awssdk.services.iam.model.GetAccountSummaryRequest;
import software.amazon.awssdk.services.iam.model.GetAccountSummaryResponse;
import software.amazon.awssdk.services.iam.model.GetContextKeysForCustomPolicyRequest;
import software.amazon.awssdk.services.iam.model.GetContextKeysForCustomPolicyResponse;
import software.amazon.awssdk.services.iam.model.GetContextKeysForPrincipalPolicyRequest;
import software.amazon.awssdk.services.iam.model.GetContextKeysForPrincipalPolicyResponse;
import software.amazon.awssdk.services.iam.model.GetCredentialReportRequest;
import software.amazon.awssdk.services.iam.model.GetCredentialReportResponse;
import software.amazon.awssdk.services.iam.model.GetGroupPolicyRequest;
import software.amazon.awssdk.services.iam.model.GetGroupPolicyResponse;
import software.amazon.awssdk.services.iam.model.GetGroupRequest;
import software.amazon.awssdk.services.iam.model.GetGroupResponse;
import software.amazon.awssdk.services.iam.model.GetInstanceProfileRequest;
import software.amazon.awssdk.services.iam.model.GetInstanceProfileResponse;
import software.amazon.awssdk.services.iam.model.GetLoginProfileRequest;
import software.amazon.awssdk.services.iam.model.GetLoginProfileResponse;
import software.amazon.awssdk.services.iam.model.GetOpenIdConnectProviderRequest;
import software.amazon.awssdk.services.iam.model.GetOpenIdConnectProviderResponse;
import software.amazon.awssdk.services.iam.model.GetOrganizationsAccessReportRequest;
import software.amazon.awssdk.services.iam.model.GetOrganizationsAccessReportResponse;
import software.amazon.awssdk.services.iam.model.GetPolicyRequest;
import software.amazon.awssdk.services.iam.model.GetPolicyResponse;
import software.amazon.awssdk.services.iam.model.GetPolicyVersionRequest;
import software.amazon.awssdk.services.iam.model.GetPolicyVersionResponse;
import software.amazon.awssdk.services.iam.model.GetRolePolicyRequest;
import software.amazon.awssdk.services.iam.model.GetRolePolicyResponse;
import software.amazon.awssdk.services.iam.model.GetRoleRequest;
import software.amazon.awssdk.services.iam.model.GetRoleResponse;
import software.amazon.awssdk.services.iam.model.GetSamlProviderRequest;
import software.amazon.awssdk.services.iam.model.GetSamlProviderResponse;
import software.amazon.awssdk.services.iam.model.GetServerCertificateRequest;
import software.amazon.awssdk.services.iam.model.GetServerCertificateResponse;
import software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsRequest;
import software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsResponse;
import software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsWithEntitiesRequest;
import software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsWithEntitiesResponse;
import software.amazon.awssdk.services.iam.model.GetServiceLinkedRoleDeletionStatusRequest;
import software.amazon.awssdk.services.iam.model.GetServiceLinkedRoleDeletionStatusResponse;
import software.amazon.awssdk.services.iam.model.GetSshPublicKeyRequest;
import software.amazon.awssdk.services.iam.model.GetSshPublicKeyResponse;
import software.amazon.awssdk.services.iam.model.GetUserPolicyRequest;
import software.amazon.awssdk.services.iam.model.GetUserPolicyResponse;
import software.amazon.awssdk.services.iam.model.GetUserRequest;
import software.amazon.awssdk.services.iam.model.GetUserResponse;
import software.amazon.awssdk.services.iam.model.IamException;
import software.amazon.awssdk.services.iam.model.InvalidAuthenticationCodeException;
import software.amazon.awssdk.services.iam.model.InvalidCertificateException;
import software.amazon.awssdk.services.iam.model.InvalidInputException;
import software.amazon.awssdk.services.iam.model.InvalidPublicKeyException;
import software.amazon.awssdk.services.iam.model.InvalidUserTypeException;
import software.amazon.awssdk.services.iam.model.KeyPairMismatchException;
import software.amazon.awssdk.services.iam.model.LimitExceededException;
import software.amazon.awssdk.services.iam.model.ListAccessKeysRequest;
import software.amazon.awssdk.services.iam.model.ListAccessKeysResponse;
import software.amazon.awssdk.services.iam.model.ListAccountAliasesRequest;
import software.amazon.awssdk.services.iam.model.ListAccountAliasesResponse;
import software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesResponse;
import software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesResponse;
import software.amazon.awssdk.services.iam.model.ListAttachedUserPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListAttachedUserPoliciesResponse;
import software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyRequest;
import software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyResponse;
import software.amazon.awssdk.services.iam.model.ListGroupPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListGroupPoliciesResponse;
import software.amazon.awssdk.services.iam.model.ListGroupsForUserRequest;
import software.amazon.awssdk.services.iam.model.ListGroupsForUserResponse;
import software.amazon.awssdk.services.iam.model.ListGroupsRequest;
import software.amazon.awssdk.services.iam.model.ListGroupsResponse;
import software.amazon.awssdk.services.iam.model.ListInstanceProfileTagsRequest;
import software.amazon.awssdk.services.iam.model.ListInstanceProfileTagsResponse;
import software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleRequest;
import software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleResponse;
import software.amazon.awssdk.services.iam.model.ListInstanceProfilesRequest;
import software.amazon.awssdk.services.iam.model.ListInstanceProfilesResponse;
import software.amazon.awssdk.services.iam.model.ListMfaDeviceTagsRequest;
import software.amazon.awssdk.services.iam.model.ListMfaDeviceTagsResponse;
import software.amazon.awssdk.services.iam.model.ListMfaDevicesRequest;
import software.amazon.awssdk.services.iam.model.ListMfaDevicesResponse;
import software.amazon.awssdk.services.iam.model.ListOpenIdConnectProviderTagsRequest;
import software.amazon.awssdk.services.iam.model.ListOpenIdConnectProviderTagsResponse;
import software.amazon.awssdk.services.iam.model.ListOpenIdConnectProvidersRequest;
import software.amazon.awssdk.services.iam.model.ListOpenIdConnectProvidersResponse;
import software.amazon.awssdk.services.iam.model.ListPoliciesGrantingServiceAccessRequest;
import software.amazon.awssdk.services.iam.model.ListPoliciesGrantingServiceAccessResponse;
import software.amazon.awssdk.services.iam.model.ListPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListPoliciesResponse;
import software.amazon.awssdk.services.iam.model.ListPolicyTagsRequest;
import software.amazon.awssdk.services.iam.model.ListPolicyTagsResponse;
import software.amazon.awssdk.services.iam.model.ListPolicyVersionsRequest;
import software.amazon.awssdk.services.iam.model.ListPolicyVersionsResponse;
import software.amazon.awssdk.services.iam.model.ListRolePoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListRolePoliciesResponse;
import software.amazon.awssdk.services.iam.model.ListRoleTagsRequest;
import software.amazon.awssdk.services.iam.model.ListRoleTagsResponse;
import software.amazon.awssdk.services.iam.model.ListRolesRequest;
import software.amazon.awssdk.services.iam.model.ListRolesResponse;
import software.amazon.awssdk.services.iam.model.ListSamlProviderTagsRequest;
import software.amazon.awssdk.services.iam.model.ListSamlProviderTagsResponse;
import software.amazon.awssdk.services.iam.model.ListSamlProvidersRequest;
import software.amazon.awssdk.services.iam.model.ListSamlProvidersResponse;
import software.amazon.awssdk.services.iam.model.ListServerCertificateTagsRequest;
import software.amazon.awssdk.services.iam.model.ListServerCertificateTagsResponse;
import software.amazon.awssdk.services.iam.model.ListServerCertificatesRequest;
import software.amazon.awssdk.services.iam.model.ListServerCertificatesResponse;
import software.amazon.awssdk.services.iam.model.ListServiceSpecificCredentialsRequest;
import software.amazon.awssdk.services.iam.model.ListServiceSpecificCredentialsResponse;
import software.amazon.awssdk.services.iam.model.ListSigningCertificatesRequest;
import software.amazon.awssdk.services.iam.model.ListSigningCertificatesResponse;
import software.amazon.awssdk.services.iam.model.ListSshPublicKeysRequest;
import software.amazon.awssdk.services.iam.model.ListSshPublicKeysResponse;
import software.amazon.awssdk.services.iam.model.ListUserPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListUserPoliciesResponse;
import software.amazon.awssdk.services.iam.model.ListUserTagsRequest;
import software.amazon.awssdk.services.iam.model.ListUserTagsResponse;
import software.amazon.awssdk.services.iam.model.ListUsersRequest;
import software.amazon.awssdk.services.iam.model.ListUsersResponse;
import software.amazon.awssdk.services.iam.model.ListVirtualMfaDevicesRequest;
import software.amazon.awssdk.services.iam.model.ListVirtualMfaDevicesResponse;
import software.amazon.awssdk.services.iam.model.MalformedCertificateException;
import software.amazon.awssdk.services.iam.model.MalformedPolicyDocumentException;
import software.amazon.awssdk.services.iam.model.NoSuchEntityException;
import software.amazon.awssdk.services.iam.model.PasswordPolicyViolationException;
import software.amazon.awssdk.services.iam.model.PolicyEvaluationException;
import software.amazon.awssdk.services.iam.model.PolicyNotAttachableException;
import software.amazon.awssdk.services.iam.model.PutGroupPolicyRequest;
import software.amazon.awssdk.services.iam.model.PutGroupPolicyResponse;
import software.amazon.awssdk.services.iam.model.PutRolePermissionsBoundaryRequest;
import software.amazon.awssdk.services.iam.model.PutRolePermissionsBoundaryResponse;
import software.amazon.awssdk.services.iam.model.PutRolePolicyRequest;
import software.amazon.awssdk.services.iam.model.PutRolePolicyResponse;
import software.amazon.awssdk.services.iam.model.PutUserPermissionsBoundaryRequest;
import software.amazon.awssdk.services.iam.model.PutUserPermissionsBoundaryResponse;
import software.amazon.awssdk.services.iam.model.PutUserPolicyRequest;
import software.amazon.awssdk.services.iam.model.PutUserPolicyResponse;
import software.amazon.awssdk.services.iam.model.RemoveClientIdFromOpenIdConnectProviderRequest;
import software.amazon.awssdk.services.iam.model.RemoveClientIdFromOpenIdConnectProviderResponse;
import software.amazon.awssdk.services.iam.model.RemoveRoleFromInstanceProfileRequest;
import software.amazon.awssdk.services.iam.model.RemoveRoleFromInstanceProfileResponse;
import software.amazon.awssdk.services.iam.model.RemoveUserFromGroupRequest;
import software.amazon.awssdk.services.iam.model.RemoveUserFromGroupResponse;
import software.amazon.awssdk.services.iam.model.ReportGenerationLimitExceededException;
import software.amazon.awssdk.services.iam.model.ResetServiceSpecificCredentialRequest;
import software.amazon.awssdk.services.iam.model.ResetServiceSpecificCredentialResponse;
import software.amazon.awssdk.services.iam.model.ResyncMfaDeviceRequest;
import software.amazon.awssdk.services.iam.model.ResyncMfaDeviceResponse;
import software.amazon.awssdk.services.iam.model.ServiceFailureException;
import software.amazon.awssdk.services.iam.model.ServiceNotSupportedException;
import software.amazon.awssdk.services.iam.model.SetDefaultPolicyVersionRequest;
import software.amazon.awssdk.services.iam.model.SetDefaultPolicyVersionResponse;
import software.amazon.awssdk.services.iam.model.SetSecurityTokenServicePreferencesRequest;
import software.amazon.awssdk.services.iam.model.SetSecurityTokenServicePreferencesResponse;
import software.amazon.awssdk.services.iam.model.SimulateCustomPolicyRequest;
import software.amazon.awssdk.services.iam.model.SimulateCustomPolicyResponse;
import software.amazon.awssdk.services.iam.model.SimulatePrincipalPolicyRequest;
import software.amazon.awssdk.services.iam.model.SimulatePrincipalPolicyResponse;
import software.amazon.awssdk.services.iam.model.TagInstanceProfileRequest;
import software.amazon.awssdk.services.iam.model.TagInstanceProfileResponse;
import software.amazon.awssdk.services.iam.model.TagMfaDeviceRequest;
import software.amazon.awssdk.services.iam.model.TagMfaDeviceResponse;
import software.amazon.awssdk.services.iam.model.TagOpenIdConnectProviderRequest;
import software.amazon.awssdk.services.iam.model.TagOpenIdConnectProviderResponse;
import software.amazon.awssdk.services.iam.model.TagPolicyRequest;
import software.amazon.awssdk.services.iam.model.TagPolicyResponse;
import software.amazon.awssdk.services.iam.model.TagRoleRequest;
import software.amazon.awssdk.services.iam.model.TagRoleResponse;
import software.amazon.awssdk.services.iam.model.TagSamlProviderRequest;
import software.amazon.awssdk.services.iam.model.TagSamlProviderResponse;
import software.amazon.awssdk.services.iam.model.TagServerCertificateRequest;
import software.amazon.awssdk.services.iam.model.TagServerCertificateResponse;
import software.amazon.awssdk.services.iam.model.TagUserRequest;
import software.amazon.awssdk.services.iam.model.TagUserResponse;
import software.amazon.awssdk.services.iam.model.UnmodifiableEntityException;
import software.amazon.awssdk.services.iam.model.UnrecognizedPublicKeyEncodingException;
import software.amazon.awssdk.services.iam.model.UntagInstanceProfileRequest;
import software.amazon.awssdk.services.iam.model.UntagInstanceProfileResponse;
import software.amazon.awssdk.services.iam.model.UntagMfaDeviceRequest;
import software.amazon.awssdk.services.iam.model.UntagMfaDeviceResponse;
import software.amazon.awssdk.services.iam.model.UntagOpenIdConnectProviderRequest;
import software.amazon.awssdk.services.iam.model.UntagOpenIdConnectProviderResponse;
import software.amazon.awssdk.services.iam.model.UntagPolicyRequest;
import software.amazon.awssdk.services.iam.model.UntagPolicyResponse;
import software.amazon.awssdk.services.iam.model.UntagRoleRequest;
import software.amazon.awssdk.services.iam.model.UntagRoleResponse;
import software.amazon.awssdk.services.iam.model.UntagSamlProviderRequest;
import software.amazon.awssdk.services.iam.model.UntagSamlProviderResponse;
import software.amazon.awssdk.services.iam.model.UntagServerCertificateRequest;
import software.amazon.awssdk.services.iam.model.UntagServerCertificateResponse;
import software.amazon.awssdk.services.iam.model.UntagUserRequest;
import software.amazon.awssdk.services.iam.model.UntagUserResponse;
import software.amazon.awssdk.services.iam.model.UpdateAccessKeyRequest;
import software.amazon.awssdk.services.iam.model.UpdateAccessKeyResponse;
import software.amazon.awssdk.services.iam.model.UpdateAccountPasswordPolicyRequest;
import software.amazon.awssdk.services.iam.model.UpdateAccountPasswordPolicyResponse;
import software.amazon.awssdk.services.iam.model.UpdateAssumeRolePolicyRequest;
import software.amazon.awssdk.services.iam.model.UpdateAssumeRolePolicyResponse;
import software.amazon.awssdk.services.iam.model.UpdateGroupRequest;
import software.amazon.awssdk.services.iam.model.UpdateGroupResponse;
import software.amazon.awssdk.services.iam.model.UpdateLoginProfileRequest;
import software.amazon.awssdk.services.iam.model.UpdateLoginProfileResponse;
import software.amazon.awssdk.services.iam.model.UpdateOpenIdConnectProviderThumbprintRequest;
import software.amazon.awssdk.services.iam.model.UpdateOpenIdConnectProviderThumbprintResponse;
import software.amazon.awssdk.services.iam.model.UpdateRoleDescriptionRequest;
import software.amazon.awssdk.services.iam.model.UpdateRoleDescriptionResponse;
import software.amazon.awssdk.services.iam.model.UpdateRoleRequest;
import software.amazon.awssdk.services.iam.model.UpdateRoleResponse;
import software.amazon.awssdk.services.iam.model.UpdateSamlProviderRequest;
import software.amazon.awssdk.services.iam.model.UpdateSamlProviderResponse;
import software.amazon.awssdk.services.iam.model.UpdateServerCertificateRequest;
import software.amazon.awssdk.services.iam.model.UpdateServerCertificateResponse;
import software.amazon.awssdk.services.iam.model.UpdateServiceSpecificCredentialRequest;
import software.amazon.awssdk.services.iam.model.UpdateServiceSpecificCredentialResponse;
import software.amazon.awssdk.services.iam.model.UpdateSigningCertificateRequest;
import software.amazon.awssdk.services.iam.model.UpdateSigningCertificateResponse;
import software.amazon.awssdk.services.iam.model.UpdateSshPublicKeyRequest;
import software.amazon.awssdk.services.iam.model.UpdateSshPublicKeyResponse;
import software.amazon.awssdk.services.iam.model.UpdateUserRequest;
import software.amazon.awssdk.services.iam.model.UpdateUserResponse;
import software.amazon.awssdk.services.iam.model.UploadServerCertificateRequest;
import software.amazon.awssdk.services.iam.model.UploadServerCertificateResponse;
import software.amazon.awssdk.services.iam.model.UploadSigningCertificateRequest;
import software.amazon.awssdk.services.iam.model.UploadSigningCertificateResponse;
import software.amazon.awssdk.services.iam.model.UploadSshPublicKeyRequest;
import software.amazon.awssdk.services.iam.model.UploadSshPublicKeyResponse;
import software.amazon.awssdk.services.iam.paginators.GetAccountAuthorizationDetailsIterable;
import software.amazon.awssdk.services.iam.paginators.GetGroupIterable;
import software.amazon.awssdk.services.iam.paginators.ListAccessKeysIterable;
import software.amazon.awssdk.services.iam.paginators.ListAccountAliasesIterable;
import software.amazon.awssdk.services.iam.paginators.ListAttachedGroupPoliciesIterable;
import software.amazon.awssdk.services.iam.paginators.ListAttachedRolePoliciesIterable;
import software.amazon.awssdk.services.iam.paginators.ListAttachedUserPoliciesIterable;
import software.amazon.awssdk.services.iam.paginators.ListEntitiesForPolicyIterable;
import software.amazon.awssdk.services.iam.paginators.ListGroupPoliciesIterable;
import software.amazon.awssdk.services.iam.paginators.ListGroupsForUserIterable;
import software.amazon.awssdk.services.iam.paginators.ListGroupsIterable;
import software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesForRoleIterable;
import software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesIterable;
import software.amazon.awssdk.services.iam.paginators.ListMFADevicesIterable;
import software.amazon.awssdk.services.iam.paginators.ListPoliciesIterable;
import software.amazon.awssdk.services.iam.paginators.ListPolicyVersionsIterable;
import software.amazon.awssdk.services.iam.paginators.ListRolePoliciesIterable;
import software.amazon.awssdk.services.iam.paginators.ListRolesIterable;
import software.amazon.awssdk.services.iam.paginators.ListSSHPublicKeysIterable;
import software.amazon.awssdk.services.iam.paginators.ListServerCertificatesIterable;
import software.amazon.awssdk.services.iam.paginators.ListSigningCertificatesIterable;
import software.amazon.awssdk.services.iam.paginators.ListUserPoliciesIterable;
import software.amazon.awssdk.services.iam.paginators.ListUserTagsIterable;
import software.amazon.awssdk.services.iam.paginators.ListUsersIterable;
import software.amazon.awssdk.services.iam.paginators.ListVirtualMFADevicesIterable;
import software.amazon.awssdk.services.iam.paginators.SimulateCustomPolicyIterable;
import software.amazon.awssdk.services.iam.paginators.SimulatePrincipalPolicyIterable;
import software.amazon.awssdk.services.iam.waiters.IamWaiter;

/**
 * Service client for accessing IAM. This can be created using the static {@link #builder()} method.
 *
 * <fullname>AWS Identity and Access Management</fullname>
 * <p>
 * AWS Identity and Access Management (IAM) is a web service for securely controlling access to AWS services. With IAM,
 * you can centrally manage users, security credentials such as access keys, and permissions that control which AWS
 * resources users and applications can access. For more information about IAM, see <a
 * href="http://aws.amazon.com/iam/">AWS Identity and Access Management (IAM)</a> and the <a
 * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/">AWS Identity and Access Management User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface IamClient extends SdkClient {
    String SERVICE_NAME = "iam";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "iam";

    /**
     * Create a builder that can be used to configure and create a {@link IamClient}.
     */
    static IamClientBuilder builder() {
        return new DefaultIamClientBuilder();
    }

    /**
     * <p>
     * Adds a new client ID (also known as audience) to the list of client IDs already registered for the specified IAM
     * OpenID Connect (OIDC) provider resource.
     * </p>
     * <p>
     * This operation is idempotent; it does not fail or return an error if you add an existing client ID to the
     * provider.
     * </p>
     *
     * @param addClientIdToOpenIdConnectProviderRequest
     * @return Result of the AddClientIDToOpenIDConnectProvider operation returned by the service.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.AddClientIDToOpenIDConnectProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AddClientIDToOpenIDConnectProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default AddClientIdToOpenIdConnectProviderResponse addClientIDToOpenIDConnectProvider(
            AddClientIdToOpenIdConnectProviderRequest addClientIdToOpenIdConnectProviderRequest) throws InvalidInputException,
            NoSuchEntityException, LimitExceededException, ServiceFailureException, AwsServiceException, SdkClientException,
            IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a new client ID (also known as audience) to the list of client IDs already registered for the specified IAM
     * OpenID Connect (OIDC) provider resource.
     * </p>
     * <p>
     * This operation is idempotent; it does not fail or return an error if you add an existing client ID to the
     * provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddClientIdToOpenIdConnectProviderRequest.Builder}
     * avoiding the need to create one manually via {@link AddClientIdToOpenIdConnectProviderRequest#builder()}
     * </p>
     *
     * @param addClientIdToOpenIdConnectProviderRequest
     *        A {@link Consumer} that will call methods on {@link AddClientIDToOpenIDConnectProviderRequest.Builder} to
     *        create a request.
     * @return Result of the AddClientIDToOpenIDConnectProvider operation returned by the service.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.AddClientIDToOpenIDConnectProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AddClientIDToOpenIDConnectProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default AddClientIdToOpenIdConnectProviderResponse addClientIDToOpenIDConnectProvider(
            Consumer<AddClientIdToOpenIdConnectProviderRequest.Builder> addClientIdToOpenIdConnectProviderRequest)
            throws InvalidInputException, NoSuchEntityException, LimitExceededException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        return addClientIDToOpenIDConnectProvider(AddClientIdToOpenIdConnectProviderRequest.builder()
                .applyMutation(addClientIdToOpenIdConnectProviderRequest).build());
    }

    /**
     * <p>
     * Adds the specified IAM role to the specified instance profile. An instance profile can contain only one role, and
     * this quota cannot be increased. You can remove the existing role and then add a different role to an instance
     * profile. You must then wait for the change to appear across all of AWS because of <a
     * href="https://en.wikipedia.org/wiki/Eventual_consistency">eventual consistency</a>. To force the change, you must
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateIamInstanceProfile.html">
     * disassociate the instance profile</a> and then <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateIamInstanceProfile.html">associate the
     * instance profile</a>, or you can stop your instance and then restart it.
     * </p>
     * <note>
     * <p>
     * The caller of this operation must be granted the <code>PassRole</code> permission on the IAM role by a
     * permissions policy.
     * </p>
     * </note>
     * <p>
     * For more information about roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with roles</a>. For more
     * information about instance profiles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About instance profiles</a>.
     * </p>
     *
     * @param addRoleToInstanceProfileRequest
     * @return Result of the AddRoleToInstanceProfile operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws UnmodifiableEntityException
     *         The request was rejected because only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.AddRoleToInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AddRoleToInstanceProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default AddRoleToInstanceProfileResponse addRoleToInstanceProfile(
            AddRoleToInstanceProfileRequest addRoleToInstanceProfileRequest) throws NoSuchEntityException,
            EntityAlreadyExistsException, LimitExceededException, UnmodifiableEntityException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified IAM role to the specified instance profile. An instance profile can contain only one role, and
     * this quota cannot be increased. You can remove the existing role and then add a different role to an instance
     * profile. You must then wait for the change to appear across all of AWS because of <a
     * href="https://en.wikipedia.org/wiki/Eventual_consistency">eventual consistency</a>. To force the change, you must
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateIamInstanceProfile.html">
     * disassociate the instance profile</a> and then <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateIamInstanceProfile.html">associate the
     * instance profile</a>, or you can stop your instance and then restart it.
     * </p>
     * <note>
     * <p>
     * The caller of this operation must be granted the <code>PassRole</code> permission on the IAM role by a
     * permissions policy.
     * </p>
     * </note>
     * <p>
     * For more information about roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with roles</a>. For more
     * information about instance profiles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About instance profiles</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddRoleToInstanceProfileRequest.Builder} avoiding
     * the need to create one manually via {@link AddRoleToInstanceProfileRequest#builder()}
     * </p>
     *
     * @param addRoleToInstanceProfileRequest
     *        A {@link Consumer} that will call methods on {@link AddRoleToInstanceProfileRequest.Builder} to create a
     *        request.
     * @return Result of the AddRoleToInstanceProfile operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws UnmodifiableEntityException
     *         The request was rejected because only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.AddRoleToInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AddRoleToInstanceProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default AddRoleToInstanceProfileResponse addRoleToInstanceProfile(
            Consumer<AddRoleToInstanceProfileRequest.Builder> addRoleToInstanceProfileRequest) throws NoSuchEntityException,
            EntityAlreadyExistsException, LimitExceededException, UnmodifiableEntityException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        return addRoleToInstanceProfile(AddRoleToInstanceProfileRequest.builder().applyMutation(addRoleToInstanceProfileRequest)
                .build());
    }

    /**
     * <p>
     * Adds the specified user to the specified group.
     * </p>
     *
     * @param addUserToGroupRequest
     * @return Result of the AddUserToGroup operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.AddUserToGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AddUserToGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default AddUserToGroupResponse addUserToGroup(AddUserToGroupRequest addUserToGroupRequest) throws NoSuchEntityException,
            LimitExceededException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified user to the specified group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddUserToGroupRequest.Builder} avoiding the need to
     * create one manually via {@link AddUserToGroupRequest#builder()}
     * </p>
     *
     * @param addUserToGroupRequest
     *        A {@link Consumer} that will call methods on {@link AddUserToGroupRequest.Builder} to create a request.
     * @return Result of the AddUserToGroup operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.AddUserToGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AddUserToGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default AddUserToGroupResponse addUserToGroup(Consumer<AddUserToGroupRequest.Builder> addUserToGroupRequest)
            throws NoSuchEntityException, LimitExceededException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        return addUserToGroup(AddUserToGroupRequest.builder().applyMutation(addUserToGroupRequest).build());
    }

    /**
     * <p>
     * Attaches the specified managed policy to the specified IAM group.
     * </p>
     * <p>
     * You use this operation to attach a managed policy to a group. To embed an inline policy in a group, use
     * <a>PutGroupPolicy</a>.
     * </p>
     * <p>
     * As a best practice, you can validate your IAM policies. To learn more, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html">Validating IAM
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param attachGroupPolicyRequest
     * @return Result of the AttachGroupPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws PolicyNotAttachableException
     *         The request failed because AWS service role policies can only be attached to the service-linked role for
     *         that service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.AttachGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AttachGroupPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default AttachGroupPolicyResponse attachGroupPolicy(AttachGroupPolicyRequest attachGroupPolicyRequest)
            throws NoSuchEntityException, LimitExceededException, InvalidInputException, PolicyNotAttachableException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches the specified managed policy to the specified IAM group.
     * </p>
     * <p>
     * You use this operation to attach a managed policy to a group. To embed an inline policy in a group, use
     * <a>PutGroupPolicy</a>.
     * </p>
     * <p>
     * As a best practice, you can validate your IAM policies. To learn more, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html">Validating IAM
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachGroupPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link AttachGroupPolicyRequest#builder()}
     * </p>
     *
     * @param attachGroupPolicyRequest
     *        A {@link Consumer} that will call methods on {@link AttachGroupPolicyRequest.Builder} to create a request.
     * @return Result of the AttachGroupPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws PolicyNotAttachableException
     *         The request failed because AWS service role policies can only be attached to the service-linked role for
     *         that service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.AttachGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AttachGroupPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default AttachGroupPolicyResponse attachGroupPolicy(Consumer<AttachGroupPolicyRequest.Builder> attachGroupPolicyRequest)
            throws NoSuchEntityException, LimitExceededException, InvalidInputException, PolicyNotAttachableException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return attachGroupPolicy(AttachGroupPolicyRequest.builder().applyMutation(attachGroupPolicyRequest).build());
    }

    /**
     * <p>
     * Attaches the specified managed policy to the specified IAM role. When you attach a managed policy to a role, the
     * managed policy becomes part of the role's permission (access) policy.
     * </p>
     * <note>
     * <p>
     * You cannot use a managed policy as the role's trust policy. The role's trust policy is created at the same time
     * as the role, using <a>CreateRole</a>. You can update a role's trust policy using <a>UpdateAssumeRolePolicy</a>.
     * </p>
     * </note>
     * <p>
     * Use this operation to attach a <i>managed</i> policy to a role. To embed an inline policy in a role, use
     * <a>PutRolePolicy</a>. For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * As a best practice, you can validate your IAM policies. To learn more, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html">Validating IAM
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param attachRolePolicyRequest
     * @return Result of the AttachRolePolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws UnmodifiableEntityException
     *         The request was rejected because only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.
     * @throws PolicyNotAttachableException
     *         The request failed because AWS service role policies can only be attached to the service-linked role for
     *         that service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.AttachRolePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AttachRolePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default AttachRolePolicyResponse attachRolePolicy(AttachRolePolicyRequest attachRolePolicyRequest)
            throws NoSuchEntityException, LimitExceededException, InvalidInputException, UnmodifiableEntityException,
            PolicyNotAttachableException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches the specified managed policy to the specified IAM role. When you attach a managed policy to a role, the
     * managed policy becomes part of the role's permission (access) policy.
     * </p>
     * <note>
     * <p>
     * You cannot use a managed policy as the role's trust policy. The role's trust policy is created at the same time
     * as the role, using <a>CreateRole</a>. You can update a role's trust policy using <a>UpdateAssumeRolePolicy</a>.
     * </p>
     * </note>
     * <p>
     * Use this operation to attach a <i>managed</i> policy to a role. To embed an inline policy in a role, use
     * <a>PutRolePolicy</a>. For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * As a best practice, you can validate your IAM policies. To learn more, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html">Validating IAM
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachRolePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link AttachRolePolicyRequest#builder()}
     * </p>
     *
     * @param attachRolePolicyRequest
     *        A {@link Consumer} that will call methods on {@link AttachRolePolicyRequest.Builder} to create a request.
     * @return Result of the AttachRolePolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws UnmodifiableEntityException
     *         The request was rejected because only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.
     * @throws PolicyNotAttachableException
     *         The request failed because AWS service role policies can only be attached to the service-linked role for
     *         that service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.AttachRolePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AttachRolePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default AttachRolePolicyResponse attachRolePolicy(Consumer<AttachRolePolicyRequest.Builder> attachRolePolicyRequest)
            throws NoSuchEntityException, LimitExceededException, InvalidInputException, UnmodifiableEntityException,
            PolicyNotAttachableException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return attachRolePolicy(AttachRolePolicyRequest.builder().applyMutation(attachRolePolicyRequest).build());
    }

    /**
     * <p>
     * Attaches the specified managed policy to the specified user.
     * </p>
     * <p>
     * You use this operation to attach a <i>managed</i> policy to a user. To embed an inline policy in a user, use
     * <a>PutUserPolicy</a>.
     * </p>
     * <p>
     * As a best practice, you can validate your IAM policies. To learn more, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html">Validating IAM
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param attachUserPolicyRequest
     * @return Result of the AttachUserPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws PolicyNotAttachableException
     *         The request failed because AWS service role policies can only be attached to the service-linked role for
     *         that service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.AttachUserPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AttachUserPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default AttachUserPolicyResponse attachUserPolicy(AttachUserPolicyRequest attachUserPolicyRequest)
            throws NoSuchEntityException, LimitExceededException, InvalidInputException, PolicyNotAttachableException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches the specified managed policy to the specified user.
     * </p>
     * <p>
     * You use this operation to attach a <i>managed</i> policy to a user. To embed an inline policy in a user, use
     * <a>PutUserPolicy</a>.
     * </p>
     * <p>
     * As a best practice, you can validate your IAM policies. To learn more, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html">Validating IAM
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachUserPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link AttachUserPolicyRequest#builder()}
     * </p>
     *
     * @param attachUserPolicyRequest
     *        A {@link Consumer} that will call methods on {@link AttachUserPolicyRequest.Builder} to create a request.
     * @return Result of the AttachUserPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws PolicyNotAttachableException
     *         The request failed because AWS service role policies can only be attached to the service-linked role for
     *         that service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.AttachUserPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AttachUserPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default AttachUserPolicyResponse attachUserPolicy(Consumer<AttachUserPolicyRequest.Builder> attachUserPolicyRequest)
            throws NoSuchEntityException, LimitExceededException, InvalidInputException, PolicyNotAttachableException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return attachUserPolicy(AttachUserPolicyRequest.builder().applyMutation(attachUserPolicyRequest).build());
    }

    /**
     * <p>
     * Changes the password of the IAM user who is calling this operation. This operation can be performed using the AWS
     * CLI, the AWS API, or the <b>My Security Credentials</b> page in the AWS Management Console. The AWS account root
     * user password is not affected by this operation.
     * </p>
     * <p>
     * Use <a>UpdateLoginProfile</a> to use the AWS CLI, the AWS API, or the <b>Users</b> page in the IAM console to
     * change the password for any IAM user. For more information about modifying passwords, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html">Managing passwords</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     *
     * @param changePasswordRequest
     * @return Result of the ChangePassword operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidUserTypeException
     *         The request was rejected because the type of user for the transaction was incorrect.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws EntityTemporarilyUnmodifiableException
     *         The request was rejected because it referenced an entity that is temporarily unmodifiable, such as a user
     *         name that was deleted and then recreated. The error indicates that the request is likely to succeed if
     *         you try again after waiting several minutes. The error message describes the entity.
     * @throws PasswordPolicyViolationException
     *         The request was rejected because the provided password did not meet the requirements imposed by the
     *         account password policy.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ChangePassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ChangePassword" target="_top">AWS API
     *      Documentation</a>
     */
    default ChangePasswordResponse changePassword(ChangePasswordRequest changePasswordRequest) throws NoSuchEntityException,
            InvalidUserTypeException, LimitExceededException, EntityTemporarilyUnmodifiableException,
            PasswordPolicyViolationException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes the password of the IAM user who is calling this operation. This operation can be performed using the AWS
     * CLI, the AWS API, or the <b>My Security Credentials</b> page in the AWS Management Console. The AWS account root
     * user password is not affected by this operation.
     * </p>
     * <p>
     * Use <a>UpdateLoginProfile</a> to use the AWS CLI, the AWS API, or the <b>Users</b> page in the IAM console to
     * change the password for any IAM user. For more information about modifying passwords, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html">Managing passwords</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ChangePasswordRequest.Builder} avoiding the need to
     * create one manually via {@link ChangePasswordRequest#builder()}
     * </p>
     *
     * @param changePasswordRequest
     *        A {@link Consumer} that will call methods on {@link ChangePasswordRequest.Builder} to create a request.
     * @return Result of the ChangePassword operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidUserTypeException
     *         The request was rejected because the type of user for the transaction was incorrect.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws EntityTemporarilyUnmodifiableException
     *         The request was rejected because it referenced an entity that is temporarily unmodifiable, such as a user
     *         name that was deleted and then recreated. The error indicates that the request is likely to succeed if
     *         you try again after waiting several minutes. The error message describes the entity.
     * @throws PasswordPolicyViolationException
     *         The request was rejected because the provided password did not meet the requirements imposed by the
     *         account password policy.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ChangePassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ChangePassword" target="_top">AWS API
     *      Documentation</a>
     */
    default ChangePasswordResponse changePassword(Consumer<ChangePasswordRequest.Builder> changePasswordRequest)
            throws NoSuchEntityException, InvalidUserTypeException, LimitExceededException,
            EntityTemporarilyUnmodifiableException, PasswordPolicyViolationException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        return changePassword(ChangePasswordRequest.builder().applyMutation(changePasswordRequest).build());
    }

    /**
     * <p>
     * Creates a new AWS secret access key and corresponding AWS access key ID for the specified user. The default
     * status for new keys is <code>Active</code>.
     * </p>
     * <p>
     * If you do not specify a user name, IAM determines the user name implicitly based on the AWS access key ID signing
     * the request. This operation works for access keys under the AWS account. Consequently, you can use this operation
     * to manage AWS account root user credentials. This is true even if the AWS account has no associated users.
     * </p>
     * <p>
     * For information about quotas on the number of keys you can create, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * <important>
     * <p>
     * To ensure the security of your AWS account, the secret access key is accessible only during key and user
     * creation. You must save the key (for example, in a text file) if you want to be able to access it again. If a
     * secret key is lost, you can delete the access keys for the associated user and then create new keys.
     * </p>
     * </important>
     *
     * @return Result of the CreateAccessKey operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateAccessKey
     * @see #createAccessKey(CreateAccessKeyRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateAccessKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAccessKeyResponse createAccessKey() throws NoSuchEntityException, LimitExceededException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return createAccessKey(CreateAccessKeyRequest.builder().build());
    }

    /**
     * <p>
     * Creates a new AWS secret access key and corresponding AWS access key ID for the specified user. The default
     * status for new keys is <code>Active</code>.
     * </p>
     * <p>
     * If you do not specify a user name, IAM determines the user name implicitly based on the AWS access key ID signing
     * the request. This operation works for access keys under the AWS account. Consequently, you can use this operation
     * to manage AWS account root user credentials. This is true even if the AWS account has no associated users.
     * </p>
     * <p>
     * For information about quotas on the number of keys you can create, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * <important>
     * <p>
     * To ensure the security of your AWS account, the secret access key is accessible only during key and user
     * creation. You must save the key (for example, in a text file) if you want to be able to access it again. If a
     * secret key is lost, you can delete the access keys for the associated user and then create new keys.
     * </p>
     * </important>
     *
     * @param createAccessKeyRequest
     * @return Result of the CreateAccessKey operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateAccessKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateAccessKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAccessKeyResponse createAccessKey(CreateAccessKeyRequest createAccessKeyRequest) throws NoSuchEntityException,
            LimitExceededException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new AWS secret access key and corresponding AWS access key ID for the specified user. The default
     * status for new keys is <code>Active</code>.
     * </p>
     * <p>
     * If you do not specify a user name, IAM determines the user name implicitly based on the AWS access key ID signing
     * the request. This operation works for access keys under the AWS account. Consequently, you can use this operation
     * to manage AWS account root user credentials. This is true even if the AWS account has no associated users.
     * </p>
     * <p>
     * For information about quotas on the number of keys you can create, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * <important>
     * <p>
     * To ensure the security of your AWS account, the secret access key is accessible only during key and user
     * creation. You must save the key (for example, in a text file) if you want to be able to access it again. If a
     * secret key is lost, you can delete the access keys for the associated user and then create new keys.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAccessKeyRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAccessKeyRequest#builder()}
     * </p>
     *
     * @param createAccessKeyRequest
     *        A {@link Consumer} that will call methods on {@link CreateAccessKeyRequest.Builder} to create a request.
     * @return Result of the CreateAccessKey operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateAccessKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateAccessKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAccessKeyResponse createAccessKey(Consumer<CreateAccessKeyRequest.Builder> createAccessKeyRequest)
            throws NoSuchEntityException, LimitExceededException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        return createAccessKey(CreateAccessKeyRequest.builder().applyMutation(createAccessKeyRequest).build());
    }

    /**
     * <p>
     * Creates an alias for your AWS account. For information about using an AWS account alias, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AccountAlias.html">Using an alias for your AWS account
     * ID</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param createAccountAliasRequest
     * @return Result of the CreateAccountAlias operation returned by the service.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateAccountAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateAccountAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAccountAliasResponse createAccountAlias(CreateAccountAliasRequest createAccountAliasRequest)
            throws EntityAlreadyExistsException, LimitExceededException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an alias for your AWS account. For information about using an AWS account alias, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AccountAlias.html">Using an alias for your AWS account
     * ID</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAccountAliasRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAccountAliasRequest#builder()}
     * </p>
     *
     * @param createAccountAliasRequest
     *        A {@link Consumer} that will call methods on {@link CreateAccountAliasRequest.Builder} to create a
     *        request.
     * @return Result of the CreateAccountAlias operation returned by the service.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateAccountAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateAccountAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAccountAliasResponse createAccountAlias(Consumer<CreateAccountAliasRequest.Builder> createAccountAliasRequest)
            throws EntityAlreadyExistsException, LimitExceededException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        return createAccountAlias(CreateAccountAliasRequest.builder().applyMutation(createAccountAliasRequest).build());
    }

    /**
     * <p>
     * Creates a new group.
     * </p>
     * <p>
     * For information about the number of groups you can create, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     *
     * @param createGroupRequest
     * @return Result of the CreateGroup operation returned by the service.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateGroupResponse createGroup(CreateGroupRequest createGroupRequest) throws LimitExceededException,
            EntityAlreadyExistsException, NoSuchEntityException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new group.
     * </p>
     * <p>
     * For information about the number of groups you can create, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGroupRequest.Builder} avoiding the need to
     * create one manually via {@link CreateGroupRequest#builder()}
     * </p>
     *
     * @param createGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateGroupRequest.Builder} to create a request.
     * @return Result of the CreateGroup operation returned by the service.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateGroupResponse createGroup(Consumer<CreateGroupRequest.Builder> createGroupRequest)
            throws LimitExceededException, EntityAlreadyExistsException, NoSuchEntityException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        return createGroup(CreateGroupRequest.builder().applyMutation(createGroupRequest).build());
    }

    /**
     * <p>
     * Creates a new instance profile. For information about instance profiles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html">Using roles for
     * applications on Amazon EC2</a> in the <i>IAM User Guide</i>, and <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-roles-for-amazon-ec2.html#ec2-instance-profile"
     * >Instance profiles</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * For information about the number of instance profiles you can create, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM object quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     *
     * @param createInstanceProfileRequest
     * @return Result of the CreateInstanceProfile operation returned by the service.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ConcurrentModificationException
     *         The request was rejected because multiple requests to change this object were submitted simultaneously.
     *         Wait a few minutes and submit your request again.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateInstanceProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateInstanceProfileResponse createInstanceProfile(CreateInstanceProfileRequest createInstanceProfileRequest)
            throws EntityAlreadyExistsException, InvalidInputException, LimitExceededException, ConcurrentModificationException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new instance profile. For information about instance profiles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html">Using roles for
     * applications on Amazon EC2</a> in the <i>IAM User Guide</i>, and <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-roles-for-amazon-ec2.html#ec2-instance-profile"
     * >Instance profiles</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * For information about the number of instance profiles you can create, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM object quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInstanceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateInstanceProfileRequest#builder()}
     * </p>
     *
     * @param createInstanceProfileRequest
     *        A {@link Consumer} that will call methods on {@link CreateInstanceProfileRequest.Builder} to create a
     *        request.
     * @return Result of the CreateInstanceProfile operation returned by the service.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ConcurrentModificationException
     *         The request was rejected because multiple requests to change this object were submitted simultaneously.
     *         Wait a few minutes and submit your request again.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateInstanceProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateInstanceProfileResponse createInstanceProfile(
            Consumer<CreateInstanceProfileRequest.Builder> createInstanceProfileRequest) throws EntityAlreadyExistsException,
            InvalidInputException, LimitExceededException, ConcurrentModificationException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        return createInstanceProfile(CreateInstanceProfileRequest.builder().applyMutation(createInstanceProfileRequest).build());
    }

    /**
     * <p>
     * Creates a password for the specified IAM user. A password allows an IAM user to access AWS services through the
     * AWS Management Console.
     * </p>
     * <p>
     * You can use the AWS CLI, the AWS API, or the <b>Users</b> page in the IAM console to create a password for any
     * IAM user. Use <a>ChangePassword</a> to update your own existing password in the <b>My Security Credentials</b>
     * page in the AWS Management Console.
     * </p>
     * <p>
     * For more information about managing passwords, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html">Managing passwords</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     *
     * @param createLoginProfileRequest
     * @return Result of the CreateLoginProfile operation returned by the service.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws PasswordPolicyViolationException
     *         The request was rejected because the provided password did not meet the requirements imposed by the
     *         account password policy.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateLoginProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateLoginProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateLoginProfileResponse createLoginProfile(CreateLoginProfileRequest createLoginProfileRequest)
            throws EntityAlreadyExistsException, NoSuchEntityException, PasswordPolicyViolationException, LimitExceededException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a password for the specified IAM user. A password allows an IAM user to access AWS services through the
     * AWS Management Console.
     * </p>
     * <p>
     * You can use the AWS CLI, the AWS API, or the <b>Users</b> page in the IAM console to create a password for any
     * IAM user. Use <a>ChangePassword</a> to update your own existing password in the <b>My Security Credentials</b>
     * page in the AWS Management Console.
     * </p>
     * <p>
     * For more information about managing passwords, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html">Managing passwords</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLoginProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateLoginProfileRequest#builder()}
     * </p>
     *
     * @param createLoginProfileRequest
     *        A {@link Consumer} that will call methods on {@link CreateLoginProfileRequest.Builder} to create a
     *        request.
     * @return Result of the CreateLoginProfile operation returned by the service.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws PasswordPolicyViolationException
     *         The request was rejected because the provided password did not meet the requirements imposed by the
     *         account password policy.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateLoginProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateLoginProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateLoginProfileResponse createLoginProfile(Consumer<CreateLoginProfileRequest.Builder> createLoginProfileRequest)
            throws EntityAlreadyExistsException, NoSuchEntityException, PasswordPolicyViolationException, LimitExceededException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return createLoginProfile(CreateLoginProfileRequest.builder().applyMutation(createLoginProfileRequest).build());
    }

    /**
     * <p>
     * Creates an IAM entity to describe an identity provider (IdP) that supports <a
     * href="http://openid.net/connect/">OpenID Connect (OIDC)</a>.
     * </p>
     * <p>
     * The OIDC provider that you create with this operation can be used as a principal in a role's trust policy. Such a
     * policy establishes a trust relationship between AWS and the OIDC provider.
     * </p>
     * <p>
     * If you are using an OIDC identity provider from Google, Facebook, or Amazon Cognito, you don't need to create a
     * separate IAM identity provider. These OIDC identity providers are already built-in to AWS and are available for
     * your use. Instead, you can move directly to creating new roles using your identity provider. To learn more, see
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-idp_oidc.html">Creating a role for
     * web identity or OpenID connect federation</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * When you create the IAM OIDC provider, you specify the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The URL of the OIDC identity provider (IdP) to trust
     * </p>
     * </li>
     * <li>
     * <p>
     * A list of client IDs (also known as audiences) that identify the application or applications that are allowed to
     * authenticate using the OIDC provider
     * </p>
     * </li>
     * <li>
     * <p>
     * A list of thumbprints of one or more server certificates that the IdP uses
     * </p>
     * </li>
     * </ul>
     * <p>
     * You get all of this information from the OIDC IdP that you want to use to access AWS.
     * </p>
     * <note>
     * <p>
     * The trust for the OIDC provider is derived from the IAM provider that this operation creates. Therefore, it is
     * best to limit access to the <a>CreateOpenIDConnectProvider</a> operation to highly privileged users.
     * </p>
     * </note>
     *
     * @param createOpenIdConnectProviderRequest
     * @return Result of the CreateOpenIDConnectProvider operation returned by the service.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ConcurrentModificationException
     *         The request was rejected because multiple requests to change this object were submitted simultaneously.
     *         Wait a few minutes and submit your request again.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateOpenIDConnectProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateOpenIDConnectProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateOpenIdConnectProviderResponse createOpenIDConnectProvider(
            CreateOpenIdConnectProviderRequest createOpenIdConnectProviderRequest) throws InvalidInputException,
            EntityAlreadyExistsException, LimitExceededException, ConcurrentModificationException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an IAM entity to describe an identity provider (IdP) that supports <a
     * href="http://openid.net/connect/">OpenID Connect (OIDC)</a>.
     * </p>
     * <p>
     * The OIDC provider that you create with this operation can be used as a principal in a role's trust policy. Such a
     * policy establishes a trust relationship between AWS and the OIDC provider.
     * </p>
     * <p>
     * If you are using an OIDC identity provider from Google, Facebook, or Amazon Cognito, you don't need to create a
     * separate IAM identity provider. These OIDC identity providers are already built-in to AWS and are available for
     * your use. Instead, you can move directly to creating new roles using your identity provider. To learn more, see
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-idp_oidc.html">Creating a role for
     * web identity or OpenID connect federation</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * When you create the IAM OIDC provider, you specify the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The URL of the OIDC identity provider (IdP) to trust
     * </p>
     * </li>
     * <li>
     * <p>
     * A list of client IDs (also known as audiences) that identify the application or applications that are allowed to
     * authenticate using the OIDC provider
     * </p>
     * </li>
     * <li>
     * <p>
     * A list of thumbprints of one or more server certificates that the IdP uses
     * </p>
     * </li>
     * </ul>
     * <p>
     * You get all of this information from the OIDC IdP that you want to use to access AWS.
     * </p>
     * <note>
     * <p>
     * The trust for the OIDC provider is derived from the IAM provider that this operation creates. Therefore, it is
     * best to limit access to the <a>CreateOpenIDConnectProvider</a> operation to highly privileged users.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOpenIdConnectProviderRequest.Builder}
     * avoiding the need to create one manually via {@link CreateOpenIdConnectProviderRequest#builder()}
     * </p>
     *
     * @param createOpenIdConnectProviderRequest
     *        A {@link Consumer} that will call methods on {@link CreateOpenIDConnectProviderRequest.Builder} to create
     *        a request.
     * @return Result of the CreateOpenIDConnectProvider operation returned by the service.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ConcurrentModificationException
     *         The request was rejected because multiple requests to change this object were submitted simultaneously.
     *         Wait a few minutes and submit your request again.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateOpenIDConnectProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateOpenIDConnectProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateOpenIdConnectProviderResponse createOpenIDConnectProvider(
            Consumer<CreateOpenIdConnectProviderRequest.Builder> createOpenIdConnectProviderRequest)
            throws InvalidInputException, EntityAlreadyExistsException, LimitExceededException, ConcurrentModificationException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return createOpenIDConnectProvider(CreateOpenIdConnectProviderRequest.builder()
                .applyMutation(createOpenIdConnectProviderRequest).build());
    }

    /**
     * <p>
     * Creates a new managed policy for your AWS account.
     * </p>
     * <p>
     * This operation creates a policy version with a version identifier of <code>v1</code> and sets v1 as the policy's
     * default version. For more information about policy versions, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * As a best practice, you can validate your IAM policies. To learn more, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html">Validating IAM
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For more information about managed policies in general, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param createPolicyRequest
     * @return Result of the CreatePolicy operation returned by the service.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws MalformedPolicyDocumentException
     *         The request was rejected because the policy document was malformed. The error message describes the
     *         specific error.
     * @throws ConcurrentModificationException
     *         The request was rejected because multiple requests to change this object were submitted simultaneously.
     *         Wait a few minutes and submit your request again.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreatePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreatePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePolicyResponse createPolicy(CreatePolicyRequest createPolicyRequest) throws InvalidInputException,
            LimitExceededException, EntityAlreadyExistsException, MalformedPolicyDocumentException,
            ConcurrentModificationException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new managed policy for your AWS account.
     * </p>
     * <p>
     * This operation creates a policy version with a version identifier of <code>v1</code> and sets v1 as the policy's
     * default version. For more information about policy versions, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * As a best practice, you can validate your IAM policies. To learn more, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html">Validating IAM
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For more information about managed policies in general, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePolicyRequest.Builder} avoiding the need to
     * create one manually via {@link CreatePolicyRequest#builder()}
     * </p>
     *
     * @param createPolicyRequest
     *        A {@link Consumer} that will call methods on {@link CreatePolicyRequest.Builder} to create a request.
     * @return Result of the CreatePolicy operation returned by the service.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws MalformedPolicyDocumentException
     *         The request was rejected because the policy document was malformed. The error message describes the
     *         specific error.
     * @throws ConcurrentModificationException
     *         The request was rejected because multiple requests to change this object were submitted simultaneously.
     *         Wait a few minutes and submit your request again.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreatePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreatePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePolicyResponse createPolicy(Consumer<CreatePolicyRequest.Builder> createPolicyRequest)
            throws InvalidInputException, LimitExceededException, EntityAlreadyExistsException, MalformedPolicyDocumentException,
            ConcurrentModificationException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return createPolicy(CreatePolicyRequest.builder().applyMutation(createPolicyRequest).build());
    }

    /**
     * <p>
     * Creates a new version of the specified managed policy. To update a managed policy, you create a new policy
     * version. A managed policy can have up to five versions. If the policy has five versions, you must delete an
     * existing version using <a>DeletePolicyVersion</a> before you create a new version.
     * </p>
     * <p>
     * Optionally, you can set the new version as the policy's default version. The default version is the version that
     * is in effect for the IAM users, groups, and roles to which the policy is attached.
     * </p>
     * <p>
     * For more information about managed policy versions, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param createPolicyVersionRequest
     * @return Result of the CreatePolicyVersion operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws MalformedPolicyDocumentException
     *         The request was rejected because the policy document was malformed. The error message describes the
     *         specific error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreatePolicyVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreatePolicyVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePolicyVersionResponse createPolicyVersion(CreatePolicyVersionRequest createPolicyVersionRequest)
            throws NoSuchEntityException, MalformedPolicyDocumentException, InvalidInputException, LimitExceededException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new version of the specified managed policy. To update a managed policy, you create a new policy
     * version. A managed policy can have up to five versions. If the policy has five versions, you must delete an
     * existing version using <a>DeletePolicyVersion</a> before you create a new version.
     * </p>
     * <p>
     * Optionally, you can set the new version as the policy's default version. The default version is the version that
     * is in effect for the IAM users, groups, and roles to which the policy is attached.
     * </p>
     * <p>
     * For more information about managed policy versions, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePolicyVersionRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePolicyVersionRequest#builder()}
     * </p>
     *
     * @param createPolicyVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreatePolicyVersionRequest.Builder} to create a
     *        request.
     * @return Result of the CreatePolicyVersion operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws MalformedPolicyDocumentException
     *         The request was rejected because the policy document was malformed. The error message describes the
     *         specific error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreatePolicyVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreatePolicyVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePolicyVersionResponse createPolicyVersion(
            Consumer<CreatePolicyVersionRequest.Builder> createPolicyVersionRequest) throws NoSuchEntityException,
            MalformedPolicyDocumentException, InvalidInputException, LimitExceededException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        return createPolicyVersion(CreatePolicyVersionRequest.builder().applyMutation(createPolicyVersionRequest).build());
    }

    /**
     * <p>
     * Creates a new role for your AWS account. For more information about roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">IAM roles</a>. For information
     * about quotas for role names and the number of roles you can create, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     *
     * @param createRoleRequest
     * @return Result of the CreateRole operation returned by the service.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws MalformedPolicyDocumentException
     *         The request was rejected because the policy document was malformed. The error message describes the
     *         specific error.
     * @throws ConcurrentModificationException
     *         The request was rejected because multiple requests to change this object were submitted simultaneously.
     *         Wait a few minutes and submit your request again.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateRole" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateRoleResponse createRole(CreateRoleRequest createRoleRequest) throws LimitExceededException,
            InvalidInputException, EntityAlreadyExistsException, MalformedPolicyDocumentException,
            ConcurrentModificationException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new role for your AWS account. For more information about roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">IAM roles</a>. For information
     * about quotas for role names and the number of roles you can create, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRoleRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRoleRequest#builder()}
     * </p>
     *
     * @param createRoleRequest
     *        A {@link Consumer} that will call methods on {@link CreateRoleRequest.Builder} to create a request.
     * @return Result of the CreateRole operation returned by the service.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws MalformedPolicyDocumentException
     *         The request was rejected because the policy document was malformed. The error message describes the
     *         specific error.
     * @throws ConcurrentModificationException
     *         The request was rejected because multiple requests to change this object were submitted simultaneously.
     *         Wait a few minutes and submit your request again.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateRole" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateRoleResponse createRole(Consumer<CreateRoleRequest.Builder> createRoleRequest) throws LimitExceededException,
            InvalidInputException, EntityAlreadyExistsException, MalformedPolicyDocumentException,
            ConcurrentModificationException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return createRole(CreateRoleRequest.builder().applyMutation(createRoleRequest).build());
    }

    /**
     * <p>
     * Creates an IAM resource that describes an identity provider (IdP) that supports SAML 2.0.
     * </p>
     * <p>
     * The SAML provider resource that you create with this operation can be used as a principal in an IAM role's trust
     * policy. Such a policy can enable federated users who sign in using the SAML IdP to assume the role. You can
     * create an IAM role that supports Web-based single sign-on (SSO) to the AWS Management Console or one that
     * supports API access to AWS.
     * </p>
     * <p>
     * When you create the SAML provider resource, you upload a SAML metadata document that you get from your IdP. That
     * document includes the issuer's name, expiration information, and keys that can be used to validate the SAML
     * authentication response (assertions) that the IdP sends. You must generate the metadata document using the
     * identity management software that is used as your organization's IdP.
     * </p>
     * <note>
     * <p>
     * This operation requires <a
     * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-saml.html">Enabling SAML
     * 2.0 federated users to access the AWS Management Console</a> and <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html">About SAML 2.0-based
     * federation</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param createSamlProviderRequest
     * @return Result of the CreateSAMLProvider operation returned by the service.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ConcurrentModificationException
     *         The request was rejected because multiple requests to change this object were submitted simultaneously.
     *         Wait a few minutes and submit your request again.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateSAMLProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateSAMLProvider" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSamlProviderResponse createSAMLProvider(CreateSamlProviderRequest createSamlProviderRequest)
            throws InvalidInputException, EntityAlreadyExistsException, LimitExceededException, ConcurrentModificationException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an IAM resource that describes an identity provider (IdP) that supports SAML 2.0.
     * </p>
     * <p>
     * The SAML provider resource that you create with this operation can be used as a principal in an IAM role's trust
     * policy. Such a policy can enable federated users who sign in using the SAML IdP to assume the role. You can
     * create an IAM role that supports Web-based single sign-on (SSO) to the AWS Management Console or one that
     * supports API access to AWS.
     * </p>
     * <p>
     * When you create the SAML provider resource, you upload a SAML metadata document that you get from your IdP. That
     * document includes the issuer's name, expiration information, and keys that can be used to validate the SAML
     * authentication response (assertions) that the IdP sends. You must generate the metadata document using the
     * identity management software that is used as your organization's IdP.
     * </p>
     * <note>
     * <p>
     * This operation requires <a
     * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-saml.html">Enabling SAML
     * 2.0 federated users to access the AWS Management Console</a> and <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html">About SAML 2.0-based
     * federation</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSamlProviderRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSamlProviderRequest#builder()}
     * </p>
     *
     * @param createSamlProviderRequest
     *        A {@link Consumer} that will call methods on {@link CreateSAMLProviderRequest.Builder} to create a
     *        request.
     * @return Result of the CreateSAMLProvider operation returned by the service.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ConcurrentModificationException
     *         The request was rejected because multiple requests to change this object were submitted simultaneously.
     *         Wait a few minutes and submit your request again.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateSAMLProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateSAMLProvider" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSamlProviderResponse createSAMLProvider(Consumer<CreateSamlProviderRequest.Builder> createSamlProviderRequest)
            throws InvalidInputException, EntityAlreadyExistsException, LimitExceededException, ConcurrentModificationException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return createSAMLProvider(CreateSamlProviderRequest.builder().applyMutation(createSamlProviderRequest).build());
    }

    /**
     * <p>
     * Creates an IAM role that is linked to a specific AWS service. The service controls the attached policies and when
     * the role can be deleted. This helps ensure that the service is not broken by an unexpectedly changed or deleted
     * role, which could put your AWS resources into an unknown state. Allowing the service to control the role helps
     * improve service stability and proper cleanup when a service and its role are no longer needed. For more
     * information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/using-service-linked-roles.html">Using
     * service-linked roles</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * To attach a policy to this service-linked role, you must make the request using the AWS service that depends on
     * this role.
     * </p>
     *
     * @param createServiceLinkedRoleRequest
     * @return Result of the CreateServiceLinkedRole operation returned by the service.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateServiceLinkedRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateServiceLinkedRole" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateServiceLinkedRoleResponse createServiceLinkedRole(CreateServiceLinkedRoleRequest createServiceLinkedRoleRequest)
            throws InvalidInputException, LimitExceededException, NoSuchEntityException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an IAM role that is linked to a specific AWS service. The service controls the attached policies and when
     * the role can be deleted. This helps ensure that the service is not broken by an unexpectedly changed or deleted
     * role, which could put your AWS resources into an unknown state. Allowing the service to control the role helps
     * improve service stability and proper cleanup when a service and its role are no longer needed. For more
     * information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/using-service-linked-roles.html">Using
     * service-linked roles</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * To attach a policy to this service-linked role, you must make the request using the AWS service that depends on
     * this role.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateServiceLinkedRoleRequest.Builder} avoiding
     * the need to create one manually via {@link CreateServiceLinkedRoleRequest#builder()}
     * </p>
     *
     * @param createServiceLinkedRoleRequest
     *        A {@link Consumer} that will call methods on {@link CreateServiceLinkedRoleRequest.Builder} to create a
     *        request.
     * @return Result of the CreateServiceLinkedRole operation returned by the service.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateServiceLinkedRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateServiceLinkedRole" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateServiceLinkedRoleResponse createServiceLinkedRole(
            Consumer<CreateServiceLinkedRoleRequest.Builder> createServiceLinkedRoleRequest) throws InvalidInputException,
            LimitExceededException, NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException,
            IamException {
        return createServiceLinkedRole(CreateServiceLinkedRoleRequest.builder().applyMutation(createServiceLinkedRoleRequest)
                .build());
    }

    /**
     * <p>
     * Generates a set of credentials consisting of a user name and password that can be used to access the service
     * specified in the request. These credentials are generated by IAM, and can be used only for the specified service.
     * </p>
     * <p>
     * You can have a maximum of two sets of service-specific credentials for each supported service per user.
     * </p>
     * <p>
     * You can create service-specific credentials for AWS CodeCommit and Amazon Keyspaces (for Apache Cassandra).
     * </p>
     * <p>
     * You can reset the password to a new service-generated value by calling <a>ResetServiceSpecificCredential</a>.
     * </p>
     * <p>
     * For more information about service-specific credentials, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_ssh-keys.html">Using IAM with AWS
     * CodeCommit: Git credentials, SSH keys, and AWS access keys</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param createServiceSpecificCredentialRequest
     * @return Result of the CreateServiceSpecificCredential operation returned by the service.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceNotSupportedException
     *         The specified service does not support service-specific credentials.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateServiceSpecificCredential
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateServiceSpecificCredential"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateServiceSpecificCredentialResponse createServiceSpecificCredential(
            CreateServiceSpecificCredentialRequest createServiceSpecificCredentialRequest) throws LimitExceededException,
            NoSuchEntityException, ServiceNotSupportedException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates a set of credentials consisting of a user name and password that can be used to access the service
     * specified in the request. These credentials are generated by IAM, and can be used only for the specified service.
     * </p>
     * <p>
     * You can have a maximum of two sets of service-specific credentials for each supported service per user.
     * </p>
     * <p>
     * You can create service-specific credentials for AWS CodeCommit and Amazon Keyspaces (for Apache Cassandra).
     * </p>
     * <p>
     * You can reset the password to a new service-generated value by calling <a>ResetServiceSpecificCredential</a>.
     * </p>
     * <p>
     * For more information about service-specific credentials, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_ssh-keys.html">Using IAM with AWS
     * CodeCommit: Git credentials, SSH keys, and AWS access keys</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateServiceSpecificCredentialRequest.Builder}
     * avoiding the need to create one manually via {@link CreateServiceSpecificCredentialRequest#builder()}
     * </p>
     *
     * @param createServiceSpecificCredentialRequest
     *        A {@link Consumer} that will call methods on {@link CreateServiceSpecificCredentialRequest.Builder} to
     *        create a request.
     * @return Result of the CreateServiceSpecificCredential operation returned by the service.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceNotSupportedException
     *         The specified service does not support service-specific credentials.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateServiceSpecificCredential
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateServiceSpecificCredential"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateServiceSpecificCredentialResponse createServiceSpecificCredential(
            Consumer<CreateServiceSpecificCredentialRequest.Builder> createServiceSpecificCredentialRequest)
            throws LimitExceededException, NoSuchEntityException, ServiceNotSupportedException, AwsServiceException,
            SdkClientException, IamException {
        return createServiceSpecificCredential(CreateServiceSpecificCredentialRequest.builder()
                .applyMutation(createServiceSpecificCredentialRequest).build());
    }

    /**
     * <p>
     * Creates a new IAM user for your AWS account.
     * </p>
     * <p>
     * For information about quotas for the number of IAM users you can create, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     *
     * @param createUserRequest
     * @return Result of the CreateUser operation returned by the service.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ConcurrentModificationException
     *         The request was rejected because multiple requests to change this object were submitted simultaneously.
     *         Wait a few minutes and submit your request again.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateUserResponse createUser(CreateUserRequest createUserRequest) throws LimitExceededException,
            EntityAlreadyExistsException, NoSuchEntityException, InvalidInputException, ConcurrentModificationException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new IAM user for your AWS account.
     * </p>
     * <p>
     * For information about quotas for the number of IAM users you can create, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserRequest.Builder} avoiding the need to
     * create one manually via {@link CreateUserRequest#builder()}
     * </p>
     *
     * @param createUserRequest
     *        A {@link Consumer} that will call methods on {@link CreateUserRequest.Builder} to create a request.
     * @return Result of the CreateUser operation returned by the service.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ConcurrentModificationException
     *         The request was rejected because multiple requests to change this object were submitted simultaneously.
     *         Wait a few minutes and submit your request again.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateUserResponse createUser(Consumer<CreateUserRequest.Builder> createUserRequest) throws LimitExceededException,
            EntityAlreadyExistsException, NoSuchEntityException, InvalidInputException, ConcurrentModificationException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return createUser(CreateUserRequest.builder().applyMutation(createUserRequest).build());
    }

    /**
     * <p>
     * Creates a new virtual MFA device for the AWS account. After creating the virtual MFA, use <a>EnableMFADevice</a>
     * to attach the MFA device to an IAM user. For more information about creating and working with virtual MFA
     * devices, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html">Using a virtual MFA
     * device</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For information about the maximum number of MFA devices you can create, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * <important>
     * <p>
     * The seed information contained in the QR code and the Base32 string should be treated like any other secret
     * access information. In other words, protect the seed information as you would your AWS access keys or your
     * passwords. After you provision your virtual device, you should ensure that the information is destroyed following
     * secure procedures.
     * </p>
     * </important>
     *
     * @param createVirtualMfaDeviceRequest
     * @return Result of the CreateVirtualMFADevice operation returned by the service.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws ConcurrentModificationException
     *         The request was rejected because multiple requests to change this object were submitted simultaneously.
     *         Wait a few minutes and submit your request again.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateVirtualMFADevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateVirtualMFADevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateVirtualMfaDeviceResponse createVirtualMFADevice(CreateVirtualMfaDeviceRequest createVirtualMfaDeviceRequest)
            throws LimitExceededException, InvalidInputException, EntityAlreadyExistsException, ConcurrentModificationException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new virtual MFA device for the AWS account. After creating the virtual MFA, use <a>EnableMFADevice</a>
     * to attach the MFA device to an IAM user. For more information about creating and working with virtual MFA
     * devices, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html">Using a virtual MFA
     * device</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For information about the maximum number of MFA devices you can create, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * <important>
     * <p>
     * The seed information contained in the QR code and the Base32 string should be treated like any other secret
     * access information. In other words, protect the seed information as you would your AWS access keys or your
     * passwords. After you provision your virtual device, you should ensure that the information is destroyed following
     * secure procedures.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVirtualMfaDeviceRequest.Builder} avoiding the
     * need to create one manually via {@link CreateVirtualMfaDeviceRequest#builder()}
     * </p>
     *
     * @param createVirtualMfaDeviceRequest
     *        A {@link Consumer} that will call methods on {@link CreateVirtualMFADeviceRequest.Builder} to create a
     *        request.
     * @return Result of the CreateVirtualMFADevice operation returned by the service.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws ConcurrentModificationException
     *         The request was rejected because multiple requests to change this object were submitted simultaneously.
     *         Wait a few minutes and submit your request again.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateVirtualMFADevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateVirtualMFADevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateVirtualMfaDeviceResponse createVirtualMFADevice(
            Consumer<CreateVirtualMfaDeviceRequest.Builder> createVirtualMfaDeviceRequest) throws LimitExceededException,
            InvalidInputException, EntityAlreadyExistsException, ConcurrentModificationException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        return createVirtualMFADevice(CreateVirtualMfaDeviceRequest.builder().applyMutation(createVirtualMfaDeviceRequest)
                .build());
    }

    /**
     * <p>
     * Deactivates the specified MFA device and removes it from association with the user name for which it was
     * originally enabled.
     * </p>
     * <p>
     * For more information about creating and working with virtual MFA devices, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html">Enabling a virtual multi-factor
     * authentication (MFA) device</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param deactivateMfaDeviceRequest
     * @return Result of the DeactivateMFADevice operation returned by the service.
     * @throws EntityTemporarilyUnmodifiableException
     *         The request was rejected because it referenced an entity that is temporarily unmodifiable, such as a user
     *         name that was deleted and then recreated. The error indicates that the request is likely to succeed if
     *         you try again after waiting several minutes. The error message describes the entity.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeactivateMFADevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeactivateMFADevice" target="_top">AWS API
     *      Documentation</a>
     */
    default DeactivateMfaDeviceResponse deactivateMFADevice(DeactivateMfaDeviceRequest deactivateMfaDeviceRequest)
            throws EntityTemporarilyUnmodifiableException, NoSuchEntityException, LimitExceededException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deactivates the specified MFA device and removes it from association with the user name for which it was
     * originally enabled.
     * </p>
     * <p>
     * For more information about creating and working with virtual MFA devices, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html">Enabling a virtual multi-factor
     * authentication (MFA) device</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeactivateMfaDeviceRequest.Builder} avoiding the
     * need to create one manually via {@link DeactivateMfaDeviceRequest#builder()}
     * </p>
     *
     * @param deactivateMfaDeviceRequest
     *        A {@link Consumer} that will call methods on {@link DeactivateMFADeviceRequest.Builder} to create a
     *        request.
     * @return Result of the DeactivateMFADevice operation returned by the service.
     * @throws EntityTemporarilyUnmodifiableException
     *         The request was rejected because it referenced an entity that is temporarily unmodifiable, such as a user
     *         name that was deleted and then recreated. The error indicates that the request is likely to succeed if
     *         you try again after waiting several minutes. The error message describes the entity.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeactivateMFADevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeactivateMFADevice" target="_top">AWS API
     *      Documentation</a>
     */
    default DeactivateMfaDeviceResponse deactivateMFADevice(
            Consumer<DeactivateMfaDeviceRequest.Builder> deactivateMfaDeviceRequest)
            throws EntityTemporarilyUnmodifiableException, NoSuchEntityException, LimitExceededException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return deactivateMFADevice(DeactivateMfaDeviceRequest.builder().applyMutation(deactivateMfaDeviceRequest).build());
    }

    /**
     * <p>
     * Deletes the access key pair associated with the specified IAM user.
     * </p>
     * <p>
     * If you do not specify a user name, IAM determines the user name implicitly based on the AWS access key ID signing
     * the request. This operation works for access keys under the AWS account. Consequently, you can use this operation
     * to manage AWS account root user credentials even if the AWS account has no associated users.
     * </p>
     *
     * @param deleteAccessKeyRequest
     * @return Result of the DeleteAccessKey operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteAccessKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteAccessKey" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAccessKeyResponse deleteAccessKey(DeleteAccessKeyRequest deleteAccessKeyRequest) throws NoSuchEntityException,
            LimitExceededException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the access key pair associated with the specified IAM user.
     * </p>
     * <p>
     * If you do not specify a user name, IAM determines the user name implicitly based on the AWS access key ID signing
     * the request. This operation works for access keys under the AWS account. Consequently, you can use this operation
     * to manage AWS account root user credentials even if the AWS account has no associated users.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccessKeyRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAccessKeyRequest#builder()}
     * </p>
     *
     * @param deleteAccessKeyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAccessKeyRequest.Builder} to create a request.
     * @return Result of the DeleteAccessKey operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteAccessKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteAccessKey" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAccessKeyResponse deleteAccessKey(Consumer<DeleteAccessKeyRequest.Builder> deleteAccessKeyRequest)
            throws NoSuchEntityException, LimitExceededException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        return deleteAccessKey(DeleteAccessKeyRequest.builder().applyMutation(deleteAccessKeyRequest).build());
    }

    /**
     * <p>
     * Deletes the specified AWS account alias. For information about using an AWS account alias, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AccountAlias.html">Using an alias for your AWS account
     * ID</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param deleteAccountAliasRequest
     * @return Result of the DeleteAccountAlias operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteAccountAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteAccountAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAccountAliasResponse deleteAccountAlias(DeleteAccountAliasRequest deleteAccountAliasRequest)
            throws NoSuchEntityException, LimitExceededException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified AWS account alias. For information about using an AWS account alias, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AccountAlias.html">Using an alias for your AWS account
     * ID</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccountAliasRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAccountAliasRequest#builder()}
     * </p>
     *
     * @param deleteAccountAliasRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAccountAliasRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteAccountAlias operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteAccountAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteAccountAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAccountAliasResponse deleteAccountAlias(Consumer<DeleteAccountAliasRequest.Builder> deleteAccountAliasRequest)
            throws NoSuchEntityException, LimitExceededException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        return deleteAccountAlias(DeleteAccountAliasRequest.builder().applyMutation(deleteAccountAliasRequest).build());
    }

    /**
     * <p>
     * Deletes the password policy for the AWS account. There are no parameters.
     * </p>
     *
     * @return Result of the DeleteAccountPasswordPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteAccountPasswordPolicy
     * @see #deleteAccountPasswordPolicy(DeleteAccountPasswordPolicyRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteAccountPasswordPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAccountPasswordPolicyResponse deleteAccountPasswordPolicy() throws NoSuchEntityException,
            LimitExceededException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return deleteAccountPasswordPolicy(DeleteAccountPasswordPolicyRequest.builder().build());
    }

    /**
     * <p>
     * Deletes the password policy for the AWS account. There are no parameters.
     * </p>
     *
     * @param deleteAccountPasswordPolicyRequest
     * @return Result of the DeleteAccountPasswordPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteAccountPasswordPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteAccountPasswordPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAccountPasswordPolicyResponse deleteAccountPasswordPolicy(
            DeleteAccountPasswordPolicyRequest deleteAccountPasswordPolicyRequest) throws NoSuchEntityException,
            LimitExceededException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the password policy for the AWS account. There are no parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccountPasswordPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteAccountPasswordPolicyRequest#builder()}
     * </p>
     *
     * @param deleteAccountPasswordPolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAccountPasswordPolicyRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteAccountPasswordPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteAccountPasswordPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteAccountPasswordPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAccountPasswordPolicyResponse deleteAccountPasswordPolicy(
            Consumer<DeleteAccountPasswordPolicyRequest.Builder> deleteAccountPasswordPolicyRequest)
            throws NoSuchEntityException, LimitExceededException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        return deleteAccountPasswordPolicy(DeleteAccountPasswordPolicyRequest.builder()
                .applyMutation(deleteAccountPasswordPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes the specified IAM group. The group must not contain any users or have any attached policies.
     * </p>
     *
     * @param deleteGroupRequest
     * @return Result of the DeleteGroup operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws DeleteConflictException
     *         The request was rejected because it attempted to delete a resource that has attached subordinate
     *         entities. The error message describes these entities.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteGroupResponse deleteGroup(DeleteGroupRequest deleteGroupRequest) throws NoSuchEntityException,
            DeleteConflictException, LimitExceededException, ServiceFailureException, AwsServiceException, SdkClientException,
            IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified IAM group. The group must not contain any users or have any attached policies.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGroupRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGroupRequest#builder()}
     * </p>
     *
     * @param deleteGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGroupRequest.Builder} to create a request.
     * @return Result of the DeleteGroup operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws DeleteConflictException
     *         The request was rejected because it attempted to delete a resource that has attached subordinate
     *         entities. The error message describes these entities.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteGroupResponse deleteGroup(Consumer<DeleteGroupRequest.Builder> deleteGroupRequest)
            throws NoSuchEntityException, DeleteConflictException, LimitExceededException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        return deleteGroup(DeleteGroupRequest.builder().applyMutation(deleteGroupRequest).build());
    }

    /**
     * <p>
     * Deletes the specified inline policy that is embedded in the specified IAM group.
     * </p>
     * <p>
     * A group can also have managed policies attached to it. To detach a managed policy from a group, use
     * <a>DetachGroupPolicy</a>. For more information about policies, refer to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param deleteGroupPolicyRequest
     * @return Result of the DeleteGroupPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteGroupPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteGroupPolicyResponse deleteGroupPolicy(DeleteGroupPolicyRequest deleteGroupPolicyRequest)
            throws NoSuchEntityException, LimitExceededException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified inline policy that is embedded in the specified IAM group.
     * </p>
     * <p>
     * A group can also have managed policies attached to it. To detach a managed policy from a group, use
     * <a>DetachGroupPolicy</a>. For more information about policies, refer to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGroupPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteGroupPolicyRequest#builder()}
     * </p>
     *
     * @param deleteGroupPolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGroupPolicyRequest.Builder} to create a request.
     * @return Result of the DeleteGroupPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteGroupPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteGroupPolicyResponse deleteGroupPolicy(Consumer<DeleteGroupPolicyRequest.Builder> deleteGroupPolicyRequest)
            throws NoSuchEntityException, LimitExceededException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        return deleteGroupPolicy(DeleteGroupPolicyRequest.builder().applyMutation(deleteGroupPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes the specified instance profile. The instance profile must not have an associated role.
     * </p>
     * <important>
     * <p>
     * Make sure that you do not have any Amazon EC2 instances running with the instance profile you are about to
     * delete. Deleting a role or instance profile that is associated with a running instance will break any
     * applications running on the instance.
     * </p>
     * </important>
     * <p>
     * For more information about instance profiles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About instance profiles</a>.
     * </p>
     *
     * @param deleteInstanceProfileRequest
     * @return Result of the DeleteInstanceProfile operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws DeleteConflictException
     *         The request was rejected because it attempted to delete a resource that has attached subordinate
     *         entities. The error message describes these entities.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteInstanceProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteInstanceProfileResponse deleteInstanceProfile(DeleteInstanceProfileRequest deleteInstanceProfileRequest)
            throws NoSuchEntityException, DeleteConflictException, LimitExceededException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified instance profile. The instance profile must not have an associated role.
     * </p>
     * <important>
     * <p>
     * Make sure that you do not have any Amazon EC2 instances running with the instance profile you are about to
     * delete. Deleting a role or instance profile that is associated with a running instance will break any
     * applications running on the instance.
     * </p>
     * </important>
     * <p>
     * For more information about instance profiles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About instance profiles</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInstanceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteInstanceProfileRequest#builder()}
     * </p>
     *
     * @param deleteInstanceProfileRequest
     *        A {@link Consumer} that will call methods on {@link DeleteInstanceProfileRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteInstanceProfile operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws DeleteConflictException
     *         The request was rejected because it attempted to delete a resource that has attached subordinate
     *         entities. The error message describes these entities.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteInstanceProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteInstanceProfileResponse deleteInstanceProfile(
            Consumer<DeleteInstanceProfileRequest.Builder> deleteInstanceProfileRequest) throws NoSuchEntityException,
            DeleteConflictException, LimitExceededException, ServiceFailureException, AwsServiceException, SdkClientException,
            IamException {
        return deleteInstanceProfile(DeleteInstanceProfileRequest.builder().applyMutation(deleteInstanceProfileRequest).build());
    }

    /**
     * <p>
     * Deletes the password for the specified IAM user, which terminates the user's ability to access AWS services
     * through the AWS Management Console.
     * </p>
     * <p>
     * You can use the AWS CLI, the AWS API, or the <b>Users</b> page in the IAM console to delete a password for any
     * IAM user. You can use <a>ChangePassword</a> to update, but not delete, your own password in the <b>My Security
     * Credentials</b> page in the AWS Management Console.
     * </p>
     * <important>
     * <p>
     * Deleting a user's password does not prevent a user from accessing AWS through the command line interface or the
     * API. To prevent all user access, you must also either make any access keys inactive or delete them. For more
     * information about making keys inactive or deleting them, see <a>UpdateAccessKey</a> and <a>DeleteAccessKey</a>.
     * </p>
     * </important>
     *
     * @param deleteLoginProfileRequest
     * @return Result of the DeleteLoginProfile operation returned by the service.
     * @throws EntityTemporarilyUnmodifiableException
     *         The request was rejected because it referenced an entity that is temporarily unmodifiable, such as a user
     *         name that was deleted and then recreated. The error indicates that the request is likely to succeed if
     *         you try again after waiting several minutes. The error message describes the entity.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteLoginProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteLoginProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteLoginProfileResponse deleteLoginProfile(DeleteLoginProfileRequest deleteLoginProfileRequest)
            throws EntityTemporarilyUnmodifiableException, NoSuchEntityException, LimitExceededException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the password for the specified IAM user, which terminates the user's ability to access AWS services
     * through the AWS Management Console.
     * </p>
     * <p>
     * You can use the AWS CLI, the AWS API, or the <b>Users</b> page in the IAM console to delete a password for any
     * IAM user. You can use <a>ChangePassword</a> to update, but not delete, your own password in the <b>My Security
     * Credentials</b> page in the AWS Management Console.
     * </p>
     * <important>
     * <p>
     * Deleting a user's password does not prevent a user from accessing AWS through the command line interface or the
     * API. To prevent all user access, you must also either make any access keys inactive or delete them. For more
     * information about making keys inactive or deleting them, see <a>UpdateAccessKey</a> and <a>DeleteAccessKey</a>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLoginProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteLoginProfileRequest#builder()}
     * </p>
     *
     * @param deleteLoginProfileRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLoginProfileRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteLoginProfile operation returned by the service.
     * @throws EntityTemporarilyUnmodifiableException
     *         The request was rejected because it referenced an entity that is temporarily unmodifiable, such as a user
     *         name that was deleted and then recreated. The error indicates that the request is likely to succeed if
     *         you try again after waiting several minutes. The error message describes the entity.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteLoginProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteLoginProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteLoginProfileResponse deleteLoginProfile(Consumer<DeleteLoginProfileRequest.Builder> deleteLoginProfileRequest)
            throws EntityTemporarilyUnmodifiableException, NoSuchEntityException, LimitExceededException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return deleteLoginProfile(DeleteLoginProfileRequest.builder().applyMutation(deleteLoginProfileRequest).build());
    }

    /**
     * <p>
     * Deletes an OpenID Connect identity provider (IdP) resource object in IAM.
     * </p>
     * <p>
     * Deleting an IAM OIDC provider resource does not update any roles that reference the provider as a principal in
     * their trust policies. Any attempt to assume a role that references a deleted provider fails.
     * </p>
     * <p>
     * This operation is idempotent; it does not fail or return an error if you call the operation for a provider that
     * does not exist.
     * </p>
     *
     * @param deleteOpenIdConnectProviderRequest
     * @return Result of the DeleteOpenIDConnectProvider operation returned by the service.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteOpenIDConnectProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteOpenIDConnectProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteOpenIdConnectProviderResponse deleteOpenIDConnectProvider(
            DeleteOpenIdConnectProviderRequest deleteOpenIdConnectProviderRequest) throws InvalidInputException,
            NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an OpenID Connect identity provider (IdP) resource object in IAM.
     * </p>
     * <p>
     * Deleting an IAM OIDC provider resource does not update any roles that reference the provider as a principal in
     * their trust policies. Any attempt to assume a role that references a deleted provider fails.
     * </p>
     * <p>
     * This operation is idempotent; it does not fail or return an error if you call the operation for a provider that
     * does not exist.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOpenIdConnectProviderRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteOpenIdConnectProviderRequest#builder()}
     * </p>
     *
     * @param deleteOpenIdConnectProviderRequest
     *        A {@link Consumer} that will call methods on {@link DeleteOpenIDConnectProviderRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteOpenIDConnectProvider operation returned by the service.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteOpenIDConnectProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteOpenIDConnectProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteOpenIdConnectProviderResponse deleteOpenIDConnectProvider(
            Consumer<DeleteOpenIdConnectProviderRequest.Builder> deleteOpenIdConnectProviderRequest)
            throws InvalidInputException, NoSuchEntityException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        return deleteOpenIDConnectProvider(DeleteOpenIdConnectProviderRequest.builder()
                .applyMutation(deleteOpenIdConnectProviderRequest).build());
    }

    /**
     * <p>
     * Deletes the specified managed policy.
     * </p>
     * <p>
     * Before you can delete a managed policy, you must first detach the policy from all users, groups, and roles that
     * it is attached to. In addition, you must delete all the policy's versions. The following steps describe the
     * process for deleting a managed policy:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Detach the policy from all users, groups, and roles that the policy is attached to, using
     * <a>DetachUserPolicy</a>, <a>DetachGroupPolicy</a>, or <a>DetachRolePolicy</a>. To list all the users, groups, and
     * roles that a policy is attached to, use <a>ListEntitiesForPolicy</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Delete all versions of the policy using <a>DeletePolicyVersion</a>. To list the policy's versions, use
     * <a>ListPolicyVersions</a>. You cannot use <a>DeletePolicyVersion</a> to delete the version that is marked as the
     * default version. You delete the policy's default version in the next step of the process.
     * </p>
     * </li>
     * <li>
     * <p>
     * Delete the policy (this automatically deletes the policy's default version) using this operation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For information about managed policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param deletePolicyRequest
     * @return Result of the DeletePolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws DeleteConflictException
     *         The request was rejected because it attempted to delete a resource that has attached subordinate
     *         entities. The error message describes these entities.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeletePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeletePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePolicyResponse deletePolicy(DeletePolicyRequest deletePolicyRequest) throws NoSuchEntityException,
            LimitExceededException, InvalidInputException, DeleteConflictException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified managed policy.
     * </p>
     * <p>
     * Before you can delete a managed policy, you must first detach the policy from all users, groups, and roles that
     * it is attached to. In addition, you must delete all the policy's versions. The following steps describe the
     * process for deleting a managed policy:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Detach the policy from all users, groups, and roles that the policy is attached to, using
     * <a>DetachUserPolicy</a>, <a>DetachGroupPolicy</a>, or <a>DetachRolePolicy</a>. To list all the users, groups, and
     * roles that a policy is attached to, use <a>ListEntitiesForPolicy</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Delete all versions of the policy using <a>DeletePolicyVersion</a>. To list the policy's versions, use
     * <a>ListPolicyVersions</a>. You cannot use <a>DeletePolicyVersion</a> to delete the version that is marked as the
     * default version. You delete the policy's default version in the next step of the process.
     * </p>
     * </li>
     * <li>
     * <p>
     * Delete the policy (this automatically deletes the policy's default version) using this operation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For information about managed policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePolicyRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePolicyRequest#builder()}
     * </p>
     *
     * @param deletePolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeletePolicyRequest.Builder} to create a request.
     * @return Result of the DeletePolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws DeleteConflictException
     *         The request was rejected because it attempted to delete a resource that has attached subordinate
     *         entities. The error message describes these entities.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeletePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeletePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePolicyResponse deletePolicy(Consumer<DeletePolicyRequest.Builder> deletePolicyRequest)
            throws NoSuchEntityException, LimitExceededException, InvalidInputException, DeleteConflictException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return deletePolicy(DeletePolicyRequest.builder().applyMutation(deletePolicyRequest).build());
    }

    /**
     * <p>
     * Deletes the specified version from the specified managed policy.
     * </p>
     * <p>
     * You cannot delete the default version from a policy using this operation. To delete the default version from a
     * policy, use <a>DeletePolicy</a>. To find out which version of a policy is marked as the default version, use
     * <a>ListPolicyVersions</a>.
     * </p>
     * <p>
     * For information about versions for managed policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param deletePolicyVersionRequest
     * @return Result of the DeletePolicyVersion operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws DeleteConflictException
     *         The request was rejected because it attempted to delete a resource that has attached subordinate
     *         entities. The error message describes these entities.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeletePolicyVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeletePolicyVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePolicyVersionResponse deletePolicyVersion(DeletePolicyVersionRequest deletePolicyVersionRequest)
            throws NoSuchEntityException, LimitExceededException, InvalidInputException, DeleteConflictException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified version from the specified managed policy.
     * </p>
     * <p>
     * You cannot delete the default version from a policy using this operation. To delete the default version from a
     * policy, use <a>DeletePolicy</a>. To find out which version of a policy is marked as the default version, use
     * <a>ListPolicyVersions</a>.
     * </p>
     * <p>
     * For information about versions for managed policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePolicyVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DeletePolicyVersionRequest#builder()}
     * </p>
     *
     * @param deletePolicyVersionRequest
     *        A {@link Consumer} that will call methods on {@link DeletePolicyVersionRequest.Builder} to create a
     *        request.
     * @return Result of the DeletePolicyVersion operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws DeleteConflictException
     *         The request was rejected because it attempted to delete a resource that has attached subordinate
     *         entities. The error message describes these entities.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeletePolicyVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeletePolicyVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePolicyVersionResponse deletePolicyVersion(
            Consumer<DeletePolicyVersionRequest.Builder> deletePolicyVersionRequest) throws NoSuchEntityException,
            LimitExceededException, InvalidInputException, DeleteConflictException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        return deletePolicyVersion(DeletePolicyVersionRequest.builder().applyMutation(deletePolicyVersionRequest).build());
    }

    /**
     * <p>
     * Deletes the specified role. The role must not have any policies attached. For more information about roles, see
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with roles</a>.
     * </p>
     * <important>
     * <p>
     * Make sure that you do not have any Amazon EC2 instances running with the role you are about to delete. Deleting a
     * role or instance profile that is associated with a running instance will break any applications running on the
     * instance.
     * </p>
     * </important>
     *
     * @param deleteRoleRequest
     * @return Result of the DeleteRole operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws DeleteConflictException
     *         The request was rejected because it attempted to delete a resource that has attached subordinate
     *         entities. The error message describes these entities.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws UnmodifiableEntityException
     *         The request was rejected because only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.
     * @throws ConcurrentModificationException
     *         The request was rejected because multiple requests to change this object were submitted simultaneously.
     *         Wait a few minutes and submit your request again.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteRole" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRoleResponse deleteRole(DeleteRoleRequest deleteRoleRequest) throws NoSuchEntityException,
            DeleteConflictException, LimitExceededException, UnmodifiableEntityException, ConcurrentModificationException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified role. The role must not have any policies attached. For more information about roles, see
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with roles</a>.
     * </p>
     * <important>
     * <p>
     * Make sure that you do not have any Amazon EC2 instances running with the role you are about to delete. Deleting a
     * role or instance profile that is associated with a running instance will break any applications running on the
     * instance.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRoleRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRoleRequest#builder()}
     * </p>
     *
     * @param deleteRoleRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRoleRequest.Builder} to create a request.
     * @return Result of the DeleteRole operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws DeleteConflictException
     *         The request was rejected because it attempted to delete a resource that has attached subordinate
     *         entities. The error message describes these entities.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws UnmodifiableEntityException
     *         The request was rejected because only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.
     * @throws ConcurrentModificationException
     *         The request was rejected because multiple requests to change this object were submitted simultaneously.
     *         Wait a few minutes and submit your request again.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteRole" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRoleResponse deleteRole(Consumer<DeleteRoleRequest.Builder> deleteRoleRequest) throws NoSuchEntityException,
            DeleteConflictException, LimitExceededException, UnmodifiableEntityException, ConcurrentModificationException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return deleteRole(DeleteRoleRequest.builder().applyMutation(deleteRoleRequest).build());
    }

    /**
     * <p>
     * Deletes the permissions boundary for the specified IAM role.
     * </p>
     * <important>
     * <p>
     * Deleting the permissions boundary for a role might increase its permissions. For example, it might allow anyone
     * who assumes the role to perform all the actions granted in its permissions policies.
     * </p>
     * </important>
     *
     * @param deleteRolePermissionsBoundaryRequest
     * @return Result of the DeleteRolePermissionsBoundary operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws UnmodifiableEntityException
     *         The request was rejected because only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteRolePermissionsBoundary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteRolePermissionsBoundary"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRolePermissionsBoundaryResponse deleteRolePermissionsBoundary(
            DeleteRolePermissionsBoundaryRequest deleteRolePermissionsBoundaryRequest) throws NoSuchEntityException,
            UnmodifiableEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the permissions boundary for the specified IAM role.
     * </p>
     * <important>
     * <p>
     * Deleting the permissions boundary for a role might increase its permissions. For example, it might allow anyone
     * who assumes the role to perform all the actions granted in its permissions policies.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRolePermissionsBoundaryRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteRolePermissionsBoundaryRequest#builder()}
     * </p>
     *
     * @param deleteRolePermissionsBoundaryRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRolePermissionsBoundaryRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteRolePermissionsBoundary operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws UnmodifiableEntityException
     *         The request was rejected because only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteRolePermissionsBoundary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteRolePermissionsBoundary"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRolePermissionsBoundaryResponse deleteRolePermissionsBoundary(
            Consumer<DeleteRolePermissionsBoundaryRequest.Builder> deleteRolePermissionsBoundaryRequest)
            throws NoSuchEntityException, UnmodifiableEntityException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        return deleteRolePermissionsBoundary(DeleteRolePermissionsBoundaryRequest.builder()
                .applyMutation(deleteRolePermissionsBoundaryRequest).build());
    }

    /**
     * <p>
     * Deletes the specified inline policy that is embedded in the specified IAM role.
     * </p>
     * <p>
     * A role can also have managed policies attached to it. To detach a managed policy from a role, use
     * <a>DetachRolePolicy</a>. For more information about policies, refer to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param deleteRolePolicyRequest
     * @return Result of the DeleteRolePolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws UnmodifiableEntityException
     *         The request was rejected because only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteRolePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteRolePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRolePolicyResponse deleteRolePolicy(DeleteRolePolicyRequest deleteRolePolicyRequest)
            throws NoSuchEntityException, LimitExceededException, UnmodifiableEntityException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified inline policy that is embedded in the specified IAM role.
     * </p>
     * <p>
     * A role can also have managed policies attached to it. To detach a managed policy from a role, use
     * <a>DetachRolePolicy</a>. For more information about policies, refer to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRolePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteRolePolicyRequest#builder()}
     * </p>
     *
     * @param deleteRolePolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRolePolicyRequest.Builder} to create a request.
     * @return Result of the DeleteRolePolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws UnmodifiableEntityException
     *         The request was rejected because only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteRolePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteRolePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRolePolicyResponse deleteRolePolicy(Consumer<DeleteRolePolicyRequest.Builder> deleteRolePolicyRequest)
            throws NoSuchEntityException, LimitExceededException, UnmodifiableEntityException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        return deleteRolePolicy(DeleteRolePolicyRequest.builder().applyMutation(deleteRolePolicyRequest).build());
    }

    /**
     * <p>
     * Deletes a SAML provider resource in IAM.
     * </p>
     * <p>
     * Deleting the provider resource from IAM does not update any roles that reference the SAML provider resource's ARN
     * as a principal in their trust policies. Any attempt to assume a role that references a non-existent provider
     * resource ARN fails.
     * </p>
     * <note>
     * <p>
     * This operation requires <a
     * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.
     * </p>
     * </note>
     *
     * @param deleteSamlProviderRequest
     * @return Result of the DeleteSAMLProvider operation returned by the service.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteSAMLProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteSAMLProvider" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSamlProviderResponse deleteSAMLProvider(DeleteSamlProviderRequest deleteSamlProviderRequest)
            throws InvalidInputException, LimitExceededException, NoSuchEntityException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a SAML provider resource in IAM.
     * </p>
     * <p>
     * Deleting the provider resource from IAM does not update any roles that reference the SAML provider resource's ARN
     * as a principal in their trust policies. Any attempt to assume a role that references a non-existent provider
     * resource ARN fails.
     * </p>
     * <note>
     * <p>
     * This operation requires <a
     * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSamlProviderRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSamlProviderRequest#builder()}
     * </p>
     *
     * @param deleteSamlProviderRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSAMLProviderRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteSAMLProvider operation returned by the service.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteSAMLProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteSAMLProvider" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSamlProviderResponse deleteSAMLProvider(Consumer<DeleteSamlProviderRequest.Builder> deleteSamlProviderRequest)
            throws InvalidInputException, LimitExceededException, NoSuchEntityException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        return deleteSAMLProvider(DeleteSamlProviderRequest.builder().applyMutation(deleteSamlProviderRequest).build());
    }

    /**
     * <p>
     * Deletes the specified SSH public key.
     * </p>
     * <p>
     * The SSH public key deleted by this operation is used only for authenticating the associated IAM user to an AWS
     * CodeCommit repository. For more information about using SSH keys to authenticate to an AWS CodeCommit repository,
     * see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up AWS
     * CodeCommit for SSH connections</a> in the <i>AWS CodeCommit User Guide</i>.
     * </p>
     *
     * @param deleteSshPublicKeyRequest
     * @return Result of the DeleteSSHPublicKey operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteSSHPublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteSSHPublicKey" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSshPublicKeyResponse deleteSSHPublicKey(DeleteSshPublicKeyRequest deleteSshPublicKeyRequest)
            throws NoSuchEntityException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified SSH public key.
     * </p>
     * <p>
     * The SSH public key deleted by this operation is used only for authenticating the associated IAM user to an AWS
     * CodeCommit repository. For more information about using SSH keys to authenticate to an AWS CodeCommit repository,
     * see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up AWS
     * CodeCommit for SSH connections</a> in the <i>AWS CodeCommit User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSshPublicKeyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSshPublicKeyRequest#builder()}
     * </p>
     *
     * @param deleteSshPublicKeyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSSHPublicKeyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteSSHPublicKey operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteSSHPublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteSSHPublicKey" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSshPublicKeyResponse deleteSSHPublicKey(Consumer<DeleteSshPublicKeyRequest.Builder> deleteSshPublicKeyRequest)
            throws NoSuchEntityException, AwsServiceException, SdkClientException, IamException {
        return deleteSSHPublicKey(DeleteSshPublicKeyRequest.builder().applyMutation(deleteSshPublicKeyRequest).build());
    }

    /**
     * <p>
     * Deletes the specified server certificate.
     * </p>
     * <p>
     * For more information about working with server certificates, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with server
     * certificates</a> in the <i>IAM User Guide</i>. This topic also includes a list of AWS services that can use the
     * server certificates that you manage with IAM.
     * </p>
     * <important>
     * <p>
     * If you are using a server certificate with Elastic Load Balancing, deleting the certificate could have
     * implications for your application. If Elastic Load Balancing doesn't detect the deletion of bound certificates,
     * it may continue to use the certificates. This could cause Elastic Load Balancing to stop accepting traffic. We
     * recommend that you remove the reference to the certificate from Elastic Load Balancing before using this command
     * to delete the certificate. For more information, see <a href=
     * "https://docs.aws.amazon.com/ElasticLoadBalancing/latest/APIReference/API_DeleteLoadBalancerListeners.html"
     * >DeleteLoadBalancerListeners</a> in the <i>Elastic Load Balancing API Reference</i>.
     * </p>
     * </important>
     *
     * @param deleteServerCertificateRequest
     * @return Result of the DeleteServerCertificate operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws DeleteConflictException
     *         The request was rejected because it attempted to delete a resource that has attached subordinate
     *         entities. The error message describes these entities.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteServerCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteServerCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteServerCertificateResponse deleteServerCertificate(DeleteServerCertificateRequest deleteServerCertificateRequest)
            throws NoSuchEntityException, DeleteConflictException, LimitExceededException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified server certificate.
     * </p>
     * <p>
     * For more information about working with server certificates, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with server
     * certificates</a> in the <i>IAM User Guide</i>. This topic also includes a list of AWS services that can use the
     * server certificates that you manage with IAM.
     * </p>
     * <important>
     * <p>
     * If you are using a server certificate with Elastic Load Balancing, deleting the certificate could have
     * implications for your application. If Elastic Load Balancing doesn't detect the deletion of bound certificates,
     * it may continue to use the certificates. This could cause Elastic Load Balancing to stop accepting traffic. We
     * recommend that you remove the reference to the certificate from Elastic Load Balancing before using this command
     * to delete the certificate. For more information, see <a href=
     * "https://docs.aws.amazon.com/ElasticLoadBalancing/latest/APIReference/API_DeleteLoadBalancerListeners.html"
     * >DeleteLoadBalancerListeners</a> in the <i>Elastic Load Balancing API Reference</i>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteServerCertificateRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteServerCertificateRequest#builder()}
     * </p>
     *
     * @param deleteServerCertificateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteServerCertificateRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteServerCertificate operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws DeleteConflictException
     *         The request was rejected because it attempted to delete a resource that has attached subordinate
     *         entities. The error message describes these entities.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteServerCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteServerCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteServerCertificateResponse deleteServerCertificate(
            Consumer<DeleteServerCertificateRequest.Builder> deleteServerCertificateRequest) throws NoSuchEntityException,
            DeleteConflictException, LimitExceededException, ServiceFailureException, AwsServiceException, SdkClientException,
            IamException {
        return deleteServerCertificate(DeleteServerCertificateRequest.builder().applyMutation(deleteServerCertificateRequest)
                .build());
    }

    /**
     * <p>
     * Submits a service-linked role deletion request and returns a <code>DeletionTaskId</code>, which you can use to
     * check the status of the deletion. Before you call this operation, confirm that the role has no active sessions
     * and that any resources used by the role in the linked service are deleted. If you call this operation more than
     * once for the same service-linked role and an earlier deletion task is not complete, then the
     * <code>DeletionTaskId</code> of the earlier request is returned.
     * </p>
     * <p>
     * If you submit a deletion request for a service-linked role whose linked service is still accessing a resource,
     * then the deletion task fails. If it fails, the <a>GetServiceLinkedRoleDeletionStatus</a> operation returns the
     * reason for the failure, usually including the resources that must be deleted. To delete the service-linked role,
     * you must first remove those resources from the linked service and then submit the deletion request again.
     * Resources are specific to the service that is linked to the role. For more information about removing resources
     * from a service, see the <a href="http://docs.aws.amazon.com/">AWS documentation</a> for your service.
     * </p>
     * <p>
     * For more information about service-linked roles, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-linked-role"
     * >Roles terms and concepts: AWS service-linked role</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param deleteServiceLinkedRoleRequest
     * @return Result of the DeleteServiceLinkedRole operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteServiceLinkedRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteServiceLinkedRole" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteServiceLinkedRoleResponse deleteServiceLinkedRole(DeleteServiceLinkedRoleRequest deleteServiceLinkedRoleRequest)
            throws NoSuchEntityException, LimitExceededException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Submits a service-linked role deletion request and returns a <code>DeletionTaskId</code>, which you can use to
     * check the status of the deletion. Before you call this operation, confirm that the role has no active sessions
     * and that any resources used by the role in the linked service are deleted. If you call this operation more than
     * once for the same service-linked role and an earlier deletion task is not complete, then the
     * <code>DeletionTaskId</code> of the earlier request is returned.
     * </p>
     * <p>
     * If you submit a deletion request for a service-linked role whose linked service is still accessing a resource,
     * then the deletion task fails. If it fails, the <a>GetServiceLinkedRoleDeletionStatus</a> operation returns the
     * reason for the failure, usually including the resources that must be deleted. To delete the service-linked role,
     * you must first remove those resources from the linked service and then submit the deletion request again.
     * Resources are specific to the service that is linked to the role. For more information about removing resources
     * from a service, see the <a href="http://docs.aws.amazon.com/">AWS documentation</a> for your service.
     * </p>
     * <p>
     * For more information about service-linked roles, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-linked-role"
     * >Roles terms and concepts: AWS service-linked role</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteServiceLinkedRoleRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteServiceLinkedRoleRequest#builder()}
     * </p>
     *
     * @param deleteServiceLinkedRoleRequest
     *        A {@link Consumer} that will call methods on {@link DeleteServiceLinkedRoleRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteServiceLinkedRole operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteServiceLinkedRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteServiceLinkedRole" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteServiceLinkedRoleResponse deleteServiceLinkedRole(
            Consumer<DeleteServiceLinkedRoleRequest.Builder> deleteServiceLinkedRoleRequest) throws NoSuchEntityException,
            LimitExceededException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return deleteServiceLinkedRole(DeleteServiceLinkedRoleRequest.builder().applyMutation(deleteServiceLinkedRoleRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified service-specific credential.
     * </p>
     *
     * @param deleteServiceSpecificCredentialRequest
     * @return Result of the DeleteServiceSpecificCredential operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteServiceSpecificCredential
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteServiceSpecificCredential"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteServiceSpecificCredentialResponse deleteServiceSpecificCredential(
            DeleteServiceSpecificCredentialRequest deleteServiceSpecificCredentialRequest) throws NoSuchEntityException,
            AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified service-specific credential.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteServiceSpecificCredentialRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteServiceSpecificCredentialRequest#builder()}
     * </p>
     *
     * @param deleteServiceSpecificCredentialRequest
     *        A {@link Consumer} that will call methods on {@link DeleteServiceSpecificCredentialRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteServiceSpecificCredential operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteServiceSpecificCredential
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteServiceSpecificCredential"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteServiceSpecificCredentialResponse deleteServiceSpecificCredential(
            Consumer<DeleteServiceSpecificCredentialRequest.Builder> deleteServiceSpecificCredentialRequest)
            throws NoSuchEntityException, AwsServiceException, SdkClientException, IamException {
        return deleteServiceSpecificCredential(DeleteServiceSpecificCredentialRequest.builder()
                .applyMutation(deleteServiceSpecificCredentialRequest).build());
    }

    /**
     * <p>
     * Deletes a signing certificate associated with the specified IAM user.
     * </p>
     * <p>
     * If you do not specify a user name, IAM determines the user name implicitly based on the AWS access key ID signing
     * the request. This operation works for access keys under the AWS account. Consequently, you can use this operation
     * to manage AWS account root user credentials even if the AWS account has no associated IAM users.
     * </p>
     *
     * @param deleteSigningCertificateRequest
     * @return Result of the DeleteSigningCertificate operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteSigningCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteSigningCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteSigningCertificateResponse deleteSigningCertificate(
            DeleteSigningCertificateRequest deleteSigningCertificateRequest) throws NoSuchEntityException,
            LimitExceededException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a signing certificate associated with the specified IAM user.
     * </p>
     * <p>
     * If you do not specify a user name, IAM determines the user name implicitly based on the AWS access key ID signing
     * the request. This operation works for access keys under the AWS account. Consequently, you can use this operation
     * to manage AWS account root user credentials even if the AWS account has no associated IAM users.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSigningCertificateRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteSigningCertificateRequest#builder()}
     * </p>
     *
     * @param deleteSigningCertificateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSigningCertificateRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteSigningCertificate operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteSigningCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteSigningCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteSigningCertificateResponse deleteSigningCertificate(
            Consumer<DeleteSigningCertificateRequest.Builder> deleteSigningCertificateRequest) throws NoSuchEntityException,
            LimitExceededException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return deleteSigningCertificate(DeleteSigningCertificateRequest.builder().applyMutation(deleteSigningCertificateRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified IAM user. Unlike the AWS Management Console, when you delete a user programmatically, you
     * must delete the items attached to the user manually, or the deletion fails. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_manage.html#id_users_deleting_cli">Deleting an
     * IAM user</a>. Before attempting to delete a user, remove the following items:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Password (<a>DeleteLoginProfile</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Access keys (<a>DeleteAccessKey</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Signing certificate (<a>DeleteSigningCertificate</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * SSH public key (<a>DeleteSSHPublicKey</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Git credentials (<a>DeleteServiceSpecificCredential</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Multi-factor authentication (MFA) device (<a>DeactivateMFADevice</a>, <a>DeleteVirtualMFADevice</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Inline policies (<a>DeleteUserPolicy</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Attached managed policies (<a>DetachUserPolicy</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Group memberships (<a>RemoveUserFromGroup</a>)
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteUserRequest
     * @return Result of the DeleteUser operation returned by the service.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws DeleteConflictException
     *         The request was rejected because it attempted to delete a resource that has attached subordinate
     *         entities. The error message describes these entities.
     * @throws ConcurrentModificationException
     *         The request was rejected because multiple requests to change this object were submitted simultaneously.
     *         Wait a few minutes and submit your request again.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws LimitExceededException,
            NoSuchEntityException, DeleteConflictException, ConcurrentModificationException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified IAM user. Unlike the AWS Management Console, when you delete a user programmatically, you
     * must delete the items attached to the user manually, or the deletion fails. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_manage.html#id_users_deleting_cli">Deleting an
     * IAM user</a>. Before attempting to delete a user, remove the following items:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Password (<a>DeleteLoginProfile</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Access keys (<a>DeleteAccessKey</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Signing certificate (<a>DeleteSigningCertificate</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * SSH public key (<a>DeleteSSHPublicKey</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Git credentials (<a>DeleteServiceSpecificCredential</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Multi-factor authentication (MFA) device (<a>DeactivateMFADevice</a>, <a>DeleteVirtualMFADevice</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Inline policies (<a>DeleteUserPolicy</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Attached managed policies (<a>DetachUserPolicy</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Group memberships (<a>RemoveUserFromGroup</a>)
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUserRequest#builder()}
     * </p>
     *
     * @param deleteUserRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUserRequest.Builder} to create a request.
     * @return Result of the DeleteUser operation returned by the service.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws DeleteConflictException
     *         The request was rejected because it attempted to delete a resource that has attached subordinate
     *         entities. The error message describes these entities.
     * @throws ConcurrentModificationException
     *         The request was rejected because multiple requests to change this object were submitted simultaneously.
     *         Wait a few minutes and submit your request again.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteUserResponse deleteUser(Consumer<DeleteUserRequest.Builder> deleteUserRequest) throws LimitExceededException,
            NoSuchEntityException, DeleteConflictException, ConcurrentModificationException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        return deleteUser(DeleteUserRequest.builder().applyMutation(deleteUserRequest).build());
    }

    /**
     * <p>
     * Deletes the permissions boundary for the specified IAM user.
     * </p>
     * <important>
     * <p>
     * Deleting the permissions boundary for a user might increase its permissions by allowing the user to perform all
     * the actions granted in its permissions policies.
     * </p>
     * </important>
     *
     * @param deleteUserPermissionsBoundaryRequest
     * @return Result of the DeleteUserPermissionsBoundary operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteUserPermissionsBoundary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteUserPermissionsBoundary"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteUserPermissionsBoundaryResponse deleteUserPermissionsBoundary(
            DeleteUserPermissionsBoundaryRequest deleteUserPermissionsBoundaryRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the permissions boundary for the specified IAM user.
     * </p>
     * <important>
     * <p>
     * Deleting the permissions boundary for a user might increase its permissions by allowing the user to perform all
     * the actions granted in its permissions policies.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserPermissionsBoundaryRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteUserPermissionsBoundaryRequest#builder()}
     * </p>
     *
     * @param deleteUserPermissionsBoundaryRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUserPermissionsBoundaryRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteUserPermissionsBoundary operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteUserPermissionsBoundary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteUserPermissionsBoundary"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteUserPermissionsBoundaryResponse deleteUserPermissionsBoundary(
            Consumer<DeleteUserPermissionsBoundaryRequest.Builder> deleteUserPermissionsBoundaryRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return deleteUserPermissionsBoundary(DeleteUserPermissionsBoundaryRequest.builder()
                .applyMutation(deleteUserPermissionsBoundaryRequest).build());
    }

    /**
     * <p>
     * Deletes the specified inline policy that is embedded in the specified IAM user.
     * </p>
     * <p>
     * A user can also have managed policies attached to it. To detach a managed policy from a user, use
     * <a>DetachUserPolicy</a>. For more information about policies, refer to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param deleteUserPolicyRequest
     * @return Result of the DeleteUserPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteUserPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteUserPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteUserPolicyResponse deleteUserPolicy(DeleteUserPolicyRequest deleteUserPolicyRequest)
            throws NoSuchEntityException, LimitExceededException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified inline policy that is embedded in the specified IAM user.
     * </p>
     * <p>
     * A user can also have managed policies attached to it. To detach a managed policy from a user, use
     * <a>DetachUserPolicy</a>. For more information about policies, refer to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteUserPolicyRequest#builder()}
     * </p>
     *
     * @param deleteUserPolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUserPolicyRequest.Builder} to create a request.
     * @return Result of the DeleteUserPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteUserPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteUserPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteUserPolicyResponse deleteUserPolicy(Consumer<DeleteUserPolicyRequest.Builder> deleteUserPolicyRequest)
            throws NoSuchEntityException, LimitExceededException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        return deleteUserPolicy(DeleteUserPolicyRequest.builder().applyMutation(deleteUserPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes a virtual MFA device.
     * </p>
     * <note>
     * <p>
     * You must deactivate a user's virtual MFA device before you can delete it. For information about deactivating MFA
     * devices, see <a>DeactivateMFADevice</a>.
     * </p>
     * </note>
     *
     * @param deleteVirtualMfaDeviceRequest
     * @return Result of the DeleteVirtualMFADevice operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws DeleteConflictException
     *         The request was rejected because it attempted to delete a resource that has attached subordinate
     *         entities. The error message describes these entities.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteVirtualMFADevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteVirtualMFADevice" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteVirtualMfaDeviceResponse deleteVirtualMFADevice(DeleteVirtualMfaDeviceRequest deleteVirtualMfaDeviceRequest)
            throws NoSuchEntityException, DeleteConflictException, LimitExceededException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a virtual MFA device.
     * </p>
     * <note>
     * <p>
     * You must deactivate a user's virtual MFA device before you can delete it. For information about deactivating MFA
     * devices, see <a>DeactivateMFADevice</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVirtualMfaDeviceRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteVirtualMfaDeviceRequest#builder()}
     * </p>
     *
     * @param deleteVirtualMfaDeviceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVirtualMFADeviceRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteVirtualMFADevice operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws DeleteConflictException
     *         The request was rejected because it attempted to delete a resource that has attached subordinate
     *         entities. The error message describes these entities.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteVirtualMFADevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteVirtualMFADevice" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteVirtualMfaDeviceResponse deleteVirtualMFADevice(
            Consumer<DeleteVirtualMfaDeviceRequest.Builder> deleteVirtualMfaDeviceRequest) throws NoSuchEntityException,
            DeleteConflictException, LimitExceededException, ServiceFailureException, AwsServiceException, SdkClientException,
            IamException {
        return deleteVirtualMFADevice(DeleteVirtualMfaDeviceRequest.builder().applyMutation(deleteVirtualMfaDeviceRequest)
                .build());
    }

    /**
     * <p>
     * Removes the specified managed policy from the specified IAM group.
     * </p>
     * <p>
     * A group can also have inline policies embedded with it. To delete an inline policy, use <a>DeleteGroupPolicy</a>.
     * For information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param detachGroupPolicyRequest
     * @return Result of the DetachGroupPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DetachGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DetachGroupPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default DetachGroupPolicyResponse detachGroupPolicy(DetachGroupPolicyRequest detachGroupPolicyRequest)
            throws NoSuchEntityException, LimitExceededException, InvalidInputException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified managed policy from the specified IAM group.
     * </p>
     * <p>
     * A group can also have inline policies embedded with it. To delete an inline policy, use <a>DeleteGroupPolicy</a>.
     * For information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetachGroupPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link DetachGroupPolicyRequest#builder()}
     * </p>
     *
     * @param detachGroupPolicyRequest
     *        A {@link Consumer} that will call methods on {@link DetachGroupPolicyRequest.Builder} to create a request.
     * @return Result of the DetachGroupPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DetachGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DetachGroupPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default DetachGroupPolicyResponse detachGroupPolicy(Consumer<DetachGroupPolicyRequest.Builder> detachGroupPolicyRequest)
            throws NoSuchEntityException, LimitExceededException, InvalidInputException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        return detachGroupPolicy(DetachGroupPolicyRequest.builder().applyMutation(detachGroupPolicyRequest).build());
    }

    /**
     * <p>
     * Removes the specified managed policy from the specified role.
     * </p>
     * <p>
     * A role can also have inline policies embedded with it. To delete an inline policy, use <a>DeleteRolePolicy</a>.
     * For information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param detachRolePolicyRequest
     * @return Result of the DetachRolePolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws UnmodifiableEntityException
     *         The request was rejected because only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DetachRolePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DetachRolePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default DetachRolePolicyResponse detachRolePolicy(DetachRolePolicyRequest detachRolePolicyRequest)
            throws NoSuchEntityException, LimitExceededException, InvalidInputException, UnmodifiableEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified managed policy from the specified role.
     * </p>
     * <p>
     * A role can also have inline policies embedded with it. To delete an inline policy, use <a>DeleteRolePolicy</a>.
     * For information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetachRolePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link DetachRolePolicyRequest#builder()}
     * </p>
     *
     * @param detachRolePolicyRequest
     *        A {@link Consumer} that will call methods on {@link DetachRolePolicyRequest.Builder} to create a request.
     * @return Result of the DetachRolePolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws UnmodifiableEntityException
     *         The request was rejected because only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DetachRolePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DetachRolePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default DetachRolePolicyResponse detachRolePolicy(Consumer<DetachRolePolicyRequest.Builder> detachRolePolicyRequest)
            throws NoSuchEntityException, LimitExceededException, InvalidInputException, UnmodifiableEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return detachRolePolicy(DetachRolePolicyRequest.builder().applyMutation(detachRolePolicyRequest).build());
    }

    /**
     * <p>
     * Removes the specified managed policy from the specified user.
     * </p>
     * <p>
     * A user can also have inline policies embedded with it. To delete an inline policy, use <a>DeleteUserPolicy</a>.
     * For information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param detachUserPolicyRequest
     * @return Result of the DetachUserPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DetachUserPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DetachUserPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default DetachUserPolicyResponse detachUserPolicy(DetachUserPolicyRequest detachUserPolicyRequest)
            throws NoSuchEntityException, LimitExceededException, InvalidInputException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified managed policy from the specified user.
     * </p>
     * <p>
     * A user can also have inline policies embedded with it. To delete an inline policy, use <a>DeleteUserPolicy</a>.
     * For information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetachUserPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link DetachUserPolicyRequest#builder()}
     * </p>
     *
     * @param detachUserPolicyRequest
     *        A {@link Consumer} that will call methods on {@link DetachUserPolicyRequest.Builder} to create a request.
     * @return Result of the DetachUserPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DetachUserPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DetachUserPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default DetachUserPolicyResponse detachUserPolicy(Consumer<DetachUserPolicyRequest.Builder> detachUserPolicyRequest)
            throws NoSuchEntityException, LimitExceededException, InvalidInputException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        return detachUserPolicy(DetachUserPolicyRequest.builder().applyMutation(detachUserPolicyRequest).build());
    }

    /**
     * <p>
     * Enables the specified MFA device and associates it with the specified IAM user. When enabled, the MFA device is
     * required for every subsequent login by the IAM user associated with the device.
     * </p>
     *
     * @param enableMfaDeviceRequest
     * @return Result of the EnableMFADevice operation returned by the service.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws EntityTemporarilyUnmodifiableException
     *         The request was rejected because it referenced an entity that is temporarily unmodifiable, such as a user
     *         name that was deleted and then recreated. The error indicates that the request is likely to succeed if
     *         you try again after waiting several minutes. The error message describes the entity.
     * @throws InvalidAuthenticationCodeException
     *         The request was rejected because the authentication code was not recognized. The error message describes
     *         the specific error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.EnableMFADevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/EnableMFADevice" target="_top">AWS API
     *      Documentation</a>
     */
    default EnableMfaDeviceResponse enableMFADevice(EnableMfaDeviceRequest enableMfaDeviceRequest)
            throws EntityAlreadyExistsException, EntityTemporarilyUnmodifiableException, InvalidAuthenticationCodeException,
            LimitExceededException, NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException,
            IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the specified MFA device and associates it with the specified IAM user. When enabled, the MFA device is
     * required for every subsequent login by the IAM user associated with the device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableMfaDeviceRequest.Builder} avoiding the need
     * to create one manually via {@link EnableMfaDeviceRequest#builder()}
     * </p>
     *
     * @param enableMfaDeviceRequest
     *        A {@link Consumer} that will call methods on {@link EnableMFADeviceRequest.Builder} to create a request.
     * @return Result of the EnableMFADevice operation returned by the service.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws EntityTemporarilyUnmodifiableException
     *         The request was rejected because it referenced an entity that is temporarily unmodifiable, such as a user
     *         name that was deleted and then recreated. The error indicates that the request is likely to succeed if
     *         you try again after waiting several minutes. The error message describes the entity.
     * @throws InvalidAuthenticationCodeException
     *         The request was rejected because the authentication code was not recognized. The error message describes
     *         the specific error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.EnableMFADevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/EnableMFADevice" target="_top">AWS API
     *      Documentation</a>
     */
    default EnableMfaDeviceResponse enableMFADevice(Consumer<EnableMfaDeviceRequest.Builder> enableMfaDeviceRequest)
            throws EntityAlreadyExistsException, EntityTemporarilyUnmodifiableException, InvalidAuthenticationCodeException,
            LimitExceededException, NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException,
            IamException {
        return enableMFADevice(EnableMfaDeviceRequest.builder().applyMutation(enableMfaDeviceRequest).build());
    }

    /**
     * <p>
     * Generates a credential report for the AWS account. For more information about the credential report, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Getting credential reports</a> in
     * the <i>IAM User Guide</i>.
     * </p>
     *
     * @return Result of the GenerateCredentialReport operation returned by the service.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GenerateCredentialReport
     * @see #generateCredentialReport(GenerateCredentialReportRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GenerateCredentialReport" target="_top">AWS
     *      API Documentation</a>
     */
    default GenerateCredentialReportResponse generateCredentialReport() throws LimitExceededException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        return generateCredentialReport(GenerateCredentialReportRequest.builder().build());
    }

    /**
     * <p>
     * Generates a credential report for the AWS account. For more information about the credential report, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Getting credential reports</a> in
     * the <i>IAM User Guide</i>.
     * </p>
     *
     * @param generateCredentialReportRequest
     * @return Result of the GenerateCredentialReport operation returned by the service.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GenerateCredentialReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GenerateCredentialReport" target="_top">AWS
     *      API Documentation</a>
     */
    default GenerateCredentialReportResponse generateCredentialReport(
            GenerateCredentialReportRequest generateCredentialReportRequest) throws LimitExceededException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates a credential report for the AWS account. For more information about the credential report, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Getting credential reports</a> in
     * the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GenerateCredentialReportRequest.Builder} avoiding
     * the need to create one manually via {@link GenerateCredentialReportRequest#builder()}
     * </p>
     *
     * @param generateCredentialReportRequest
     *        A {@link Consumer} that will call methods on {@link GenerateCredentialReportRequest.Builder} to create a
     *        request.
     * @return Result of the GenerateCredentialReport operation returned by the service.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GenerateCredentialReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GenerateCredentialReport" target="_top">AWS
     *      API Documentation</a>
     */
    default GenerateCredentialReportResponse generateCredentialReport(
            Consumer<GenerateCredentialReportRequest.Builder> generateCredentialReportRequest) throws LimitExceededException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return generateCredentialReport(GenerateCredentialReportRequest.builder().applyMutation(generateCredentialReportRequest)
                .build());
    }

    /**
     * <p>
     * Generates a report for service last accessed data for AWS Organizations. You can generate a report for any
     * entities (organization root, organizational unit, or account) or policies in your organization.
     * </p>
     * <p>
     * To call this operation, you must be signed in using your AWS Organizations management account credentials. You
     * can use your long-term IAM user or root user credentials, or temporary credentials from assuming an IAM role.
     * SCPs must be enabled for your organization root. You must have the required IAM and AWS Organizations
     * permissions. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Refining permissions
     * using service last accessed data</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can generate a service last accessed data report for entities by specifying only the entity's path. This data
     * includes a list of services that are allowed by any service control policies (SCPs) that apply to the entity.
     * </p>
     * <p>
     * You can generate a service last accessed data report for a policy by specifying an entity's path and an optional
     * AWS Organizations policy ID. This data includes a list of services that are allowed by the specified SCP.
     * </p>
     * <p>
     * For each service in both report types, the data includes the most recent account activity that the policy allows
     * to account principals in the entity or the entity's children. For important information about the data, reporting
     * period, permissions required, troubleshooting, and supported Regions see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Reducing permissions
     * using service last accessed data</a> in the <i>IAM User Guide</i>.
     * </p>
     * <important>
     * <p>
     * The data includes all attempts to access AWS, not just the successful ones. This includes all attempts that were
     * made using the AWS Management Console, the AWS API through any of the SDKs, or any of the command line tools. An
     * unexpected entry in the service last accessed data does not mean that an account has been compromised, because
     * the request might have been denied. Refer to your CloudTrail logs as the authoritative source for information
     * about all API calls and whether they were successful or denied access. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/cloudtrail-integration.html">Logging IAM events with
     * CloudTrail</a> in the <i>IAM User Guide</i>.
     * </p>
     * </important>
     * <p>
     * This operation returns a <code>JobId</code>. Use this parameter in the
     * <code> <a>GetOrganizationsAccessReport</a> </code> operation to check the status of the report generation. To
     * check the status of this request, use the <code>JobId</code> parameter in the
     * <code> <a>GetOrganizationsAccessReport</a> </code> operation and test the <code>JobStatus</code> response
     * parameter. When the job is complete, you can retrieve the report.
     * </p>
     * <p>
     * To generate a service last accessed data report for entities, specify an entity path without specifying the
     * optional AWS Organizations policy ID. The type of entity that you specify determines the data returned in the
     * report.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Root</b> – When you specify the organizations root as the entity, the resulting report lists all of the
     * services allowed by SCPs that are attached to your root. For each service, the report includes data for all
     * accounts in your organization except the management account, because the management account is not limited by
     * SCPs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>OU</b> – When you specify an organizational unit (OU) as the entity, the resulting report lists all of the
     * services allowed by SCPs that are attached to the OU and its parents. For each service, the report includes data
     * for all accounts in the OU or its children. This data excludes the management account, because the management
     * account is not limited by SCPs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>management account</b> – When you specify the management account, the resulting report lists all AWS services,
     * because the management account is not limited by SCPs. For each service, the report includes data for only the
     * management account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Account</b> – When you specify another account as the entity, the resulting report lists all of the services
     * allowed by SCPs that are attached to the account and its parents. For each service, the report includes data for
     * only the specified account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To generate a service last accessed data report for policies, specify an entity path and the optional AWS
     * Organizations policy ID. The type of entity that you specify determines the data returned for each service.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Root</b> – When you specify the root entity and a policy ID, the resulting report lists all of the services
     * that are allowed by the specified SCP. For each service, the report includes data for all accounts in your
     * organization to which the SCP applies. This data excludes the management account, because the management account
     * is not limited by SCPs. If the SCP is not attached to any entities in the organization, then the report will
     * return a list of services with no data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>OU</b> – When you specify an OU entity and a policy ID, the resulting report lists all of the services that
     * are allowed by the specified SCP. For each service, the report includes data for all accounts in the OU or its
     * children to which the SCP applies. This means that other accounts outside the OU that are affected by the SCP
     * might not be included in the data. This data excludes the management account, because the management account is
     * not limited by SCPs. If the SCP is not attached to the OU or one of its children, the report will return a list
     * of services with no data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>management account</b> – When you specify the management account, the resulting report lists all AWS services,
     * because the management account is not limited by SCPs. If you specify a policy ID in the CLI or API, the policy
     * is ignored. For each service, the report includes data for only the management account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Account</b> – When you specify another account entity and a policy ID, the resulting report lists all of the
     * services that are allowed by the specified SCP. For each service, the report includes data for only the specified
     * account. This means that other accounts in the organization that are affected by the SCP might not be included in
     * the data. If the SCP is not attached to the account, the report will return a list of services with no data.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Service last accessed data does not use other policy types when determining whether a principal could access a
     * service. These other policy types include identity-based policies, resource-based policies, access control lists,
     * IAM permissions boundaries, and STS assume role policies. It only applies SCP logic. For more about the
     * evaluation of policy types, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics"
     * >Evaluating policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * </note>
     * <p>
     * For more information about service last accessed data, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Reducing policy scope
     * by viewing user activity</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param generateOrganizationsAccessReportRequest
     * @return Result of the GenerateOrganizationsAccessReport operation returned by the service.
     * @throws ReportGenerationLimitExceededException
     *         The request failed because the maximum number of concurrent requests for this account are already
     *         running.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GenerateOrganizationsAccessReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GenerateOrganizationsAccessReport"
     *      target="_top">AWS API Documentation</a>
     */
    default GenerateOrganizationsAccessReportResponse generateOrganizationsAccessReport(
            GenerateOrganizationsAccessReportRequest generateOrganizationsAccessReportRequest)
            throws ReportGenerationLimitExceededException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates a report for service last accessed data for AWS Organizations. You can generate a report for any
     * entities (organization root, organizational unit, or account) or policies in your organization.
     * </p>
     * <p>
     * To call this operation, you must be signed in using your AWS Organizations management account credentials. You
     * can use your long-term IAM user or root user credentials, or temporary credentials from assuming an IAM role.
     * SCPs must be enabled for your organization root. You must have the required IAM and AWS Organizations
     * permissions. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Refining permissions
     * using service last accessed data</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can generate a service last accessed data report for entities by specifying only the entity's path. This data
     * includes a list of services that are allowed by any service control policies (SCPs) that apply to the entity.
     * </p>
     * <p>
     * You can generate a service last accessed data report for a policy by specifying an entity's path and an optional
     * AWS Organizations policy ID. This data includes a list of services that are allowed by the specified SCP.
     * </p>
     * <p>
     * For each service in both report types, the data includes the most recent account activity that the policy allows
     * to account principals in the entity or the entity's children. For important information about the data, reporting
     * period, permissions required, troubleshooting, and supported Regions see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Reducing permissions
     * using service last accessed data</a> in the <i>IAM User Guide</i>.
     * </p>
     * <important>
     * <p>
     * The data includes all attempts to access AWS, not just the successful ones. This includes all attempts that were
     * made using the AWS Management Console, the AWS API through any of the SDKs, or any of the command line tools. An
     * unexpected entry in the service last accessed data does not mean that an account has been compromised, because
     * the request might have been denied. Refer to your CloudTrail logs as the authoritative source for information
     * about all API calls and whether they were successful or denied access. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/cloudtrail-integration.html">Logging IAM events with
     * CloudTrail</a> in the <i>IAM User Guide</i>.
     * </p>
     * </important>
     * <p>
     * This operation returns a <code>JobId</code>. Use this parameter in the
     * <code> <a>GetOrganizationsAccessReport</a> </code> operation to check the status of the report generation. To
     * check the status of this request, use the <code>JobId</code> parameter in the
     * <code> <a>GetOrganizationsAccessReport</a> </code> operation and test the <code>JobStatus</code> response
     * parameter. When the job is complete, you can retrieve the report.
     * </p>
     * <p>
     * To generate a service last accessed data report for entities, specify an entity path without specifying the
     * optional AWS Organizations policy ID. The type of entity that you specify determines the data returned in the
     * report.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Root</b> – When you specify the organizations root as the entity, the resulting report lists all of the
     * services allowed by SCPs that are attached to your root. For each service, the report includes data for all
     * accounts in your organization except the management account, because the management account is not limited by
     * SCPs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>OU</b> – When you specify an organizational unit (OU) as the entity, the resulting report lists all of the
     * services allowed by SCPs that are attached to the OU and its parents. For each service, the report includes data
     * for all accounts in the OU or its children. This data excludes the management account, because the management
     * account is not limited by SCPs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>management account</b> – When you specify the management account, the resulting report lists all AWS services,
     * because the management account is not limited by SCPs. For each service, the report includes data for only the
     * management account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Account</b> – When you specify another account as the entity, the resulting report lists all of the services
     * allowed by SCPs that are attached to the account and its parents. For each service, the report includes data for
     * only the specified account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To generate a service last accessed data report for policies, specify an entity path and the optional AWS
     * Organizations policy ID. The type of entity that you specify determines the data returned for each service.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Root</b> – When you specify the root entity and a policy ID, the resulting report lists all of the services
     * that are allowed by the specified SCP. For each service, the report includes data for all accounts in your
     * organization to which the SCP applies. This data excludes the management account, because the management account
     * is not limited by SCPs. If the SCP is not attached to any entities in the organization, then the report will
     * return a list of services with no data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>OU</b> – When you specify an OU entity and a policy ID, the resulting report lists all of the services that
     * are allowed by the specified SCP. For each service, the report includes data for all accounts in the OU or its
     * children to which the SCP applies. This means that other accounts outside the OU that are affected by the SCP
     * might not be included in the data. This data excludes the management account, because the management account is
     * not limited by SCPs. If the SCP is not attached to the OU or one of its children, the report will return a list
     * of services with no data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>management account</b> – When you specify the management account, the resulting report lists all AWS services,
     * because the management account is not limited by SCPs. If you specify a policy ID in the CLI or API, the policy
     * is ignored. For each service, the report includes data for only the management account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Account</b> – When you specify another account entity and a policy ID, the resulting report lists all of the
     * services that are allowed by the specified SCP. For each service, the report includes data for only the specified
     * account. This means that other accounts in the organization that are affected by the SCP might not be included in
     * the data. If the SCP is not attached to the account, the report will return a list of services with no data.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Service last accessed data does not use other policy types when determining whether a principal could access a
     * service. These other policy types include identity-based policies, resource-based policies, access control lists,
     * IAM permissions boundaries, and STS assume role policies. It only applies SCP logic. For more about the
     * evaluation of policy types, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics"
     * >Evaluating policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * </note>
     * <p>
     * For more information about service last accessed data, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Reducing policy scope
     * by viewing user activity</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GenerateOrganizationsAccessReportRequest.Builder}
     * avoiding the need to create one manually via {@link GenerateOrganizationsAccessReportRequest#builder()}
     * </p>
     *
     * @param generateOrganizationsAccessReportRequest
     *        A {@link Consumer} that will call methods on {@link GenerateOrganizationsAccessReportRequest.Builder} to
     *        create a request.
     * @return Result of the GenerateOrganizationsAccessReport operation returned by the service.
     * @throws ReportGenerationLimitExceededException
     *         The request failed because the maximum number of concurrent requests for this account are already
     *         running.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GenerateOrganizationsAccessReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GenerateOrganizationsAccessReport"
     *      target="_top">AWS API Documentation</a>
     */
    default GenerateOrganizationsAccessReportResponse generateOrganizationsAccessReport(
            Consumer<GenerateOrganizationsAccessReportRequest.Builder> generateOrganizationsAccessReportRequest)
            throws ReportGenerationLimitExceededException, AwsServiceException, SdkClientException, IamException {
        return generateOrganizationsAccessReport(GenerateOrganizationsAccessReportRequest.builder()
                .applyMutation(generateOrganizationsAccessReportRequest).build());
    }

    /**
     * <p>
     * Generates a report that includes details about when an IAM resource (user, group, role, or policy) was last used
     * in an attempt to access AWS services. Recent activity usually appears within four hours. IAM reports activity for
     * the last 365 days, or less if your Region began supporting this feature within the last year. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period"
     * >Regions where data is tracked</a>.
     * </p>
     * <important>
     * <p>
     * The service last accessed data includes all attempts to access an AWS API, not just the successful ones. This
     * includes all attempts that were made using the AWS Management Console, the AWS API through any of the SDKs, or
     * any of the command line tools. An unexpected entry in the service last accessed data does not mean that your
     * account has been compromised, because the request might have been denied. Refer to your CloudTrail logs as the
     * authoritative source for information about all API calls and whether they were successful or denied access. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/cloudtrail-integration.html">Logging IAM events with
     * CloudTrail</a> in the <i>IAM User Guide</i>.
     * </p>
     * </important>
     * <p>
     * The <code>GenerateServiceLastAccessedDetails</code> operation returns a <code>JobId</code>. Use this parameter in
     * the following operations to retrieve the following details from your report:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>GetServiceLastAccessedDetails</a> – Use this operation for users, groups, roles, or policies to list every AWS
     * service that the resource could access using permissions policies. For each service, the response includes
     * information about the most recent access attempt.
     * </p>
     * <p>
     * The <code>JobId</code> returned by <code>GenerateServiceLastAccessedDetail</code> must be used by the same role
     * within a session, or by the same user when used to call <code>GetServiceLastAccessedDetail</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>GetServiceLastAccessedDetailsWithEntities</a> – Use this operation for groups and policies to list information
     * about the associated entities (users or roles) that attempted to access a specific AWS service.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To check the status of the <code>GenerateServiceLastAccessedDetails</code> request, use the <code>JobId</code>
     * parameter in the same operations and test the <code>JobStatus</code> response parameter.
     * </p>
     * <p>
     * For additional information about the permissions policies that allow an identity (user, group, or role) to access
     * specific services, use the <a>ListPoliciesGrantingServiceAccess</a> operation.
     * </p>
     * <note>
     * <p>
     * Service last accessed data does not use other policy types when determining whether a resource could access a
     * service. These other policy types include resource-based policies, access control lists, AWS Organizations
     * policies, IAM permissions boundaries, and AWS STS assume role policies. It only applies permissions policy logic.
     * For more about the evaluation of policy types, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics"
     * >Evaluating policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * </note>
     * <p>
     * For more information about service and action last accessed data, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Reducing permissions
     * using service last accessed data</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param generateServiceLastAccessedDetailsRequest
     * @return Result of the GenerateServiceLastAccessedDetails operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GenerateServiceLastAccessedDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GenerateServiceLastAccessedDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GenerateServiceLastAccessedDetailsResponse generateServiceLastAccessedDetails(
            GenerateServiceLastAccessedDetailsRequest generateServiceLastAccessedDetailsRequest) throws NoSuchEntityException,
            InvalidInputException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates a report that includes details about when an IAM resource (user, group, role, or policy) was last used
     * in an attempt to access AWS services. Recent activity usually appears within four hours. IAM reports activity for
     * the last 365 days, or less if your Region began supporting this feature within the last year. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period"
     * >Regions where data is tracked</a>.
     * </p>
     * <important>
     * <p>
     * The service last accessed data includes all attempts to access an AWS API, not just the successful ones. This
     * includes all attempts that were made using the AWS Management Console, the AWS API through any of the SDKs, or
     * any of the command line tools. An unexpected entry in the service last accessed data does not mean that your
     * account has been compromised, because the request might have been denied. Refer to your CloudTrail logs as the
     * authoritative source for information about all API calls and whether they were successful or denied access. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/cloudtrail-integration.html">Logging IAM events with
     * CloudTrail</a> in the <i>IAM User Guide</i>.
     * </p>
     * </important>
     * <p>
     * The <code>GenerateServiceLastAccessedDetails</code> operation returns a <code>JobId</code>. Use this parameter in
     * the following operations to retrieve the following details from your report:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>GetServiceLastAccessedDetails</a> – Use this operation for users, groups, roles, or policies to list every AWS
     * service that the resource could access using permissions policies. For each service, the response includes
     * information about the most recent access attempt.
     * </p>
     * <p>
     * The <code>JobId</code> returned by <code>GenerateServiceLastAccessedDetail</code> must be used by the same role
     * within a session, or by the same user when used to call <code>GetServiceLastAccessedDetail</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>GetServiceLastAccessedDetailsWithEntities</a> – Use this operation for groups and policies to list information
     * about the associated entities (users or roles) that attempted to access a specific AWS service.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To check the status of the <code>GenerateServiceLastAccessedDetails</code> request, use the <code>JobId</code>
     * parameter in the same operations and test the <code>JobStatus</code> response parameter.
     * </p>
     * <p>
     * For additional information about the permissions policies that allow an identity (user, group, or role) to access
     * specific services, use the <a>ListPoliciesGrantingServiceAccess</a> operation.
     * </p>
     * <note>
     * <p>
     * Service last accessed data does not use other policy types when determining whether a resource could access a
     * service. These other policy types include resource-based policies, access control lists, AWS Organizations
     * policies, IAM permissions boundaries, and AWS STS assume role policies. It only applies permissions policy logic.
     * For more about the evaluation of policy types, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics"
     * >Evaluating policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * </note>
     * <p>
     * For more information about service and action last accessed data, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Reducing permissions
     * using service last accessed data</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GenerateServiceLastAccessedDetailsRequest.Builder}
     * avoiding the need to create one manually via {@link GenerateServiceLastAccessedDetailsRequest#builder()}
     * </p>
     *
     * @param generateServiceLastAccessedDetailsRequest
     *        A {@link Consumer} that will call methods on {@link GenerateServiceLastAccessedDetailsRequest.Builder} to
     *        create a request.
     * @return Result of the GenerateServiceLastAccessedDetails operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GenerateServiceLastAccessedDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GenerateServiceLastAccessedDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GenerateServiceLastAccessedDetailsResponse generateServiceLastAccessedDetails(
            Consumer<GenerateServiceLastAccessedDetailsRequest.Builder> generateServiceLastAccessedDetailsRequest)
            throws NoSuchEntityException, InvalidInputException, AwsServiceException, SdkClientException, IamException {
        return generateServiceLastAccessedDetails(GenerateServiceLastAccessedDetailsRequest.builder()
                .applyMutation(generateServiceLastAccessedDetailsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about when the specified access key was last used. The information includes the date and
     * time of last use, along with the AWS service and Region that were specified in the last request made with that
     * key.
     * </p>
     *
     * @param getAccessKeyLastUsedRequest
     * @return Result of the GetAccessKeyLastUsed operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetAccessKeyLastUsed
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccessKeyLastUsed" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAccessKeyLastUsedResponse getAccessKeyLastUsed(GetAccessKeyLastUsedRequest getAccessKeyLastUsedRequest)
            throws NoSuchEntityException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about when the specified access key was last used. The information includes the date and
     * time of last use, along with the AWS service and Region that were specified in the last request made with that
     * key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccessKeyLastUsedRequest.Builder} avoiding the
     * need to create one manually via {@link GetAccessKeyLastUsedRequest#builder()}
     * </p>
     *
     * @param getAccessKeyLastUsedRequest
     *        A {@link Consumer} that will call methods on {@link GetAccessKeyLastUsedRequest.Builder} to create a
     *        request.
     * @return Result of the GetAccessKeyLastUsed operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetAccessKeyLastUsed
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccessKeyLastUsed" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAccessKeyLastUsedResponse getAccessKeyLastUsed(
            Consumer<GetAccessKeyLastUsedRequest.Builder> getAccessKeyLastUsedRequest) throws NoSuchEntityException,
            AwsServiceException, SdkClientException, IamException {
        return getAccessKeyLastUsed(GetAccessKeyLastUsedRequest.builder().applyMutation(getAccessKeyLastUsedRequest).build());
    }

    /**
     * <p>
     * Retrieves information about all IAM users, groups, roles, and policies in your AWS account, including their
     * relationships to one another. Use this operation to obtain a snapshot of the configuration of IAM permissions
     * (users, groups, roles, and policies) in your account.
     * </p>
     * <note>
     * <p>
     * Policies returned by this operation are URL-encoded compliant with <a
     * href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy
     * back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the
     * <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar
     * functionality.
     * </p>
     * </note>
     * <p>
     * You can optionally filter the results using the <code>Filter</code> parameter. You can paginate the results using
     * the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @return Result of the GetAccountAuthorizationDetails operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetAccountAuthorizationDetails
     * @see #getAccountAuthorizationDetails(GetAccountAuthorizationDetailsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountAuthorizationDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAccountAuthorizationDetailsResponse getAccountAuthorizationDetails() throws ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        return getAccountAuthorizationDetails(GetAccountAuthorizationDetailsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves information about all IAM users, groups, roles, and policies in your AWS account, including their
     * relationships to one another. Use this operation to obtain a snapshot of the configuration of IAM permissions
     * (users, groups, roles, and policies) in your account.
     * </p>
     * <note>
     * <p>
     * Policies returned by this operation are URL-encoded compliant with <a
     * href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy
     * back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the
     * <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar
     * functionality.
     * </p>
     * </note>
     * <p>
     * You can optionally filter the results using the <code>Filter</code> parameter. You can paginate the results using
     * the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param getAccountAuthorizationDetailsRequest
     * @return Result of the GetAccountAuthorizationDetails operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetAccountAuthorizationDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountAuthorizationDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAccountAuthorizationDetailsResponse getAccountAuthorizationDetails(
            GetAccountAuthorizationDetailsRequest getAccountAuthorizationDetailsRequest) throws ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about all IAM users, groups, roles, and policies in your AWS account, including their
     * relationships to one another. Use this operation to obtain a snapshot of the configuration of IAM permissions
     * (users, groups, roles, and policies) in your account.
     * </p>
     * <note>
     * <p>
     * Policies returned by this operation are URL-encoded compliant with <a
     * href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy
     * back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the
     * <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar
     * functionality.
     * </p>
     * </note>
     * <p>
     * You can optionally filter the results using the <code>Filter</code> parameter. You can paginate the results using
     * the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountAuthorizationDetailsRequest.Builder}
     * avoiding the need to create one manually via {@link GetAccountAuthorizationDetailsRequest#builder()}
     * </p>
     *
     * @param getAccountAuthorizationDetailsRequest
     *        A {@link Consumer} that will call methods on {@link GetAccountAuthorizationDetailsRequest.Builder} to
     *        create a request.
     * @return Result of the GetAccountAuthorizationDetails operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetAccountAuthorizationDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountAuthorizationDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAccountAuthorizationDetailsResponse getAccountAuthorizationDetails(
            Consumer<GetAccountAuthorizationDetailsRequest.Builder> getAccountAuthorizationDetailsRequest)
            throws ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return getAccountAuthorizationDetails(GetAccountAuthorizationDetailsRequest.builder()
                .applyMutation(getAccountAuthorizationDetailsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about all IAM users, groups, roles, and policies in your AWS account, including their
     * relationships to one another. Use this operation to obtain a snapshot of the configuration of IAM permissions
     * (users, groups, roles, and policies) in your account.
     * </p>
     * <note>
     * <p>
     * Policies returned by this operation are URL-encoded compliant with <a
     * href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy
     * back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the
     * <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar
     * functionality.
     * </p>
     * </note>
     * <p>
     * You can optionally filter the results using the <code>Filter</code> parameter. You can paginate the results using
     * the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getAccountAuthorizationDetails(software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.GetAccountAuthorizationDetailsIterable responses = client.getAccountAuthorizationDetailsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.GetAccountAuthorizationDetailsIterable responses = client
     *             .getAccountAuthorizationDetailsPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.GetAccountAuthorizationDetailsIterable responses = client.getAccountAuthorizationDetailsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAccountAuthorizationDetails(software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetAccountAuthorizationDetails
     * @see #getAccountAuthorizationDetailsPaginator(GetAccountAuthorizationDetailsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountAuthorizationDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAccountAuthorizationDetailsIterable getAccountAuthorizationDetailsPaginator() throws ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        return getAccountAuthorizationDetailsPaginator(GetAccountAuthorizationDetailsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves information about all IAM users, groups, roles, and policies in your AWS account, including their
     * relationships to one another. Use this operation to obtain a snapshot of the configuration of IAM permissions
     * (users, groups, roles, and policies) in your account.
     * </p>
     * <note>
     * <p>
     * Policies returned by this operation are URL-encoded compliant with <a
     * href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy
     * back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the
     * <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar
     * functionality.
     * </p>
     * </note>
     * <p>
     * You can optionally filter the results using the <code>Filter</code> parameter. You can paginate the results using
     * the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getAccountAuthorizationDetails(software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.GetAccountAuthorizationDetailsIterable responses = client.getAccountAuthorizationDetailsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.GetAccountAuthorizationDetailsIterable responses = client
     *             .getAccountAuthorizationDetailsPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.GetAccountAuthorizationDetailsIterable responses = client.getAccountAuthorizationDetailsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAccountAuthorizationDetails(software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getAccountAuthorizationDetailsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetAccountAuthorizationDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountAuthorizationDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAccountAuthorizationDetailsIterable getAccountAuthorizationDetailsPaginator(
            GetAccountAuthorizationDetailsRequest getAccountAuthorizationDetailsRequest) throws ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about all IAM users, groups, roles, and policies in your AWS account, including their
     * relationships to one another. Use this operation to obtain a snapshot of the configuration of IAM permissions
     * (users, groups, roles, and policies) in your account.
     * </p>
     * <note>
     * <p>
     * Policies returned by this operation are URL-encoded compliant with <a
     * href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy
     * back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the
     * <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar
     * functionality.
     * </p>
     * </note>
     * <p>
     * You can optionally filter the results using the <code>Filter</code> parameter. You can paginate the results using
     * the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getAccountAuthorizationDetails(software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.GetAccountAuthorizationDetailsIterable responses = client.getAccountAuthorizationDetailsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.GetAccountAuthorizationDetailsIterable responses = client
     *             .getAccountAuthorizationDetailsPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.GetAccountAuthorizationDetailsIterable responses = client.getAccountAuthorizationDetailsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAccountAuthorizationDetails(software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountAuthorizationDetailsRequest.Builder}
     * avoiding the need to create one manually via {@link GetAccountAuthorizationDetailsRequest#builder()}
     * </p>
     *
     * @param getAccountAuthorizationDetailsRequest
     *        A {@link Consumer} that will call methods on {@link GetAccountAuthorizationDetailsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetAccountAuthorizationDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountAuthorizationDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAccountAuthorizationDetailsIterable getAccountAuthorizationDetailsPaginator(
            Consumer<GetAccountAuthorizationDetailsRequest.Builder> getAccountAuthorizationDetailsRequest)
            throws ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return getAccountAuthorizationDetailsPaginator(GetAccountAuthorizationDetailsRequest.builder()
                .applyMutation(getAccountAuthorizationDetailsRequest).build());
    }

    /**
     * <p>
     * Retrieves the password policy for the AWS account. This tells you the complexity requirements and mandatory
     * rotation periods for the IAM user passwords in your account. For more information about using a password policy,
     * see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingPasswordPolicies.html">Managing an
     * IAM password policy</a>.
     * </p>
     *
     * @return Result of the GetAccountPasswordPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetAccountPasswordPolicy
     * @see #getAccountPasswordPolicy(GetAccountPasswordPolicyRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountPasswordPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAccountPasswordPolicyResponse getAccountPasswordPolicy() throws NoSuchEntityException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        return getAccountPasswordPolicy(GetAccountPasswordPolicyRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves the password policy for the AWS account. This tells you the complexity requirements and mandatory
     * rotation periods for the IAM user passwords in your account. For more information about using a password policy,
     * see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingPasswordPolicies.html">Managing an
     * IAM password policy</a>.
     * </p>
     *
     * @param getAccountPasswordPolicyRequest
     * @return Result of the GetAccountPasswordPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetAccountPasswordPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountPasswordPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAccountPasswordPolicyResponse getAccountPasswordPolicy(
            GetAccountPasswordPolicyRequest getAccountPasswordPolicyRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the password policy for the AWS account. This tells you the complexity requirements and mandatory
     * rotation periods for the IAM user passwords in your account. For more information about using a password policy,
     * see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingPasswordPolicies.html">Managing an
     * IAM password policy</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountPasswordPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link GetAccountPasswordPolicyRequest#builder()}
     * </p>
     *
     * @param getAccountPasswordPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetAccountPasswordPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the GetAccountPasswordPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetAccountPasswordPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountPasswordPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAccountPasswordPolicyResponse getAccountPasswordPolicy(
            Consumer<GetAccountPasswordPolicyRequest.Builder> getAccountPasswordPolicyRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return getAccountPasswordPolicy(GetAccountPasswordPolicyRequest.builder().applyMutation(getAccountPasswordPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about IAM entity usage and IAM quotas in the AWS account.
     * </p>
     * <p>
     * For information about IAM quotas, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     *
     * @return Result of the GetAccountSummary operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetAccountSummary
     * @see #getAccountSummary(GetAccountSummaryRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountSummary" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAccountSummaryResponse getAccountSummary() throws ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        return getAccountSummary(GetAccountSummaryRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves information about IAM entity usage and IAM quotas in the AWS account.
     * </p>
     * <p>
     * For information about IAM quotas, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     *
     * @param getAccountSummaryRequest
     * @return Result of the GetAccountSummary operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetAccountSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountSummary" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAccountSummaryResponse getAccountSummary(GetAccountSummaryRequest getAccountSummaryRequest)
            throws ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about IAM entity usage and IAM quotas in the AWS account.
     * </p>
     * <p>
     * For information about IAM quotas, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountSummaryRequest.Builder} avoiding the need
     * to create one manually via {@link GetAccountSummaryRequest#builder()}
     * </p>
     *
     * @param getAccountSummaryRequest
     *        A {@link Consumer} that will call methods on {@link GetAccountSummaryRequest.Builder} to create a request.
     * @return Result of the GetAccountSummary operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetAccountSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountSummary" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAccountSummaryResponse getAccountSummary(Consumer<GetAccountSummaryRequest.Builder> getAccountSummaryRequest)
            throws ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return getAccountSummary(GetAccountSummaryRequest.builder().applyMutation(getAccountSummaryRequest).build());
    }

    /**
     * <p>
     * Gets a list of all of the context keys referenced in the input policies. The policies are supplied as a list of
     * one or more strings. To get the context keys from policies associated with an IAM user, group, or role, use
     * <a>GetContextKeysForPrincipalPolicy</a>.
     * </p>
     * <p>
     * Context keys are variables maintained by AWS and its services that provide details about the context of an API
     * query request. Context keys can be evaluated by testing against a value specified in an IAM policy. Use
     * <code>GetContextKeysForCustomPolicy</code> to understand what key names and values you must supply when you call
     * <a>SimulateCustomPolicy</a>. Note that all parameters are shown in unencoded form here for clarity but must be
     * URL encoded to be included as a part of a real HTML request.
     * </p>
     *
     * @param getContextKeysForCustomPolicyRequest
     * @return Result of the GetContextKeysForCustomPolicy operation returned by the service.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetContextKeysForCustomPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetContextKeysForCustomPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetContextKeysForCustomPolicyResponse getContextKeysForCustomPolicy(
            GetContextKeysForCustomPolicyRequest getContextKeysForCustomPolicyRequest) throws InvalidInputException,
            AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of all of the context keys referenced in the input policies. The policies are supplied as a list of
     * one or more strings. To get the context keys from policies associated with an IAM user, group, or role, use
     * <a>GetContextKeysForPrincipalPolicy</a>.
     * </p>
     * <p>
     * Context keys are variables maintained by AWS and its services that provide details about the context of an API
     * query request. Context keys can be evaluated by testing against a value specified in an IAM policy. Use
     * <code>GetContextKeysForCustomPolicy</code> to understand what key names and values you must supply when you call
     * <a>SimulateCustomPolicy</a>. Note that all parameters are shown in unencoded form here for clarity but must be
     * URL encoded to be included as a part of a real HTML request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContextKeysForCustomPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link GetContextKeysForCustomPolicyRequest#builder()}
     * </p>
     *
     * @param getContextKeysForCustomPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetContextKeysForCustomPolicyRequest.Builder} to
     *        create a request.
     * @return Result of the GetContextKeysForCustomPolicy operation returned by the service.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetContextKeysForCustomPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetContextKeysForCustomPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetContextKeysForCustomPolicyResponse getContextKeysForCustomPolicy(
            Consumer<GetContextKeysForCustomPolicyRequest.Builder> getContextKeysForCustomPolicyRequest)
            throws InvalidInputException, AwsServiceException, SdkClientException, IamException {
        return getContextKeysForCustomPolicy(GetContextKeysForCustomPolicyRequest.builder()
                .applyMutation(getContextKeysForCustomPolicyRequest).build());
    }

    /**
     * <p>
     * Gets a list of all of the context keys referenced in all the IAM policies that are attached to the specified IAM
     * entity. The entity can be an IAM user, group, or role. If you specify a user, then the request also includes all
     * of the policies attached to groups that the user is a member of.
     * </p>
     * <p>
     * You can optionally include a list of one or more additional policies, specified as strings. If you want to
     * include <i>only</i> a list of policies by string, use <a>GetContextKeysForCustomPolicy</a> instead.
     * </p>
     * <p>
     * <b>Note:</b> This operation discloses information about the permissions granted to other users. If you do not
     * want users to see other user's permissions, then consider allowing them to use
     * <a>GetContextKeysForCustomPolicy</a> instead.
     * </p>
     * <p>
     * Context keys are variables maintained by AWS and its services that provide details about the context of an API
     * query request. Context keys can be evaluated by testing against a value in an IAM policy. Use
     * <a>GetContextKeysForPrincipalPolicy</a> to understand what key names and values you must supply when you call
     * <a>SimulatePrincipalPolicy</a>.
     * </p>
     *
     * @param getContextKeysForPrincipalPolicyRequest
     * @return Result of the GetContextKeysForPrincipalPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetContextKeysForPrincipalPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetContextKeysForPrincipalPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetContextKeysForPrincipalPolicyResponse getContextKeysForPrincipalPolicy(
            GetContextKeysForPrincipalPolicyRequest getContextKeysForPrincipalPolicyRequest) throws NoSuchEntityException,
            InvalidInputException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of all of the context keys referenced in all the IAM policies that are attached to the specified IAM
     * entity. The entity can be an IAM user, group, or role. If you specify a user, then the request also includes all
     * of the policies attached to groups that the user is a member of.
     * </p>
     * <p>
     * You can optionally include a list of one or more additional policies, specified as strings. If you want to
     * include <i>only</i> a list of policies by string, use <a>GetContextKeysForCustomPolicy</a> instead.
     * </p>
     * <p>
     * <b>Note:</b> This operation discloses information about the permissions granted to other users. If you do not
     * want users to see other user's permissions, then consider allowing them to use
     * <a>GetContextKeysForCustomPolicy</a> instead.
     * </p>
     * <p>
     * Context keys are variables maintained by AWS and its services that provide details about the context of an API
     * query request. Context keys can be evaluated by testing against a value in an IAM policy. Use
     * <a>GetContextKeysForPrincipalPolicy</a> to understand what key names and values you must supply when you call
     * <a>SimulatePrincipalPolicy</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContextKeysForPrincipalPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link GetContextKeysForPrincipalPolicyRequest#builder()}
     * </p>
     *
     * @param getContextKeysForPrincipalPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetContextKeysForPrincipalPolicyRequest.Builder} to
     *        create a request.
     * @return Result of the GetContextKeysForPrincipalPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetContextKeysForPrincipalPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetContextKeysForPrincipalPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetContextKeysForPrincipalPolicyResponse getContextKeysForPrincipalPolicy(
            Consumer<GetContextKeysForPrincipalPolicyRequest.Builder> getContextKeysForPrincipalPolicyRequest)
            throws NoSuchEntityException, InvalidInputException, AwsServiceException, SdkClientException, IamException {
        return getContextKeysForPrincipalPolicy(GetContextKeysForPrincipalPolicyRequest.builder()
                .applyMutation(getContextKeysForPrincipalPolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves a credential report for the AWS account. For more information about the credential report, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Getting credential reports</a> in
     * the <i>IAM User Guide</i>.
     * </p>
     *
     * @return Result of the GetCredentialReport operation returned by the service.
     * @throws CredentialReportNotPresentException
     *         The request was rejected because the credential report does not exist. To generate a credential report,
     *         use <a>GenerateCredentialReport</a>.
     * @throws CredentialReportExpiredException
     *         The request was rejected because the most recent credential report has expired. To generate a new
     *         credential report, use <a>GenerateCredentialReport</a>. For more information about credential report
     *         expiration, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Getting credential
     *         reports</a> in the <i>IAM User Guide</i>.
     * @throws CredentialReportNotReadyException
     *         The request was rejected because the credential report is still being generated.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetCredentialReport
     * @see #getCredentialReport(GetCredentialReportRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetCredentialReport" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCredentialReportResponse getCredentialReport() throws CredentialReportNotPresentException,
            CredentialReportExpiredException, CredentialReportNotReadyException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        return getCredentialReport(GetCredentialReportRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves a credential report for the AWS account. For more information about the credential report, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Getting credential reports</a> in
     * the <i>IAM User Guide</i>.
     * </p>
     *
     * @param getCredentialReportRequest
     * @return Result of the GetCredentialReport operation returned by the service.
     * @throws CredentialReportNotPresentException
     *         The request was rejected because the credential report does not exist. To generate a credential report,
     *         use <a>GenerateCredentialReport</a>.
     * @throws CredentialReportExpiredException
     *         The request was rejected because the most recent credential report has expired. To generate a new
     *         credential report, use <a>GenerateCredentialReport</a>. For more information about credential report
     *         expiration, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Getting credential
     *         reports</a> in the <i>IAM User Guide</i>.
     * @throws CredentialReportNotReadyException
     *         The request was rejected because the credential report is still being generated.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetCredentialReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetCredentialReport" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCredentialReportResponse getCredentialReport(GetCredentialReportRequest getCredentialReportRequest)
            throws CredentialReportNotPresentException, CredentialReportExpiredException, CredentialReportNotReadyException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a credential report for the AWS account. For more information about the credential report, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Getting credential reports</a> in
     * the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCredentialReportRequest.Builder} avoiding the
     * need to create one manually via {@link GetCredentialReportRequest#builder()}
     * </p>
     *
     * @param getCredentialReportRequest
     *        A {@link Consumer} that will call methods on {@link GetCredentialReportRequest.Builder} to create a
     *        request.
     * @return Result of the GetCredentialReport operation returned by the service.
     * @throws CredentialReportNotPresentException
     *         The request was rejected because the credential report does not exist. To generate a credential report,
     *         use <a>GenerateCredentialReport</a>.
     * @throws CredentialReportExpiredException
     *         The request was rejected because the most recent credential report has expired. To generate a new
     *         credential report, use <a>GenerateCredentialReport</a>. For more information about credential report
     *         expiration, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Getting credential
     *         reports</a> in the <i>IAM User Guide</i>.
     * @throws CredentialReportNotReadyException
     *         The request was rejected because the credential report is still being generated.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetCredentialReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetCredentialReport" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCredentialReportResponse getCredentialReport(
            Consumer<GetCredentialReportRequest.Builder> getCredentialReportRequest) throws CredentialReportNotPresentException,
            CredentialReportExpiredException, CredentialReportNotReadyException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        return getCredentialReport(GetCredentialReportRequest.builder().applyMutation(getCredentialReportRequest).build());
    }

    /**
     * <p>
     * Returns a list of IAM users that are in the specified IAM group. You can paginate the results using the
     * <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param getGroupRequest
     * @return Result of the GetGroup operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGroupResponse getGroup(GetGroupRequest getGroupRequest) throws NoSuchEntityException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of IAM users that are in the specified IAM group. You can paginate the results using the
     * <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGroupRequest.Builder} avoiding the need to
     * create one manually via {@link GetGroupRequest#builder()}
     * </p>
     *
     * @param getGroupRequest
     *        A {@link Consumer} that will call methods on {@link GetGroupRequest.Builder} to create a request.
     * @return Result of the GetGroup operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGroupResponse getGroup(Consumer<GetGroupRequest.Builder> getGroupRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return getGroup(GetGroupRequest.builder().applyMutation(getGroupRequest).build());
    }

    /**
     * <p>
     * Returns a list of IAM users that are in the specified IAM group. You can paginate the results using the
     * <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getGroup(software.amazon.awssdk.services.iam.model.GetGroupRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.GetGroupIterable responses = client.getGroupPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.GetGroupIterable responses = client.getGroupPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.GetGroupResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.GetGroupIterable responses = client.getGroupPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getGroup(software.amazon.awssdk.services.iam.model.GetGroupRequest)} operation.</b>
     * </p>
     *
     * @param getGroupRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGroupIterable getGroupPaginator(GetGroupRequest getGroupRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of IAM users that are in the specified IAM group. You can paginate the results using the
     * <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getGroup(software.amazon.awssdk.services.iam.model.GetGroupRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.GetGroupIterable responses = client.getGroupPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.GetGroupIterable responses = client.getGroupPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.GetGroupResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.GetGroupIterable responses = client.getGroupPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getGroup(software.amazon.awssdk.services.iam.model.GetGroupRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGroupRequest.Builder} avoiding the need to
     * create one manually via {@link GetGroupRequest#builder()}
     * </p>
     *
     * @param getGroupRequest
     *        A {@link Consumer} that will call methods on {@link GetGroupRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGroupIterable getGroupPaginator(Consumer<GetGroupRequest.Builder> getGroupRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return getGroupPaginator(GetGroupRequest.builder().applyMutation(getGroupRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified inline policy document that is embedded in the specified IAM group.
     * </p>
     * <note>
     * <p>
     * Policies returned by this operation are URL-encoded compliant with <a
     * href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy
     * back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the
     * <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar
     * functionality.
     * </p>
     * </note>
     * <p>
     * An IAM group can also have managed policies attached to it. To retrieve a managed policy document that is
     * attached to a group, use <a>GetPolicy</a> to determine the policy's default version, then use
     * <a>GetPolicyVersion</a> to retrieve the policy document.
     * </p>
     * <p>
     * For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param getGroupPolicyRequest
     * @return Result of the GetGroupPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetGroupPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGroupPolicyResponse getGroupPolicy(GetGroupPolicyRequest getGroupPolicyRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified inline policy document that is embedded in the specified IAM group.
     * </p>
     * <note>
     * <p>
     * Policies returned by this operation are URL-encoded compliant with <a
     * href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy
     * back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the
     * <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar
     * functionality.
     * </p>
     * </note>
     * <p>
     * An IAM group can also have managed policies attached to it. To retrieve a managed policy document that is
     * attached to a group, use <a>GetPolicy</a> to determine the policy's default version, then use
     * <a>GetPolicyVersion</a> to retrieve the policy document.
     * </p>
     * <p>
     * For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGroupPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link GetGroupPolicyRequest#builder()}
     * </p>
     *
     * @param getGroupPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetGroupPolicyRequest.Builder} to create a request.
     * @return Result of the GetGroupPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetGroupPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGroupPolicyResponse getGroupPolicy(Consumer<GetGroupPolicyRequest.Builder> getGroupPolicyRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return getGroupPolicy(GetGroupPolicyRequest.builder().applyMutation(getGroupPolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified instance profile, including the instance profile's path, GUID, ARN, and
     * role. For more information about instance profiles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About instance profiles</a> in
     * the <i>IAM User Guide</i>.
     * </p>
     *
     * @param getInstanceProfileRequest
     * @return Result of the GetInstanceProfile operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetInstanceProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInstanceProfileResponse getInstanceProfile(GetInstanceProfileRequest getInstanceProfileRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified instance profile, including the instance profile's path, GUID, ARN, and
     * role. For more information about instance profiles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About instance profiles</a> in
     * the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInstanceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link GetInstanceProfileRequest#builder()}
     * </p>
     *
     * @param getInstanceProfileRequest
     *        A {@link Consumer} that will call methods on {@link GetInstanceProfileRequest.Builder} to create a
     *        request.
     * @return Result of the GetInstanceProfile operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetInstanceProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInstanceProfileResponse getInstanceProfile(Consumer<GetInstanceProfileRequest.Builder> getInstanceProfileRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return getInstanceProfile(GetInstanceProfileRequest.builder().applyMutation(getInstanceProfileRequest).build());
    }

    /**
     * <p>
     * Retrieves the user name and password creation date for the specified IAM user. If the user has not been assigned
     * a password, the operation returns a 404 (<code>NoSuchEntity</code>) error.
     * </p>
     *
     * @param getLoginProfileRequest
     * @return Result of the GetLoginProfile operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetLoginProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetLoginProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLoginProfileResponse getLoginProfile(GetLoginProfileRequest getLoginProfileRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the user name and password creation date for the specified IAM user. If the user has not been assigned
     * a password, the operation returns a 404 (<code>NoSuchEntity</code>) error.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLoginProfileRequest.Builder} avoiding the need
     * to create one manually via {@link GetLoginProfileRequest#builder()}
     * </p>
     *
     * @param getLoginProfileRequest
     *        A {@link Consumer} that will call methods on {@link GetLoginProfileRequest.Builder} to create a request.
     * @return Result of the GetLoginProfile operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetLoginProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetLoginProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLoginProfileResponse getLoginProfile(Consumer<GetLoginProfileRequest.Builder> getLoginProfileRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return getLoginProfile(GetLoginProfileRequest.builder().applyMutation(getLoginProfileRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified OpenID Connect (OIDC) provider resource object in IAM.
     * </p>
     *
     * @param getOpenIdConnectProviderRequest
     * @return Result of the GetOpenIDConnectProvider operation returned by the service.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetOpenIDConnectProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetOpenIDConnectProvider" target="_top">AWS
     *      API Documentation</a>
     */
    default GetOpenIdConnectProviderResponse getOpenIDConnectProvider(
            GetOpenIdConnectProviderRequest getOpenIdConnectProviderRequest) throws InvalidInputException, NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified OpenID Connect (OIDC) provider resource object in IAM.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOpenIdConnectProviderRequest.Builder} avoiding
     * the need to create one manually via {@link GetOpenIdConnectProviderRequest#builder()}
     * </p>
     *
     * @param getOpenIdConnectProviderRequest
     *        A {@link Consumer} that will call methods on {@link GetOpenIDConnectProviderRequest.Builder} to create a
     *        request.
     * @return Result of the GetOpenIDConnectProvider operation returned by the service.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetOpenIDConnectProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetOpenIDConnectProvider" target="_top">AWS
     *      API Documentation</a>
     */
    default GetOpenIdConnectProviderResponse getOpenIDConnectProvider(
            Consumer<GetOpenIdConnectProviderRequest.Builder> getOpenIdConnectProviderRequest) throws InvalidInputException,
            NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return getOpenIDConnectProvider(GetOpenIdConnectProviderRequest.builder().applyMutation(getOpenIdConnectProviderRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the service last accessed data report for AWS Organizations that was previously generated using the
     * <code> <a>GenerateOrganizationsAccessReport</a> </code> operation. This operation retrieves the status of your
     * report job and the report contents.
     * </p>
     * <p>
     * Depending on the parameters that you passed when you generated the report, the data returned could include
     * different information. For details, see <a>GenerateOrganizationsAccessReport</a>.
     * </p>
     * <p>
     * To call this operation, you must be signed in to the management account in your organization. SCPs must be
     * enabled for your organization root. You must have permissions to perform this operation. For more information,
     * see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Refining
     * permissions using service last accessed data</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For each service that principals in an account (root users, IAM users, or IAM roles) could access using SCPs, the
     * operation returns details about the most recent access attempt. If there was no attempt, the service is listed
     * without details about the most recent attempt to access the service. If the operation fails, it returns the
     * reason that it failed.
     * </p>
     * <p>
     * By default, the list is sorted by service namespace.
     * </p>
     *
     * @param getOrganizationsAccessReportRequest
     * @return Result of the GetOrganizationsAccessReport operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetOrganizationsAccessReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetOrganizationsAccessReport"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOrganizationsAccessReportResponse getOrganizationsAccessReport(
            GetOrganizationsAccessReportRequest getOrganizationsAccessReportRequest) throws NoSuchEntityException,
            AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the service last accessed data report for AWS Organizations that was previously generated using the
     * <code> <a>GenerateOrganizationsAccessReport</a> </code> operation. This operation retrieves the status of your
     * report job and the report contents.
     * </p>
     * <p>
     * Depending on the parameters that you passed when you generated the report, the data returned could include
     * different information. For details, see <a>GenerateOrganizationsAccessReport</a>.
     * </p>
     * <p>
     * To call this operation, you must be signed in to the management account in your organization. SCPs must be
     * enabled for your organization root. You must have permissions to perform this operation. For more information,
     * see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Refining
     * permissions using service last accessed data</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For each service that principals in an account (root users, IAM users, or IAM roles) could access using SCPs, the
     * operation returns details about the most recent access attempt. If there was no attempt, the service is listed
     * without details about the most recent attempt to access the service. If the operation fails, it returns the
     * reason that it failed.
     * </p>
     * <p>
     * By default, the list is sorted by service namespace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOrganizationsAccessReportRequest.Builder}
     * avoiding the need to create one manually via {@link GetOrganizationsAccessReportRequest#builder()}
     * </p>
     *
     * @param getOrganizationsAccessReportRequest
     *        A {@link Consumer} that will call methods on {@link GetOrganizationsAccessReportRequest.Builder} to create
     *        a request.
     * @return Result of the GetOrganizationsAccessReport operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetOrganizationsAccessReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetOrganizationsAccessReport"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOrganizationsAccessReportResponse getOrganizationsAccessReport(
            Consumer<GetOrganizationsAccessReportRequest.Builder> getOrganizationsAccessReportRequest)
            throws NoSuchEntityException, AwsServiceException, SdkClientException, IamException {
        return getOrganizationsAccessReport(GetOrganizationsAccessReportRequest.builder()
                .applyMutation(getOrganizationsAccessReportRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified managed policy, including the policy's default version and the total
     * number of IAM users, groups, and roles to which the policy is attached. To retrieve the list of the specific
     * users, groups, and roles that the policy is attached to, use <a>ListEntitiesForPolicy</a>. This operation returns
     * metadata about the policy. To retrieve the actual policy document for a specific version of the policy, use
     * <a>GetPolicyVersion</a>.
     * </p>
     * <p>
     * This operation retrieves information about managed policies. To retrieve information about an inline policy that
     * is embedded with an IAM user, group, or role, use <a>GetUserPolicy</a>, <a>GetGroupPolicy</a>, or
     * <a>GetRolePolicy</a>.
     * </p>
     * <p>
     * For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param getPolicyRequest
     * @return Result of the GetPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPolicyResponse getPolicy(GetPolicyRequest getPolicyRequest) throws NoSuchEntityException, InvalidInputException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified managed policy, including the policy's default version and the total
     * number of IAM users, groups, and roles to which the policy is attached. To retrieve the list of the specific
     * users, groups, and roles that the policy is attached to, use <a>ListEntitiesForPolicy</a>. This operation returns
     * metadata about the policy. To retrieve the actual policy document for a specific version of the policy, use
     * <a>GetPolicyVersion</a>.
     * </p>
     * <p>
     * This operation retrieves information about managed policies. To retrieve information about an inline policy that
     * is embedded with an IAM user, group, or role, use <a>GetUserPolicy</a>, <a>GetGroupPolicy</a>, or
     * <a>GetRolePolicy</a>.
     * </p>
     * <p>
     * For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link GetPolicyRequest#builder()}
     * </p>
     *
     * @param getPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetPolicyRequest.Builder} to create a request.
     * @return Result of the GetPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPolicyResponse getPolicy(Consumer<GetPolicyRequest.Builder> getPolicyRequest) throws NoSuchEntityException,
            InvalidInputException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return getPolicy(GetPolicyRequest.builder().applyMutation(getPolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified version of the specified managed policy, including the policy document.
     * </p>
     * <note>
     * <p>
     * Policies returned by this operation are URL-encoded compliant with <a
     * href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy
     * back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the
     * <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar
     * functionality.
     * </p>
     * </note>
     * <p>
     * To list the available versions for a policy, use <a>ListPolicyVersions</a>.
     * </p>
     * <p>
     * This operation retrieves information about managed policies. To retrieve information about an inline policy that
     * is embedded in a user, group, or role, use <a>GetUserPolicy</a>, <a>GetGroupPolicy</a>, or <a>GetRolePolicy</a>.
     * </p>
     * <p>
     * For more information about the types of policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For more information about managed policy versions, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param getPolicyVersionRequest
     * @return Result of the GetPolicyVersion operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetPolicyVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetPolicyVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPolicyVersionResponse getPolicyVersion(GetPolicyVersionRequest getPolicyVersionRequest)
            throws NoSuchEntityException, InvalidInputException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified version of the specified managed policy, including the policy document.
     * </p>
     * <note>
     * <p>
     * Policies returned by this operation are URL-encoded compliant with <a
     * href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy
     * back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the
     * <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar
     * functionality.
     * </p>
     * </note>
     * <p>
     * To list the available versions for a policy, use <a>ListPolicyVersions</a>.
     * </p>
     * <p>
     * This operation retrieves information about managed policies. To retrieve information about an inline policy that
     * is embedded in a user, group, or role, use <a>GetUserPolicy</a>, <a>GetGroupPolicy</a>, or <a>GetRolePolicy</a>.
     * </p>
     * <p>
     * For more information about the types of policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For more information about managed policy versions, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPolicyVersionRequest.Builder} avoiding the need
     * to create one manually via {@link GetPolicyVersionRequest#builder()}
     * </p>
     *
     * @param getPolicyVersionRequest
     *        A {@link Consumer} that will call methods on {@link GetPolicyVersionRequest.Builder} to create a request.
     * @return Result of the GetPolicyVersion operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetPolicyVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetPolicyVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPolicyVersionResponse getPolicyVersion(Consumer<GetPolicyVersionRequest.Builder> getPolicyVersionRequest)
            throws NoSuchEntityException, InvalidInputException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        return getPolicyVersion(GetPolicyVersionRequest.builder().applyMutation(getPolicyVersionRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified role, including the role's path, GUID, ARN, and the role's trust policy
     * that grants permission to assume the role. For more information about roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with roles</a>.
     * </p>
     * <note>
     * <p>
     * Policies returned by this operation are URL-encoded compliant with <a
     * href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy
     * back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the
     * <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar
     * functionality.
     * </p>
     * </note>
     *
     * @param getRoleRequest
     * @return Result of the GetRole operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetRole" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRoleResponse getRole(GetRoleRequest getRoleRequest) throws NoSuchEntityException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified role, including the role's path, GUID, ARN, and the role's trust policy
     * that grants permission to assume the role. For more information about roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with roles</a>.
     * </p>
     * <note>
     * <p>
     * Policies returned by this operation are URL-encoded compliant with <a
     * href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy
     * back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the
     * <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar
     * functionality.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRoleRequest.Builder} avoiding the need to create
     * one manually via {@link GetRoleRequest#builder()}
     * </p>
     *
     * @param getRoleRequest
     *        A {@link Consumer} that will call methods on {@link GetRoleRequest.Builder} to create a request.
     * @return Result of the GetRole operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetRole" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRoleResponse getRole(Consumer<GetRoleRequest.Builder> getRoleRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return getRole(GetRoleRequest.builder().applyMutation(getRoleRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified inline policy document that is embedded with the specified IAM role.
     * </p>
     * <note>
     * <p>
     * Policies returned by this operation are URL-encoded compliant with <a
     * href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy
     * back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the
     * <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar
     * functionality.
     * </p>
     * </note>
     * <p>
     * An IAM role can also have managed policies attached to it. To retrieve a managed policy document that is attached
     * to a role, use <a>GetPolicy</a> to determine the policy's default version, then use <a>GetPolicyVersion</a> to
     * retrieve the policy document.
     * </p>
     * <p>
     * For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For more information about roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html">Using roles to delegate permissions
     * and federate identities</a>.
     * </p>
     *
     * @param getRolePolicyRequest
     * @return Result of the GetRolePolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetRolePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetRolePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRolePolicyResponse getRolePolicy(GetRolePolicyRequest getRolePolicyRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified inline policy document that is embedded with the specified IAM role.
     * </p>
     * <note>
     * <p>
     * Policies returned by this operation are URL-encoded compliant with <a
     * href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy
     * back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the
     * <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar
     * functionality.
     * </p>
     * </note>
     * <p>
     * An IAM role can also have managed policies attached to it. To retrieve a managed policy document that is attached
     * to a role, use <a>GetPolicy</a> to determine the policy's default version, then use <a>GetPolicyVersion</a> to
     * retrieve the policy document.
     * </p>
     * <p>
     * For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For more information about roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html">Using roles to delegate permissions
     * and federate identities</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRolePolicyRequest.Builder} avoiding the need to
     * create one manually via {@link GetRolePolicyRequest#builder()}
     * </p>
     *
     * @param getRolePolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetRolePolicyRequest.Builder} to create a request.
     * @return Result of the GetRolePolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetRolePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetRolePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRolePolicyResponse getRolePolicy(Consumer<GetRolePolicyRequest.Builder> getRolePolicyRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return getRolePolicy(GetRolePolicyRequest.builder().applyMutation(getRolePolicyRequest).build());
    }

    /**
     * <p>
     * Returns the SAML provider metadocument that was uploaded when the IAM SAML provider resource object was created
     * or updated.
     * </p>
     * <note>
     * <p>
     * This operation requires <a
     * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.
     * </p>
     * </note>
     *
     * @param getSamlProviderRequest
     * @return Result of the GetSAMLProvider operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetSAMLProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetSAMLProvider" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSamlProviderResponse getSAMLProvider(GetSamlProviderRequest getSamlProviderRequest) throws NoSuchEntityException,
            InvalidInputException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the SAML provider metadocument that was uploaded when the IAM SAML provider resource object was created
     * or updated.
     * </p>
     * <note>
     * <p>
     * This operation requires <a
     * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSamlProviderRequest.Builder} avoiding the need
     * to create one manually via {@link GetSamlProviderRequest#builder()}
     * </p>
     *
     * @param getSamlProviderRequest
     *        A {@link Consumer} that will call methods on {@link GetSAMLProviderRequest.Builder} to create a request.
     * @return Result of the GetSAMLProvider operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetSAMLProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetSAMLProvider" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSamlProviderResponse getSAMLProvider(Consumer<GetSamlProviderRequest.Builder> getSamlProviderRequest)
            throws NoSuchEntityException, InvalidInputException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        return getSAMLProvider(GetSamlProviderRequest.builder().applyMutation(getSamlProviderRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified SSH public key, including metadata about the key.
     * </p>
     * <p>
     * The SSH public key retrieved by this operation is used only for authenticating the associated IAM user to an AWS
     * CodeCommit repository. For more information about using SSH keys to authenticate to an AWS CodeCommit repository,
     * see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up AWS
     * CodeCommit for SSH connections</a> in the <i>AWS CodeCommit User Guide</i>.
     * </p>
     *
     * @param getSshPublicKeyRequest
     * @return Result of the GetSSHPublicKey operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws UnrecognizedPublicKeyEncodingException
     *         The request was rejected because the public key encoding format is unsupported or unrecognized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetSSHPublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetSSHPublicKey" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSshPublicKeyResponse getSSHPublicKey(GetSshPublicKeyRequest getSshPublicKeyRequest) throws NoSuchEntityException,
            UnrecognizedPublicKeyEncodingException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified SSH public key, including metadata about the key.
     * </p>
     * <p>
     * The SSH public key retrieved by this operation is used only for authenticating the associated IAM user to an AWS
     * CodeCommit repository. For more information about using SSH keys to authenticate to an AWS CodeCommit repository,
     * see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up AWS
     * CodeCommit for SSH connections</a> in the <i>AWS CodeCommit User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSshPublicKeyRequest.Builder} avoiding the need
     * to create one manually via {@link GetSshPublicKeyRequest#builder()}
     * </p>
     *
     * @param getSshPublicKeyRequest
     *        A {@link Consumer} that will call methods on {@link GetSSHPublicKeyRequest.Builder} to create a request.
     * @return Result of the GetSSHPublicKey operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws UnrecognizedPublicKeyEncodingException
     *         The request was rejected because the public key encoding format is unsupported or unrecognized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetSSHPublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetSSHPublicKey" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSshPublicKeyResponse getSSHPublicKey(Consumer<GetSshPublicKeyRequest.Builder> getSshPublicKeyRequest)
            throws NoSuchEntityException, UnrecognizedPublicKeyEncodingException, AwsServiceException, SdkClientException,
            IamException {
        return getSSHPublicKey(GetSshPublicKeyRequest.builder().applyMutation(getSshPublicKeyRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified server certificate stored in IAM.
     * </p>
     * <p>
     * For more information about working with server certificates, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with server
     * certificates</a> in the <i>IAM User Guide</i>. This topic includes a list of AWS services that can use the server
     * certificates that you manage with IAM.
     * </p>
     *
     * @param getServerCertificateRequest
     * @return Result of the GetServerCertificate operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetServerCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetServerCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    default GetServerCertificateResponse getServerCertificate(GetServerCertificateRequest getServerCertificateRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified server certificate stored in IAM.
     * </p>
     * <p>
     * For more information about working with server certificates, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with server
     * certificates</a> in the <i>IAM User Guide</i>. This topic includes a list of AWS services that can use the server
     * certificates that you manage with IAM.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServerCertificateRequest.Builder} avoiding the
     * need to create one manually via {@link GetServerCertificateRequest#builder()}
     * </p>
     *
     * @param getServerCertificateRequest
     *        A {@link Consumer} that will call methods on {@link GetServerCertificateRequest.Builder} to create a
     *        request.
     * @return Result of the GetServerCertificate operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetServerCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetServerCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    default GetServerCertificateResponse getServerCertificate(
            Consumer<GetServerCertificateRequest.Builder> getServerCertificateRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return getServerCertificate(GetServerCertificateRequest.builder().applyMutation(getServerCertificateRequest).build());
    }

    /**
     * <p>
     * Retrieves a service last accessed report that was created using the
     * <code>GenerateServiceLastAccessedDetails</code> operation. You can use the <code>JobId</code> parameter in
     * <code>GetServiceLastAccessedDetails</code> to retrieve the status of your report job. When the report is
     * complete, you can retrieve the generated report. The report includes a list of AWS services that the resource
     * (user, group, role, or managed policy) can access.
     * </p>
     * <note>
     * <p>
     * Service last accessed data does not use other policy types when determining whether a resource could access a
     * service. These other policy types include resource-based policies, access control lists, AWS Organizations
     * policies, IAM permissions boundaries, and AWS STS assume role policies. It only applies permissions policy logic.
     * For more about the evaluation of policy types, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics"
     * >Evaluating policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * </note>
     * <p>
     * For each service that the resource could access using permissions policies, the operation returns details about
     * the most recent access attempt. If there was no attempt, the service is listed without details about the most
     * recent attempt to access the service. If the operation fails, the <code>GetServiceLastAccessedDetails</code>
     * operation returns the reason that it failed.
     * </p>
     * <p>
     * The <code>GetServiceLastAccessedDetails</code> operation returns a list of services. This list includes the
     * number of entities that have attempted to access the service and the date and time of the last attempt. It also
     * returns the ARN of the following entity, depending on the resource ARN that you used to generate the report:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>User</b> – Returns the user ARN that you used to generate the report
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Group</b> – Returns the ARN of the group member (user) that last attempted to access the service
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Role</b> – Returns the role ARN that you used to generate the report
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Policy</b> – Returns the ARN of the user or role that last used the policy to attempt to access the service
     * </p>
     * </li>
     * </ul>
     * <p>
     * By default, the list is sorted by service namespace.
     * </p>
     * <p>
     * If you specified <code>ACTION_LEVEL</code> granularity when you generated the report, this operation returns
     * service and action last accessed data. This includes the most recent access attempt for each tracked action
     * within a service. Otherwise, this operation returns only service data.
     * </p>
     * <p>
     * For more information about service and action last accessed data, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Reducing permissions
     * using service last accessed data</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param getServiceLastAccessedDetailsRequest
     * @return Result of the GetServiceLastAccessedDetails operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetServiceLastAccessedDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetServiceLastAccessedDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServiceLastAccessedDetailsResponse getServiceLastAccessedDetails(
            GetServiceLastAccessedDetailsRequest getServiceLastAccessedDetailsRequest) throws NoSuchEntityException,
            InvalidInputException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a service last accessed report that was created using the
     * <code>GenerateServiceLastAccessedDetails</code> operation. You can use the <code>JobId</code> parameter in
     * <code>GetServiceLastAccessedDetails</code> to retrieve the status of your report job. When the report is
     * complete, you can retrieve the generated report. The report includes a list of AWS services that the resource
     * (user, group, role, or managed policy) can access.
     * </p>
     * <note>
     * <p>
     * Service last accessed data does not use other policy types when determining whether a resource could access a
     * service. These other policy types include resource-based policies, access control lists, AWS Organizations
     * policies, IAM permissions boundaries, and AWS STS assume role policies. It only applies permissions policy logic.
     * For more about the evaluation of policy types, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics"
     * >Evaluating policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * </note>
     * <p>
     * For each service that the resource could access using permissions policies, the operation returns details about
     * the most recent access attempt. If there was no attempt, the service is listed without details about the most
     * recent attempt to access the service. If the operation fails, the <code>GetServiceLastAccessedDetails</code>
     * operation returns the reason that it failed.
     * </p>
     * <p>
     * The <code>GetServiceLastAccessedDetails</code> operation returns a list of services. This list includes the
     * number of entities that have attempted to access the service and the date and time of the last attempt. It also
     * returns the ARN of the following entity, depending on the resource ARN that you used to generate the report:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>User</b> – Returns the user ARN that you used to generate the report
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Group</b> – Returns the ARN of the group member (user) that last attempted to access the service
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Role</b> – Returns the role ARN that you used to generate the report
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Policy</b> – Returns the ARN of the user or role that last used the policy to attempt to access the service
     * </p>
     * </li>
     * </ul>
     * <p>
     * By default, the list is sorted by service namespace.
     * </p>
     * <p>
     * If you specified <code>ACTION_LEVEL</code> granularity when you generated the report, this operation returns
     * service and action last accessed data. This includes the most recent access attempt for each tracked action
     * within a service. Otherwise, this operation returns only service data.
     * </p>
     * <p>
     * For more information about service and action last accessed data, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Reducing permissions
     * using service last accessed data</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceLastAccessedDetailsRequest.Builder}
     * avoiding the need to create one manually via {@link GetServiceLastAccessedDetailsRequest#builder()}
     * </p>
     *
     * @param getServiceLastAccessedDetailsRequest
     *        A {@link Consumer} that will call methods on {@link GetServiceLastAccessedDetailsRequest.Builder} to
     *        create a request.
     * @return Result of the GetServiceLastAccessedDetails operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetServiceLastAccessedDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetServiceLastAccessedDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServiceLastAccessedDetailsResponse getServiceLastAccessedDetails(
            Consumer<GetServiceLastAccessedDetailsRequest.Builder> getServiceLastAccessedDetailsRequest)
            throws NoSuchEntityException, InvalidInputException, AwsServiceException, SdkClientException, IamException {
        return getServiceLastAccessedDetails(GetServiceLastAccessedDetailsRequest.builder()
                .applyMutation(getServiceLastAccessedDetailsRequest).build());
    }

    /**
     * <p>
     * After you generate a group or policy report using the <code>GenerateServiceLastAccessedDetails</code> operation,
     * you can use the <code>JobId</code> parameter in <code>GetServiceLastAccessedDetailsWithEntities</code>. This
     * operation retrieves the status of your report job and a list of entities that could have used group or policy
     * permissions to access the specified service.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Group</b> – For a group report, this operation returns a list of users in the group that could have used the
     * group’s policies in an attempt to access the service.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Policy</b> – For a policy report, this operation returns a list of entities (users or roles) that could have
     * used the policy in an attempt to access the service.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can also use this operation for user or role reports to retrieve details about those entities.
     * </p>
     * <p>
     * If the operation fails, the <code>GetServiceLastAccessedDetailsWithEntities</code> operation returns the reason
     * that it failed.
     * </p>
     * <p>
     * By default, the list of associated entities is sorted by date, with the most recent access listed first.
     * </p>
     *
     * @param getServiceLastAccessedDetailsWithEntitiesRequest
     * @return Result of the GetServiceLastAccessedDetailsWithEntities operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetServiceLastAccessedDetailsWithEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetServiceLastAccessedDetailsWithEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServiceLastAccessedDetailsWithEntitiesResponse getServiceLastAccessedDetailsWithEntities(
            GetServiceLastAccessedDetailsWithEntitiesRequest getServiceLastAccessedDetailsWithEntitiesRequest)
            throws NoSuchEntityException, InvalidInputException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * After you generate a group or policy report using the <code>GenerateServiceLastAccessedDetails</code> operation,
     * you can use the <code>JobId</code> parameter in <code>GetServiceLastAccessedDetailsWithEntities</code>. This
     * operation retrieves the status of your report job and a list of entities that could have used group or policy
     * permissions to access the specified service.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Group</b> – For a group report, this operation returns a list of users in the group that could have used the
     * group’s policies in an attempt to access the service.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Policy</b> – For a policy report, this operation returns a list of entities (users or roles) that could have
     * used the policy in an attempt to access the service.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can also use this operation for user or role reports to retrieve details about those entities.
     * </p>
     * <p>
     * If the operation fails, the <code>GetServiceLastAccessedDetailsWithEntities</code> operation returns the reason
     * that it failed.
     * </p>
     * <p>
     * By default, the list of associated entities is sorted by date, with the most recent access listed first.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetServiceLastAccessedDetailsWithEntitiesRequest.Builder} avoiding the need to create one manually via
     * {@link GetServiceLastAccessedDetailsWithEntitiesRequest#builder()}
     * </p>
     *
     * @param getServiceLastAccessedDetailsWithEntitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link GetServiceLastAccessedDetailsWithEntitiesRequest.Builder} to create a request.
     * @return Result of the GetServiceLastAccessedDetailsWithEntities operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetServiceLastAccessedDetailsWithEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetServiceLastAccessedDetailsWithEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServiceLastAccessedDetailsWithEntitiesResponse getServiceLastAccessedDetailsWithEntities(
            Consumer<GetServiceLastAccessedDetailsWithEntitiesRequest.Builder> getServiceLastAccessedDetailsWithEntitiesRequest)
            throws NoSuchEntityException, InvalidInputException, AwsServiceException, SdkClientException, IamException {
        return getServiceLastAccessedDetailsWithEntities(GetServiceLastAccessedDetailsWithEntitiesRequest.builder()
                .applyMutation(getServiceLastAccessedDetailsWithEntitiesRequest).build());
    }

    /**
     * <p>
     * Retrieves the status of your service-linked role deletion. After you use <a>DeleteServiceLinkedRole</a> to submit
     * a service-linked role for deletion, you can use the <code>DeletionTaskId</code> parameter in
     * <code>GetServiceLinkedRoleDeletionStatus</code> to check the status of the deletion. If the deletion fails, this
     * operation returns the reason that it failed, if that information is returned by the service.
     * </p>
     *
     * @param getServiceLinkedRoleDeletionStatusRequest
     * @return Result of the GetServiceLinkedRoleDeletionStatus operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetServiceLinkedRoleDeletionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetServiceLinkedRoleDeletionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServiceLinkedRoleDeletionStatusResponse getServiceLinkedRoleDeletionStatus(
            GetServiceLinkedRoleDeletionStatusRequest getServiceLinkedRoleDeletionStatusRequest) throws NoSuchEntityException,
            InvalidInputException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the status of your service-linked role deletion. After you use <a>DeleteServiceLinkedRole</a> to submit
     * a service-linked role for deletion, you can use the <code>DeletionTaskId</code> parameter in
     * <code>GetServiceLinkedRoleDeletionStatus</code> to check the status of the deletion. If the deletion fails, this
     * operation returns the reason that it failed, if that information is returned by the service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceLinkedRoleDeletionStatusRequest.Builder}
     * avoiding the need to create one manually via {@link GetServiceLinkedRoleDeletionStatusRequest#builder()}
     * </p>
     *
     * @param getServiceLinkedRoleDeletionStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetServiceLinkedRoleDeletionStatusRequest.Builder} to
     *        create a request.
     * @return Result of the GetServiceLinkedRoleDeletionStatus operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetServiceLinkedRoleDeletionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetServiceLinkedRoleDeletionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServiceLinkedRoleDeletionStatusResponse getServiceLinkedRoleDeletionStatus(
            Consumer<GetServiceLinkedRoleDeletionStatusRequest.Builder> getServiceLinkedRoleDeletionStatusRequest)
            throws NoSuchEntityException, InvalidInputException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        return getServiceLinkedRoleDeletionStatus(GetServiceLinkedRoleDeletionStatusRequest.builder()
                .applyMutation(getServiceLinkedRoleDeletionStatusRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified IAM user, including the user's creation date, path, unique ID, and ARN.
     * </p>
     * <p>
     * If you do not specify a user name, IAM determines the user name implicitly based on the AWS access key ID used to
     * sign the request to this operation.
     * </p>
     *
     * @return Result of the GetUser operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetUser
     * @see #getUser(GetUserRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetUser" target="_top">AWS API
     *      Documentation</a>
     */
    default GetUserResponse getUser() throws NoSuchEntityException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        return getUser(GetUserRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves information about the specified IAM user, including the user's creation date, path, unique ID, and ARN.
     * </p>
     * <p>
     * If you do not specify a user name, IAM determines the user name implicitly based on the AWS access key ID used to
     * sign the request to this operation.
     * </p>
     *
     * @param getUserRequest
     * @return Result of the GetUser operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetUser" target="_top">AWS API
     *      Documentation</a>
     */
    default GetUserResponse getUser(GetUserRequest getUserRequest) throws NoSuchEntityException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified IAM user, including the user's creation date, path, unique ID, and ARN.
     * </p>
     * <p>
     * If you do not specify a user name, IAM determines the user name implicitly based on the AWS access key ID used to
     * sign the request to this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUserRequest.Builder} avoiding the need to create
     * one manually via {@link GetUserRequest#builder()}
     * </p>
     *
     * @param getUserRequest
     *        A {@link Consumer} that will call methods on {@link GetUserRequest.Builder} to create a request.
     * @return Result of the GetUser operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetUser" target="_top">AWS API
     *      Documentation</a>
     */
    default GetUserResponse getUser(Consumer<GetUserRequest.Builder> getUserRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return getUser(GetUserRequest.builder().applyMutation(getUserRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified inline policy document that is embedded in the specified IAM user.
     * </p>
     * <note>
     * <p>
     * Policies returned by this operation are URL-encoded compliant with <a
     * href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy
     * back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the
     * <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar
     * functionality.
     * </p>
     * </note>
     * <p>
     * An IAM user can also have managed policies attached to it. To retrieve a managed policy document that is attached
     * to a user, use <a>GetPolicy</a> to determine the policy's default version. Then use <a>GetPolicyVersion</a> to
     * retrieve the policy document.
     * </p>
     * <p>
     * For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param getUserPolicyRequest
     * @return Result of the GetUserPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetUserPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetUserPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetUserPolicyResponse getUserPolicy(GetUserPolicyRequest getUserPolicyRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified inline policy document that is embedded in the specified IAM user.
     * </p>
     * <note>
     * <p>
     * Policies returned by this operation are URL-encoded compliant with <a
     * href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy
     * back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the
     * <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar
     * functionality.
     * </p>
     * </note>
     * <p>
     * An IAM user can also have managed policies attached to it. To retrieve a managed policy document that is attached
     * to a user, use <a>GetPolicy</a> to determine the policy's default version. Then use <a>GetPolicyVersion</a> to
     * retrieve the policy document.
     * </p>
     * <p>
     * For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUserPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link GetUserPolicyRequest#builder()}
     * </p>
     *
     * @param getUserPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetUserPolicyRequest.Builder} to create a request.
     * @return Result of the GetUserPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetUserPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetUserPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetUserPolicyResponse getUserPolicy(Consumer<GetUserPolicyRequest.Builder> getUserPolicyRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return getUserPolicy(GetUserPolicyRequest.builder().applyMutation(getUserPolicyRequest).build());
    }

    /**
     * <p>
     * Returns information about the access key IDs associated with the specified IAM user. If there is none, the
     * operation returns an empty list.
     * </p>
     * <p>
     * Although each user is limited to a small number of keys, you can still paginate the results using the
     * <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * If the <code>UserName</code> field is not specified, the user name is determined implicitly based on the AWS
     * access key ID used to sign the request. This operation works for access keys under the AWS account. Consequently,
     * you can use this operation to manage AWS account root user credentials even if the AWS account has no associated
     * users.
     * </p>
     * <note>
     * <p>
     * To ensure the security of your AWS account, the secret access key is accessible only during key and user
     * creation.
     * </p>
     * </note>
     *
     * @return Result of the ListAccessKeys operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListAccessKeys
     * @see #listAccessKeys(ListAccessKeysRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccessKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAccessKeysResponse listAccessKeys() throws NoSuchEntityException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        return listAccessKeys(ListAccessKeysRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about the access key IDs associated with the specified IAM user. If there is none, the
     * operation returns an empty list.
     * </p>
     * <p>
     * Although each user is limited to a small number of keys, you can still paginate the results using the
     * <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * If the <code>UserName</code> field is not specified, the user name is determined implicitly based on the AWS
     * access key ID used to sign the request. This operation works for access keys under the AWS account. Consequently,
     * you can use this operation to manage AWS account root user credentials even if the AWS account has no associated
     * users.
     * </p>
     * <note>
     * <p>
     * To ensure the security of your AWS account, the secret access key is accessible only during key and user
     * creation.
     * </p>
     * </note>
     *
     * @param listAccessKeysRequest
     * @return Result of the ListAccessKeys operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListAccessKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccessKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAccessKeysResponse listAccessKeys(ListAccessKeysRequest listAccessKeysRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the access key IDs associated with the specified IAM user. If there is none, the
     * operation returns an empty list.
     * </p>
     * <p>
     * Although each user is limited to a small number of keys, you can still paginate the results using the
     * <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * If the <code>UserName</code> field is not specified, the user name is determined implicitly based on the AWS
     * access key ID used to sign the request. This operation works for access keys under the AWS account. Consequently,
     * you can use this operation to manage AWS account root user credentials even if the AWS account has no associated
     * users.
     * </p>
     * <note>
     * <p>
     * To ensure the security of your AWS account, the secret access key is accessible only during key and user
     * creation.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessKeysRequest.Builder} avoiding the need to
     * create one manually via {@link ListAccessKeysRequest#builder()}
     * </p>
     *
     * @param listAccessKeysRequest
     *        A {@link Consumer} that will call methods on {@link ListAccessKeysRequest.Builder} to create a request.
     * @return Result of the ListAccessKeys operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListAccessKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccessKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAccessKeysResponse listAccessKeys(Consumer<ListAccessKeysRequest.Builder> listAccessKeysRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listAccessKeys(ListAccessKeysRequest.builder().applyMutation(listAccessKeysRequest).build());
    }

    /**
     * <p>
     * Returns information about the access key IDs associated with the specified IAM user. If there is none, the
     * operation returns an empty list.
     * </p>
     * <p>
     * Although each user is limited to a small number of keys, you can still paginate the results using the
     * <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * If the <code>UserName</code> field is not specified, the user name is determined implicitly based on the AWS
     * access key ID used to sign the request. This operation works for access keys under the AWS account. Consequently,
     * you can use this operation to manage AWS account root user credentials even if the AWS account has no associated
     * users.
     * </p>
     * <note>
     * <p>
     * To ensure the security of your AWS account, the secret access key is accessible only during key and user
     * creation.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of {@link #listAccessKeys(software.amazon.awssdk.services.iam.model.ListAccessKeysRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAccessKeysIterable responses = client.listAccessKeysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListAccessKeysIterable responses = client.listAccessKeysPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListAccessKeysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAccessKeysIterable responses = client.listAccessKeysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccessKeys(software.amazon.awssdk.services.iam.model.ListAccessKeysRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListAccessKeys
     * @see #listAccessKeysPaginator(ListAccessKeysRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccessKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAccessKeysIterable listAccessKeysPaginator() throws NoSuchEntityException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        return listAccessKeysPaginator(ListAccessKeysRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about the access key IDs associated with the specified IAM user. If there is none, the
     * operation returns an empty list.
     * </p>
     * <p>
     * Although each user is limited to a small number of keys, you can still paginate the results using the
     * <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * If the <code>UserName</code> field is not specified, the user name is determined implicitly based on the AWS
     * access key ID used to sign the request. This operation works for access keys under the AWS account. Consequently,
     * you can use this operation to manage AWS account root user credentials even if the AWS account has no associated
     * users.
     * </p>
     * <note>
     * <p>
     * To ensure the security of your AWS account, the secret access key is accessible only during key and user
     * creation.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of {@link #listAccessKeys(software.amazon.awssdk.services.iam.model.ListAccessKeysRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAccessKeysIterable responses = client.listAccessKeysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListAccessKeysIterable responses = client.listAccessKeysPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListAccessKeysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAccessKeysIterable responses = client.listAccessKeysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccessKeys(software.amazon.awssdk.services.iam.model.ListAccessKeysRequest)} operation.</b>
     * </p>
     *
     * @param listAccessKeysRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListAccessKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccessKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAccessKeysIterable listAccessKeysPaginator(ListAccessKeysRequest listAccessKeysRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the access key IDs associated with the specified IAM user. If there is none, the
     * operation returns an empty list.
     * </p>
     * <p>
     * Although each user is limited to a small number of keys, you can still paginate the results using the
     * <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * If the <code>UserName</code> field is not specified, the user name is determined implicitly based on the AWS
     * access key ID used to sign the request. This operation works for access keys under the AWS account. Consequently,
     * you can use this operation to manage AWS account root user credentials even if the AWS account has no associated
     * users.
     * </p>
     * <note>
     * <p>
     * To ensure the security of your AWS account, the secret access key is accessible only during key and user
     * creation.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of {@link #listAccessKeys(software.amazon.awssdk.services.iam.model.ListAccessKeysRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAccessKeysIterable responses = client.listAccessKeysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListAccessKeysIterable responses = client.listAccessKeysPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListAccessKeysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAccessKeysIterable responses = client.listAccessKeysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccessKeys(software.amazon.awssdk.services.iam.model.ListAccessKeysRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessKeysRequest.Builder} avoiding the need to
     * create one manually via {@link ListAccessKeysRequest#builder()}
     * </p>
     *
     * @param listAccessKeysRequest
     *        A {@link Consumer} that will call methods on {@link ListAccessKeysRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListAccessKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccessKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAccessKeysIterable listAccessKeysPaginator(Consumer<ListAccessKeysRequest.Builder> listAccessKeysRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listAccessKeysPaginator(ListAccessKeysRequest.builder().applyMutation(listAccessKeysRequest).build());
    }

    /**
     * <p>
     * Lists the account alias associated with the AWS account (Note: you can have only one). For information about
     * using an AWS account alias, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AccountAlias.html">Using an alias for your AWS account
     * ID</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @return Result of the ListAccountAliases operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListAccountAliases
     * @see #listAccountAliases(ListAccountAliasesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccountAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAccountAliasesResponse listAccountAliases() throws ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        return listAccountAliases(ListAccountAliasesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the account alias associated with the AWS account (Note: you can have only one). For information about
     * using an AWS account alias, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AccountAlias.html">Using an alias for your AWS account
     * ID</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param listAccountAliasesRequest
     * @return Result of the ListAccountAliases operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListAccountAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccountAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAccountAliasesResponse listAccountAliases(ListAccountAliasesRequest listAccountAliasesRequest)
            throws ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the account alias associated with the AWS account (Note: you can have only one). For information about
     * using an AWS account alias, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AccountAlias.html">Using an alias for your AWS account
     * ID</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountAliasesRequest.Builder} avoiding the
     * need to create one manually via {@link ListAccountAliasesRequest#builder()}
     * </p>
     *
     * @param listAccountAliasesRequest
     *        A {@link Consumer} that will call methods on {@link ListAccountAliasesRequest.Builder} to create a
     *        request.
     * @return Result of the ListAccountAliases operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListAccountAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccountAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAccountAliasesResponse listAccountAliases(Consumer<ListAccountAliasesRequest.Builder> listAccountAliasesRequest)
            throws ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listAccountAliases(ListAccountAliasesRequest.builder().applyMutation(listAccountAliasesRequest).build());
    }

    /**
     * <p>
     * Lists the account alias associated with the AWS account (Note: you can have only one). For information about
     * using an AWS account alias, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AccountAlias.html">Using an alias for your AWS account
     * ID</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccountAliases(software.amazon.awssdk.services.iam.model.ListAccountAliasesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAccountAliasesIterable responses = client.listAccountAliasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListAccountAliasesIterable responses = client
     *             .listAccountAliasesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListAccountAliasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAccountAliasesIterable responses = client.listAccountAliasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAliases(software.amazon.awssdk.services.iam.model.ListAccountAliasesRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListAccountAliases
     * @see #listAccountAliasesPaginator(ListAccountAliasesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccountAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAccountAliasesIterable listAccountAliasesPaginator() throws ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        return listAccountAliasesPaginator(ListAccountAliasesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the account alias associated with the AWS account (Note: you can have only one). For information about
     * using an AWS account alias, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AccountAlias.html">Using an alias for your AWS account
     * ID</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccountAliases(software.amazon.awssdk.services.iam.model.ListAccountAliasesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAccountAliasesIterable responses = client.listAccountAliasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListAccountAliasesIterable responses = client
     *             .listAccountAliasesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListAccountAliasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAccountAliasesIterable responses = client.listAccountAliasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAliases(software.amazon.awssdk.services.iam.model.ListAccountAliasesRequest)} operation.</b>
     * </p>
     *
     * @param listAccountAliasesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListAccountAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccountAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAccountAliasesIterable listAccountAliasesPaginator(ListAccountAliasesRequest listAccountAliasesRequest)
            throws ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the account alias associated with the AWS account (Note: you can have only one). For information about
     * using an AWS account alias, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AccountAlias.html">Using an alias for your AWS account
     * ID</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccountAliases(software.amazon.awssdk.services.iam.model.ListAccountAliasesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAccountAliasesIterable responses = client.listAccountAliasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListAccountAliasesIterable responses = client
     *             .listAccountAliasesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListAccountAliasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAccountAliasesIterable responses = client.listAccountAliasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAliases(software.amazon.awssdk.services.iam.model.ListAccountAliasesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountAliasesRequest.Builder} avoiding the
     * need to create one manually via {@link ListAccountAliasesRequest#builder()}
     * </p>
     *
     * @param listAccountAliasesRequest
     *        A {@link Consumer} that will call methods on {@link ListAccountAliasesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListAccountAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccountAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAccountAliasesIterable listAccountAliasesPaginator(
            Consumer<ListAccountAliasesRequest.Builder> listAccountAliasesRequest) throws ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        return listAccountAliasesPaginator(ListAccountAliasesRequest.builder().applyMutation(listAccountAliasesRequest).build());
    }

    /**
     * <p>
     * Lists all managed policies that are attached to the specified IAM group.
     * </p>
     * <p>
     * An IAM group can also have inline policies embedded with it. To list the inline policies for a group, use
     * <a>ListGroupPolicies</a>. For information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. You can use the
     * <code>PathPrefix</code> parameter to limit the list of policies to only those matching the specified path prefix.
     * If there are no policies attached to the specified group (or none that match the specified path prefix), the
     * operation returns an empty list.
     * </p>
     *
     * @param listAttachedGroupPoliciesRequest
     * @return Result of the ListAttachedGroupPolicies operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListAttachedGroupPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedGroupPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAttachedGroupPoliciesResponse listAttachedGroupPolicies(
            ListAttachedGroupPoliciesRequest listAttachedGroupPoliciesRequest) throws NoSuchEntityException,
            InvalidInputException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all managed policies that are attached to the specified IAM group.
     * </p>
     * <p>
     * An IAM group can also have inline policies embedded with it. To list the inline policies for a group, use
     * <a>ListGroupPolicies</a>. For information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. You can use the
     * <code>PathPrefix</code> parameter to limit the list of policies to only those matching the specified path prefix.
     * If there are no policies attached to the specified group (or none that match the specified path prefix), the
     * operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttachedGroupPoliciesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAttachedGroupPoliciesRequest#builder()}
     * </p>
     *
     * @param listAttachedGroupPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListAttachedGroupPoliciesRequest.Builder} to create a
     *        request.
     * @return Result of the ListAttachedGroupPolicies operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListAttachedGroupPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedGroupPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAttachedGroupPoliciesResponse listAttachedGroupPolicies(
            Consumer<ListAttachedGroupPoliciesRequest.Builder> listAttachedGroupPoliciesRequest) throws NoSuchEntityException,
            InvalidInputException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listAttachedGroupPolicies(ListAttachedGroupPoliciesRequest.builder()
                .applyMutation(listAttachedGroupPoliciesRequest).build());
    }

    /**
     * <p>
     * Lists all managed policies that are attached to the specified IAM group.
     * </p>
     * <p>
     * An IAM group can also have inline policies embedded with it. To list the inline policies for a group, use
     * <a>ListGroupPolicies</a>. For information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. You can use the
     * <code>PathPrefix</code> parameter to limit the list of policies to only those matching the specified path prefix.
     * If there are no policies attached to the specified group (or none that match the specified path prefix), the
     * operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAttachedGroupPolicies(software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAttachedGroupPoliciesIterable responses = client.listAttachedGroupPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListAttachedGroupPoliciesIterable responses = client
     *             .listAttachedGroupPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAttachedGroupPoliciesIterable responses = client.listAttachedGroupPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttachedGroupPolicies(software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAttachedGroupPoliciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListAttachedGroupPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedGroupPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAttachedGroupPoliciesIterable listAttachedGroupPoliciesPaginator(
            ListAttachedGroupPoliciesRequest listAttachedGroupPoliciesRequest) throws NoSuchEntityException,
            InvalidInputException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all managed policies that are attached to the specified IAM group.
     * </p>
     * <p>
     * An IAM group can also have inline policies embedded with it. To list the inline policies for a group, use
     * <a>ListGroupPolicies</a>. For information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. You can use the
     * <code>PathPrefix</code> parameter to limit the list of policies to only those matching the specified path prefix.
     * If there are no policies attached to the specified group (or none that match the specified path prefix), the
     * operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAttachedGroupPolicies(software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAttachedGroupPoliciesIterable responses = client.listAttachedGroupPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListAttachedGroupPoliciesIterable responses = client
     *             .listAttachedGroupPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAttachedGroupPoliciesIterable responses = client.listAttachedGroupPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttachedGroupPolicies(software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttachedGroupPoliciesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAttachedGroupPoliciesRequest#builder()}
     * </p>
     *
     * @param listAttachedGroupPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListAttachedGroupPoliciesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListAttachedGroupPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedGroupPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAttachedGroupPoliciesIterable listAttachedGroupPoliciesPaginator(
            Consumer<ListAttachedGroupPoliciesRequest.Builder> listAttachedGroupPoliciesRequest) throws NoSuchEntityException,
            InvalidInputException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listAttachedGroupPoliciesPaginator(ListAttachedGroupPoliciesRequest.builder()
                .applyMutation(listAttachedGroupPoliciesRequest).build());
    }

    /**
     * <p>
     * Lists all managed policies that are attached to the specified IAM role.
     * </p>
     * <p>
     * An IAM role can also have inline policies embedded with it. To list the inline policies for a role, use
     * <a>ListRolePolicies</a>. For information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. You can use the
     * <code>PathPrefix</code> parameter to limit the list of policies to only those matching the specified path prefix.
     * If there are no policies attached to the specified role (or none that match the specified path prefix), the
     * operation returns an empty list.
     * </p>
     *
     * @param listAttachedRolePoliciesRequest
     * @return Result of the ListAttachedRolePolicies operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListAttachedRolePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedRolePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAttachedRolePoliciesResponse listAttachedRolePolicies(
            ListAttachedRolePoliciesRequest listAttachedRolePoliciesRequest) throws NoSuchEntityException, InvalidInputException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all managed policies that are attached to the specified IAM role.
     * </p>
     * <p>
     * An IAM role can also have inline policies embedded with it. To list the inline policies for a role, use
     * <a>ListRolePolicies</a>. For information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. You can use the
     * <code>PathPrefix</code> parameter to limit the list of policies to only those matching the specified path prefix.
     * If there are no policies attached to the specified role (or none that match the specified path prefix), the
     * operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttachedRolePoliciesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAttachedRolePoliciesRequest#builder()}
     * </p>
     *
     * @param listAttachedRolePoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListAttachedRolePoliciesRequest.Builder} to create a
     *        request.
     * @return Result of the ListAttachedRolePolicies operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListAttachedRolePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedRolePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAttachedRolePoliciesResponse listAttachedRolePolicies(
            Consumer<ListAttachedRolePoliciesRequest.Builder> listAttachedRolePoliciesRequest) throws NoSuchEntityException,
            InvalidInputException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listAttachedRolePolicies(ListAttachedRolePoliciesRequest.builder().applyMutation(listAttachedRolePoliciesRequest)
                .build());
    }

    /**
     * <p>
     * Lists all managed policies that are attached to the specified IAM role.
     * </p>
     * <p>
     * An IAM role can also have inline policies embedded with it. To list the inline policies for a role, use
     * <a>ListRolePolicies</a>. For information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. You can use the
     * <code>PathPrefix</code> parameter to limit the list of policies to only those matching the specified path prefix.
     * If there are no policies attached to the specified role (or none that match the specified path prefix), the
     * operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAttachedRolePolicies(software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAttachedRolePoliciesIterable responses = client.listAttachedRolePoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListAttachedRolePoliciesIterable responses = client
     *             .listAttachedRolePoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAttachedRolePoliciesIterable responses = client.listAttachedRolePoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttachedRolePolicies(software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAttachedRolePoliciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListAttachedRolePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedRolePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAttachedRolePoliciesIterable listAttachedRolePoliciesPaginator(
            ListAttachedRolePoliciesRequest listAttachedRolePoliciesRequest) throws NoSuchEntityException, InvalidInputException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all managed policies that are attached to the specified IAM role.
     * </p>
     * <p>
     * An IAM role can also have inline policies embedded with it. To list the inline policies for a role, use
     * <a>ListRolePolicies</a>. For information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. You can use the
     * <code>PathPrefix</code> parameter to limit the list of policies to only those matching the specified path prefix.
     * If there are no policies attached to the specified role (or none that match the specified path prefix), the
     * operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAttachedRolePolicies(software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAttachedRolePoliciesIterable responses = client.listAttachedRolePoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListAttachedRolePoliciesIterable responses = client
     *             .listAttachedRolePoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAttachedRolePoliciesIterable responses = client.listAttachedRolePoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttachedRolePolicies(software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttachedRolePoliciesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAttachedRolePoliciesRequest#builder()}
     * </p>
     *
     * @param listAttachedRolePoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListAttachedRolePoliciesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListAttachedRolePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedRolePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAttachedRolePoliciesIterable listAttachedRolePoliciesPaginator(
            Consumer<ListAttachedRolePoliciesRequest.Builder> listAttachedRolePoliciesRequest) throws NoSuchEntityException,
            InvalidInputException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listAttachedRolePoliciesPaginator(ListAttachedRolePoliciesRequest.builder()
                .applyMutation(listAttachedRolePoliciesRequest).build());
    }

    /**
     * <p>
     * Lists all managed policies that are attached to the specified IAM user.
     * </p>
     * <p>
     * An IAM user can also have inline policies embedded with it. To list the inline policies for a user, use
     * <a>ListUserPolicies</a>. For information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. You can use the
     * <code>PathPrefix</code> parameter to limit the list of policies to only those matching the specified path prefix.
     * If there are no policies attached to the specified group (or none that match the specified path prefix), the
     * operation returns an empty list.
     * </p>
     *
     * @param listAttachedUserPoliciesRequest
     * @return Result of the ListAttachedUserPolicies operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListAttachedUserPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedUserPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAttachedUserPoliciesResponse listAttachedUserPolicies(
            ListAttachedUserPoliciesRequest listAttachedUserPoliciesRequest) throws NoSuchEntityException, InvalidInputException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all managed policies that are attached to the specified IAM user.
     * </p>
     * <p>
     * An IAM user can also have inline policies embedded with it. To list the inline policies for a user, use
     * <a>ListUserPolicies</a>. For information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. You can use the
     * <code>PathPrefix</code> parameter to limit the list of policies to only those matching the specified path prefix.
     * If there are no policies attached to the specified group (or none that match the specified path prefix), the
     * operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttachedUserPoliciesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAttachedUserPoliciesRequest#builder()}
     * </p>
     *
     * @param listAttachedUserPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListAttachedUserPoliciesRequest.Builder} to create a
     *        request.
     * @return Result of the ListAttachedUserPolicies operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListAttachedUserPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedUserPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAttachedUserPoliciesResponse listAttachedUserPolicies(
            Consumer<ListAttachedUserPoliciesRequest.Builder> listAttachedUserPoliciesRequest) throws NoSuchEntityException,
            InvalidInputException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listAttachedUserPolicies(ListAttachedUserPoliciesRequest.builder().applyMutation(listAttachedUserPoliciesRequest)
                .build());
    }

    /**
     * <p>
     * Lists all managed policies that are attached to the specified IAM user.
     * </p>
     * <p>
     * An IAM user can also have inline policies embedded with it. To list the inline policies for a user, use
     * <a>ListUserPolicies</a>. For information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. You can use the
     * <code>PathPrefix</code> parameter to limit the list of policies to only those matching the specified path prefix.
     * If there are no policies attached to the specified group (or none that match the specified path prefix), the
     * operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAttachedUserPolicies(software.amazon.awssdk.services.iam.model.ListAttachedUserPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAttachedUserPoliciesIterable responses = client.listAttachedUserPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListAttachedUserPoliciesIterable responses = client
     *             .listAttachedUserPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListAttachedUserPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAttachedUserPoliciesIterable responses = client.listAttachedUserPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttachedUserPolicies(software.amazon.awssdk.services.iam.model.ListAttachedUserPoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAttachedUserPoliciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListAttachedUserPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedUserPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAttachedUserPoliciesIterable listAttachedUserPoliciesPaginator(
            ListAttachedUserPoliciesRequest listAttachedUserPoliciesRequest) throws NoSuchEntityException, InvalidInputException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all managed policies that are attached to the specified IAM user.
     * </p>
     * <p>
     * An IAM user can also have inline policies embedded with it. To list the inline policies for a user, use
     * <a>ListUserPolicies</a>. For information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. You can use the
     * <code>PathPrefix</code> parameter to limit the list of policies to only those matching the specified path prefix.
     * If there are no policies attached to the specified group (or none that match the specified path prefix), the
     * operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAttachedUserPolicies(software.amazon.awssdk.services.iam.model.ListAttachedUserPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAttachedUserPoliciesIterable responses = client.listAttachedUserPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListAttachedUserPoliciesIterable responses = client
     *             .listAttachedUserPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListAttachedUserPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAttachedUserPoliciesIterable responses = client.listAttachedUserPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttachedUserPolicies(software.amazon.awssdk.services.iam.model.ListAttachedUserPoliciesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttachedUserPoliciesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAttachedUserPoliciesRequest#builder()}
     * </p>
     *
     * @param listAttachedUserPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListAttachedUserPoliciesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListAttachedUserPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedUserPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAttachedUserPoliciesIterable listAttachedUserPoliciesPaginator(
            Consumer<ListAttachedUserPoliciesRequest.Builder> listAttachedUserPoliciesRequest) throws NoSuchEntityException,
            InvalidInputException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listAttachedUserPoliciesPaginator(ListAttachedUserPoliciesRequest.builder()
                .applyMutation(listAttachedUserPoliciesRequest).build());
    }

    /**
     * <p>
     * Lists all IAM users, groups, and roles that the specified managed policy is attached to.
     * </p>
     * <p>
     * You can use the optional <code>EntityFilter</code> parameter to limit the results to a particular type of entity
     * (users, groups, or roles). For example, to list only the roles that are attached to the specified policy, set
     * <code>EntityFilter</code> to <code>Role</code>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listEntitiesForPolicyRequest
     * @return Result of the ListEntitiesForPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListEntitiesForPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListEntitiesForPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEntitiesForPolicyResponse listEntitiesForPolicy(ListEntitiesForPolicyRequest listEntitiesForPolicyRequest)
            throws NoSuchEntityException, InvalidInputException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all IAM users, groups, and roles that the specified managed policy is attached to.
     * </p>
     * <p>
     * You can use the optional <code>EntityFilter</code> parameter to limit the results to a particular type of entity
     * (users, groups, or roles). For example, to list only the roles that are attached to the specified policy, set
     * <code>EntityFilter</code> to <code>Role</code>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntitiesForPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link ListEntitiesForPolicyRequest#builder()}
     * </p>
     *
     * @param listEntitiesForPolicyRequest
     *        A {@link Consumer} that will call methods on {@link ListEntitiesForPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the ListEntitiesForPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListEntitiesForPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListEntitiesForPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEntitiesForPolicyResponse listEntitiesForPolicy(
            Consumer<ListEntitiesForPolicyRequest.Builder> listEntitiesForPolicyRequest) throws NoSuchEntityException,
            InvalidInputException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listEntitiesForPolicy(ListEntitiesForPolicyRequest.builder().applyMutation(listEntitiesForPolicyRequest).build());
    }

    /**
     * <p>
     * Lists all IAM users, groups, and roles that the specified managed policy is attached to.
     * </p>
     * <p>
     * You can use the optional <code>EntityFilter</code> parameter to limit the results to a particular type of entity
     * (users, groups, or roles). For example, to list only the roles that are attached to the specified policy, set
     * <code>EntityFilter</code> to <code>Role</code>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntitiesForPolicy(software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListEntitiesForPolicyIterable responses = client.listEntitiesForPolicyPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListEntitiesForPolicyIterable responses = client
     *             .listEntitiesForPolicyPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListEntitiesForPolicyIterable responses = client.listEntitiesForPolicyPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntitiesForPolicy(software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEntitiesForPolicyRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListEntitiesForPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListEntitiesForPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEntitiesForPolicyIterable listEntitiesForPolicyPaginator(ListEntitiesForPolicyRequest listEntitiesForPolicyRequest)
            throws NoSuchEntityException, InvalidInputException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all IAM users, groups, and roles that the specified managed policy is attached to.
     * </p>
     * <p>
     * You can use the optional <code>EntityFilter</code> parameter to limit the results to a particular type of entity
     * (users, groups, or roles). For example, to list only the roles that are attached to the specified policy, set
     * <code>EntityFilter</code> to <code>Role</code>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntitiesForPolicy(software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListEntitiesForPolicyIterable responses = client.listEntitiesForPolicyPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListEntitiesForPolicyIterable responses = client
     *             .listEntitiesForPolicyPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListEntitiesForPolicyIterable responses = client.listEntitiesForPolicyPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntitiesForPolicy(software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntitiesForPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link ListEntitiesForPolicyRequest#builder()}
     * </p>
     *
     * @param listEntitiesForPolicyRequest
     *        A {@link Consumer} that will call methods on {@link ListEntitiesForPolicyRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListEntitiesForPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListEntitiesForPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEntitiesForPolicyIterable listEntitiesForPolicyPaginator(
            Consumer<ListEntitiesForPolicyRequest.Builder> listEntitiesForPolicyRequest) throws NoSuchEntityException,
            InvalidInputException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listEntitiesForPolicyPaginator(ListEntitiesForPolicyRequest.builder().applyMutation(listEntitiesForPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Lists the names of the inline policies that are embedded in the specified IAM group.
     * </p>
     * <p>
     * An IAM group can also have managed policies attached to it. To list the managed policies that are attached to a
     * group, use <a>ListAttachedGroupPolicies</a>. For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. If there are no
     * inline policies embedded with the specified group, the operation returns an empty list.
     * </p>
     *
     * @param listGroupPoliciesRequest
     * @return Result of the ListGroupPolicies operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListGroupPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroupPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupPoliciesResponse listGroupPolicies(ListGroupPoliciesRequest listGroupPoliciesRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the names of the inline policies that are embedded in the specified IAM group.
     * </p>
     * <p>
     * An IAM group can also have managed policies attached to it. To list the managed policies that are attached to a
     * group, use <a>ListAttachedGroupPolicies</a>. For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. If there are no
     * inline policies embedded with the specified group, the operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupPoliciesRequest.Builder} avoiding the need
     * to create one manually via {@link ListGroupPoliciesRequest#builder()}
     * </p>
     *
     * @param listGroupPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupPoliciesRequest.Builder} to create a request.
     * @return Result of the ListGroupPolicies operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListGroupPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroupPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupPoliciesResponse listGroupPolicies(Consumer<ListGroupPoliciesRequest.Builder> listGroupPoliciesRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listGroupPolicies(ListGroupPoliciesRequest.builder().applyMutation(listGroupPoliciesRequest).build());
    }

    /**
     * <p>
     * Lists the names of the inline policies that are embedded in the specified IAM group.
     * </p>
     * <p>
     * An IAM group can also have managed policies attached to it. To list the managed policies that are attached to a
     * group, use <a>ListAttachedGroupPolicies</a>. For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. If there are no
     * inline policies embedded with the specified group, the operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGroupPolicies(software.amazon.awssdk.services.iam.model.ListGroupPoliciesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListGroupPoliciesIterable responses = client.listGroupPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListGroupPoliciesIterable responses = client
     *             .listGroupPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListGroupPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListGroupPoliciesIterable responses = client.listGroupPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroupPolicies(software.amazon.awssdk.services.iam.model.ListGroupPoliciesRequest)} operation.</b>
     * </p>
     *
     * @param listGroupPoliciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListGroupPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroupPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupPoliciesIterable listGroupPoliciesPaginator(ListGroupPoliciesRequest listGroupPoliciesRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the names of the inline policies that are embedded in the specified IAM group.
     * </p>
     * <p>
     * An IAM group can also have managed policies attached to it. To list the managed policies that are attached to a
     * group, use <a>ListAttachedGroupPolicies</a>. For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. If there are no
     * inline policies embedded with the specified group, the operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGroupPolicies(software.amazon.awssdk.services.iam.model.ListGroupPoliciesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListGroupPoliciesIterable responses = client.listGroupPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListGroupPoliciesIterable responses = client
     *             .listGroupPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListGroupPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListGroupPoliciesIterable responses = client.listGroupPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroupPolicies(software.amazon.awssdk.services.iam.model.ListGroupPoliciesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupPoliciesRequest.Builder} avoiding the need
     * to create one manually via {@link ListGroupPoliciesRequest#builder()}
     * </p>
     *
     * @param listGroupPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupPoliciesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListGroupPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroupPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupPoliciesIterable listGroupPoliciesPaginator(
            Consumer<ListGroupPoliciesRequest.Builder> listGroupPoliciesRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listGroupPoliciesPaginator(ListGroupPoliciesRequest.builder().applyMutation(listGroupPoliciesRequest).build());
    }

    /**
     * <p>
     * Lists the IAM groups that have the specified path prefix.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @return Result of the ListGroups operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListGroups
     * @see #listGroups(ListGroupsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsResponse listGroups() throws ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listGroups(ListGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the IAM groups that have the specified path prefix.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listGroupsRequest
     * @return Result of the ListGroups operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsResponse listGroups(ListGroupsRequest listGroupsRequest) throws ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the IAM groups that have the specified path prefix.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGroupsRequest#builder()}
     * </p>
     *
     * @param listGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupsRequest.Builder} to create a request.
     * @return Result of the ListGroups operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsResponse listGroups(Consumer<ListGroupsRequest.Builder> listGroupsRequest) throws ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        return listGroups(ListGroupsRequest.builder().applyMutation(listGroupsRequest).build());
    }

    /**
     * <p>
     * Lists the IAM groups that have the specified path prefix.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listGroups(software.amazon.awssdk.services.iam.model.ListGroupsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListGroupsIterable responses = client.listGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListGroupsIterable responses = client.listGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListGroupsIterable responses = client.listGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroups(software.amazon.awssdk.services.iam.model.ListGroupsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListGroups
     * @see #listGroupsPaginator(ListGroupsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsIterable listGroupsPaginator() throws ServiceFailureException, AwsServiceException, SdkClientException,
            IamException {
        return listGroupsPaginator(ListGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the IAM groups that have the specified path prefix.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listGroups(software.amazon.awssdk.services.iam.model.ListGroupsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListGroupsIterable responses = client.listGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListGroupsIterable responses = client.listGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListGroupsIterable responses = client.listGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroups(software.amazon.awssdk.services.iam.model.ListGroupsRequest)} operation.</b>
     * </p>
     *
     * @param listGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsIterable listGroupsPaginator(ListGroupsRequest listGroupsRequest) throws ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the IAM groups that have the specified path prefix.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listGroups(software.amazon.awssdk.services.iam.model.ListGroupsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListGroupsIterable responses = client.listGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListGroupsIterable responses = client.listGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListGroupsIterable responses = client.listGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroups(software.amazon.awssdk.services.iam.model.ListGroupsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGroupsRequest#builder()}
     * </p>
     *
     * @param listGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsIterable listGroupsPaginator(Consumer<ListGroupsRequest.Builder> listGroupsRequest)
            throws ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listGroupsPaginator(ListGroupsRequest.builder().applyMutation(listGroupsRequest).build());
    }

    /**
     * <p>
     * Lists the IAM groups that the specified IAM user belongs to.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listGroupsForUserRequest
     * @return Result of the ListGroupsForUser operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListGroupsForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroupsForUser" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsForUserResponse listGroupsForUser(ListGroupsForUserRequest listGroupsForUserRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the IAM groups that the specified IAM user belongs to.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsForUserRequest.Builder} avoiding the need
     * to create one manually via {@link ListGroupsForUserRequest#builder()}
     * </p>
     *
     * @param listGroupsForUserRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupsForUserRequest.Builder} to create a request.
     * @return Result of the ListGroupsForUser operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListGroupsForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroupsForUser" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsForUserResponse listGroupsForUser(Consumer<ListGroupsForUserRequest.Builder> listGroupsForUserRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listGroupsForUser(ListGroupsForUserRequest.builder().applyMutation(listGroupsForUserRequest).build());
    }

    /**
     * <p>
     * Lists the IAM groups that the specified IAM user belongs to.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGroupsForUser(software.amazon.awssdk.services.iam.model.ListGroupsForUserRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListGroupsForUserIterable responses = client.listGroupsForUserPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListGroupsForUserIterable responses = client
     *             .listGroupsForUserPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListGroupsForUserResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListGroupsForUserIterable responses = client.listGroupsForUserPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroupsForUser(software.amazon.awssdk.services.iam.model.ListGroupsForUserRequest)} operation.</b>
     * </p>
     *
     * @param listGroupsForUserRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListGroupsForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroupsForUser" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsForUserIterable listGroupsForUserPaginator(ListGroupsForUserRequest listGroupsForUserRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the IAM groups that the specified IAM user belongs to.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGroupsForUser(software.amazon.awssdk.services.iam.model.ListGroupsForUserRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListGroupsForUserIterable responses = client.listGroupsForUserPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListGroupsForUserIterable responses = client
     *             .listGroupsForUserPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListGroupsForUserResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListGroupsForUserIterable responses = client.listGroupsForUserPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroupsForUser(software.amazon.awssdk.services.iam.model.ListGroupsForUserRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsForUserRequest.Builder} avoiding the need
     * to create one manually via {@link ListGroupsForUserRequest#builder()}
     * </p>
     *
     * @param listGroupsForUserRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupsForUserRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListGroupsForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroupsForUser" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsForUserIterable listGroupsForUserPaginator(
            Consumer<ListGroupsForUserRequest.Builder> listGroupsForUserRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listGroupsForUserPaginator(ListGroupsForUserRequest.builder().applyMutation(listGroupsForUserRequest).build());
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified IAM instance profile. The returned list of tags is sorted by
     * tag key. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     *
     * @param listInstanceProfileTagsRequest
     * @return Result of the ListInstanceProfileTags operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListInstanceProfileTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfileTags" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInstanceProfileTagsResponse listInstanceProfileTags(ListInstanceProfileTagsRequest listInstanceProfileTagsRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified IAM instance profile. The returned list of tags is sorted by
     * tag key. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceProfileTagsRequest.Builder} avoiding
     * the need to create one manually via {@link ListInstanceProfileTagsRequest#builder()}
     * </p>
     *
     * @param listInstanceProfileTagsRequest
     *        A {@link Consumer} that will call methods on {@link ListInstanceProfileTagsRequest.Builder} to create a
     *        request.
     * @return Result of the ListInstanceProfileTags operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListInstanceProfileTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfileTags" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInstanceProfileTagsResponse listInstanceProfileTags(
            Consumer<ListInstanceProfileTagsRequest.Builder> listInstanceProfileTagsRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listInstanceProfileTags(ListInstanceProfileTagsRequest.builder().applyMutation(listInstanceProfileTagsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the instance profiles that have the specified path prefix. If there are none, the operation returns an
     * empty list. For more information about instance profiles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About instance profiles</a>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for an instance profile, see <a>GetInstanceProfile</a>.
     * </p>
     * </note>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @return Result of the ListInstanceProfiles operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListInstanceProfiles
     * @see #listInstanceProfiles(ListInstanceProfilesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInstanceProfilesResponse listInstanceProfiles() throws ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        return listInstanceProfiles(ListInstanceProfilesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the instance profiles that have the specified path prefix. If there are none, the operation returns an
     * empty list. For more information about instance profiles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About instance profiles</a>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for an instance profile, see <a>GetInstanceProfile</a>.
     * </p>
     * </note>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listInstanceProfilesRequest
     * @return Result of the ListInstanceProfiles operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListInstanceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInstanceProfilesResponse listInstanceProfiles(ListInstanceProfilesRequest listInstanceProfilesRequest)
            throws ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the instance profiles that have the specified path prefix. If there are none, the operation returns an
     * empty list. For more information about instance profiles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About instance profiles</a>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for an instance profile, see <a>GetInstanceProfile</a>.
     * </p>
     * </note>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListInstanceProfilesRequest#builder()}
     * </p>
     *
     * @param listInstanceProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListInstanceProfilesRequest.Builder} to create a
     *        request.
     * @return Result of the ListInstanceProfiles operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListInstanceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInstanceProfilesResponse listInstanceProfiles(
            Consumer<ListInstanceProfilesRequest.Builder> listInstanceProfilesRequest) throws ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        return listInstanceProfiles(ListInstanceProfilesRequest.builder().applyMutation(listInstanceProfilesRequest).build());
    }

    /**
     * <p>
     * Lists the instance profiles that have the specified path prefix. If there are none, the operation returns an
     * empty list. For more information about instance profiles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About instance profiles</a>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for an instance profile, see <a>GetInstanceProfile</a>.
     * </p>
     * </note>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInstanceProfiles(software.amazon.awssdk.services.iam.model.ListInstanceProfilesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesIterable responses = client.listInstanceProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesIterable responses = client
     *             .listInstanceProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListInstanceProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesIterable responses = client.listInstanceProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceProfiles(software.amazon.awssdk.services.iam.model.ListInstanceProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListInstanceProfiles
     * @see #listInstanceProfilesPaginator(ListInstanceProfilesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInstanceProfilesIterable listInstanceProfilesPaginator() throws ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        return listInstanceProfilesPaginator(ListInstanceProfilesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the instance profiles that have the specified path prefix. If there are none, the operation returns an
     * empty list. For more information about instance profiles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About instance profiles</a>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for an instance profile, see <a>GetInstanceProfile</a>.
     * </p>
     * </note>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInstanceProfiles(software.amazon.awssdk.services.iam.model.ListInstanceProfilesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesIterable responses = client.listInstanceProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesIterable responses = client
     *             .listInstanceProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListInstanceProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesIterable responses = client.listInstanceProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceProfiles(software.amazon.awssdk.services.iam.model.ListInstanceProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInstanceProfilesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListInstanceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInstanceProfilesIterable listInstanceProfilesPaginator(ListInstanceProfilesRequest listInstanceProfilesRequest)
            throws ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the instance profiles that have the specified path prefix. If there are none, the operation returns an
     * empty list. For more information about instance profiles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About instance profiles</a>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for an instance profile, see <a>GetInstanceProfile</a>.
     * </p>
     * </note>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInstanceProfiles(software.amazon.awssdk.services.iam.model.ListInstanceProfilesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesIterable responses = client.listInstanceProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesIterable responses = client
     *             .listInstanceProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListInstanceProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesIterable responses = client.listInstanceProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceProfiles(software.amazon.awssdk.services.iam.model.ListInstanceProfilesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListInstanceProfilesRequest#builder()}
     * </p>
     *
     * @param listInstanceProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListInstanceProfilesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListInstanceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInstanceProfilesIterable listInstanceProfilesPaginator(
            Consumer<ListInstanceProfilesRequest.Builder> listInstanceProfilesRequest) throws ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        return listInstanceProfilesPaginator(ListInstanceProfilesRequest.builder().applyMutation(listInstanceProfilesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the instance profiles that have the specified associated IAM role. If there are none, the operation returns
     * an empty list. For more information about instance profiles, go to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About instance profiles</a>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listInstanceProfilesForRoleRequest
     * @return Result of the ListInstanceProfilesForRole operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListInstanceProfilesForRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfilesForRole"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceProfilesForRoleResponse listInstanceProfilesForRole(
            ListInstanceProfilesForRoleRequest listInstanceProfilesForRoleRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the instance profiles that have the specified associated IAM role. If there are none, the operation returns
     * an empty list. For more information about instance profiles, go to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About instance profiles</a>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceProfilesForRoleRequest.Builder}
     * avoiding the need to create one manually via {@link ListInstanceProfilesForRoleRequest#builder()}
     * </p>
     *
     * @param listInstanceProfilesForRoleRequest
     *        A {@link Consumer} that will call methods on {@link ListInstanceProfilesForRoleRequest.Builder} to create
     *        a request.
     * @return Result of the ListInstanceProfilesForRole operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListInstanceProfilesForRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfilesForRole"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceProfilesForRoleResponse listInstanceProfilesForRole(
            Consumer<ListInstanceProfilesForRoleRequest.Builder> listInstanceProfilesForRoleRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listInstanceProfilesForRole(ListInstanceProfilesForRoleRequest.builder()
                .applyMutation(listInstanceProfilesForRoleRequest).build());
    }

    /**
     * <p>
     * Lists the instance profiles that have the specified associated IAM role. If there are none, the operation returns
     * an empty list. For more information about instance profiles, go to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About instance profiles</a>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInstanceProfilesForRole(software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesForRoleIterable responses = client.listInstanceProfilesForRolePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesForRoleIterable responses = client
     *             .listInstanceProfilesForRolePaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesForRoleIterable responses = client.listInstanceProfilesForRolePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceProfilesForRole(software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInstanceProfilesForRoleRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListInstanceProfilesForRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfilesForRole"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceProfilesForRoleIterable listInstanceProfilesForRolePaginator(
            ListInstanceProfilesForRoleRequest listInstanceProfilesForRoleRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the instance profiles that have the specified associated IAM role. If there are none, the operation returns
     * an empty list. For more information about instance profiles, go to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About instance profiles</a>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInstanceProfilesForRole(software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesForRoleIterable responses = client.listInstanceProfilesForRolePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesForRoleIterable responses = client
     *             .listInstanceProfilesForRolePaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesForRoleIterable responses = client.listInstanceProfilesForRolePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceProfilesForRole(software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceProfilesForRoleRequest.Builder}
     * avoiding the need to create one manually via {@link ListInstanceProfilesForRoleRequest#builder()}
     * </p>
     *
     * @param listInstanceProfilesForRoleRequest
     *        A {@link Consumer} that will call methods on {@link ListInstanceProfilesForRoleRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListInstanceProfilesForRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfilesForRole"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceProfilesForRoleIterable listInstanceProfilesForRolePaginator(
            Consumer<ListInstanceProfilesForRoleRequest.Builder> listInstanceProfilesForRoleRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listInstanceProfilesForRolePaginator(ListInstanceProfilesForRoleRequest.builder()
                .applyMutation(listInstanceProfilesForRoleRequest).build());
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified IAM virtual multi-factor authentication (MFA) device. The
     * returned list of tags is sorted by tag key. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     *
     * @param listMfaDeviceTagsRequest
     * @return Result of the ListMFADeviceTags operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListMFADeviceTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListMFADeviceTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMfaDeviceTagsResponse listMFADeviceTags(ListMfaDeviceTagsRequest listMfaDeviceTagsRequest)
            throws NoSuchEntityException, InvalidInputException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified IAM virtual multi-factor authentication (MFA) device. The
     * returned list of tags is sorted by tag key. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMfaDeviceTagsRequest.Builder} avoiding the need
     * to create one manually via {@link ListMfaDeviceTagsRequest#builder()}
     * </p>
     *
     * @param listMfaDeviceTagsRequest
     *        A {@link Consumer} that will call methods on {@link ListMFADeviceTagsRequest.Builder} to create a request.
     * @return Result of the ListMFADeviceTags operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListMFADeviceTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListMFADeviceTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMfaDeviceTagsResponse listMFADeviceTags(Consumer<ListMfaDeviceTagsRequest.Builder> listMfaDeviceTagsRequest)
            throws NoSuchEntityException, InvalidInputException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        return listMFADeviceTags(ListMfaDeviceTagsRequest.builder().applyMutation(listMfaDeviceTagsRequest).build());
    }

    /**
     * <p>
     * Lists the MFA devices for an IAM user. If the request includes a IAM user name, then this operation lists all the
     * MFA devices associated with the specified user. If you do not specify a user name, IAM determines the user name
     * implicitly based on the AWS access key ID signing the request for this operation.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @return Result of the ListMFADevices operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListMFADevices
     * @see #listMFADevices(ListMfaDevicesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListMFADevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMfaDevicesResponse listMFADevices() throws NoSuchEntityException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        return listMFADevices(ListMfaDevicesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the MFA devices for an IAM user. If the request includes a IAM user name, then this operation lists all the
     * MFA devices associated with the specified user. If you do not specify a user name, IAM determines the user name
     * implicitly based on the AWS access key ID signing the request for this operation.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listMfaDevicesRequest
     * @return Result of the ListMFADevices operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListMFADevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListMFADevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMfaDevicesResponse listMFADevices(ListMfaDevicesRequest listMfaDevicesRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the MFA devices for an IAM user. If the request includes a IAM user name, then this operation lists all the
     * MFA devices associated with the specified user. If you do not specify a user name, IAM determines the user name
     * implicitly based on the AWS access key ID signing the request for this operation.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMfaDevicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListMfaDevicesRequest#builder()}
     * </p>
     *
     * @param listMfaDevicesRequest
     *        A {@link Consumer} that will call methods on {@link ListMFADevicesRequest.Builder} to create a request.
     * @return Result of the ListMFADevices operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListMFADevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListMFADevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMfaDevicesResponse listMFADevices(Consumer<ListMfaDevicesRequest.Builder> listMfaDevicesRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listMFADevices(ListMfaDevicesRequest.builder().applyMutation(listMfaDevicesRequest).build());
    }

    /**
     * <p>
     * Lists the MFA devices for an IAM user. If the request includes a IAM user name, then this operation lists all the
     * MFA devices associated with the specified user. If you do not specify a user name, IAM determines the user name
     * implicitly based on the AWS access key ID signing the request for this operation.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listMFADevices(software.amazon.awssdk.services.iam.model.ListMfaDevicesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListMFADevicesIterable responses = client.listMFADevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListMFADevicesIterable responses = client.listMFADevicesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListMfaDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListMFADevicesIterable responses = client.listMFADevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMFADevices(software.amazon.awssdk.services.iam.model.ListMfaDevicesRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListMFADevices
     * @see #listMFADevicesPaginator(ListMfaDevicesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListMFADevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMFADevicesIterable listMFADevicesPaginator() throws NoSuchEntityException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        return listMFADevicesPaginator(ListMfaDevicesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the MFA devices for an IAM user. If the request includes a IAM user name, then this operation lists all the
     * MFA devices associated with the specified user. If you do not specify a user name, IAM determines the user name
     * implicitly based on the AWS access key ID signing the request for this operation.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listMFADevices(software.amazon.awssdk.services.iam.model.ListMfaDevicesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListMFADevicesIterable responses = client.listMFADevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListMFADevicesIterable responses = client.listMFADevicesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListMfaDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListMFADevicesIterable responses = client.listMFADevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMFADevices(software.amazon.awssdk.services.iam.model.ListMfaDevicesRequest)} operation.</b>
     * </p>
     *
     * @param listMfaDevicesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListMFADevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListMFADevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMFADevicesIterable listMFADevicesPaginator(ListMfaDevicesRequest listMfaDevicesRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the MFA devices for an IAM user. If the request includes a IAM user name, then this operation lists all the
     * MFA devices associated with the specified user. If you do not specify a user name, IAM determines the user name
     * implicitly based on the AWS access key ID signing the request for this operation.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listMFADevices(software.amazon.awssdk.services.iam.model.ListMfaDevicesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListMFADevicesIterable responses = client.listMFADevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListMFADevicesIterable responses = client.listMFADevicesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListMfaDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListMFADevicesIterable responses = client.listMFADevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMFADevices(software.amazon.awssdk.services.iam.model.ListMfaDevicesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMfaDevicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListMfaDevicesRequest#builder()}
     * </p>
     *
     * @param listMfaDevicesRequest
     *        A {@link Consumer} that will call methods on {@link ListMFADevicesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListMFADevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListMFADevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMFADevicesIterable listMFADevicesPaginator(Consumer<ListMfaDevicesRequest.Builder> listMfaDevicesRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listMFADevicesPaginator(ListMfaDevicesRequest.builder().applyMutation(listMfaDevicesRequest).build());
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified OpenID Connect (OIDC)-compatible identity provider. The
     * returned list of tags is sorted by tag key. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html">About web identity
     * federation</a>.
     * </p>
     * <p>
     * For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     *
     * @param listOpenIdConnectProviderTagsRequest
     * @return Result of the ListOpenIDConnectProviderTags operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListOpenIDConnectProviderTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListOpenIDConnectProviderTags"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOpenIdConnectProviderTagsResponse listOpenIDConnectProviderTags(
            ListOpenIdConnectProviderTagsRequest listOpenIdConnectProviderTagsRequest) throws NoSuchEntityException,
            ServiceFailureException, InvalidInputException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified OpenID Connect (OIDC)-compatible identity provider. The
     * returned list of tags is sorted by tag key. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html">About web identity
     * federation</a>.
     * </p>
     * <p>
     * For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOpenIdConnectProviderTagsRequest.Builder}
     * avoiding the need to create one manually via {@link ListOpenIdConnectProviderTagsRequest#builder()}
     * </p>
     *
     * @param listOpenIdConnectProviderTagsRequest
     *        A {@link Consumer} that will call methods on {@link ListOpenIDConnectProviderTagsRequest.Builder} to
     *        create a request.
     * @return Result of the ListOpenIDConnectProviderTags operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListOpenIDConnectProviderTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListOpenIDConnectProviderTags"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOpenIdConnectProviderTagsResponse listOpenIDConnectProviderTags(
            Consumer<ListOpenIdConnectProviderTagsRequest.Builder> listOpenIdConnectProviderTagsRequest)
            throws NoSuchEntityException, ServiceFailureException, InvalidInputException, AwsServiceException,
            SdkClientException, IamException {
        return listOpenIDConnectProviderTags(ListOpenIdConnectProviderTagsRequest.builder()
                .applyMutation(listOpenIdConnectProviderTagsRequest).build());
    }

    /**
     * <p>
     * Lists information about the IAM OpenID Connect (OIDC) provider resource objects defined in the AWS account.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for an OIDC provider, see <a>GetOpenIDConnectProvider</a>.
     * </p>
     * </note>
     *
     * @return Result of the ListOpenIDConnectProviders operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListOpenIDConnectProviders
     * @see #listOpenIDConnectProviders(ListOpenIdConnectProvidersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListOpenIDConnectProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOpenIdConnectProvidersResponse listOpenIDConnectProviders() throws ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        return listOpenIDConnectProviders(ListOpenIdConnectProvidersRequest.builder().build());
    }

    /**
     * <p>
     * Lists information about the IAM OpenID Connect (OIDC) provider resource objects defined in the AWS account.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for an OIDC provider, see <a>GetOpenIDConnectProvider</a>.
     * </p>
     * </note>
     *
     * @param listOpenIdConnectProvidersRequest
     * @return Result of the ListOpenIDConnectProviders operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListOpenIDConnectProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListOpenIDConnectProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOpenIdConnectProvidersResponse listOpenIDConnectProviders(
            ListOpenIdConnectProvidersRequest listOpenIdConnectProvidersRequest) throws ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about the IAM OpenID Connect (OIDC) provider resource objects defined in the AWS account.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for an OIDC provider, see <a>GetOpenIDConnectProvider</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOpenIdConnectProvidersRequest.Builder} avoiding
     * the need to create one manually via {@link ListOpenIdConnectProvidersRequest#builder()}
     * </p>
     *
     * @param listOpenIdConnectProvidersRequest
     *        A {@link Consumer} that will call methods on {@link ListOpenIDConnectProvidersRequest.Builder} to create a
     *        request.
     * @return Result of the ListOpenIDConnectProviders operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListOpenIDConnectProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListOpenIDConnectProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOpenIdConnectProvidersResponse listOpenIDConnectProviders(
            Consumer<ListOpenIdConnectProvidersRequest.Builder> listOpenIdConnectProvidersRequest)
            throws ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listOpenIDConnectProviders(ListOpenIdConnectProvidersRequest.builder()
                .applyMutation(listOpenIdConnectProvidersRequest).build());
    }

    /**
     * <p>
     * Lists all the managed policies that are available in your AWS account, including your own customer-defined
     * managed policies and all AWS managed policies.
     * </p>
     * <p>
     * You can filter the list of policies that is returned using the optional <code>OnlyAttached</code>,
     * <code>Scope</code>, and <code>PathPrefix</code> parameters. For example, to list only the customer managed
     * policies in your AWS account, set <code>Scope</code> to <code>Local</code>. To list only AWS managed policies,
     * set <code>Scope</code> to <code>AWS</code>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * For more information about managed policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for a customer manged policy, see <a>GetPolicy</a>.
     * </p>
     * </note>
     *
     * @return Result of the ListPolicies operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListPolicies
     * @see #listPolicies(ListPoliciesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPoliciesResponse listPolicies() throws ServiceFailureException, AwsServiceException, SdkClientException,
            IamException {
        return listPolicies(ListPoliciesRequest.builder().build());
    }

    /**
     * <p>
     * Lists all the managed policies that are available in your AWS account, including your own customer-defined
     * managed policies and all AWS managed policies.
     * </p>
     * <p>
     * You can filter the list of policies that is returned using the optional <code>OnlyAttached</code>,
     * <code>Scope</code>, and <code>PathPrefix</code> parameters. For example, to list only the customer managed
     * policies in your AWS account, set <code>Scope</code> to <code>Local</code>. To list only AWS managed policies,
     * set <code>Scope</code> to <code>AWS</code>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * For more information about managed policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for a customer manged policy, see <a>GetPolicy</a>.
     * </p>
     * </note>
     *
     * @param listPoliciesRequest
     * @return Result of the ListPolicies operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPoliciesResponse listPolicies(ListPoliciesRequest listPoliciesRequest) throws ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the managed policies that are available in your AWS account, including your own customer-defined
     * managed policies and all AWS managed policies.
     * </p>
     * <p>
     * You can filter the list of policies that is returned using the optional <code>OnlyAttached</code>,
     * <code>Scope</code>, and <code>PathPrefix</code> parameters. For example, to list only the customer managed
     * policies in your AWS account, set <code>Scope</code> to <code>Local</code>. To list only AWS managed policies,
     * set <code>Scope</code> to <code>AWS</code>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * For more information about managed policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for a customer manged policy, see <a>GetPolicy</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPoliciesRequest.Builder} avoiding the need to
     * create one manually via {@link ListPoliciesRequest#builder()}
     * </p>
     *
     * @param listPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListPoliciesRequest.Builder} to create a request.
     * @return Result of the ListPolicies operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPoliciesResponse listPolicies(Consumer<ListPoliciesRequest.Builder> listPoliciesRequest)
            throws ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listPolicies(ListPoliciesRequest.builder().applyMutation(listPoliciesRequest).build());
    }

    /**
     * <p>
     * Lists all the managed policies that are available in your AWS account, including your own customer-defined
     * managed policies and all AWS managed policies.
     * </p>
     * <p>
     * You can filter the list of policies that is returned using the optional <code>OnlyAttached</code>,
     * <code>Scope</code>, and <code>PathPrefix</code> parameters. For example, to list only the customer managed
     * policies in your AWS account, set <code>Scope</code> to <code>Local</code>. To list only AWS managed policies,
     * set <code>Scope</code> to <code>AWS</code>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * For more information about managed policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for a customer manged policy, see <a>GetPolicy</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of {@link #listPolicies(software.amazon.awssdk.services.iam.model.ListPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListPoliciesIterable responses = client.listPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListPoliciesIterable responses = client.listPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListPoliciesIterable responses = client.listPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPolicies(software.amazon.awssdk.services.iam.model.ListPoliciesRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListPolicies
     * @see #listPoliciesPaginator(ListPoliciesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPoliciesIterable listPoliciesPaginator() throws ServiceFailureException, AwsServiceException, SdkClientException,
            IamException {
        return listPoliciesPaginator(ListPoliciesRequest.builder().build());
    }

    /**
     * <p>
     * Lists all the managed policies that are available in your AWS account, including your own customer-defined
     * managed policies and all AWS managed policies.
     * </p>
     * <p>
     * You can filter the list of policies that is returned using the optional <code>OnlyAttached</code>,
     * <code>Scope</code>, and <code>PathPrefix</code> parameters. For example, to list only the customer managed
     * policies in your AWS account, set <code>Scope</code> to <code>Local</code>. To list only AWS managed policies,
     * set <code>Scope</code> to <code>AWS</code>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * For more information about managed policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for a customer manged policy, see <a>GetPolicy</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of {@link #listPolicies(software.amazon.awssdk.services.iam.model.ListPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListPoliciesIterable responses = client.listPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListPoliciesIterable responses = client.listPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListPoliciesIterable responses = client.listPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPolicies(software.amazon.awssdk.services.iam.model.ListPoliciesRequest)} operation.</b>
     * </p>
     *
     * @param listPoliciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPoliciesIterable listPoliciesPaginator(ListPoliciesRequest listPoliciesRequest) throws ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the managed policies that are available in your AWS account, including your own customer-defined
     * managed policies and all AWS managed policies.
     * </p>
     * <p>
     * You can filter the list of policies that is returned using the optional <code>OnlyAttached</code>,
     * <code>Scope</code>, and <code>PathPrefix</code> parameters. For example, to list only the customer managed
     * policies in your AWS account, set <code>Scope</code> to <code>Local</code>. To list only AWS managed policies,
     * set <code>Scope</code> to <code>AWS</code>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * For more information about managed policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for a customer manged policy, see <a>GetPolicy</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of {@link #listPolicies(software.amazon.awssdk.services.iam.model.ListPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListPoliciesIterable responses = client.listPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListPoliciesIterable responses = client.listPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListPoliciesIterable responses = client.listPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPolicies(software.amazon.awssdk.services.iam.model.ListPoliciesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPoliciesRequest.Builder} avoiding the need to
     * create one manually via {@link ListPoliciesRequest#builder()}
     * </p>
     *
     * @param listPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListPoliciesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPoliciesIterable listPoliciesPaginator(Consumer<ListPoliciesRequest.Builder> listPoliciesRequest)
            throws ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listPoliciesPaginator(ListPoliciesRequest.builder().applyMutation(listPoliciesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of policies that the IAM identity (user, group, or role) can use to access each specified
     * service.
     * </p>
     * <note>
     * <p>
     * This operation does not use other policy types when determining whether a resource could access a service. These
     * other policy types include resource-based policies, access control lists, AWS Organizations policies, IAM
     * permissions boundaries, and AWS STS assume role policies. It only applies permissions policy logic. For more
     * about the evaluation of policy types, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics"
     * >Evaluating policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * </note>
     * <p>
     * The list of policies returned by the operation depends on the ARN of the identity that you provide.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>User</b> – The list of policies includes the managed and inline policies that are attached to the user
     * directly. The list also includes any additional managed and inline policies that are attached to the group to
     * which the user belongs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Group</b> – The list of policies includes only the managed and inline policies that are attached to the group
     * directly. Policies that are attached to the group’s user are not included.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Role</b> – The list of policies includes only the managed and inline policies that are attached to the role.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For each managed policy, this operation returns the ARN and policy name. For each inline policy, it returns the
     * policy name and the entity to which it is attached. Inline policies do not have an ARN. For more information
     * about these policy types, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed policies
     * and inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * Policies that are attached to users and roles as permissions boundaries are not returned. To view which managed
     * policy is currently used to set the permissions boundary for a user or role, use the <a>GetUser</a> or
     * <a>GetRole</a> operations.
     * </p>
     *
     * @param listPoliciesGrantingServiceAccessRequest
     * @return Result of the ListPoliciesGrantingServiceAccess operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListPoliciesGrantingServiceAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPoliciesGrantingServiceAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPoliciesGrantingServiceAccessResponse listPoliciesGrantingServiceAccess(
            ListPoliciesGrantingServiceAccessRequest listPoliciesGrantingServiceAccessRequest) throws NoSuchEntityException,
            InvalidInputException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of policies that the IAM identity (user, group, or role) can use to access each specified
     * service.
     * </p>
     * <note>
     * <p>
     * This operation does not use other policy types when determining whether a resource could access a service. These
     * other policy types include resource-based policies, access control lists, AWS Organizations policies, IAM
     * permissions boundaries, and AWS STS assume role policies. It only applies permissions policy logic. For more
     * about the evaluation of policy types, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics"
     * >Evaluating policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * </note>
     * <p>
     * The list of policies returned by the operation depends on the ARN of the identity that you provide.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>User</b> – The list of policies includes the managed and inline policies that are attached to the user
     * directly. The list also includes any additional managed and inline policies that are attached to the group to
     * which the user belongs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Group</b> – The list of policies includes only the managed and inline policies that are attached to the group
     * directly. Policies that are attached to the group’s user are not included.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Role</b> – The list of policies includes only the managed and inline policies that are attached to the role.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For each managed policy, this operation returns the ARN and policy name. For each inline policy, it returns the
     * policy name and the entity to which it is attached. Inline policies do not have an ARN. For more information
     * about these policy types, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed policies
     * and inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * Policies that are attached to users and roles as permissions boundaries are not returned. To view which managed
     * policy is currently used to set the permissions boundary for a user or role, use the <a>GetUser</a> or
     * <a>GetRole</a> operations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPoliciesGrantingServiceAccessRequest.Builder}
     * avoiding the need to create one manually via {@link ListPoliciesGrantingServiceAccessRequest#builder()}
     * </p>
     *
     * @param listPoliciesGrantingServiceAccessRequest
     *        A {@link Consumer} that will call methods on {@link ListPoliciesGrantingServiceAccessRequest.Builder} to
     *        create a request.
     * @return Result of the ListPoliciesGrantingServiceAccess operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListPoliciesGrantingServiceAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPoliciesGrantingServiceAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPoliciesGrantingServiceAccessResponse listPoliciesGrantingServiceAccess(
            Consumer<ListPoliciesGrantingServiceAccessRequest.Builder> listPoliciesGrantingServiceAccessRequest)
            throws NoSuchEntityException, InvalidInputException, AwsServiceException, SdkClientException, IamException {
        return listPoliciesGrantingServiceAccess(ListPoliciesGrantingServiceAccessRequest.builder()
                .applyMutation(listPoliciesGrantingServiceAccessRequest).build());
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified IAM customer managed policy. The returned list of tags is
     * sorted by tag key. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     *
     * @param listPolicyTagsRequest
     * @return Result of the ListPolicyTags operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListPolicyTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicyTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPolicyTagsResponse listPolicyTags(ListPolicyTagsRequest listPolicyTagsRequest) throws NoSuchEntityException,
            ServiceFailureException, InvalidInputException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified IAM customer managed policy. The returned list of tags is
     * sorted by tag key. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPolicyTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPolicyTagsRequest#builder()}
     * </p>
     *
     * @param listPolicyTagsRequest
     *        A {@link Consumer} that will call methods on {@link ListPolicyTagsRequest.Builder} to create a request.
     * @return Result of the ListPolicyTags operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListPolicyTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicyTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPolicyTagsResponse listPolicyTags(Consumer<ListPolicyTagsRequest.Builder> listPolicyTagsRequest)
            throws NoSuchEntityException, ServiceFailureException, InvalidInputException, AwsServiceException,
            SdkClientException, IamException {
        return listPolicyTags(ListPolicyTagsRequest.builder().applyMutation(listPolicyTagsRequest).build());
    }

    /**
     * <p>
     * Lists information about the versions of the specified managed policy, including the version that is currently set
     * as the policy's default version.
     * </p>
     * <p>
     * For more information about managed policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param listPolicyVersionsRequest
     * @return Result of the ListPolicyVersions operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListPolicyVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicyVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPolicyVersionsResponse listPolicyVersions(ListPolicyVersionsRequest listPolicyVersionsRequest)
            throws NoSuchEntityException, InvalidInputException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about the versions of the specified managed policy, including the version that is currently set
     * as the policy's default version.
     * </p>
     * <p>
     * For more information about managed policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPolicyVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPolicyVersionsRequest#builder()}
     * </p>
     *
     * @param listPolicyVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListPolicyVersionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListPolicyVersions operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListPolicyVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicyVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPolicyVersionsResponse listPolicyVersions(Consumer<ListPolicyVersionsRequest.Builder> listPolicyVersionsRequest)
            throws NoSuchEntityException, InvalidInputException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        return listPolicyVersions(ListPolicyVersionsRequest.builder().applyMutation(listPolicyVersionsRequest).build());
    }

    /**
     * <p>
     * Lists information about the versions of the specified managed policy, including the version that is currently set
     * as the policy's default version.
     * </p>
     * <p>
     * For more information about managed policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPolicyVersions(software.amazon.awssdk.services.iam.model.ListPolicyVersionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListPolicyVersionsIterable responses = client.listPolicyVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListPolicyVersionsIterable responses = client
     *             .listPolicyVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListPolicyVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListPolicyVersionsIterable responses = client.listPolicyVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPolicyVersions(software.amazon.awssdk.services.iam.model.ListPolicyVersionsRequest)} operation.</b>
     * </p>
     *
     * @param listPolicyVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListPolicyVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicyVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPolicyVersionsIterable listPolicyVersionsPaginator(ListPolicyVersionsRequest listPolicyVersionsRequest)
            throws NoSuchEntityException, InvalidInputException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about the versions of the specified managed policy, including the version that is currently set
     * as the policy's default version.
     * </p>
     * <p>
     * For more information about managed policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPolicyVersions(software.amazon.awssdk.services.iam.model.ListPolicyVersionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListPolicyVersionsIterable responses = client.listPolicyVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListPolicyVersionsIterable responses = client
     *             .listPolicyVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListPolicyVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListPolicyVersionsIterable responses = client.listPolicyVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPolicyVersions(software.amazon.awssdk.services.iam.model.ListPolicyVersionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPolicyVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPolicyVersionsRequest#builder()}
     * </p>
     *
     * @param listPolicyVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListPolicyVersionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListPolicyVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicyVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPolicyVersionsIterable listPolicyVersionsPaginator(
            Consumer<ListPolicyVersionsRequest.Builder> listPolicyVersionsRequest) throws NoSuchEntityException,
            InvalidInputException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listPolicyVersionsPaginator(ListPolicyVersionsRequest.builder().applyMutation(listPolicyVersionsRequest).build());
    }

    /**
     * <p>
     * Lists the names of the inline policies that are embedded in the specified IAM role.
     * </p>
     * <p>
     * An IAM role can also have managed policies attached to it. To list the managed policies that are attached to a
     * role, use <a>ListAttachedRolePolicies</a>. For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. If there are no
     * inline policies embedded with the specified role, the operation returns an empty list.
     * </p>
     *
     * @param listRolePoliciesRequest
     * @return Result of the ListRolePolicies operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListRolePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRolePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRolePoliciesResponse listRolePolicies(ListRolePoliciesRequest listRolePoliciesRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the names of the inline policies that are embedded in the specified IAM role.
     * </p>
     * <p>
     * An IAM role can also have managed policies attached to it. To list the managed policies that are attached to a
     * role, use <a>ListAttachedRolePolicies</a>. For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. If there are no
     * inline policies embedded with the specified role, the operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRolePoliciesRequest.Builder} avoiding the need
     * to create one manually via {@link ListRolePoliciesRequest#builder()}
     * </p>
     *
     * @param listRolePoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListRolePoliciesRequest.Builder} to create a request.
     * @return Result of the ListRolePolicies operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListRolePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRolePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRolePoliciesResponse listRolePolicies(Consumer<ListRolePoliciesRequest.Builder> listRolePoliciesRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listRolePolicies(ListRolePoliciesRequest.builder().applyMutation(listRolePoliciesRequest).build());
    }

    /**
     * <p>
     * Lists the names of the inline policies that are embedded in the specified IAM role.
     * </p>
     * <p>
     * An IAM role can also have managed policies attached to it. To list the managed policies that are attached to a
     * role, use <a>ListAttachedRolePolicies</a>. For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. If there are no
     * inline policies embedded with the specified role, the operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRolePolicies(software.amazon.awssdk.services.iam.model.ListRolePoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListRolePoliciesIterable responses = client.listRolePoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListRolePoliciesIterable responses = client.listRolePoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListRolePoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListRolePoliciesIterable responses = client.listRolePoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRolePolicies(software.amazon.awssdk.services.iam.model.ListRolePoliciesRequest)} operation.</b>
     * </p>
     *
     * @param listRolePoliciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListRolePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRolePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRolePoliciesIterable listRolePoliciesPaginator(ListRolePoliciesRequest listRolePoliciesRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the names of the inline policies that are embedded in the specified IAM role.
     * </p>
     * <p>
     * An IAM role can also have managed policies attached to it. To list the managed policies that are attached to a
     * role, use <a>ListAttachedRolePolicies</a>. For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. If there are no
     * inline policies embedded with the specified role, the operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRolePolicies(software.amazon.awssdk.services.iam.model.ListRolePoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListRolePoliciesIterable responses = client.listRolePoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListRolePoliciesIterable responses = client.listRolePoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListRolePoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListRolePoliciesIterable responses = client.listRolePoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRolePolicies(software.amazon.awssdk.services.iam.model.ListRolePoliciesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRolePoliciesRequest.Builder} avoiding the need
     * to create one manually via {@link ListRolePoliciesRequest#builder()}
     * </p>
     *
     * @param listRolePoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListRolePoliciesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListRolePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRolePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRolePoliciesIterable listRolePoliciesPaginator(Consumer<ListRolePoliciesRequest.Builder> listRolePoliciesRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listRolePoliciesPaginator(ListRolePoliciesRequest.builder().applyMutation(listRolePoliciesRequest).build());
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified role. The returned list of tags is sorted by tag key. For more
     * information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging
     * IAM resources</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param listRoleTagsRequest
     * @return Result of the ListRoleTags operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListRoleTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRoleTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRoleTagsResponse listRoleTags(ListRoleTagsRequest listRoleTagsRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified role. The returned list of tags is sorted by tag key. For more
     * information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging
     * IAM resources</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRoleTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRoleTagsRequest#builder()}
     * </p>
     *
     * @param listRoleTagsRequest
     *        A {@link Consumer} that will call methods on {@link ListRoleTagsRequest.Builder} to create a request.
     * @return Result of the ListRoleTags operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListRoleTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRoleTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRoleTagsResponse listRoleTags(Consumer<ListRoleTagsRequest.Builder> listRoleTagsRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listRoleTags(ListRoleTagsRequest.builder().applyMutation(listRoleTagsRequest).build());
    }

    /**
     * <p>
     * Lists the IAM roles that have the specified path prefix. If there are none, the operation returns an empty list.
     * For more information about roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with roles</a>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for a role, see <a>GetRole</a>.
     * </p>
     * </note>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @return Result of the ListRoles operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListRoles
     * @see #listRoles(ListRolesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRoles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRolesResponse listRoles() throws ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listRoles(ListRolesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the IAM roles that have the specified path prefix. If there are none, the operation returns an empty list.
     * For more information about roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with roles</a>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for a role, see <a>GetRole</a>.
     * </p>
     * </note>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listRolesRequest
     * @return Result of the ListRoles operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListRoles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRoles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRolesResponse listRoles(ListRolesRequest listRolesRequest) throws ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the IAM roles that have the specified path prefix. If there are none, the operation returns an empty list.
     * For more information about roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with roles</a>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for a role, see <a>GetRole</a>.
     * </p>
     * </note>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRolesRequest.Builder} avoiding the need to
     * create one manually via {@link ListRolesRequest#builder()}
     * </p>
     *
     * @param listRolesRequest
     *        A {@link Consumer} that will call methods on {@link ListRolesRequest.Builder} to create a request.
     * @return Result of the ListRoles operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListRoles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRoles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRolesResponse listRoles(Consumer<ListRolesRequest.Builder> listRolesRequest) throws ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        return listRoles(ListRolesRequest.builder().applyMutation(listRolesRequest).build());
    }

    /**
     * <p>
     * Lists the IAM roles that have the specified path prefix. If there are none, the operation returns an empty list.
     * For more information about roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with roles</a>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for a role, see <a>GetRole</a>.
     * </p>
     * </note>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRoles(software.amazon.awssdk.services.iam.model.ListRolesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListRolesIterable responses = client.listRolesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListRolesIterable responses = client.listRolesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListRolesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListRolesIterable responses = client.listRolesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRoles(software.amazon.awssdk.services.iam.model.ListRolesRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListRoles
     * @see #listRolesPaginator(ListRolesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRoles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRolesIterable listRolesPaginator() throws ServiceFailureException, AwsServiceException, SdkClientException,
            IamException {
        return listRolesPaginator(ListRolesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the IAM roles that have the specified path prefix. If there are none, the operation returns an empty list.
     * For more information about roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with roles</a>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for a role, see <a>GetRole</a>.
     * </p>
     * </note>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRoles(software.amazon.awssdk.services.iam.model.ListRolesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListRolesIterable responses = client.listRolesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListRolesIterable responses = client.listRolesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListRolesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListRolesIterable responses = client.listRolesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRoles(software.amazon.awssdk.services.iam.model.ListRolesRequest)} operation.</b>
     * </p>
     *
     * @param listRolesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListRoles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRoles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRolesIterable listRolesPaginator(ListRolesRequest listRolesRequest) throws ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the IAM roles that have the specified path prefix. If there are none, the operation returns an empty list.
     * For more information about roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with roles</a>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for a role, see <a>GetRole</a>.
     * </p>
     * </note>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRoles(software.amazon.awssdk.services.iam.model.ListRolesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListRolesIterable responses = client.listRolesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListRolesIterable responses = client.listRolesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListRolesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListRolesIterable responses = client.listRolesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRoles(software.amazon.awssdk.services.iam.model.ListRolesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRolesRequest.Builder} avoiding the need to
     * create one manually via {@link ListRolesRequest#builder()}
     * </p>
     *
     * @param listRolesRequest
     *        A {@link Consumer} that will call methods on {@link ListRolesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListRoles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRoles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRolesIterable listRolesPaginator(Consumer<ListRolesRequest.Builder> listRolesRequest)
            throws ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listRolesPaginator(ListRolesRequest.builder().applyMutation(listRolesRequest).build());
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified Security Assertion Markup Language (SAML) identity provider.
     * The returned list of tags is sorted by tag key. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html">About SAML 2.0-based
     * federation</a>.
     * </p>
     * <p>
     * For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     *
     * @param listSamlProviderTagsRequest
     * @return Result of the ListSAMLProviderTags operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListSAMLProviderTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSAMLProviderTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSamlProviderTagsResponse listSAMLProviderTags(ListSamlProviderTagsRequest listSamlProviderTagsRequest)
            throws NoSuchEntityException, ServiceFailureException, InvalidInputException, AwsServiceException,
            SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified Security Assertion Markup Language (SAML) identity provider.
     * The returned list of tags is sorted by tag key. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html">About SAML 2.0-based
     * federation</a>.
     * </p>
     * <p>
     * For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSamlProviderTagsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSamlProviderTagsRequest#builder()}
     * </p>
     *
     * @param listSamlProviderTagsRequest
     *        A {@link Consumer} that will call methods on {@link ListSAMLProviderTagsRequest.Builder} to create a
     *        request.
     * @return Result of the ListSAMLProviderTags operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListSAMLProviderTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSAMLProviderTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSamlProviderTagsResponse listSAMLProviderTags(
            Consumer<ListSamlProviderTagsRequest.Builder> listSamlProviderTagsRequest) throws NoSuchEntityException,
            ServiceFailureException, InvalidInputException, AwsServiceException, SdkClientException, IamException {
        return listSAMLProviderTags(ListSamlProviderTagsRequest.builder().applyMutation(listSamlProviderTagsRequest).build());
    }

    /**
     * <p>
     * Lists the SAML provider resource objects defined in IAM in the account. IAM resource-listing operations return a
     * subset of the available attributes for the resource. For example, this operation does not return tags, even
     * though they are an attribute of the returned object. To view all of the information for a SAML provider, see
     * <a>GetSAMLProvider</a>.
     * </p>
     * <important>
     * <p>
     * This operation requires <a
     * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.
     * </p>
     * </important>
     *
     * @return Result of the ListSAMLProviders operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListSAMLProviders
     * @see #listSAMLProviders(ListSamlProvidersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSAMLProviders" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSamlProvidersResponse listSAMLProviders() throws ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        return listSAMLProviders(ListSamlProvidersRequest.builder().build());
    }

    /**
     * <p>
     * Lists the SAML provider resource objects defined in IAM in the account. IAM resource-listing operations return a
     * subset of the available attributes for the resource. For example, this operation does not return tags, even
     * though they are an attribute of the returned object. To view all of the information for a SAML provider, see
     * <a>GetSAMLProvider</a>.
     * </p>
     * <important>
     * <p>
     * This operation requires <a
     * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.
     * </p>
     * </important>
     *
     * @param listSamlProvidersRequest
     * @return Result of the ListSAMLProviders operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListSAMLProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSAMLProviders" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSamlProvidersResponse listSAMLProviders(ListSamlProvidersRequest listSamlProvidersRequest)
            throws ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the SAML provider resource objects defined in IAM in the account. IAM resource-listing operations return a
     * subset of the available attributes for the resource. For example, this operation does not return tags, even
     * though they are an attribute of the returned object. To view all of the information for a SAML provider, see
     * <a>GetSAMLProvider</a>.
     * </p>
     * <important>
     * <p>
     * This operation requires <a
     * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSamlProvidersRequest.Builder} avoiding the need
     * to create one manually via {@link ListSamlProvidersRequest#builder()}
     * </p>
     *
     * @param listSamlProvidersRequest
     *        A {@link Consumer} that will call methods on {@link ListSAMLProvidersRequest.Builder} to create a request.
     * @return Result of the ListSAMLProviders operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListSAMLProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSAMLProviders" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSamlProvidersResponse listSAMLProviders(Consumer<ListSamlProvidersRequest.Builder> listSamlProvidersRequest)
            throws ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listSAMLProviders(ListSamlProvidersRequest.builder().applyMutation(listSamlProvidersRequest).build());
    }

    /**
     * <p>
     * Returns information about the SSH public keys associated with the specified IAM user. If none exists, the
     * operation returns an empty list.
     * </p>
     * <p>
     * The SSH public keys returned by this operation are used only for authenticating the IAM user to an AWS CodeCommit
     * repository. For more information about using SSH keys to authenticate to an AWS CodeCommit repository, see <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up AWS
     * CodeCommit for SSH connections</a> in the <i>AWS CodeCommit User Guide</i>.
     * </p>
     * <p>
     * Although each user is limited to a small number of keys, you can still paginate the results using the
     * <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @return Result of the ListSSHPublicKeys operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListSSHPublicKeys
     * @see #listSSHPublicKeys(ListSshPublicKeysRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSSHPublicKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSshPublicKeysResponse listSSHPublicKeys() throws NoSuchEntityException, AwsServiceException, SdkClientException,
            IamException {
        return listSSHPublicKeys(ListSshPublicKeysRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about the SSH public keys associated with the specified IAM user. If none exists, the
     * operation returns an empty list.
     * </p>
     * <p>
     * The SSH public keys returned by this operation are used only for authenticating the IAM user to an AWS CodeCommit
     * repository. For more information about using SSH keys to authenticate to an AWS CodeCommit repository, see <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up AWS
     * CodeCommit for SSH connections</a> in the <i>AWS CodeCommit User Guide</i>.
     * </p>
     * <p>
     * Although each user is limited to a small number of keys, you can still paginate the results using the
     * <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listSshPublicKeysRequest
     * @return Result of the ListSSHPublicKeys operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListSSHPublicKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSSHPublicKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSshPublicKeysResponse listSSHPublicKeys(ListSshPublicKeysRequest listSshPublicKeysRequest)
            throws NoSuchEntityException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the SSH public keys associated with the specified IAM user. If none exists, the
     * operation returns an empty list.
     * </p>
     * <p>
     * The SSH public keys returned by this operation are used only for authenticating the IAM user to an AWS CodeCommit
     * repository. For more information about using SSH keys to authenticate to an AWS CodeCommit repository, see <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up AWS
     * CodeCommit for SSH connections</a> in the <i>AWS CodeCommit User Guide</i>.
     * </p>
     * <p>
     * Although each user is limited to a small number of keys, you can still paginate the results using the
     * <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSshPublicKeysRequest.Builder} avoiding the need
     * to create one manually via {@link ListSshPublicKeysRequest#builder()}
     * </p>
     *
     * @param listSshPublicKeysRequest
     *        A {@link Consumer} that will call methods on {@link ListSSHPublicKeysRequest.Builder} to create a request.
     * @return Result of the ListSSHPublicKeys operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListSSHPublicKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSSHPublicKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSshPublicKeysResponse listSSHPublicKeys(Consumer<ListSshPublicKeysRequest.Builder> listSshPublicKeysRequest)
            throws NoSuchEntityException, AwsServiceException, SdkClientException, IamException {
        return listSSHPublicKeys(ListSshPublicKeysRequest.builder().applyMutation(listSshPublicKeysRequest).build());
    }

    /**
     * <p>
     * Returns information about the SSH public keys associated with the specified IAM user. If none exists, the
     * operation returns an empty list.
     * </p>
     * <p>
     * The SSH public keys returned by this operation are used only for authenticating the IAM user to an AWS CodeCommit
     * repository. For more information about using SSH keys to authenticate to an AWS CodeCommit repository, see <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up AWS
     * CodeCommit for SSH connections</a> in the <i>AWS CodeCommit User Guide</i>.
     * </p>
     * <p>
     * Although each user is limited to a small number of keys, you can still paginate the results using the
     * <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSSHPublicKeys(software.amazon.awssdk.services.iam.model.ListSshPublicKeysRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListSSHPublicKeysIterable responses = client.listSSHPublicKeysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListSSHPublicKeysIterable responses = client
     *             .listSSHPublicKeysPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListSshPublicKeysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListSSHPublicKeysIterable responses = client.listSSHPublicKeysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSSHPublicKeys(software.amazon.awssdk.services.iam.model.ListSshPublicKeysRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListSSHPublicKeys
     * @see #listSSHPublicKeysPaginator(ListSshPublicKeysRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSSHPublicKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSSHPublicKeysIterable listSSHPublicKeysPaginator() throws NoSuchEntityException, AwsServiceException,
            SdkClientException, IamException {
        return listSSHPublicKeysPaginator(ListSshPublicKeysRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about the SSH public keys associated with the specified IAM user. If none exists, the
     * operation returns an empty list.
     * </p>
     * <p>
     * The SSH public keys returned by this operation are used only for authenticating the IAM user to an AWS CodeCommit
     * repository. For more information about using SSH keys to authenticate to an AWS CodeCommit repository, see <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up AWS
     * CodeCommit for SSH connections</a> in the <i>AWS CodeCommit User Guide</i>.
     * </p>
     * <p>
     * Although each user is limited to a small number of keys, you can still paginate the results using the
     * <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSSHPublicKeys(software.amazon.awssdk.services.iam.model.ListSshPublicKeysRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListSSHPublicKeysIterable responses = client.listSSHPublicKeysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListSSHPublicKeysIterable responses = client
     *             .listSSHPublicKeysPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListSshPublicKeysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListSSHPublicKeysIterable responses = client.listSSHPublicKeysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSSHPublicKeys(software.amazon.awssdk.services.iam.model.ListSshPublicKeysRequest)} operation.</b>
     * </p>
     *
     * @param listSshPublicKeysRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListSSHPublicKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSSHPublicKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSSHPublicKeysIterable listSSHPublicKeysPaginator(ListSshPublicKeysRequest listSshPublicKeysRequest)
            throws NoSuchEntityException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the SSH public keys associated with the specified IAM user. If none exists, the
     * operation returns an empty list.
     * </p>
     * <p>
     * The SSH public keys returned by this operation are used only for authenticating the IAM user to an AWS CodeCommit
     * repository. For more information about using SSH keys to authenticate to an AWS CodeCommit repository, see <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up AWS
     * CodeCommit for SSH connections</a> in the <i>AWS CodeCommit User Guide</i>.
     * </p>
     * <p>
     * Although each user is limited to a small number of keys, you can still paginate the results using the
     * <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSSHPublicKeys(software.amazon.awssdk.services.iam.model.ListSshPublicKeysRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListSSHPublicKeysIterable responses = client.listSSHPublicKeysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListSSHPublicKeysIterable responses = client
     *             .listSSHPublicKeysPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListSshPublicKeysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListSSHPublicKeysIterable responses = client.listSSHPublicKeysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSSHPublicKeys(software.amazon.awssdk.services.iam.model.ListSshPublicKeysRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSshPublicKeysRequest.Builder} avoiding the need
     * to create one manually via {@link ListSshPublicKeysRequest#builder()}
     * </p>
     *
     * @param listSshPublicKeysRequest
     *        A {@link Consumer} that will call methods on {@link ListSSHPublicKeysRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListSSHPublicKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSSHPublicKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSSHPublicKeysIterable listSSHPublicKeysPaginator(
            Consumer<ListSshPublicKeysRequest.Builder> listSshPublicKeysRequest) throws NoSuchEntityException,
            AwsServiceException, SdkClientException, IamException {
        return listSSHPublicKeysPaginator(ListSshPublicKeysRequest.builder().applyMutation(listSshPublicKeysRequest).build());
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified IAM server certificate. The returned list of tags is sorted by
     * tag key. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     * <note>
     * <p>
     * For certificates in a Region supported by AWS Certificate Manager (ACM), we recommend that you don't use IAM
     * server certificates. Instead, use ACM to provision, manage, and deploy your server certificates. For more
     * information about IAM server certificates, <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with server
     * certificates</a> in the <i>IAM User Guide</i>.
     * </p>
     * </note>
     *
     * @param listServerCertificateTagsRequest
     * @return Result of the ListServerCertificateTags operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListServerCertificateTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListServerCertificateTags" target="_top">AWS
     *      API Documentation</a>
     */
    default ListServerCertificateTagsResponse listServerCertificateTags(
            ListServerCertificateTagsRequest listServerCertificateTagsRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified IAM server certificate. The returned list of tags is sorted by
     * tag key. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     * <note>
     * <p>
     * For certificates in a Region supported by AWS Certificate Manager (ACM), we recommend that you don't use IAM
     * server certificates. Instead, use ACM to provision, manage, and deploy your server certificates. For more
     * information about IAM server certificates, <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with server
     * certificates</a> in the <i>IAM User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServerCertificateTagsRequest.Builder} avoiding
     * the need to create one manually via {@link ListServerCertificateTagsRequest#builder()}
     * </p>
     *
     * @param listServerCertificateTagsRequest
     *        A {@link Consumer} that will call methods on {@link ListServerCertificateTagsRequest.Builder} to create a
     *        request.
     * @return Result of the ListServerCertificateTags operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListServerCertificateTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListServerCertificateTags" target="_top">AWS
     *      API Documentation</a>
     */
    default ListServerCertificateTagsResponse listServerCertificateTags(
            Consumer<ListServerCertificateTagsRequest.Builder> listServerCertificateTagsRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listServerCertificateTags(ListServerCertificateTagsRequest.builder()
                .applyMutation(listServerCertificateTagsRequest).build());
    }

    /**
     * <p>
     * Lists the server certificates stored in IAM that have the specified path prefix. If none exist, the operation
     * returns an empty list.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * For more information about working with server certificates, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with server
     * certificates</a> in the <i>IAM User Guide</i>. This topic also includes a list of AWS services that can use the
     * server certificates that you manage with IAM.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for a servercertificate, see <a>GetServerCertificate</a>.
     * </p>
     * </note>
     *
     * @return Result of the ListServerCertificates operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListServerCertificates
     * @see #listServerCertificates(ListServerCertificatesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListServerCertificates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListServerCertificatesResponse listServerCertificates() throws ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        return listServerCertificates(ListServerCertificatesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the server certificates stored in IAM that have the specified path prefix. If none exist, the operation
     * returns an empty list.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * For more information about working with server certificates, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with server
     * certificates</a> in the <i>IAM User Guide</i>. This topic also includes a list of AWS services that can use the
     * server certificates that you manage with IAM.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for a servercertificate, see <a>GetServerCertificate</a>.
     * </p>
     * </note>
     *
     * @param listServerCertificatesRequest
     * @return Result of the ListServerCertificates operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListServerCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListServerCertificates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListServerCertificatesResponse listServerCertificates(ListServerCertificatesRequest listServerCertificatesRequest)
            throws ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the server certificates stored in IAM that have the specified path prefix. If none exist, the operation
     * returns an empty list.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * For more information about working with server certificates, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with server
     * certificates</a> in the <i>IAM User Guide</i>. This topic also includes a list of AWS services that can use the
     * server certificates that you manage with IAM.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for a servercertificate, see <a>GetServerCertificate</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServerCertificatesRequest.Builder} avoiding the
     * need to create one manually via {@link ListServerCertificatesRequest#builder()}
     * </p>
     *
     * @param listServerCertificatesRequest
     *        A {@link Consumer} that will call methods on {@link ListServerCertificatesRequest.Builder} to create a
     *        request.
     * @return Result of the ListServerCertificates operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListServerCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListServerCertificates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListServerCertificatesResponse listServerCertificates(
            Consumer<ListServerCertificatesRequest.Builder> listServerCertificatesRequest) throws ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        return listServerCertificates(ListServerCertificatesRequest.builder().applyMutation(listServerCertificatesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the server certificates stored in IAM that have the specified path prefix. If none exist, the operation
     * returns an empty list.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * For more information about working with server certificates, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with server
     * certificates</a> in the <i>IAM User Guide</i>. This topic also includes a list of AWS services that can use the
     * server certificates that you manage with IAM.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for a servercertificate, see <a>GetServerCertificate</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listServerCertificates(software.amazon.awssdk.services.iam.model.ListServerCertificatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListServerCertificatesIterable responses = client.listServerCertificatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListServerCertificatesIterable responses = client
     *             .listServerCertificatesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListServerCertificatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListServerCertificatesIterable responses = client.listServerCertificatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServerCertificates(software.amazon.awssdk.services.iam.model.ListServerCertificatesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListServerCertificates
     * @see #listServerCertificatesPaginator(ListServerCertificatesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListServerCertificates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListServerCertificatesIterable listServerCertificatesPaginator() throws ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        return listServerCertificatesPaginator(ListServerCertificatesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the server certificates stored in IAM that have the specified path prefix. If none exist, the operation
     * returns an empty list.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * For more information about working with server certificates, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with server
     * certificates</a> in the <i>IAM User Guide</i>. This topic also includes a list of AWS services that can use the
     * server certificates that you manage with IAM.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for a servercertificate, see <a>GetServerCertificate</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listServerCertificates(software.amazon.awssdk.services.iam.model.ListServerCertificatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListServerCertificatesIterable responses = client.listServerCertificatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListServerCertificatesIterable responses = client
     *             .listServerCertificatesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListServerCertificatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListServerCertificatesIterable responses = client.listServerCertificatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServerCertificates(software.amazon.awssdk.services.iam.model.ListServerCertificatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServerCertificatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListServerCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListServerCertificates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListServerCertificatesIterable listServerCertificatesPaginator(
            ListServerCertificatesRequest listServerCertificatesRequest) throws ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the server certificates stored in IAM that have the specified path prefix. If none exist, the operation
     * returns an empty list.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * For more information about working with server certificates, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with server
     * certificates</a> in the <i>IAM User Guide</i>. This topic also includes a list of AWS services that can use the
     * server certificates that you manage with IAM.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for a servercertificate, see <a>GetServerCertificate</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listServerCertificates(software.amazon.awssdk.services.iam.model.ListServerCertificatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListServerCertificatesIterable responses = client.listServerCertificatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListServerCertificatesIterable responses = client
     *             .listServerCertificatesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListServerCertificatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListServerCertificatesIterable responses = client.listServerCertificatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServerCertificates(software.amazon.awssdk.services.iam.model.ListServerCertificatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServerCertificatesRequest.Builder} avoiding the
     * need to create one manually via {@link ListServerCertificatesRequest#builder()}
     * </p>
     *
     * @param listServerCertificatesRequest
     *        A {@link Consumer} that will call methods on {@link ListServerCertificatesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListServerCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListServerCertificates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListServerCertificatesIterable listServerCertificatesPaginator(
            Consumer<ListServerCertificatesRequest.Builder> listServerCertificatesRequest) throws ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        return listServerCertificatesPaginator(ListServerCertificatesRequest.builder()
                .applyMutation(listServerCertificatesRequest).build());
    }

    /**
     * <p>
     * Returns information about the service-specific credentials associated with the specified IAM user. If none
     * exists, the operation returns an empty list. The service-specific credentials returned by this operation are used
     * only for authenticating the IAM user to a specific service. For more information about using service-specific
     * credentials to authenticate to an AWS service, see <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-gc.html">Set up service-specific
     * credentials</a> in the AWS CodeCommit User Guide.
     * </p>
     *
     * @return Result of the ListServiceSpecificCredentials operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceNotSupportedException
     *         The specified service does not support service-specific credentials.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListServiceSpecificCredentials
     * @see #listServiceSpecificCredentials(ListServiceSpecificCredentialsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListServiceSpecificCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceSpecificCredentialsResponse listServiceSpecificCredentials() throws NoSuchEntityException,
            ServiceNotSupportedException, AwsServiceException, SdkClientException, IamException {
        return listServiceSpecificCredentials(ListServiceSpecificCredentialsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about the service-specific credentials associated with the specified IAM user. If none
     * exists, the operation returns an empty list. The service-specific credentials returned by this operation are used
     * only for authenticating the IAM user to a specific service. For more information about using service-specific
     * credentials to authenticate to an AWS service, see <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-gc.html">Set up service-specific
     * credentials</a> in the AWS CodeCommit User Guide.
     * </p>
     *
     * @param listServiceSpecificCredentialsRequest
     * @return Result of the ListServiceSpecificCredentials operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceNotSupportedException
     *         The specified service does not support service-specific credentials.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListServiceSpecificCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListServiceSpecificCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceSpecificCredentialsResponse listServiceSpecificCredentials(
            ListServiceSpecificCredentialsRequest listServiceSpecificCredentialsRequest) throws NoSuchEntityException,
            ServiceNotSupportedException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the service-specific credentials associated with the specified IAM user. If none
     * exists, the operation returns an empty list. The service-specific credentials returned by this operation are used
     * only for authenticating the IAM user to a specific service. For more information about using service-specific
     * credentials to authenticate to an AWS service, see <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-gc.html">Set up service-specific
     * credentials</a> in the AWS CodeCommit User Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceSpecificCredentialsRequest.Builder}
     * avoiding the need to create one manually via {@link ListServiceSpecificCredentialsRequest#builder()}
     * </p>
     *
     * @param listServiceSpecificCredentialsRequest
     *        A {@link Consumer} that will call methods on {@link ListServiceSpecificCredentialsRequest.Builder} to
     *        create a request.
     * @return Result of the ListServiceSpecificCredentials operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceNotSupportedException
     *         The specified service does not support service-specific credentials.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListServiceSpecificCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListServiceSpecificCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceSpecificCredentialsResponse listServiceSpecificCredentials(
            Consumer<ListServiceSpecificCredentialsRequest.Builder> listServiceSpecificCredentialsRequest)
            throws NoSuchEntityException, ServiceNotSupportedException, AwsServiceException, SdkClientException, IamException {
        return listServiceSpecificCredentials(ListServiceSpecificCredentialsRequest.builder()
                .applyMutation(listServiceSpecificCredentialsRequest).build());
    }

    /**
     * <p>
     * Returns information about the signing certificates associated with the specified IAM user. If none exists, the
     * operation returns an empty list.
     * </p>
     * <p>
     * Although each user is limited to a small number of signing certificates, you can still paginate the results using
     * the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * If the <code>UserName</code> field is not specified, the user name is determined implicitly based on the AWS
     * access key ID used to sign the request for this operation. This operation works for access keys under the AWS
     * account. Consequently, you can use this operation to manage AWS account root user credentials even if the AWS
     * account has no associated users.
     * </p>
     *
     * @return Result of the ListSigningCertificates operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListSigningCertificates
     * @see #listSigningCertificates(ListSigningCertificatesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSigningCertificates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSigningCertificatesResponse listSigningCertificates() throws NoSuchEntityException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        return listSigningCertificates(ListSigningCertificatesRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about the signing certificates associated with the specified IAM user. If none exists, the
     * operation returns an empty list.
     * </p>
     * <p>
     * Although each user is limited to a small number of signing certificates, you can still paginate the results using
     * the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * If the <code>UserName</code> field is not specified, the user name is determined implicitly based on the AWS
     * access key ID used to sign the request for this operation. This operation works for access keys under the AWS
     * account. Consequently, you can use this operation to manage AWS account root user credentials even if the AWS
     * account has no associated users.
     * </p>
     *
     * @param listSigningCertificatesRequest
     * @return Result of the ListSigningCertificates operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListSigningCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSigningCertificates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSigningCertificatesResponse listSigningCertificates(ListSigningCertificatesRequest listSigningCertificatesRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the signing certificates associated with the specified IAM user. If none exists, the
     * operation returns an empty list.
     * </p>
     * <p>
     * Although each user is limited to a small number of signing certificates, you can still paginate the results using
     * the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * If the <code>UserName</code> field is not specified, the user name is determined implicitly based on the AWS
     * access key ID used to sign the request for this operation. This operation works for access keys under the AWS
     * account. Consequently, you can use this operation to manage AWS account root user credentials even if the AWS
     * account has no associated users.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSigningCertificatesRequest.Builder} avoiding
     * the need to create one manually via {@link ListSigningCertificatesRequest#builder()}
     * </p>
     *
     * @param listSigningCertificatesRequest
     *        A {@link Consumer} that will call methods on {@link ListSigningCertificatesRequest.Builder} to create a
     *        request.
     * @return Result of the ListSigningCertificates operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListSigningCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSigningCertificates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSigningCertificatesResponse listSigningCertificates(
            Consumer<ListSigningCertificatesRequest.Builder> listSigningCertificatesRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listSigningCertificates(ListSigningCertificatesRequest.builder().applyMutation(listSigningCertificatesRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about the signing certificates associated with the specified IAM user. If none exists, the
     * operation returns an empty list.
     * </p>
     * <p>
     * Although each user is limited to a small number of signing certificates, you can still paginate the results using
     * the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * If the <code>UserName</code> field is not specified, the user name is determined implicitly based on the AWS
     * access key ID used to sign the request for this operation. This operation works for access keys under the AWS
     * account. Consequently, you can use this operation to manage AWS account root user credentials even if the AWS
     * account has no associated users.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSigningCertificates(software.amazon.awssdk.services.iam.model.ListSigningCertificatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListSigningCertificatesIterable responses = client.listSigningCertificatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListSigningCertificatesIterable responses = client
     *             .listSigningCertificatesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListSigningCertificatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListSigningCertificatesIterable responses = client.listSigningCertificatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSigningCertificates(software.amazon.awssdk.services.iam.model.ListSigningCertificatesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListSigningCertificates
     * @see #listSigningCertificatesPaginator(ListSigningCertificatesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSigningCertificates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSigningCertificatesIterable listSigningCertificatesPaginator() throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listSigningCertificatesPaginator(ListSigningCertificatesRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about the signing certificates associated with the specified IAM user. If none exists, the
     * operation returns an empty list.
     * </p>
     * <p>
     * Although each user is limited to a small number of signing certificates, you can still paginate the results using
     * the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * If the <code>UserName</code> field is not specified, the user name is determined implicitly based on the AWS
     * access key ID used to sign the request for this operation. This operation works for access keys under the AWS
     * account. Consequently, you can use this operation to manage AWS account root user credentials even if the AWS
     * account has no associated users.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSigningCertificates(software.amazon.awssdk.services.iam.model.ListSigningCertificatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListSigningCertificatesIterable responses = client.listSigningCertificatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListSigningCertificatesIterable responses = client
     *             .listSigningCertificatesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListSigningCertificatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListSigningCertificatesIterable responses = client.listSigningCertificatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSigningCertificates(software.amazon.awssdk.services.iam.model.ListSigningCertificatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSigningCertificatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListSigningCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSigningCertificates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSigningCertificatesIterable listSigningCertificatesPaginator(
            ListSigningCertificatesRequest listSigningCertificatesRequest) throws NoSuchEntityException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the signing certificates associated with the specified IAM user. If none exists, the
     * operation returns an empty list.
     * </p>
     * <p>
     * Although each user is limited to a small number of signing certificates, you can still paginate the results using
     * the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * If the <code>UserName</code> field is not specified, the user name is determined implicitly based on the AWS
     * access key ID used to sign the request for this operation. This operation works for access keys under the AWS
     * account. Consequently, you can use this operation to manage AWS account root user credentials even if the AWS
     * account has no associated users.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSigningCertificates(software.amazon.awssdk.services.iam.model.ListSigningCertificatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListSigningCertificatesIterable responses = client.listSigningCertificatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListSigningCertificatesIterable responses = client
     *             .listSigningCertificatesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListSigningCertificatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListSigningCertificatesIterable responses = client.listSigningCertificatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSigningCertificates(software.amazon.awssdk.services.iam.model.ListSigningCertificatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSigningCertificatesRequest.Builder} avoiding
     * the need to create one manually via {@link ListSigningCertificatesRequest#builder()}
     * </p>
     *
     * @param listSigningCertificatesRequest
     *        A {@link Consumer} that will call methods on {@link ListSigningCertificatesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListSigningCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSigningCertificates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSigningCertificatesIterable listSigningCertificatesPaginator(
            Consumer<ListSigningCertificatesRequest.Builder> listSigningCertificatesRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listSigningCertificatesPaginator(ListSigningCertificatesRequest.builder()
                .applyMutation(listSigningCertificatesRequest).build());
    }

    /**
     * <p>
     * Lists the names of the inline policies embedded in the specified IAM user.
     * </p>
     * <p>
     * An IAM user can also have managed policies attached to it. To list the managed policies that are attached to a
     * user, use <a>ListAttachedUserPolicies</a>. For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. If there are no
     * inline policies embedded with the specified user, the operation returns an empty list.
     * </p>
     *
     * @param listUserPoliciesRequest
     * @return Result of the ListUserPolicies operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListUserPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListUserPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUserPoliciesResponse listUserPolicies(ListUserPoliciesRequest listUserPoliciesRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the names of the inline policies embedded in the specified IAM user.
     * </p>
     * <p>
     * An IAM user can also have managed policies attached to it. To list the managed policies that are attached to a
     * user, use <a>ListAttachedUserPolicies</a>. For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. If there are no
     * inline policies embedded with the specified user, the operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUserPoliciesRequest.Builder} avoiding the need
     * to create one manually via {@link ListUserPoliciesRequest#builder()}
     * </p>
     *
     * @param listUserPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListUserPoliciesRequest.Builder} to create a request.
     * @return Result of the ListUserPolicies operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListUserPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListUserPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUserPoliciesResponse listUserPolicies(Consumer<ListUserPoliciesRequest.Builder> listUserPoliciesRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listUserPolicies(ListUserPoliciesRequest.builder().applyMutation(listUserPoliciesRequest).build());
    }

    /**
     * <p>
     * Lists the names of the inline policies embedded in the specified IAM user.
     * </p>
     * <p>
     * An IAM user can also have managed policies attached to it. To list the managed policies that are attached to a
     * user, use <a>ListAttachedUserPolicies</a>. For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. If there are no
     * inline policies embedded with the specified user, the operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listUserPolicies(software.amazon.awssdk.services.iam.model.ListUserPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListUserPoliciesIterable responses = client.listUserPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListUserPoliciesIterable responses = client.listUserPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListUserPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListUserPoliciesIterable responses = client.listUserPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUserPolicies(software.amazon.awssdk.services.iam.model.ListUserPoliciesRequest)} operation.</b>
     * </p>
     *
     * @param listUserPoliciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListUserPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListUserPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUserPoliciesIterable listUserPoliciesPaginator(ListUserPoliciesRequest listUserPoliciesRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the names of the inline policies embedded in the specified IAM user.
     * </p>
     * <p>
     * An IAM user can also have managed policies attached to it. To list the managed policies that are attached to a
     * user, use <a>ListAttachedUserPolicies</a>. For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. If there are no
     * inline policies embedded with the specified user, the operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listUserPolicies(software.amazon.awssdk.services.iam.model.ListUserPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListUserPoliciesIterable responses = client.listUserPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListUserPoliciesIterable responses = client.listUserPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListUserPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListUserPoliciesIterable responses = client.listUserPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUserPolicies(software.amazon.awssdk.services.iam.model.ListUserPoliciesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUserPoliciesRequest.Builder} avoiding the need
     * to create one manually via {@link ListUserPoliciesRequest#builder()}
     * </p>
     *
     * @param listUserPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListUserPoliciesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListUserPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListUserPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUserPoliciesIterable listUserPoliciesPaginator(Consumer<ListUserPoliciesRequest.Builder> listUserPoliciesRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listUserPoliciesPaginator(ListUserPoliciesRequest.builder().applyMutation(listUserPoliciesRequest).build());
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified IAM user. The returned list of tags is sorted by tag key. For
     * more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     *
     * @param listUserTagsRequest
     * @return Result of the ListUserTags operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListUserTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListUserTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUserTagsResponse listUserTags(ListUserTagsRequest listUserTagsRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified IAM user. The returned list of tags is sorted by tag key. For
     * more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUserTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListUserTagsRequest#builder()}
     * </p>
     *
     * @param listUserTagsRequest
     *        A {@link Consumer} that will call methods on {@link ListUserTagsRequest.Builder} to create a request.
     * @return Result of the ListUserTags operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListUserTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListUserTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUserTagsResponse listUserTags(Consumer<ListUserTagsRequest.Builder> listUserTagsRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listUserTags(ListUserTagsRequest.builder().applyMutation(listUserTagsRequest).build());
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified IAM user. The returned list of tags is sorted by tag key. For
     * more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listUserTags(software.amazon.awssdk.services.iam.model.ListUserTagsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListUserTagsIterable responses = client.listUserTagsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListUserTagsIterable responses = client.listUserTagsPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListUserTagsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListUserTagsIterable responses = client.listUserTagsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUserTags(software.amazon.awssdk.services.iam.model.ListUserTagsRequest)} operation.</b>
     * </p>
     *
     * @param listUserTagsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListUserTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListUserTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUserTagsIterable listUserTagsPaginator(ListUserTagsRequest listUserTagsRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified IAM user. The returned list of tags is sorted by tag key. For
     * more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listUserTags(software.amazon.awssdk.services.iam.model.ListUserTagsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListUserTagsIterable responses = client.listUserTagsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListUserTagsIterable responses = client.listUserTagsPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListUserTagsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListUserTagsIterable responses = client.listUserTagsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUserTags(software.amazon.awssdk.services.iam.model.ListUserTagsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUserTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListUserTagsRequest#builder()}
     * </p>
     *
     * @param listUserTagsRequest
     *        A {@link Consumer} that will call methods on {@link ListUserTagsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListUserTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListUserTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUserTagsIterable listUserTagsPaginator(Consumer<ListUserTagsRequest.Builder> listUserTagsRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listUserTagsPaginator(ListUserTagsRequest.builder().applyMutation(listUserTagsRequest).build());
    }

    /**
     * <p>
     * Lists the IAM users that have the specified path prefix. If no path prefix is specified, the operation returns
     * all users in the AWS account. If there are none, the operation returns an empty list.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for a user, see <a>GetUser</a>.
     * </p>
     * </note>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @return Result of the ListUsers operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListUsers
     * @see #listUsers(ListUsersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersResponse listUsers() throws ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listUsers(ListUsersRequest.builder().build());
    }

    /**
     * <p>
     * Lists the IAM users that have the specified path prefix. If no path prefix is specified, the operation returns
     * all users in the AWS account. If there are none, the operation returns an empty list.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for a user, see <a>GetUser</a>.
     * </p>
     * </note>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listUsersRequest
     * @return Result of the ListUsers operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersResponse listUsers(ListUsersRequest listUsersRequest) throws ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the IAM users that have the specified path prefix. If no path prefix is specified, the operation returns
     * all users in the AWS account. If there are none, the operation returns an empty list.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for a user, see <a>GetUser</a>.
     * </p>
     * </note>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsersRequest.Builder} avoiding the need to
     * create one manually via {@link ListUsersRequest#builder()}
     * </p>
     *
     * @param listUsersRequest
     *        A {@link Consumer} that will call methods on {@link ListUsersRequest.Builder} to create a request.
     * @return Result of the ListUsers operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersResponse listUsers(Consumer<ListUsersRequest.Builder> listUsersRequest) throws ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        return listUsers(ListUsersRequest.builder().applyMutation(listUsersRequest).build());
    }

    /**
     * <p>
     * Lists the IAM users that have the specified path prefix. If no path prefix is specified, the operation returns
     * all users in the AWS account. If there are none, the operation returns an empty list.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for a user, see <a>GetUser</a>.
     * </p>
     * </note>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listUsers(software.amazon.awssdk.services.iam.model.ListUsersRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListUsersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsers(software.amazon.awssdk.services.iam.model.ListUsersRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListUsers
     * @see #listUsersPaginator(ListUsersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersIterable listUsersPaginator() throws ServiceFailureException, AwsServiceException, SdkClientException,
            IamException {
        return listUsersPaginator(ListUsersRequest.builder().build());
    }

    /**
     * <p>
     * Lists the IAM users that have the specified path prefix. If no path prefix is specified, the operation returns
     * all users in the AWS account. If there are none, the operation returns an empty list.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for a user, see <a>GetUser</a>.
     * </p>
     * </note>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listUsers(software.amazon.awssdk.services.iam.model.ListUsersRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListUsersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsers(software.amazon.awssdk.services.iam.model.ListUsersRequest)} operation.</b>
     * </p>
     *
     * @param listUsersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersIterable listUsersPaginator(ListUsersRequest listUsersRequest) throws ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the IAM users that have the specified path prefix. If no path prefix is specified, the operation returns
     * all users in the AWS account. If there are none, the operation returns an empty list.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for a user, see <a>GetUser</a>.
     * </p>
     * </note>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listUsers(software.amazon.awssdk.services.iam.model.ListUsersRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListUsersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsers(software.amazon.awssdk.services.iam.model.ListUsersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsersRequest.Builder} avoiding the need to
     * create one manually via {@link ListUsersRequest#builder()}
     * </p>
     *
     * @param listUsersRequest
     *        A {@link Consumer} that will call methods on {@link ListUsersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersIterable listUsersPaginator(Consumer<ListUsersRequest.Builder> listUsersRequest)
            throws ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return listUsersPaginator(ListUsersRequest.builder().applyMutation(listUsersRequest).build());
    }

    /**
     * <p>
     * Lists the virtual MFA devices defined in the AWS account by assignment status. If you do not specify an
     * assignment status, the operation returns a list of all virtual MFA devices. Assignment status can be
     * <code>Assigned</code>, <code>Unassigned</code>, or <code>Any</code>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for a virtual MFA device, see <a>ListVirtualMFADevices</a>.
     * </p>
     * </note>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @return Result of the ListVirtualMFADevices operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListVirtualMFADevices
     * @see #listVirtualMFADevices(ListVirtualMfaDevicesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListVirtualMFADevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListVirtualMfaDevicesResponse listVirtualMFADevices() throws AwsServiceException, SdkClientException, IamException {
        return listVirtualMFADevices(ListVirtualMfaDevicesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the virtual MFA devices defined in the AWS account by assignment status. If you do not specify an
     * assignment status, the operation returns a list of all virtual MFA devices. Assignment status can be
     * <code>Assigned</code>, <code>Unassigned</code>, or <code>Any</code>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for a virtual MFA device, see <a>ListVirtualMFADevices</a>.
     * </p>
     * </note>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listVirtualMfaDevicesRequest
     * @return Result of the ListVirtualMFADevices operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListVirtualMFADevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListVirtualMFADevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListVirtualMfaDevicesResponse listVirtualMFADevices(ListVirtualMfaDevicesRequest listVirtualMfaDevicesRequest)
            throws AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the virtual MFA devices defined in the AWS account by assignment status. If you do not specify an
     * assignment status, the operation returns a list of all virtual MFA devices. Assignment status can be
     * <code>Assigned</code>, <code>Unassigned</code>, or <code>Any</code>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for a virtual MFA device, see <a>ListVirtualMFADevices</a>.
     * </p>
     * </note>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVirtualMfaDevicesRequest.Builder} avoiding the
     * need to create one manually via {@link ListVirtualMfaDevicesRequest#builder()}
     * </p>
     *
     * @param listVirtualMfaDevicesRequest
     *        A {@link Consumer} that will call methods on {@link ListVirtualMFADevicesRequest.Builder} to create a
     *        request.
     * @return Result of the ListVirtualMFADevices operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListVirtualMFADevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListVirtualMFADevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListVirtualMfaDevicesResponse listVirtualMFADevices(
            Consumer<ListVirtualMfaDevicesRequest.Builder> listVirtualMfaDevicesRequest) throws AwsServiceException,
            SdkClientException, IamException {
        return listVirtualMFADevices(ListVirtualMfaDevicesRequest.builder().applyMutation(listVirtualMfaDevicesRequest).build());
    }

    /**
     * <p>
     * Lists the virtual MFA devices defined in the AWS account by assignment status. If you do not specify an
     * assignment status, the operation returns a list of all virtual MFA devices. Assignment status can be
     * <code>Assigned</code>, <code>Unassigned</code>, or <code>Any</code>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for a virtual MFA device, see <a>ListVirtualMFADevices</a>.
     * </p>
     * </note>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVirtualMFADevices(software.amazon.awssdk.services.iam.model.ListVirtualMfaDevicesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListVirtualMFADevicesIterable responses = client.listVirtualMFADevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListVirtualMFADevicesIterable responses = client
     *             .listVirtualMFADevicesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListVirtualMfaDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListVirtualMFADevicesIterable responses = client.listVirtualMFADevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVirtualMFADevices(software.amazon.awssdk.services.iam.model.ListVirtualMfaDevicesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListVirtualMFADevices
     * @see #listVirtualMFADevicesPaginator(ListVirtualMfaDevicesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListVirtualMFADevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListVirtualMFADevicesIterable listVirtualMFADevicesPaginator() throws AwsServiceException, SdkClientException,
            IamException {
        return listVirtualMFADevicesPaginator(ListVirtualMfaDevicesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the virtual MFA devices defined in the AWS account by assignment status. If you do not specify an
     * assignment status, the operation returns a list of all virtual MFA devices. Assignment status can be
     * <code>Assigned</code>, <code>Unassigned</code>, or <code>Any</code>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for a virtual MFA device, see <a>ListVirtualMFADevices</a>.
     * </p>
     * </note>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVirtualMFADevices(software.amazon.awssdk.services.iam.model.ListVirtualMfaDevicesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListVirtualMFADevicesIterable responses = client.listVirtualMFADevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListVirtualMFADevicesIterable responses = client
     *             .listVirtualMFADevicesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListVirtualMfaDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListVirtualMFADevicesIterable responses = client.listVirtualMFADevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVirtualMFADevices(software.amazon.awssdk.services.iam.model.ListVirtualMfaDevicesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVirtualMfaDevicesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListVirtualMFADevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListVirtualMFADevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListVirtualMFADevicesIterable listVirtualMFADevicesPaginator(ListVirtualMfaDevicesRequest listVirtualMfaDevicesRequest)
            throws AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the virtual MFA devices defined in the AWS account by assignment status. If you do not specify an
     * assignment status, the operation returns a list of all virtual MFA devices. Assignment status can be
     * <code>Assigned</code>, <code>Unassigned</code>, or <code>Any</code>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for a virtual MFA device, see <a>ListVirtualMFADevices</a>.
     * </p>
     * </note>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVirtualMFADevices(software.amazon.awssdk.services.iam.model.ListVirtualMfaDevicesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListVirtualMFADevicesIterable responses = client.listVirtualMFADevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListVirtualMFADevicesIterable responses = client
     *             .listVirtualMFADevicesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListVirtualMfaDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListVirtualMFADevicesIterable responses = client.listVirtualMFADevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVirtualMFADevices(software.amazon.awssdk.services.iam.model.ListVirtualMfaDevicesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVirtualMfaDevicesRequest.Builder} avoiding the
     * need to create one manually via {@link ListVirtualMfaDevicesRequest#builder()}
     * </p>
     *
     * @param listVirtualMfaDevicesRequest
     *        A {@link Consumer} that will call methods on {@link ListVirtualMFADevicesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListVirtualMFADevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListVirtualMFADevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListVirtualMFADevicesIterable listVirtualMFADevicesPaginator(
            Consumer<ListVirtualMfaDevicesRequest.Builder> listVirtualMfaDevicesRequest) throws AwsServiceException,
            SdkClientException, IamException {
        return listVirtualMFADevicesPaginator(ListVirtualMfaDevicesRequest.builder().applyMutation(listVirtualMfaDevicesRequest)
                .build());
    }

    /**
     * <p>
     * Adds or updates an inline policy document that is embedded in the specified IAM group.
     * </p>
     * <p>
     * A user can also have managed policies attached to it. To attach a managed policy to a group, use
     * <a>AttachGroupPolicy</a>. To create a new managed policy, use <a>CreatePolicy</a>. For information about
     * policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed
     * policies and inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For information about the maximum number of inline policies that you can embed in a group, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * Because policy documents can be large, you should use POST rather than GET when calling
     * <code>PutGroupPolicy</code>. For general information about using the Query API with IAM, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html">Making query requests</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * </note>
     *
     * @param putGroupPolicyRequest
     * @return Result of the PutGroupPolicy operation returned by the service.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws MalformedPolicyDocumentException
     *         The request was rejected because the policy document was malformed. The error message describes the
     *         specific error.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.PutGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PutGroupPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default PutGroupPolicyResponse putGroupPolicy(PutGroupPolicyRequest putGroupPolicyRequest) throws LimitExceededException,
            MalformedPolicyDocumentException, NoSuchEntityException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates an inline policy document that is embedded in the specified IAM group.
     * </p>
     * <p>
     * A user can also have managed policies attached to it. To attach a managed policy to a group, use
     * <a>AttachGroupPolicy</a>. To create a new managed policy, use <a>CreatePolicy</a>. For information about
     * policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed
     * policies and inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For information about the maximum number of inline policies that you can embed in a group, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * Because policy documents can be large, you should use POST rather than GET when calling
     * <code>PutGroupPolicy</code>. For general information about using the Query API with IAM, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html">Making query requests</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutGroupPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link PutGroupPolicyRequest#builder()}
     * </p>
     *
     * @param putGroupPolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutGroupPolicyRequest.Builder} to create a request.
     * @return Result of the PutGroupPolicy operation returned by the service.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws MalformedPolicyDocumentException
     *         The request was rejected because the policy document was malformed. The error message describes the
     *         specific error.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.PutGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PutGroupPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default PutGroupPolicyResponse putGroupPolicy(Consumer<PutGroupPolicyRequest.Builder> putGroupPolicyRequest)
            throws LimitExceededException, MalformedPolicyDocumentException, NoSuchEntityException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        return putGroupPolicy(PutGroupPolicyRequest.builder().applyMutation(putGroupPolicyRequest).build());
    }

    /**
     * <p>
     * Adds or updates the policy that is specified as the IAM role's permissions boundary. You can use an AWS managed
     * policy or a customer managed policy to set the boundary for a role. Use the boundary to control the maximum
     * permissions that the role can have. Setting a permissions boundary is an advanced feature that can affect the
     * permissions for the role.
     * </p>
     * <p>
     * You cannot set the boundary for a service-linked role.
     * </p>
     * <important>
     * <p>
     * Policies used as permissions boundaries do not provide permissions. You must also attach a permissions policy to
     * the role. To learn how the effective permissions for a role are evaluated, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html">IAM JSON policy
     * evaluation logic</a> in the IAM User Guide.
     * </p>
     * </important>
     *
     * @param putRolePermissionsBoundaryRequest
     * @return Result of the PutRolePermissionsBoundary operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws UnmodifiableEntityException
     *         The request was rejected because only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.
     * @throws PolicyNotAttachableException
     *         The request failed because AWS service role policies can only be attached to the service-linked role for
     *         that service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.PutRolePermissionsBoundary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PutRolePermissionsBoundary"
     *      target="_top">AWS API Documentation</a>
     */
    default PutRolePermissionsBoundaryResponse putRolePermissionsBoundary(
            PutRolePermissionsBoundaryRequest putRolePermissionsBoundaryRequest) throws NoSuchEntityException,
            InvalidInputException, UnmodifiableEntityException, PolicyNotAttachableException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates the policy that is specified as the IAM role's permissions boundary. You can use an AWS managed
     * policy or a customer managed policy to set the boundary for a role. Use the boundary to control the maximum
     * permissions that the role can have. Setting a permissions boundary is an advanced feature that can affect the
     * permissions for the role.
     * </p>
     * <p>
     * You cannot set the boundary for a service-linked role.
     * </p>
     * <important>
     * <p>
     * Policies used as permissions boundaries do not provide permissions. You must also attach a permissions policy to
     * the role. To learn how the effective permissions for a role are evaluated, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html">IAM JSON policy
     * evaluation logic</a> in the IAM User Guide.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutRolePermissionsBoundaryRequest.Builder} avoiding
     * the need to create one manually via {@link PutRolePermissionsBoundaryRequest#builder()}
     * </p>
     *
     * @param putRolePermissionsBoundaryRequest
     *        A {@link Consumer} that will call methods on {@link PutRolePermissionsBoundaryRequest.Builder} to create a
     *        request.
     * @return Result of the PutRolePermissionsBoundary operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws UnmodifiableEntityException
     *         The request was rejected because only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.
     * @throws PolicyNotAttachableException
     *         The request failed because AWS service role policies can only be attached to the service-linked role for
     *         that service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.PutRolePermissionsBoundary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PutRolePermissionsBoundary"
     *      target="_top">AWS API Documentation</a>
     */
    default PutRolePermissionsBoundaryResponse putRolePermissionsBoundary(
            Consumer<PutRolePermissionsBoundaryRequest.Builder> putRolePermissionsBoundaryRequest) throws NoSuchEntityException,
            InvalidInputException, UnmodifiableEntityException, PolicyNotAttachableException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        return putRolePermissionsBoundary(PutRolePermissionsBoundaryRequest.builder()
                .applyMutation(putRolePermissionsBoundaryRequest).build());
    }

    /**
     * <p>
     * Adds or updates an inline policy document that is embedded in the specified IAM role.
     * </p>
     * <p>
     * When you embed an inline policy in a role, the inline policy is used as part of the role's access (permissions)
     * policy. The role's trust policy is created at the same time as the role, using <a>CreateRole</a>. You can update
     * a role's trust policy using <a>UpdateAssumeRolePolicy</a>. For more information about IAM roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html">Using roles to delegate permissions
     * and federate identities</a>.
     * </p>
     * <p>
     * A role can also have a managed policy attached to it. To attach a managed policy to a role, use
     * <a>AttachRolePolicy</a>. To create a new managed policy, use <a>CreatePolicy</a>. For information about policies,
     * see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies
     * and inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For information about the maximum number of inline policies that you can embed with a role, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * Because policy documents can be large, you should use POST rather than GET when calling
     * <code>PutRolePolicy</code>. For general information about using the Query API with IAM, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html">Making query requests</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * </note>
     *
     * @param putRolePolicyRequest
     * @return Result of the PutRolePolicy operation returned by the service.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws MalformedPolicyDocumentException
     *         The request was rejected because the policy document was malformed. The error message describes the
     *         specific error.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws UnmodifiableEntityException
     *         The request was rejected because only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.PutRolePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PutRolePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default PutRolePolicyResponse putRolePolicy(PutRolePolicyRequest putRolePolicyRequest) throws LimitExceededException,
            MalformedPolicyDocumentException, NoSuchEntityException, UnmodifiableEntityException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates an inline policy document that is embedded in the specified IAM role.
     * </p>
     * <p>
     * When you embed an inline policy in a role, the inline policy is used as part of the role's access (permissions)
     * policy. The role's trust policy is created at the same time as the role, using <a>CreateRole</a>. You can update
     * a role's trust policy using <a>UpdateAssumeRolePolicy</a>. For more information about IAM roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html">Using roles to delegate permissions
     * and federate identities</a>.
     * </p>
     * <p>
     * A role can also have a managed policy attached to it. To attach a managed policy to a role, use
     * <a>AttachRolePolicy</a>. To create a new managed policy, use <a>CreatePolicy</a>. For information about policies,
     * see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies
     * and inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For information about the maximum number of inline policies that you can embed with a role, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * Because policy documents can be large, you should use POST rather than GET when calling
     * <code>PutRolePolicy</code>. For general information about using the Query API with IAM, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html">Making query requests</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutRolePolicyRequest.Builder} avoiding the need to
     * create one manually via {@link PutRolePolicyRequest#builder()}
     * </p>
     *
     * @param putRolePolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutRolePolicyRequest.Builder} to create a request.
     * @return Result of the PutRolePolicy operation returned by the service.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error message describes the limit exceeded.
     * @throws MalformedPolicyDocumentException
     *         The request was rejected because the policy document was malformed. The error message describes the
     *         specific error.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws UnmodifiableEntityException
     *         The request was rejected because only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.PutRolePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PutRolePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default PutRolePolicyResponse putRolePolicy(Consumer<PutRolePolicyRequest.Builder> putRolePolicyRequest)
            throws LimitExceededException, MalformedPolicyDocumentException, NoSuchEntityException, UnmodifiableEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return putRolePolicy(PutRolePolicyRequest.builder().applyMutation(putRolePolicyRequest).build());
    }

    /**
     * <p>
     * Adds or updates the policy that is specified as the IAM user's permissions boundary. You can use an AWS managed
     * policy or a customer managed policy to set the boundary for a user. Use the boundary to control the maximum
     * permissions that the user can have. Setting a permissions boundary is an advanced feature that can affect the
     * permissions for the user.
     * </p>
     * <important>
     * <p>
     * Policies that are used as permissions boundaries do not provide permissions. You must also attach a permissions
     * policy to the user. To learn how the effective permissions for a user are evaluated, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html">IAM JSON policy
     * evaluation logic</a> in the IAM User Guide.
     * </p>
     * </important>
     *
     * @param putUserPermissionsBoundaryRequest
     * @return Result of the PutUserPermissionsBoundary operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws PolicyNotAttachableException
     *         The request failed because AWS service role policies can only be attached to the service-linked role for
     *         that service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.PutUserPermissionsBoundary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PutUserPermissionsBoundary"
     *      target="_top">AWS API Documentation</a>
     */
    default PutUserPermissionsBoundaryResponse putUserPermissionsBoundary(
            PutUserPermissionsBoundaryRequest putUserPermissionsBoundaryRequest) throws NoSuchEntityException,
            InvalidInputException, PolicyNotAttachableException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates the policy that is specified as the IAM user's permissions boundary. You can use an AWS managed
     * policy or a customer managed policy to set the boundary for a user. Use the boundary to control the maximum
     * permissions that the user can have. Setting a permissions boundary is an advanced feature that can affect the
     * permissions for the user.
     * </p>
     * <important>
     * <p>
     * Policies that are used as permissions boundaries do not provide permissions. You must also attach a permissions
     * policy to the user. To learn how the effective permissions for a user are evaluated, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html">IAM JSON policy
     * evaluation logic</a> in the IAM User Guide.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutUserPermissionsBoundaryRequest.Builder} avoiding
     * the need to create one manually via {@link PutUserPermissionsBoundaryRequest#builder()}
     * </p>
     *
     * @param putUserPermissionsBoundaryRequest
     *        A {@link Consumer} that will call methods on {@link PutUserPermissionsBoundaryRequest.Builder} to create a
     *        request.
     * @return Result of the PutUserPermissionsBoundary operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws PolicyNotAttachableException
     *         The request failed because AWS service role policies can only be attached to the service-linked role for
     *         that service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.PutUserPermissionsBoundary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PutUserPermissionsBoundary"
     *  