/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a successful <a>ListServerCertificates</a> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServerCertificatesResponse extends IamResponse implements
        ToCopyableBuilder<ListServerCertificatesResponse.Builder, ListServerCertificatesResponse> {
    private static final SdkField<List<ServerCertificateMetadata>> SERVER_CERTIFICATE_METADATA_LIST_FIELD = SdkField
            .<List<ServerCertificateMetadata>> builder(MarshallingType.LIST)
            .memberName("ServerCertificateMetadataList")
            .getter(getter(ListServerCertificatesResponse::serverCertificateMetadataList))
            .setter(setter(Builder::serverCertificateMetadataList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerCertificateMetadataList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServerCertificateMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServerCertificateMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsTruncated").getter(getter(ListServerCertificatesResponse::isTruncated))
            .setter(setter(Builder::isTruncated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListServerCertificatesResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SERVER_CERTIFICATE_METADATA_LIST_FIELD, IS_TRUNCATED_FIELD, MARKER_FIELD));

    private final List<ServerCertificateMetadata> serverCertificateMetadataList;

    private final Boolean isTruncated;

    private final String marker;

    private ListServerCertificatesResponse(BuilderImpl builder) {
        super(builder);
        this.serverCertificateMetadataList = builder.serverCertificateMetadataList;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    /**
     * Returns true if the ServerCertificateMetadataList property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasServerCertificateMetadataList() {
        return serverCertificateMetadataList != null && !(serverCertificateMetadataList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of server certificates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasServerCertificateMetadataList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of server certificates.
     */
    public final List<ServerCertificateMetadata> serverCertificateMetadataList() {
        return serverCertificateMetadataList;
    }

    /**
     * <p>
     * A flag that indicates whether there are more items to return. If your results were truncated, you can make a
     * subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that
     * IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results
     * available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all
     * your results.
     * </p>
     * 
     * @return A flag that indicates whether there are more items to return. If your results were truncated, you can
     *         make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more
     *         items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there
     *         are more results available. We recommend that you check <code>IsTruncated</code> after every call to
     *         ensure that you receive all your results.
     */
    public final Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the
     * <code>Marker</code> parameter in a subsequent pagination request.
     * </p>
     * 
     * @return When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use
     *         for the <code>Marker</code> parameter in a subsequent pagination request.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasServerCertificateMetadataList() ? serverCertificateMetadataList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServerCertificatesResponse)) {
            return false;
        }
        ListServerCertificatesResponse other = (ListServerCertificatesResponse) obj;
        return hasServerCertificateMetadataList() == other.hasServerCertificateMetadataList()
                && Objects.equals(serverCertificateMetadataList(), other.serverCertificateMetadataList())
                && Objects.equals(isTruncated(), other.isTruncated()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListServerCertificatesResponse")
                .add("ServerCertificateMetadataList", hasServerCertificateMetadataList() ? serverCertificateMetadataList() : null)
                .add("IsTruncated", isTruncated()).add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerCertificateMetadataList":
            return Optional.ofNullable(clazz.cast(serverCertificateMetadataList()));
        case "IsTruncated":
            return Optional.ofNullable(clazz.cast(isTruncated()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListServerCertificatesResponse, T> g) {
        return obj -> g.apply((ListServerCertificatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListServerCertificatesResponse> {
        /**
         * <p>
         * A list of server certificates.
         * </p>
         * 
         * @param serverCertificateMetadataList
         *        A list of server certificates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverCertificateMetadataList(Collection<ServerCertificateMetadata> serverCertificateMetadataList);

        /**
         * <p>
         * A list of server certificates.
         * </p>
         * 
         * @param serverCertificateMetadataList
         *        A list of server certificates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverCertificateMetadataList(ServerCertificateMetadata... serverCertificateMetadataList);

        /**
         * <p>
         * A list of server certificates.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ServerCertificateMetadata>.Builder}
         * avoiding the need to create one manually via {@link List<ServerCertificateMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ServerCertificateMetadata>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #serverCertificateMetadataList(List<ServerCertificateMetadata>)}.
         * 
         * @param serverCertificateMetadataList
         *        a consumer that will call methods on {@link List<ServerCertificateMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverCertificateMetadataList(List<ServerCertificateMetadata>)
         */
        Builder serverCertificateMetadataList(Consumer<ServerCertificateMetadata.Builder>... serverCertificateMetadataList);

        /**
         * <p>
         * A flag that indicates whether there are more items to return. If your results were truncated, you can make a
         * subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note
         * that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results
         * available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive
         * all your results.
         * </p>
         * 
         * @param isTruncated
         *        A flag that indicates whether there are more items to return. If your results were truncated, you can
         *        make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more
         *        items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when
         *        there are more results available. We recommend that you check <code>IsTruncated</code> after every
         *        call to ensure that you receive all your results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for
         * the <code>Marker</code> parameter in a subsequent pagination request.
         * </p>
         * 
         * @param marker
         *        When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to
         *        use for the <code>Marker</code> parameter in a subsequent pagination request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends IamResponse.BuilderImpl implements Builder {
        private List<ServerCertificateMetadata> serverCertificateMetadataList = DefaultSdkAutoConstructList.getInstance();

        private Boolean isTruncated;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServerCertificatesResponse model) {
            super(model);
            serverCertificateMetadataList(model.serverCertificateMetadataList);
            isTruncated(model.isTruncated);
            marker(model.marker);
        }

        public final List<ServerCertificateMetadata.Builder> getServerCertificateMetadataList() {
            List<ServerCertificateMetadata.Builder> result = _serverCertificateMetadataListTypeCopier
                    .copyToBuilder(this.serverCertificateMetadataList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder serverCertificateMetadataList(Collection<ServerCertificateMetadata> serverCertificateMetadataList) {
            this.serverCertificateMetadataList = _serverCertificateMetadataListTypeCopier.copy(serverCertificateMetadataList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverCertificateMetadataList(ServerCertificateMetadata... serverCertificateMetadataList) {
            serverCertificateMetadataList(Arrays.asList(serverCertificateMetadataList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverCertificateMetadataList(
                Consumer<ServerCertificateMetadata.Builder>... serverCertificateMetadataList) {
            serverCertificateMetadataList(Stream.of(serverCertificateMetadataList)
                    .map(c -> ServerCertificateMetadata.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServerCertificateMetadataList(
                Collection<ServerCertificateMetadata.BuilderImpl> serverCertificateMetadataList) {
            this.serverCertificateMetadataList = _serverCertificateMetadataListTypeCopier
                    .copyFromBuilder(serverCertificateMetadataList);
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListServerCertificatesResponse build() {
            return new ListServerCertificatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
