/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.GroupDetail;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.services.iam.model.ManagedPolicyDetail;
import software.amazon.awssdk.services.iam.model.ManagedPolicyDetailListTypeCopier;
import software.amazon.awssdk.services.iam.model.RoleDetail;
import software.amazon.awssdk.services.iam.model.UserDetail;
import software.amazon.awssdk.services.iam.model._groupDetailListTypeCopier;
import software.amazon.awssdk.services.iam.model._roleDetailListTypeCopier;
import software.amazon.awssdk.services.iam.model._userDetailListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAccountAuthorizationDetailsResponse
extends IamResponse
implements ToCopyableBuilder<Builder, GetAccountAuthorizationDetailsResponse> {
    private static final SdkField<List<UserDetail>> USER_DETAIL_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserDetailList").getter(GetAccountAuthorizationDetailsResponse.getter(GetAccountAuthorizationDetailsResponse::userDetailList)).setter(GetAccountAuthorizationDetailsResponse.setter(Builder::userDetailList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserDetailList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<GroupDetail>> GROUP_DETAIL_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GroupDetailList").getter(GetAccountAuthorizationDetailsResponse.getter(GetAccountAuthorizationDetailsResponse::groupDetailList)).setter(GetAccountAuthorizationDetailsResponse.setter(Builder::groupDetailList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupDetailList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RoleDetail>> ROLE_DETAIL_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RoleDetailList").getter(GetAccountAuthorizationDetailsResponse.getter(GetAccountAuthorizationDetailsResponse::roleDetailList)).setter(GetAccountAuthorizationDetailsResponse.setter(Builder::roleDetailList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleDetailList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RoleDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ManagedPolicyDetail>> POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Policies").getter(GetAccountAuthorizationDetailsResponse.getter(GetAccountAuthorizationDetailsResponse::policies)).setter(GetAccountAuthorizationDetailsResponse.setter(Builder::policies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ManagedPolicyDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsTruncated").getter(GetAccountAuthorizationDetailsResponse.getter(GetAccountAuthorizationDetailsResponse::isTruncated)).setter(GetAccountAuthorizationDetailsResponse.setter(Builder::isTruncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(GetAccountAuthorizationDetailsResponse.getter(GetAccountAuthorizationDetailsResponse::marker)).setter(GetAccountAuthorizationDetailsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_DETAIL_LIST_FIELD, GROUP_DETAIL_LIST_FIELD, ROLE_DETAIL_LIST_FIELD, POLICIES_FIELD, IS_TRUNCATED_FIELD, MARKER_FIELD));
    private final List<UserDetail> userDetailList;
    private final List<GroupDetail> groupDetailList;
    private final List<RoleDetail> roleDetailList;
    private final List<ManagedPolicyDetail> policies;
    private final Boolean isTruncated;
    private final String marker;

    private GetAccountAuthorizationDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.userDetailList = builder.userDetailList;
        this.groupDetailList = builder.groupDetailList;
        this.roleDetailList = builder.roleDetailList;
        this.policies = builder.policies;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public final boolean hasUserDetailList() {
        return this.userDetailList != null && !(this.userDetailList instanceof SdkAutoConstructList);
    }

    public final List<UserDetail> userDetailList() {
        return this.userDetailList;
    }

    public final boolean hasGroupDetailList() {
        return this.groupDetailList != null && !(this.groupDetailList instanceof SdkAutoConstructList);
    }

    public final List<GroupDetail> groupDetailList() {
        return this.groupDetailList;
    }

    public final boolean hasRoleDetailList() {
        return this.roleDetailList != null && !(this.roleDetailList instanceof SdkAutoConstructList);
    }

    public final List<RoleDetail> roleDetailList() {
        return this.roleDetailList;
    }

    public final boolean hasPolicies() {
        return this.policies != null && !(this.policies instanceof SdkAutoConstructList);
    }

    public final List<ManagedPolicyDetail> policies() {
        return this.policies;
    }

    public final Boolean isTruncated() {
        return this.isTruncated;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserDetailList() ? this.userDetailList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupDetailList() ? this.groupDetailList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoleDetailList() ? this.roleDetailList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicies() ? this.policies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountAuthorizationDetailsResponse)) {
            return false;
        }
        GetAccountAuthorizationDetailsResponse other = (GetAccountAuthorizationDetailsResponse)((Object)obj);
        return this.hasUserDetailList() == other.hasUserDetailList() && Objects.equals(this.userDetailList(), other.userDetailList()) && this.hasGroupDetailList() == other.hasGroupDetailList() && Objects.equals(this.groupDetailList(), other.groupDetailList()) && this.hasRoleDetailList() == other.hasRoleDetailList() && Objects.equals(this.roleDetailList(), other.roleDetailList()) && this.hasPolicies() == other.hasPolicies() && Objects.equals(this.policies(), other.policies()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"GetAccountAuthorizationDetailsResponse").add("UserDetailList", this.hasUserDetailList() ? this.userDetailList() : null).add("GroupDetailList", this.hasGroupDetailList() ? this.groupDetailList() : null).add("RoleDetailList", this.hasRoleDetailList() ? this.roleDetailList() : null).add("Policies", this.hasPolicies() ? this.policies() : null).add("IsTruncated", (Object)this.isTruncated()).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserDetailList": {
                return Optional.ofNullable(clazz.cast(this.userDetailList()));
            }
            case "GroupDetailList": {
                return Optional.ofNullable(clazz.cast(this.groupDetailList()));
            }
            case "RoleDetailList": {
                return Optional.ofNullable(clazz.cast(this.roleDetailList()));
            }
            case "Policies": {
                return Optional.ofNullable(clazz.cast(this.policies()));
            }
            case "IsTruncated": {
                return Optional.ofNullable(clazz.cast(this.isTruncated()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAccountAuthorizationDetailsResponse, T> g) {
        return obj -> g.apply((GetAccountAuthorizationDetailsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private List<UserDetail> userDetailList = DefaultSdkAutoConstructList.getInstance();
        private List<GroupDetail> groupDetailList = DefaultSdkAutoConstructList.getInstance();
        private List<RoleDetail> roleDetailList = DefaultSdkAutoConstructList.getInstance();
        private List<ManagedPolicyDetail> policies = DefaultSdkAutoConstructList.getInstance();
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountAuthorizationDetailsResponse model) {
            super(model);
            this.userDetailList(model.userDetailList);
            this.groupDetailList(model.groupDetailList);
            this.roleDetailList(model.roleDetailList);
            this.policies(model.policies);
            this.isTruncated(model.isTruncated);
            this.marker(model.marker);
        }

        public final List<UserDetail.Builder> getUserDetailList() {
            List<UserDetail.Builder> result = _userDetailListTypeCopier.copyToBuilder(this.userDetailList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder userDetailList(Collection<UserDetail> userDetailList) {
            this.userDetailList = _userDetailListTypeCopier.copy(userDetailList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userDetailList(UserDetail ... userDetailList) {
            this.userDetailList(Arrays.asList(userDetailList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userDetailList(Consumer<UserDetail.Builder> ... userDetailList) {
            this.userDetailList(Stream.of(userDetailList).map(c -> (UserDetail)((UserDetail.Builder)UserDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUserDetailList(Collection<UserDetail.BuilderImpl> userDetailList) {
            this.userDetailList = _userDetailListTypeCopier.copyFromBuilder(userDetailList);
        }

        public final List<GroupDetail.Builder> getGroupDetailList() {
            List<GroupDetail.Builder> result = _groupDetailListTypeCopier.copyToBuilder(this.groupDetailList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder groupDetailList(Collection<GroupDetail> groupDetailList) {
            this.groupDetailList = _groupDetailListTypeCopier.copy(groupDetailList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupDetailList(GroupDetail ... groupDetailList) {
            this.groupDetailList(Arrays.asList(groupDetailList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupDetailList(Consumer<GroupDetail.Builder> ... groupDetailList) {
            this.groupDetailList(Stream.of(groupDetailList).map(c -> (GroupDetail)((GroupDetail.Builder)GroupDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGroupDetailList(Collection<GroupDetail.BuilderImpl> groupDetailList) {
            this.groupDetailList = _groupDetailListTypeCopier.copyFromBuilder(groupDetailList);
        }

        public final List<RoleDetail.Builder> getRoleDetailList() {
            List<RoleDetail.Builder> result = _roleDetailListTypeCopier.copyToBuilder(this.roleDetailList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder roleDetailList(Collection<RoleDetail> roleDetailList) {
            this.roleDetailList = _roleDetailListTypeCopier.copy(roleDetailList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roleDetailList(RoleDetail ... roleDetailList) {
            this.roleDetailList(Arrays.asList(roleDetailList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roleDetailList(Consumer<RoleDetail.Builder> ... roleDetailList) {
            this.roleDetailList(Stream.of(roleDetailList).map(c -> (RoleDetail)((RoleDetail.Builder)RoleDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRoleDetailList(Collection<RoleDetail.BuilderImpl> roleDetailList) {
            this.roleDetailList = _roleDetailListTypeCopier.copyFromBuilder(roleDetailList);
        }

        public final List<ManagedPolicyDetail.Builder> getPolicies() {
            List<ManagedPolicyDetail.Builder> result = ManagedPolicyDetailListTypeCopier.copyToBuilder(this.policies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder policies(Collection<ManagedPolicyDetail> policies) {
            this.policies = ManagedPolicyDetailListTypeCopier.copy(policies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(ManagedPolicyDetail ... policies) {
            this.policies(Arrays.asList(policies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(Consumer<ManagedPolicyDetail.Builder> ... policies) {
            this.policies(Stream.of(policies).map(c -> (ManagedPolicyDetail)((ManagedPolicyDetail.Builder)ManagedPolicyDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPolicies(Collection<ManagedPolicyDetail.BuilderImpl> policies) {
            this.policies = ManagedPolicyDetailListTypeCopier.copyFromBuilder(policies);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public GetAccountAuthorizationDetailsResponse build() {
            return new GetAccountAuthorizationDetailsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAccountAuthorizationDetailsResponse> {
        public Builder userDetailList(Collection<UserDetail> var1);

        public Builder userDetailList(UserDetail ... var1);

        public Builder userDetailList(Consumer<UserDetail.Builder> ... var1);

        public Builder groupDetailList(Collection<GroupDetail> var1);

        public Builder groupDetailList(GroupDetail ... var1);

        public Builder groupDetailList(Consumer<GroupDetail.Builder> ... var1);

        public Builder roleDetailList(Collection<RoleDetail> var1);

        public Builder roleDetailList(RoleDetail ... var1);

        public Builder roleDetailList(Consumer<RoleDetail.Builder> ... var1);

        public Builder policies(Collection<ManagedPolicyDetail> var1);

        public Builder policies(ManagedPolicyDetail ... var1);

        public Builder policies(Consumer<ManagedPolicyDetail.Builder> ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

