/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePolicyVersionRequest extends IamRequest implements
        ToCopyableBuilder<CreatePolicyVersionRequest.Builder, CreatePolicyVersionRequest> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyArn").getter(getter(CreatePolicyVersionRequest::policyArn)).setter(setter(Builder::policyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyArn").build()).build();

    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyDocument").getter(getter(CreatePolicyVersionRequest::policyDocument))
            .setter(setter(Builder::policyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDocument").build()).build();

    private static final SdkField<Boolean> SET_AS_DEFAULT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SetAsDefault").getter(getter(CreatePolicyVersionRequest::setAsDefault))
            .setter(setter(Builder::setAsDefault))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SetAsDefault").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD,
            POLICY_DOCUMENT_FIELD, SET_AS_DEFAULT_FIELD));

    private final String policyArn;

    private final String policyDocument;

    private final Boolean setAsDefault;

    private CreatePolicyVersionRequest(BuilderImpl builder) {
        super(builder);
        this.policyArn = builder.policyArn;
        this.policyDocument = builder.policyDocument;
        this.setAsDefault = builder.setAsDefault;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM policy to which you want to add a new version.
     * </p>
     * <p>
     * For more information about ARNs, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM policy to which you want to add a new version.</p>
     *         <p>
     *         For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *         (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
     */
    public final String policyArn() {
        return policyArn;
    }

    /**
     * <p>
     * The JSON policy document that you want to use as the content for this new version of the policy.
     * </p>
     * <p>
     * You must provide policies in JSON format in IAM. However, for CloudFormation templates formatted in YAML, you can
     * provide the policy in JSON or YAML format. CloudFormation always converts a YAML policy to JSON format before
     * submitting it to IAM.
     * </p>
     * <p>
     * The maximum length of the policy document that you can pass in this operation, including whitespace, is listed
     * below. To view the maximum character counts of a managed policy with no whitespaces, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length"
     * >IAM and STS character quotas</a>.
     * </p>
     * <p>
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of
     * characters consisting of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the ASCII
     * character range
     * </p>
     * </li>
     * <li>
     * <p>
     * The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>
     * )
     * </p>
     * </li>
     * </ul>
     * 
     * @return The JSON policy document that you want to use as the content for this new version of the policy.</p>
     *         <p>
     *         You must provide policies in JSON format in IAM. However, for CloudFormation templates formatted in YAML,
     *         you can provide the policy in JSON or YAML format. CloudFormation always converts a YAML policy to JSON
     *         format before submitting it to IAM.
     *         </p>
     *         <p>
     *         The maximum length of the policy document that you can pass in this operation, including whitespace, is
     *         listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length"
     *         >IAM and STS character quotas</a>.
     *         </p>
     *         <p>
     *         The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a
     *         string of characters consisting of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of
     *         the ASCII character range
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The printable characters in the Basic Latin and Latin-1 Supplement character set (through
     *         <code>\u00FF</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (
     *         <code>\u000D</code>)
     *         </p>
     *         </li>
     */
    public final String policyDocument() {
        return policyDocument;
    }

    /**
     * <p>
     * Specifies whether to set this version as the policy's default version.
     * </p>
     * <p>
     * When this parameter is <code>true</code>, the new policy version becomes the operative version. That is, it
     * becomes the version that is in effect for the IAM users, groups, and roles that the policy is attached to.
     * </p>
     * <p>
     * For more information about managed policy versions, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * 
     * @return Specifies whether to set this version as the policy's default version.</p>
     *         <p>
     *         When this parameter is <code>true</code>, the new policy version becomes the operative version. That is,
     *         it becomes the version that is in effect for the IAM users, groups, and roles that the policy is attached
     *         to.
     *         </p>
     *         <p>
     *         For more information about managed policy versions, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for
     *         managed policies</a> in the <i>IAM User Guide</i>.
     */
    public final Boolean setAsDefault() {
        return setAsDefault;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(setAsDefault());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePolicyVersionRequest)) {
            return false;
        }
        CreatePolicyVersionRequest other = (CreatePolicyVersionRequest) obj;
        return Objects.equals(policyArn(), other.policyArn()) && Objects.equals(policyDocument(), other.policyDocument())
                && Objects.equals(setAsDefault(), other.setAsDefault());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePolicyVersionRequest").add("PolicyArn", policyArn())
                .add("PolicyDocument", policyDocument()).add("SetAsDefault", setAsDefault()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyArn":
            return Optional.ofNullable(clazz.cast(policyArn()));
        case "PolicyDocument":
            return Optional.ofNullable(clazz.cast(policyDocument()));
        case "SetAsDefault":
            return Optional.ofNullable(clazz.cast(setAsDefault()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePolicyVersionRequest, T> g) {
        return obj -> g.apply((CreatePolicyVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePolicyVersionRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM policy to which you want to add a new version.
         * </p>
         * <p>
         * For more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param policyArn
         *        The Amazon Resource Name (ARN) of the IAM policy to which you want to add a new version.</p>
         *        <p>
         *        For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * The JSON policy document that you want to use as the content for this new version of the policy.
         * </p>
         * <p>
         * You must provide policies in JSON format in IAM. However, for CloudFormation templates formatted in YAML, you
         * can provide the policy in JSON or YAML format. CloudFormation always converts a YAML policy to JSON format
         * before submitting it to IAM.
         * </p>
         * <p>
         * The maximum length of the policy document that you can pass in this operation, including whitespace, is
         * listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href=
         * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length"
         * >IAM and STS character quotas</a>.
         * </p>
         * <p>
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string
         * of characters consisting of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the
         * ASCII character range
         * </p>
         * </li>
         * <li>
         * <p>
         * The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>
         * )
         * </p>
         * </li>
         * <li>
         * <p>
         * The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (
         * <code>\u000D</code>)
         * </p>
         * </li>
         * </ul>
         * 
         * @param policyDocument
         *        The JSON policy document that you want to use as the content for this new version of the policy.</p>
         *        <p>
         *        You must provide policies in JSON format in IAM. However, for CloudFormation templates formatted in
         *        YAML, you can provide the policy in JSON or YAML format. CloudFormation always converts a YAML policy
         *        to JSON format before submitting it to IAM.
         *        </p>
         *        <p>
         *        The maximum length of the policy document that you can pass in this operation, including whitespace,
         *        is listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a
         *        href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length"
         *        >IAM and STS character quotas</a>.
         *        </p>
         *        <p>
         *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a
         *        string of characters consisting of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end
         *        of the ASCII character range
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The printable characters in the Basic Latin and Latin-1 Supplement character set (through
         *        <code>\u00FF</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return
         *        (<code>\u000D</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);

        /**
         * <p>
         * Specifies whether to set this version as the policy's default version.
         * </p>
         * <p>
         * When this parameter is <code>true</code>, the new policy version becomes the operative version. That is, it
         * becomes the version that is in effect for the IAM users, groups, and roles that the policy is attached to.
         * </p>
         * <p>
         * For more information about managed policy versions, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
         * policies</a> in the <i>IAM User Guide</i>.
         * </p>
         * 
         * @param setAsDefault
         *        Specifies whether to set this version as the policy's default version.</p>
         *        <p>
         *        When this parameter is <code>true</code>, the new policy version becomes the operative version. That
         *        is, it becomes the version that is in effect for the IAM users, groups, and roles that the policy is
         *        attached to.
         *        </p>
         *        <p>
         *        For more information about managed policy versions, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for
         *        managed policies</a> in the <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder setAsDefault(Boolean setAsDefault);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private String policyArn;

        private String policyDocument;

        private Boolean setAsDefault;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePolicyVersionRequest model) {
            super(model);
            policyArn(model.policyArn);
            policyDocument(model.policyDocument);
            setAsDefault(model.setAsDefault);
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        public final Boolean getSetAsDefault() {
            return setAsDefault;
        }

        @Override
        public final Builder setAsDefault(Boolean setAsDefault) {
            this.setAsDefault = setAsDefault;
            return this;
        }

        public final void setSetAsDefault(Boolean setAsDefault) {
            this.setAsDefault = setAsDefault;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePolicyVersionRequest build() {
            return new CreatePolicyVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
