/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateServiceLinkedRoleRequest extends IamRequest implements
        ToCopyableBuilder<CreateServiceLinkedRoleRequest.Builder, CreateServiceLinkedRoleRequest> {
    private static final SdkField<String> AWS_SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AWSServiceName").getter(getter(CreateServiceLinkedRoleRequest::awsServiceName))
            .setter(setter(Builder::awsServiceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AWSServiceName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateServiceLinkedRoleRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CUSTOM_SUFFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomSuffix").getter(getter(CreateServiceLinkedRoleRequest::customSuffix))
            .setter(setter(Builder::customSuffix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomSuffix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_SERVICE_NAME_FIELD,
            DESCRIPTION_FIELD, CUSTOM_SUFFIX_FIELD));

    private final String awsServiceName;

    private final String description;

    private final String customSuffix;

    private CreateServiceLinkedRoleRequest(BuilderImpl builder) {
        super(builder);
        this.awsServiceName = builder.awsServiceName;
        this.description = builder.description;
        this.customSuffix = builder.customSuffix;
    }

    /**
     * <p>
     * The service principal for the Amazon Web Services service to which this role is attached. You use a string
     * similar to a URL but without the http:// in front. For example: <code>elasticbeanstalk.amazonaws.com</code>.
     * </p>
     * <p>
     * Service principals are unique and case-sensitive. To find the exact service principal for your service-linked
     * role, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-services-that-work-with-iam.html">Amazon Web
     * Services services that work with IAM</a> in the <i>IAM User Guide</i>. Look for the services that have <b>Yes
     * </b>in the <b>Service-Linked Role</b> column. Choose the <b>Yes</b> link to view the service-linked role
     * documentation for that service.
     * </p>
     * 
     * @return The service principal for the Amazon Web Services service to which this role is attached. You use a
     *         string similar to a URL but without the http:// in front. For example:
     *         <code>elasticbeanstalk.amazonaws.com</code>. </p>
     *         <p>
     *         Service principals are unique and case-sensitive. To find the exact service principal for your
     *         service-linked role, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-services-that-work-with-iam.html"
     *         >Amazon Web Services services that work with IAM</a> in the <i>IAM User Guide</i>. Look for the services
     *         that have <b>Yes </b>in the <b>Service-Linked Role</b> column. Choose the <b>Yes</b> link to view the
     *         service-linked role documentation for that service.
     */
    public final String awsServiceName() {
        return awsServiceName;
    }

    /**
     * <p>
     * The description of the role.
     * </p>
     * 
     * @return The description of the role.
     */
    public final String description() {
        return description;
    }

    /**
     * <p/>
     * <p>
     * A string that you provide, which is combined with the service-provided prefix to form the complete role name. If
     * you make multiple requests for the same service, then you must supply a different <code>CustomSuffix</code> for
     * each request. Otherwise the request fails with a duplicate role name error. For example, you could add
     * <code>-1</code> or <code>-debug</code> to the suffix.
     * </p>
     * <p>
     * Some services do not support the <code>CustomSuffix</code> parameter. If you provide an optional suffix and the
     * operation fails, try the operation again without the suffix.
     * </p>
     * 
     * @return <p>
     *         A string that you provide, which is combined with the service-provided prefix to form the complete role
     *         name. If you make multiple requests for the same service, then you must supply a different
     *         <code>CustomSuffix</code> for each request. Otherwise the request fails with a duplicate role name error.
     *         For example, you could add <code>-1</code> or <code>-debug</code> to the suffix.
     *         </p>
     *         <p>
     *         Some services do not support the <code>CustomSuffix</code> parameter. If you provide an optional suffix
     *         and the operation fails, try the operation again without the suffix.
     */
    public final String customSuffix() {
        return customSuffix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(customSuffix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceLinkedRoleRequest)) {
            return false;
        }
        CreateServiceLinkedRoleRequest other = (CreateServiceLinkedRoleRequest) obj;
        return Objects.equals(awsServiceName(), other.awsServiceName()) && Objects.equals(description(), other.description())
                && Objects.equals(customSuffix(), other.customSuffix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateServiceLinkedRoleRequest").add("AWSServiceName", awsServiceName())
                .add("Description", description()).add("CustomSuffix", customSuffix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AWSServiceName":
            return Optional.ofNullable(clazz.cast(awsServiceName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CustomSuffix":
            return Optional.ofNullable(clazz.cast(customSuffix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateServiceLinkedRoleRequest, T> g) {
        return obj -> g.apply((CreateServiceLinkedRoleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateServiceLinkedRoleRequest> {
        /**
         * <p>
         * The service principal for the Amazon Web Services service to which this role is attached. You use a string
         * similar to a URL but without the http:// in front. For example: <code>elasticbeanstalk.amazonaws.com</code>.
         * </p>
         * <p>
         * Service principals are unique and case-sensitive. To find the exact service principal for your service-linked
         * role, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-services-that-work-with-iam.html">Amazon
         * Web Services services that work with IAM</a> in the <i>IAM User Guide</i>. Look for the services that have
         * <b>Yes </b>in the <b>Service-Linked Role</b> column. Choose the <b>Yes</b> link to view the service-linked
         * role documentation for that service.
         * </p>
         * 
         * @param awsServiceName
         *        The service principal for the Amazon Web Services service to which this role is attached. You use a
         *        string similar to a URL but without the http:// in front. For example:
         *        <code>elasticbeanstalk.amazonaws.com</code>. </p>
         *        <p>
         *        Service principals are unique and case-sensitive. To find the exact service principal for your
         *        service-linked role, see <a href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-services-that-work-with-iam.html"
         *        >Amazon Web Services services that work with IAM</a> in the <i>IAM User Guide</i>. Look for the
         *        services that have <b>Yes </b>in the <b>Service-Linked Role</b> column. Choose the <b>Yes</b> link to
         *        view the service-linked role documentation for that service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsServiceName(String awsServiceName);

        /**
         * <p>
         * The description of the role.
         * </p>
         * 
         * @param description
         *        The description of the role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p/>
         * <p>
         * A string that you provide, which is combined with the service-provided prefix to form the complete role name.
         * If you make multiple requests for the same service, then you must supply a different
         * <code>CustomSuffix</code> for each request. Otherwise the request fails with a duplicate role name error. For
         * example, you could add <code>-1</code> or <code>-debug</code> to the suffix.
         * </p>
         * <p>
         * Some services do not support the <code>CustomSuffix</code> parameter. If you provide an optional suffix and
         * the operation fails, try the operation again without the suffix.
         * </p>
         * 
         * @param customSuffix
         *        <p>
         *        A string that you provide, which is combined with the service-provided prefix to form the complete
         *        role name. If you make multiple requests for the same service, then you must supply a different
         *        <code>CustomSuffix</code> for each request. Otherwise the request fails with a duplicate role name
         *        error. For example, you could add <code>-1</code> or <code>-debug</code> to the suffix.
         *        </p>
         *        <p>
         *        Some services do not support the <code>CustomSuffix</code> parameter. If you provide an optional
         *        suffix and the operation fails, try the operation again without the suffix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customSuffix(String customSuffix);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private String awsServiceName;

        private String description;

        private String customSuffix;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServiceLinkedRoleRequest model) {
            super(model);
            awsServiceName(model.awsServiceName);
            description(model.description);
            customSuffix(model.customSuffix);
        }

        public final String getAwsServiceName() {
            return awsServiceName;
        }

        @Override
        public final Builder awsServiceName(String awsServiceName) {
            this.awsServiceName = awsServiceName;
            return this;
        }

        public final void setAwsServiceName(String awsServiceName) {
            this.awsServiceName = awsServiceName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getCustomSuffix() {
            return customSuffix;
        }

        @Override
        public final Builder customSuffix(String customSuffix) {
            this.customSuffix = customSuffix;
            return this;
        }

        public final void setCustomSuffix(String customSuffix) {
            this.customSuffix = customSuffix;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateServiceLinkedRoleRequest build() {
            return new CreateServiceLinkedRoleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
