/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a successful <a>GetRolePolicy</a> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRolePolicyResponse extends IamResponse implements
        ToCopyableBuilder<GetRolePolicyResponse.Builder, GetRolePolicyResponse> {
    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleName").getter(getter(GetRolePolicyResponse::roleName)).setter(setter(Builder::roleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleName").build()).build();

    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyName").getter(getter(GetRolePolicyResponse::policyName)).setter(setter(Builder::policyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()).build();

    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyDocument").getter(getter(GetRolePolicyResponse::policyDocument))
            .setter(setter(Builder::policyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDocument").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_NAME_FIELD,
            POLICY_NAME_FIELD, POLICY_DOCUMENT_FIELD));

    private final String roleName;

    private final String policyName;

    private final String policyDocument;

    private GetRolePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.roleName = builder.roleName;
        this.policyName = builder.policyName;
        this.policyDocument = builder.policyDocument;
    }

    /**
     * <p>
     * The role the policy is associated with.
     * </p>
     * 
     * @return The role the policy is associated with.
     */
    public final String roleName() {
        return roleName;
    }

    /**
     * <p>
     * The name of the policy.
     * </p>
     * 
     * @return The name of the policy.
     */
    public final String policyName() {
        return policyName;
    }

    /**
     * <p>
     * The policy document.
     * </p>
     * <p>
     * IAM stores policies in JSON format. However, resources that were created using CloudFormation templates can be
     * formatted in YAML. CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.
     * </p>
     * 
     * @return The policy document.</p>
     *         <p>
     *         IAM stores policies in JSON format. However, resources that were created using CloudFormation templates
     *         can be formatted in YAML. CloudFormation always converts a YAML policy to JSON format before submitting
     *         it to IAM.
     */
    public final String policyDocument() {
        return policyDocument;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(roleName());
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(policyDocument());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRolePolicyResponse)) {
            return false;
        }
        GetRolePolicyResponse other = (GetRolePolicyResponse) obj;
        return Objects.equals(roleName(), other.roleName()) && Objects.equals(policyName(), other.policyName())
                && Objects.equals(policyDocument(), other.policyDocument());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRolePolicyResponse").add("RoleName", roleName()).add("PolicyName", policyName())
                .add("PolicyDocument", policyDocument()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleName":
            return Optional.ofNullable(clazz.cast(roleName()));
        case "PolicyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "PolicyDocument":
            return Optional.ofNullable(clazz.cast(policyDocument()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRolePolicyResponse, T> g) {
        return obj -> g.apply((GetRolePolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetRolePolicyResponse> {
        /**
         * <p>
         * The role the policy is associated with.
         * </p>
         * 
         * @param roleName
         *        The role the policy is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleName(String roleName);

        /**
         * <p>
         * The name of the policy.
         * </p>
         * 
         * @param policyName
         *        The name of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * The policy document.
         * </p>
         * <p>
         * IAM stores policies in JSON format. However, resources that were created using CloudFormation templates can
         * be formatted in YAML. CloudFormation always converts a YAML policy to JSON format before submitting it to
         * IAM.
         * </p>
         * 
         * @param policyDocument
         *        The policy document.</p>
         *        <p>
         *        IAM stores policies in JSON format. However, resources that were created using CloudFormation
         *        templates can be formatted in YAML. CloudFormation always converts a YAML policy to JSON format before
         *        submitting it to IAM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);
    }

    static final class BuilderImpl extends IamResponse.BuilderImpl implements Builder {
        private String roleName;

        private String policyName;

        private String policyDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRolePolicyResponse model) {
            super(model);
            roleName(model.roleName);
            policyName(model.policyName);
            policyDocument(model.policyDocument);
        }

        public final String getRoleName() {
            return roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public final String getPolicyName() {
            return policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public GetRolePolicyResponse build() {
            return new GetRolePolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
