/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a successful <a>ListOpenIDConnectProviders</a> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOpenIdConnectProvidersResponse extends IamResponse implements
        ToCopyableBuilder<ListOpenIdConnectProvidersResponse.Builder, ListOpenIdConnectProvidersResponse> {
    private static final SdkField<List<OpenIDConnectProviderListEntry>> OPEN_ID_CONNECT_PROVIDER_LIST_FIELD = SdkField
            .<List<OpenIDConnectProviderListEntry>> builder(MarshallingType.LIST)
            .memberName("OpenIDConnectProviderList")
            .getter(getter(ListOpenIdConnectProvidersResponse::openIDConnectProviderList))
            .setter(setter(Builder::openIDConnectProviderList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenIDConnectProviderList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OpenIDConnectProviderListEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(OpenIDConnectProviderListEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(OPEN_ID_CONNECT_PROVIDER_LIST_FIELD));

    private final List<OpenIDConnectProviderListEntry> openIDConnectProviderList;

    private ListOpenIdConnectProvidersResponse(BuilderImpl builder) {
        super(builder);
        this.openIDConnectProviderList = builder.openIDConnectProviderList;
    }

    /**
     * Returns true if the OpenIDConnectProviderList property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasOpenIDConnectProviderList() {
        return openIDConnectProviderList != null && !(openIDConnectProviderList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of IAM OIDC provider resource objects defined in the account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOpenIDConnectProviderList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of IAM OIDC provider resource objects defined in the account.
     */
    public final List<OpenIDConnectProviderListEntry> openIDConnectProviderList() {
        return openIDConnectProviderList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasOpenIDConnectProviderList() ? openIDConnectProviderList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOpenIdConnectProvidersResponse)) {
            return false;
        }
        ListOpenIdConnectProvidersResponse other = (ListOpenIdConnectProvidersResponse) obj;
        return hasOpenIDConnectProviderList() == other.hasOpenIDConnectProviderList()
                && Objects.equals(openIDConnectProviderList(), other.openIDConnectProviderList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListOpenIdConnectProvidersResponse")
                .add("OpenIDConnectProviderList", hasOpenIDConnectProviderList() ? openIDConnectProviderList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OpenIDConnectProviderList":
            return Optional.ofNullable(clazz.cast(openIDConnectProviderList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOpenIdConnectProvidersResponse, T> g) {
        return obj -> g.apply((ListOpenIdConnectProvidersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListOpenIdConnectProvidersResponse> {
        /**
         * <p>
         * The list of IAM OIDC provider resource objects defined in the account.
         * </p>
         * 
         * @param openIDConnectProviderList
         *        The list of IAM OIDC provider resource objects defined in the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openIDConnectProviderList(Collection<OpenIDConnectProviderListEntry> openIDConnectProviderList);

        /**
         * <p>
         * The list of IAM OIDC provider resource objects defined in the account.
         * </p>
         * 
         * @param openIDConnectProviderList
         *        The list of IAM OIDC provider resource objects defined in the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openIDConnectProviderList(OpenIDConnectProviderListEntry... openIDConnectProviderList);

        /**
         * <p>
         * The list of IAM OIDC provider resource objects defined in the account.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OpenIDConnectProviderListEntry>.Builder}
         * avoiding the need to create one manually via {@link List<OpenIDConnectProviderListEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OpenIDConnectProviderListEntry>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #openIDConnectProviderList(List<OpenIDConnectProviderListEntry>)}.
         * 
         * @param openIDConnectProviderList
         *        a consumer that will call methods on {@link List<OpenIDConnectProviderListEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openIDConnectProviderList(List<OpenIDConnectProviderListEntry>)
         */
        Builder openIDConnectProviderList(Consumer<OpenIDConnectProviderListEntry.Builder>... openIDConnectProviderList);
    }

    static final class BuilderImpl extends IamResponse.BuilderImpl implements Builder {
        private List<OpenIDConnectProviderListEntry> openIDConnectProviderList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListOpenIdConnectProvidersResponse model) {
            super(model);
            openIDConnectProviderList(model.openIDConnectProviderList);
        }

        public final List<OpenIDConnectProviderListEntry.Builder> getOpenIDConnectProviderList() {
            List<OpenIDConnectProviderListEntry.Builder> result = OpenIDConnectProviderListTypeCopier
                    .copyToBuilder(this.openIDConnectProviderList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder openIDConnectProviderList(Collection<OpenIDConnectProviderListEntry> openIDConnectProviderList) {
            this.openIDConnectProviderList = OpenIDConnectProviderListTypeCopier.copy(openIDConnectProviderList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder openIDConnectProviderList(OpenIDConnectProviderListEntry... openIDConnectProviderList) {
            openIDConnectProviderList(Arrays.asList(openIDConnectProviderList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder openIDConnectProviderList(
                Consumer<OpenIDConnectProviderListEntry.Builder>... openIDConnectProviderList) {
            openIDConnectProviderList(Stream.of(openIDConnectProviderList)
                    .map(c -> OpenIDConnectProviderListEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOpenIDConnectProviderList(
                Collection<OpenIDConnectProviderListEntry.BuilderImpl> openIDConnectProviderList) {
            this.openIDConnectProviderList = OpenIDConnectProviderListTypeCopier.copyFromBuilder(openIDConnectProviderList);
        }

        @Override
        public ListOpenIdConnectProvidersResponse build() {
            return new ListOpenIdConnectProvidersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
