/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAccountPasswordPolicyRequest extends IamRequest implements
        ToCopyableBuilder<UpdateAccountPasswordPolicyRequest.Builder, UpdateAccountPasswordPolicyRequest> {
    private static final SdkField<Integer> MINIMUM_PASSWORD_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinimumPasswordLength").getter(getter(UpdateAccountPasswordPolicyRequest::minimumPasswordLength))
            .setter(setter(Builder::minimumPasswordLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumPasswordLength").build())
            .build();

    private static final SdkField<Boolean> REQUIRE_SYMBOLS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RequireSymbols").getter(getter(UpdateAccountPasswordPolicyRequest::requireSymbols))
            .setter(setter(Builder::requireSymbols))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireSymbols").build()).build();

    private static final SdkField<Boolean> REQUIRE_NUMBERS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RequireNumbers").getter(getter(UpdateAccountPasswordPolicyRequest::requireNumbers))
            .setter(setter(Builder::requireNumbers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireNumbers").build()).build();

    private static final SdkField<Boolean> REQUIRE_UPPERCASE_CHARACTERS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RequireUppercaseCharacters")
            .getter(getter(UpdateAccountPasswordPolicyRequest::requireUppercaseCharacters))
            .setter(setter(Builder::requireUppercaseCharacters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireUppercaseCharacters").build())
            .build();

    private static final SdkField<Boolean> REQUIRE_LOWERCASE_CHARACTERS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RequireLowercaseCharacters")
            .getter(getter(UpdateAccountPasswordPolicyRequest::requireLowercaseCharacters))
            .setter(setter(Builder::requireLowercaseCharacters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireLowercaseCharacters").build())
            .build();

    private static final SdkField<Boolean> ALLOW_USERS_TO_CHANGE_PASSWORD_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowUsersToChangePassword")
            .getter(getter(UpdateAccountPasswordPolicyRequest::allowUsersToChangePassword))
            .setter(setter(Builder::allowUsersToChangePassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowUsersToChangePassword").build())
            .build();

    private static final SdkField<Integer> MAX_PASSWORD_AGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxPasswordAge").getter(getter(UpdateAccountPasswordPolicyRequest::maxPasswordAge))
            .setter(setter(Builder::maxPasswordAge))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxPasswordAge").build()).build();

    private static final SdkField<Integer> PASSWORD_REUSE_PREVENTION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PasswordReusePrevention").getter(getter(UpdateAccountPasswordPolicyRequest::passwordReusePrevention))
            .setter(setter(Builder::passwordReusePrevention))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PasswordReusePrevention").build())
            .build();

    private static final SdkField<Boolean> HARD_EXPIRY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HardExpiry").getter(getter(UpdateAccountPasswordPolicyRequest::hardExpiry))
            .setter(setter(Builder::hardExpiry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HardExpiry").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MINIMUM_PASSWORD_LENGTH_FIELD,
            REQUIRE_SYMBOLS_FIELD, REQUIRE_NUMBERS_FIELD, REQUIRE_UPPERCASE_CHARACTERS_FIELD, REQUIRE_LOWERCASE_CHARACTERS_FIELD,
            ALLOW_USERS_TO_CHANGE_PASSWORD_FIELD, MAX_PASSWORD_AGE_FIELD, PASSWORD_REUSE_PREVENTION_FIELD, HARD_EXPIRY_FIELD));

    private final Integer minimumPasswordLength;

    private final Boolean requireSymbols;

    private final Boolean requireNumbers;

    private final Boolean requireUppercaseCharacters;

    private final Boolean requireLowercaseCharacters;

    private final Boolean allowUsersToChangePassword;

    private final Integer maxPasswordAge;

    private final Integer passwordReusePrevention;

    private final Boolean hardExpiry;

    private UpdateAccountPasswordPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.minimumPasswordLength = builder.minimumPasswordLength;
        this.requireSymbols = builder.requireSymbols;
        this.requireNumbers = builder.requireNumbers;
        this.requireUppercaseCharacters = builder.requireUppercaseCharacters;
        this.requireLowercaseCharacters = builder.requireLowercaseCharacters;
        this.allowUsersToChangePassword = builder.allowUsersToChangePassword;
        this.maxPasswordAge = builder.maxPasswordAge;
        this.passwordReusePrevention = builder.passwordReusePrevention;
        this.hardExpiry = builder.hardExpiry;
    }

    /**
     * <p>
     * The minimum number of characters allowed in an IAM user password.
     * </p>
     * <p>
     * If you do not specify a value for this parameter, then the operation uses the default value of <code>6</code>.
     * </p>
     * 
     * @return The minimum number of characters allowed in an IAM user password.</p>
     *         <p>
     *         If you do not specify a value for this parameter, then the operation uses the default value of
     *         <code>6</code>.
     */
    public final Integer minimumPasswordLength() {
        return minimumPasswordLength;
    }

    /**
     * <p>
     * Specifies whether IAM user passwords must contain at least one of the following non-alphanumeric characters:
     * </p>
     * <p>
     * ! @ # $ % ^ &amp; * ( ) _ + - = [ ] { } | '
     * </p>
     * <p>
     * If you do not specify a value for this parameter, then the operation uses the default value of <code>false</code>
     * . The result is that passwords do not require at least one symbol character.
     * </p>
     * 
     * @return Specifies whether IAM user passwords must contain at least one of the following non-alphanumeric
     *         characters:</p>
     *         <p>
     *         ! @ # $ % ^ &amp; * ( ) _ + - = [ ] { } | '
     *         </p>
     *         <p>
     *         If you do not specify a value for this parameter, then the operation uses the default value of
     *         <code>false</code>. The result is that passwords do not require at least one symbol character.
     */
    public final Boolean requireSymbols() {
        return requireSymbols;
    }

    /**
     * <p>
     * Specifies whether IAM user passwords must contain at least one numeric character (0 to 9).
     * </p>
     * <p>
     * If you do not specify a value for this parameter, then the operation uses the default value of <code>false</code>
     * . The result is that passwords do not require at least one numeric character.
     * </p>
     * 
     * @return Specifies whether IAM user passwords must contain at least one numeric character (0 to 9).</p>
     *         <p>
     *         If you do not specify a value for this parameter, then the operation uses the default value of
     *         <code>false</code>. The result is that passwords do not require at least one numeric character.
     */
    public final Boolean requireNumbers() {
        return requireNumbers;
    }

    /**
     * <p>
     * Specifies whether IAM user passwords must contain at least one uppercase character from the ISO basic Latin
     * alphabet (A to Z).
     * </p>
     * <p>
     * If you do not specify a value for this parameter, then the operation uses the default value of <code>false</code>
     * . The result is that passwords do not require at least one uppercase character.
     * </p>
     * 
     * @return Specifies whether IAM user passwords must contain at least one uppercase character from the ISO basic
     *         Latin alphabet (A to Z).</p>
     *         <p>
     *         If you do not specify a value for this parameter, then the operation uses the default value of
     *         <code>false</code>. The result is that passwords do not require at least one uppercase character.
     */
    public final Boolean requireUppercaseCharacters() {
        return requireUppercaseCharacters;
    }

    /**
     * <p>
     * Specifies whether IAM user passwords must contain at least one lowercase character from the ISO basic Latin
     * alphabet (a to z).
     * </p>
     * <p>
     * If you do not specify a value for this parameter, then the operation uses the default value of <code>false</code>
     * . The result is that passwords do not require at least one lowercase character.
     * </p>
     * 
     * @return Specifies whether IAM user passwords must contain at least one lowercase character from the ISO basic
     *         Latin alphabet (a to z).</p>
     *         <p>
     *         If you do not specify a value for this parameter, then the operation uses the default value of
     *         <code>false</code>. The result is that passwords do not require at least one lowercase character.
     */
    public final Boolean requireLowercaseCharacters() {
        return requireLowercaseCharacters;
    }

    /**
     * <p>
     * Allows all IAM users in your account to use the Management Console to change their own passwords. For more
     * information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/HowToPwdIAMUser.html">Letting IAM
     * users change their own passwords</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * If you do not specify a value for this parameter, then the operation uses the default value of <code>false</code>
     * . The result is that IAM users in the account do not automatically have permissions to change their own password.
     * </p>
     * 
     * @return Allows all IAM users in your account to use the Management Console to change their own passwords. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/HowToPwdIAMUser.html">Letting IAM users change
     *         their own passwords</a> in the <i>IAM User Guide</i>.</p>
     *         <p>
     *         If you do not specify a value for this parameter, then the operation uses the default value of
     *         <code>false</code>. The result is that IAM users in the account do not automatically have permissions to
     *         change their own password.
     */
    public final Boolean allowUsersToChangePassword() {
        return allowUsersToChangePassword;
    }

    /**
     * <p>
     * The number of days that an IAM user password is valid.
     * </p>
     * <p>
     * If you do not specify a value for this parameter, then the operation uses the default value of <code>0</code>.
     * The result is that IAM user passwords never expire.
     * </p>
     * 
     * @return The number of days that an IAM user password is valid.</p>
     *         <p>
     *         If you do not specify a value for this parameter, then the operation uses the default value of
     *         <code>0</code>. The result is that IAM user passwords never expire.
     */
    public final Integer maxPasswordAge() {
        return maxPasswordAge;
    }

    /**
     * <p>
     * Specifies the number of previous passwords that IAM users are prevented from reusing.
     * </p>
     * <p>
     * If you do not specify a value for this parameter, then the operation uses the default value of <code>0</code>.
     * The result is that IAM users are not prevented from reusing previous passwords.
     * </p>
     * 
     * @return Specifies the number of previous passwords that IAM users are prevented from reusing.</p>
     *         <p>
     *         If you do not specify a value for this parameter, then the operation uses the default value of
     *         <code>0</code>. The result is that IAM users are not prevented from reusing previous passwords.
     */
    public final Integer passwordReusePrevention() {
        return passwordReusePrevention;
    }

    /**
     * <p>
     * Prevents IAM users from setting a new password after their password has expired. The IAM user cannot be accessed
     * until an administrator resets the password.
     * </p>
     * <p>
     * If you do not specify a value for this parameter, then the operation uses the default value of <code>false</code>
     * . The result is that IAM users can change their passwords after they expire and continue to sign in as the user.
     * </p>
     * 
     * @return Prevents IAM users from setting a new password after their password has expired. The IAM user cannot be
     *         accessed until an administrator resets the password.</p>
     *         <p>
     *         If you do not specify a value for this parameter, then the operation uses the default value of
     *         <code>false</code>. The result is that IAM users can change their passwords after they expire and
     *         continue to sign in as the user.
     */
    public final Boolean hardExpiry() {
        return hardExpiry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(minimumPasswordLength());
        hashCode = 31 * hashCode + Objects.hashCode(requireSymbols());
        hashCode = 31 * hashCode + Objects.hashCode(requireNumbers());
        hashCode = 31 * hashCode + Objects.hashCode(requireUppercaseCharacters());
        hashCode = 31 * hashCode + Objects.hashCode(requireLowercaseCharacters());
        hashCode = 31 * hashCode + Objects.hashCode(allowUsersToChangePassword());
        hashCode = 31 * hashCode + Objects.hashCode(maxPasswordAge());
        hashCode = 31 * hashCode + Objects.hashCode(passwordReusePrevention());
        hashCode = 31 * hashCode + Objects.hashCode(hardExpiry());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccountPasswordPolicyRequest)) {
            return false;
        }
        UpdateAccountPasswordPolicyRequest other = (UpdateAccountPasswordPolicyRequest) obj;
        return Objects.equals(minimumPasswordLength(), other.minimumPasswordLength())
                && Objects.equals(requireSymbols(), other.requireSymbols())
                && Objects.equals(requireNumbers(), other.requireNumbers())
                && Objects.equals(requireUppercaseCharacters(), other.requireUppercaseCharacters())
                && Objects.equals(requireLowercaseCharacters(), other.requireLowercaseCharacters())
                && Objects.equals(allowUsersToChangePassword(), other.allowUsersToChangePassword())
                && Objects.equals(maxPasswordAge(), other.maxPasswordAge())
                && Objects.equals(passwordReusePrevention(), other.passwordReusePrevention())
                && Objects.equals(hardExpiry(), other.hardExpiry());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAccountPasswordPolicyRequest").add("MinimumPasswordLength", minimumPasswordLength())
                .add("RequireSymbols", requireSymbols()).add("RequireNumbers", requireNumbers())
                .add("RequireUppercaseCharacters", requireUppercaseCharacters())
                .add("RequireLowercaseCharacters", requireLowercaseCharacters())
                .add("AllowUsersToChangePassword", allowUsersToChangePassword()).add("MaxPasswordAge", maxPasswordAge())
                .add("PasswordReusePrevention", passwordReusePrevention()).add("HardExpiry", hardExpiry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinimumPasswordLength":
            return Optional.ofNullable(clazz.cast(minimumPasswordLength()));
        case "RequireSymbols":
            return Optional.ofNullable(clazz.cast(requireSymbols()));
        case "RequireNumbers":
            return Optional.ofNullable(clazz.cast(requireNumbers()));
        case "RequireUppercaseCharacters":
            return Optional.ofNullable(clazz.cast(requireUppercaseCharacters()));
        case "RequireLowercaseCharacters":
            return Optional.ofNullable(clazz.cast(requireLowercaseCharacters()));
        case "AllowUsersToChangePassword":
            return Optional.ofNullable(clazz.cast(allowUsersToChangePassword()));
        case "MaxPasswordAge":
            return Optional.ofNullable(clazz.cast(maxPasswordAge()));
        case "PasswordReusePrevention":
            return Optional.ofNullable(clazz.cast(passwordReusePrevention()));
        case "HardExpiry":
            return Optional.ofNullable(clazz.cast(hardExpiry()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccountPasswordPolicyRequest, T> g) {
        return obj -> g.apply((UpdateAccountPasswordPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAccountPasswordPolicyRequest> {
        /**
         * <p>
         * The minimum number of characters allowed in an IAM user password.
         * </p>
         * <p>
         * If you do not specify a value for this parameter, then the operation uses the default value of <code>6</code>
         * .
         * </p>
         * 
         * @param minimumPasswordLength
         *        The minimum number of characters allowed in an IAM user password.</p>
         *        <p>
         *        If you do not specify a value for this parameter, then the operation uses the default value of
         *        <code>6</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumPasswordLength(Integer minimumPasswordLength);

        /**
         * <p>
         * Specifies whether IAM user passwords must contain at least one of the following non-alphanumeric characters:
         * </p>
         * <p>
         * ! @ # $ % ^ &amp; * ( ) _ + - = [ ] { } | '
         * </p>
         * <p>
         * If you do not specify a value for this parameter, then the operation uses the default value of
         * <code>false</code>. The result is that passwords do not require at least one symbol character.
         * </p>
         * 
         * @param requireSymbols
         *        Specifies whether IAM user passwords must contain at least one of the following non-alphanumeric
         *        characters:</p>
         *        <p>
         *        ! @ # $ % ^ &amp; * ( ) _ + - = [ ] { } | '
         *        </p>
         *        <p>
         *        If you do not specify a value for this parameter, then the operation uses the default value of
         *        <code>false</code>. The result is that passwords do not require at least one symbol character.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireSymbols(Boolean requireSymbols);

        /**
         * <p>
         * Specifies whether IAM user passwords must contain at least one numeric character (0 to 9).
         * </p>
         * <p>
         * If you do not specify a value for this parameter, then the operation uses the default value of
         * <code>false</code>. The result is that passwords do not require at least one numeric character.
         * </p>
         * 
         * @param requireNumbers
         *        Specifies whether IAM user passwords must contain at least one numeric character (0 to 9).</p>
         *        <p>
         *        If you do not specify a value for this parameter, then the operation uses the default value of
         *        <code>false</code>. The result is that passwords do not require at least one numeric character.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireNumbers(Boolean requireNumbers);

        /**
         * <p>
         * Specifies whether IAM user passwords must contain at least one uppercase character from the ISO basic Latin
         * alphabet (A to Z).
         * </p>
         * <p>
         * If you do not specify a value for this parameter, then the operation uses the default value of
         * <code>false</code>. The result is that passwords do not require at least one uppercase character.
         * </p>
         * 
         * @param requireUppercaseCharacters
         *        Specifies whether IAM user passwords must contain at least one uppercase character from the ISO basic
         *        Latin alphabet (A to Z).</p>
         *        <p>
         *        If you do not specify a value for this parameter, then the operation uses the default value of
         *        <code>false</code>. The result is that passwords do not require at least one uppercase character.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireUppercaseCharacters(Boolean requireUppercaseCharacters);

        /**
         * <p>
         * Specifies whether IAM user passwords must contain at least one lowercase character from the ISO basic Latin
         * alphabet (a to z).
         * </p>
         * <p>
         * If you do not specify a value for this parameter, then the operation uses the default value of
         * <code>false</code>. The result is that passwords do not require at least one lowercase character.
         * </p>
         * 
         * @param requireLowercaseCharacters
         *        Specifies whether IAM user passwords must contain at least one lowercase character from the ISO basic
         *        Latin alphabet (a to z).</p>
         *        <p>
         *        If you do not specify a value for this parameter, then the operation uses the default value of
         *        <code>false</code>. The result is that passwords do not require at least one lowercase character.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireLowercaseCharacters(Boolean requireLowercaseCharacters);

        /**
         * <p>
         * Allows all IAM users in your account to use the Management Console to change their own passwords. For more
         * information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/HowToPwdIAMUser.html">Letting IAM
         * users change their own passwords</a> in the <i>IAM User Guide</i>.
         * </p>
         * <p>
         * If you do not specify a value for this parameter, then the operation uses the default value of
         * <code>false</code>. The result is that IAM users in the account do not automatically have permissions to
         * change their own password.
         * </p>
         * 
         * @param allowUsersToChangePassword
         *        Allows all IAM users in your account to use the Management Console to change their own passwords. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/HowToPwdIAMUser.html">Letting IAM users change
         *        their own passwords</a> in the <i>IAM User Guide</i>.</p>
         *        <p>
         *        If you do not specify a value for this parameter, then the operation uses the default value of
         *        <code>false</code>. The result is that IAM users in the account do not automatically have permissions
         *        to change their own password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowUsersToChangePassword(Boolean allowUsersToChangePassword);

        /**
         * <p>
         * The number of days that an IAM user password is valid.
         * </p>
         * <p>
         * If you do not specify a value for this parameter, then the operation uses the default value of <code>0</code>
         * . The result is that IAM user passwords never expire.
         * </p>
         * 
         * @param maxPasswordAge
         *        The number of days that an IAM user password is valid.</p>
         *        <p>
         *        If you do not specify a value for this parameter, then the operation uses the default value of
         *        <code>0</code>. The result is that IAM user passwords never expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxPasswordAge(Integer maxPasswordAge);

        /**
         * <p>
         * Specifies the number of previous passwords that IAM users are prevented from reusing.
         * </p>
         * <p>
         * If you do not specify a value for this parameter, then the operation uses the default value of <code>0</code>
         * . The result is that IAM users are not prevented from reusing previous passwords.
         * </p>
         * 
         * @param passwordReusePrevention
         *        Specifies the number of previous passwords that IAM users are prevented from reusing.</p>
         *        <p>
         *        If you do not specify a value for this parameter, then the operation uses the default value of
         *        <code>0</code>. The result is that IAM users are not prevented from reusing previous passwords.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passwordReusePrevention(Integer passwordReusePrevention);

        /**
         * <p>
         * Prevents IAM users from setting a new password after their password has expired. The IAM user cannot be
         * accessed until an administrator resets the password.
         * </p>
         * <p>
         * If you do not specify a value for this parameter, then the operation uses the default value of
         * <code>false</code>. The result is that IAM users can change their passwords after they expire and continue to
         * sign in as the user.
         * </p>
         * 
         * @param hardExpiry
         *        Prevents IAM users from setting a new password after their password has expired. The IAM user cannot
         *        be accessed until an administrator resets the password.</p>
         *        <p>
         *        If you do not specify a value for this parameter, then the operation uses the default value of
         *        <code>false</code>. The result is that IAM users can change their passwords after they expire and
         *        continue to sign in as the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hardExpiry(Boolean hardExpiry);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private Integer minimumPasswordLength;

        private Boolean requireSymbols;

        private Boolean requireNumbers;

        private Boolean requireUppercaseCharacters;

        private Boolean requireLowercaseCharacters;

        private Boolean allowUsersToChangePassword;

        private Integer maxPasswordAge;

        private Integer passwordReusePrevention;

        private Boolean hardExpiry;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccountPasswordPolicyRequest model) {
            super(model);
            minimumPasswordLength(model.minimumPasswordLength);
            requireSymbols(model.requireSymbols);
            requireNumbers(model.requireNumbers);
            requireUppercaseCharacters(model.requireUppercaseCharacters);
            requireLowercaseCharacters(model.requireLowercaseCharacters);
            allowUsersToChangePassword(model.allowUsersToChangePassword);
            maxPasswordAge(model.maxPasswordAge);
            passwordReusePrevention(model.passwordReusePrevention);
            hardExpiry(model.hardExpiry);
        }

        public final Integer getMinimumPasswordLength() {
            return minimumPasswordLength;
        }

        @Override
        public final Builder minimumPasswordLength(Integer minimumPasswordLength) {
            this.minimumPasswordLength = minimumPasswordLength;
            return this;
        }

        public final void setMinimumPasswordLength(Integer minimumPasswordLength) {
            this.minimumPasswordLength = minimumPasswordLength;
        }

        public final Boolean getRequireSymbols() {
            return requireSymbols;
        }

        @Override
        public final Builder requireSymbols(Boolean requireSymbols) {
            this.requireSymbols = requireSymbols;
            return this;
        }

        public final void setRequireSymbols(Boolean requireSymbols) {
            this.requireSymbols = requireSymbols;
        }

        public final Boolean getRequireNumbers() {
            return requireNumbers;
        }

        @Override
        public final Builder requireNumbers(Boolean requireNumbers) {
            this.requireNumbers = requireNumbers;
            return this;
        }

        public final void setRequireNumbers(Boolean requireNumbers) {
            this.requireNumbers = requireNumbers;
        }

        public final Boolean getRequireUppercaseCharacters() {
            return requireUppercaseCharacters;
        }

        @Override
        public final Builder requireUppercaseCharacters(Boolean requireUppercaseCharacters) {
            this.requireUppercaseCharacters = requireUppercaseCharacters;
            return this;
        }

        public final void setRequireUppercaseCharacters(Boolean requireUppercaseCharacters) {
            this.requireUppercaseCharacters = requireUppercaseCharacters;
        }

        public final Boolean getRequireLowercaseCharacters() {
            return requireLowercaseCharacters;
        }

        @Override
        public final Builder requireLowercaseCharacters(Boolean requireLowercaseCharacters) {
            this.requireLowercaseCharacters = requireLowercaseCharacters;
            return this;
        }

        public final void setRequireLowercaseCharacters(Boolean requireLowercaseCharacters) {
            this.requireLowercaseCharacters = requireLowercaseCharacters;
        }

        public final Boolean getAllowUsersToChangePassword() {
            return allowUsersToChangePassword;
        }

        @Override
        public final Builder allowUsersToChangePassword(Boolean allowUsersToChangePassword) {
            this.allowUsersToChangePassword = allowUsersToChangePassword;
            return this;
        }

        public final void setAllowUsersToChangePassword(Boolean allowUsersToChangePassword) {
            this.allowUsersToChangePassword = allowUsersToChangePassword;
        }

        public final Integer getMaxPasswordAge() {
            return maxPasswordAge;
        }

        @Override
        public final Builder maxPasswordAge(Integer maxPasswordAge) {
            this.maxPasswordAge = maxPasswordAge;
            return this;
        }

        public final void setMaxPasswordAge(Integer maxPasswordAge) {
            this.maxPasswordAge = maxPasswordAge;
        }

        public final Integer getPasswordReusePrevention() {
            return passwordReusePrevention;
        }

        @Override
        public final Builder passwordReusePrevention(Integer passwordReusePrevention) {
            this.passwordReusePrevention = passwordReusePrevention;
            return this;
        }

        public final void setPasswordReusePrevention(Integer passwordReusePrevention) {
            this.passwordReusePrevention = passwordReusePrevention;
        }

        public final Boolean getHardExpiry() {
            return hardExpiry;
        }

        @Override
        public final Builder hardExpiry(Boolean hardExpiry) {
            this.hardExpiry = hardExpiry;
            return this;
        }

        public final void setHardExpiry(Boolean hardExpiry) {
            this.hardExpiry = hardExpiry;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAccountPasswordPolicyRequest build() {
            return new UpdateAccountPasswordPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
