/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the account password policy.
 * </p>
 * <p>
 * This data type is used as a response element in the <a>GetAccountPasswordPolicy</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PasswordPolicy implements SdkPojo, Serializable, ToCopyableBuilder<PasswordPolicy.Builder, PasswordPolicy> {
    private static final SdkField<Integer> MINIMUM_PASSWORD_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinimumPasswordLength").getter(getter(PasswordPolicy::minimumPasswordLength))
            .setter(setter(Builder::minimumPasswordLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumPasswordLength").build())
            .build();

    private static final SdkField<Boolean> REQUIRE_SYMBOLS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RequireSymbols").getter(getter(PasswordPolicy::requireSymbols)).setter(setter(Builder::requireSymbols))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireSymbols").build()).build();

    private static final SdkField<Boolean> REQUIRE_NUMBERS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RequireNumbers").getter(getter(PasswordPolicy::requireNumbers)).setter(setter(Builder::requireNumbers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireNumbers").build()).build();

    private static final SdkField<Boolean> REQUIRE_UPPERCASE_CHARACTERS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RequireUppercaseCharacters")
            .getter(getter(PasswordPolicy::requireUppercaseCharacters))
            .setter(setter(Builder::requireUppercaseCharacters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireUppercaseCharacters").build())
            .build();

    private static final SdkField<Boolean> REQUIRE_LOWERCASE_CHARACTERS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RequireLowercaseCharacters")
            .getter(getter(PasswordPolicy::requireLowercaseCharacters))
            .setter(setter(Builder::requireLowercaseCharacters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireLowercaseCharacters").build())
            .build();

    private static final SdkField<Boolean> ALLOW_USERS_TO_CHANGE_PASSWORD_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowUsersToChangePassword")
            .getter(getter(PasswordPolicy::allowUsersToChangePassword))
            .setter(setter(Builder::allowUsersToChangePassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowUsersToChangePassword").build())
            .build();

    private static final SdkField<Boolean> EXPIRE_PASSWORDS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ExpirePasswords").getter(getter(PasswordPolicy::expirePasswords))
            .setter(setter(Builder::expirePasswords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirePasswords").build()).build();

    private static final SdkField<Integer> MAX_PASSWORD_AGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxPasswordAge").getter(getter(PasswordPolicy::maxPasswordAge)).setter(setter(Builder::maxPasswordAge))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxPasswordAge").build()).build();

    private static final SdkField<Integer> PASSWORD_REUSE_PREVENTION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PasswordReusePrevention").getter(getter(PasswordPolicy::passwordReusePrevention))
            .setter(setter(Builder::passwordReusePrevention))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PasswordReusePrevention").build())
            .build();

    private static final SdkField<Boolean> HARD_EXPIRY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HardExpiry").getter(getter(PasswordPolicy::hardExpiry)).setter(setter(Builder::hardExpiry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HardExpiry").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MINIMUM_PASSWORD_LENGTH_FIELD,
            REQUIRE_SYMBOLS_FIELD, REQUIRE_NUMBERS_FIELD, REQUIRE_UPPERCASE_CHARACTERS_FIELD, REQUIRE_LOWERCASE_CHARACTERS_FIELD,
            ALLOW_USERS_TO_CHANGE_PASSWORD_FIELD, EXPIRE_PASSWORDS_FIELD, MAX_PASSWORD_AGE_FIELD,
            PASSWORD_REUSE_PREVENTION_FIELD, HARD_EXPIRY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer minimumPasswordLength;

    private final Boolean requireSymbols;

    private final Boolean requireNumbers;

    private final Boolean requireUppercaseCharacters;

    private final Boolean requireLowercaseCharacters;

    private final Boolean allowUsersToChangePassword;

    private final Boolean expirePasswords;

    private final Integer maxPasswordAge;

    private final Integer passwordReusePrevention;

    private final Boolean hardExpiry;

    private PasswordPolicy(BuilderImpl builder) {
        this.minimumPasswordLength = builder.minimumPasswordLength;
        this.requireSymbols = builder.requireSymbols;
        this.requireNumbers = builder.requireNumbers;
        this.requireUppercaseCharacters = builder.requireUppercaseCharacters;
        this.requireLowercaseCharacters = builder.requireLowercaseCharacters;
        this.allowUsersToChangePassword = builder.allowUsersToChangePassword;
        this.expirePasswords = builder.expirePasswords;
        this.maxPasswordAge = builder.maxPasswordAge;
        this.passwordReusePrevention = builder.passwordReusePrevention;
        this.hardExpiry = builder.hardExpiry;
    }

    /**
     * <p>
     * Minimum length to require for IAM user passwords.
     * </p>
     * 
     * @return Minimum length to require for IAM user passwords.
     */
    public final Integer minimumPasswordLength() {
        return minimumPasswordLength;
    }

    /**
     * <p>
     * Specifies whether IAM user passwords must contain at least one of the following symbols:
     * </p>
     * <p>
     * ! @ # $ % ^ &amp; * ( ) _ + - = [ ] { } | '
     * </p>
     * 
     * @return Specifies whether IAM user passwords must contain at least one of the following symbols:</p>
     *         <p>
     *         ! @ # $ % ^ &amp; * ( ) _ + - = [ ] { } | '
     */
    public final Boolean requireSymbols() {
        return requireSymbols;
    }

    /**
     * <p>
     * Specifies whether IAM user passwords must contain at least one numeric character (0 to 9).
     * </p>
     * 
     * @return Specifies whether IAM user passwords must contain at least one numeric character (0 to 9).
     */
    public final Boolean requireNumbers() {
        return requireNumbers;
    }

    /**
     * <p>
     * Specifies whether IAM user passwords must contain at least one uppercase character (A to Z).
     * </p>
     * 
     * @return Specifies whether IAM user passwords must contain at least one uppercase character (A to Z).
     */
    public final Boolean requireUppercaseCharacters() {
        return requireUppercaseCharacters;
    }

    /**
     * <p>
     * Specifies whether IAM user passwords must contain at least one lowercase character (a to z).
     * </p>
     * 
     * @return Specifies whether IAM user passwords must contain at least one lowercase character (a to z).
     */
    public final Boolean requireLowercaseCharacters() {
        return requireLowercaseCharacters;
    }

    /**
     * <p>
     * Specifies whether IAM users are allowed to change their own password.
     * </p>
     * 
     * @return Specifies whether IAM users are allowed to change their own password.
     */
    public final Boolean allowUsersToChangePassword() {
        return allowUsersToChangePassword;
    }

    /**
     * <p>
     * Indicates whether passwords in the account expire. Returns true if <code>MaxPasswordAge</code> contains a value
     * greater than 0. Returns false if MaxPasswordAge is 0 or not present.
     * </p>
     * 
     * @return Indicates whether passwords in the account expire. Returns true if <code>MaxPasswordAge</code> contains a
     *         value greater than 0. Returns false if MaxPasswordAge is 0 or not present.
     */
    public final Boolean expirePasswords() {
        return expirePasswords;
    }

    /**
     * <p>
     * The number of days that an IAM user password is valid.
     * </p>
     * 
     * @return The number of days that an IAM user password is valid.
     */
    public final Integer maxPasswordAge() {
        return maxPasswordAge;
    }

    /**
     * <p>
     * Specifies the number of previous passwords that IAM users are prevented from reusing.
     * </p>
     * 
     * @return Specifies the number of previous passwords that IAM users are prevented from reusing.
     */
    public final Integer passwordReusePrevention() {
        return passwordReusePrevention;
    }

    /**
     * <p>
     * Specifies whether IAM users are prevented from setting a new password after their password has expired.
     * </p>
     * 
     * @return Specifies whether IAM users are prevented from setting a new password after their password has expired.
     */
    public final Boolean hardExpiry() {
        return hardExpiry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minimumPasswordLength());
        hashCode = 31 * hashCode + Objects.hashCode(requireSymbols());
        hashCode = 31 * hashCode + Objects.hashCode(requireNumbers());
        hashCode = 31 * hashCode + Objects.hashCode(requireUppercaseCharacters());
        hashCode = 31 * hashCode + Objects.hashCode(requireLowercaseCharacters());
        hashCode = 31 * hashCode + Objects.hashCode(allowUsersToChangePassword());
        hashCode = 31 * hashCode + Objects.hashCode(expirePasswords());
        hashCode = 31 * hashCode + Objects.hashCode(maxPasswordAge());
        hashCode = 31 * hashCode + Objects.hashCode(passwordReusePrevention());
        hashCode = 31 * hashCode + Objects.hashCode(hardExpiry());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PasswordPolicy)) {
            return false;
        }
        PasswordPolicy other = (PasswordPolicy) obj;
        return Objects.equals(minimumPasswordLength(), other.minimumPasswordLength())
                && Objects.equals(requireSymbols(), other.requireSymbols())
                && Objects.equals(requireNumbers(), other.requireNumbers())
                && Objects.equals(requireUppercaseCharacters(), other.requireUppercaseCharacters())
                && Objects.equals(requireLowercaseCharacters(), other.requireLowercaseCharacters())
                && Objects.equals(allowUsersToChangePassword(), other.allowUsersToChangePassword())
                && Objects.equals(expirePasswords(), other.expirePasswords())
                && Objects.equals(maxPasswordAge(), other.maxPasswordAge())
                && Objects.equals(passwordReusePrevention(), other.passwordReusePrevention())
                && Objects.equals(hardExpiry(), other.hardExpiry());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PasswordPolicy").add("MinimumPasswordLength", minimumPasswordLength())
                .add("RequireSymbols", requireSymbols()).add("RequireNumbers", requireNumbers())
                .add("RequireUppercaseCharacters", requireUppercaseCharacters())
                .add("RequireLowercaseCharacters", requireLowercaseCharacters())
                .add("AllowUsersToChangePassword", allowUsersToChangePassword()).add("ExpirePasswords", expirePasswords())
                .add("MaxPasswordAge", maxPasswordAge()).add("PasswordReusePrevention", passwordReusePrevention())
                .add("HardExpiry", hardExpiry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinimumPasswordLength":
            return Optional.ofNullable(clazz.cast(minimumPasswordLength()));
        case "RequireSymbols":
            return Optional.ofNullable(clazz.cast(requireSymbols()));
        case "RequireNumbers":
            return Optional.ofNullable(clazz.cast(requireNumbers()));
        case "RequireUppercaseCharacters":
            return Optional.ofNullable(clazz.cast(requireUppercaseCharacters()));
        case "RequireLowercaseCharacters":
            return Optional.ofNullable(clazz.cast(requireLowercaseCharacters()));
        case "AllowUsersToChangePassword":
            return Optional.ofNullable(clazz.cast(allowUsersToChangePassword()));
        case "ExpirePasswords":
            return Optional.ofNullable(clazz.cast(expirePasswords()));
        case "MaxPasswordAge":
            return Optional.ofNullable(clazz.cast(maxPasswordAge()));
        case "PasswordReusePrevention":
            return Optional.ofNullable(clazz.cast(passwordReusePrevention()));
        case "HardExpiry":
            return Optional.ofNullable(clazz.cast(hardExpiry()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PasswordPolicy, T> g) {
        return obj -> g.apply((PasswordPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PasswordPolicy> {
        /**
         * <p>
         * Minimum length to require for IAM user passwords.
         * </p>
         * 
         * @param minimumPasswordLength
         *        Minimum length to require for IAM user passwords.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumPasswordLength(Integer minimumPasswordLength);

        /**
         * <p>
         * Specifies whether IAM user passwords must contain at least one of the following symbols:
         * </p>
         * <p>
         * ! @ # $ % ^ &amp; * ( ) _ + - = [ ] { } | '
         * </p>
         * 
         * @param requireSymbols
         *        Specifies whether IAM user passwords must contain at least one of the following symbols:</p>
         *        <p>
         *        ! @ # $ % ^ &amp; * ( ) _ + - = [ ] { } | '
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireSymbols(Boolean requireSymbols);

        /**
         * <p>
         * Specifies whether IAM user passwords must contain at least one numeric character (0 to 9).
         * </p>
         * 
         * @param requireNumbers
         *        Specifies whether IAM user passwords must contain at least one numeric character (0 to 9).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireNumbers(Boolean requireNumbers);

        /**
         * <p>
         * Specifies whether IAM user passwords must contain at least one uppercase character (A to Z).
         * </p>
         * 
         * @param requireUppercaseCharacters
         *        Specifies whether IAM user passwords must contain at least one uppercase character (A to Z).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireUppercaseCharacters(Boolean requireUppercaseCharacters);

        /**
         * <p>
         * Specifies whether IAM user passwords must contain at least one lowercase character (a to z).
         * </p>
         * 
         * @param requireLowercaseCharacters
         *        Specifies whether IAM user passwords must contain at least one lowercase character (a to z).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireLowercaseCharacters(Boolean requireLowercaseCharacters);

        /**
         * <p>
         * Specifies whether IAM users are allowed to change their own password.
         * </p>
         * 
         * @param allowUsersToChangePassword
         *        Specifies whether IAM users are allowed to change their own password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowUsersToChangePassword(Boolean allowUsersToChangePassword);

        /**
         * <p>
         * Indicates whether passwords in the account expire. Returns true if <code>MaxPasswordAge</code> contains a
         * value greater than 0. Returns false if MaxPasswordAge is 0 or not present.
         * </p>
         * 
         * @param expirePasswords
         *        Indicates whether passwords in the account expire. Returns true if <code>MaxPasswordAge</code>
         *        contains a value greater than 0. Returns false if MaxPasswordAge is 0 or not present.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirePasswords(Boolean expirePasswords);

        /**
         * <p>
         * The number of days that an IAM user password is valid.
         * </p>
         * 
         * @param maxPasswordAge
         *        The number of days that an IAM user password is valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxPasswordAge(Integer maxPasswordAge);

        /**
         * <p>
         * Specifies the number of previous passwords that IAM users are prevented from reusing.
         * </p>
         * 
         * @param passwordReusePrevention
         *        Specifies the number of previous passwords that IAM users are prevented from reusing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passwordReusePrevention(Integer passwordReusePrevention);

        /**
         * <p>
         * Specifies whether IAM users are prevented from setting a new password after their password has expired.
         * </p>
         * 
         * @param hardExpiry
         *        Specifies whether IAM users are prevented from setting a new password after their password has
         *        expired.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hardExpiry(Boolean hardExpiry);
    }

    static final class BuilderImpl implements Builder {
        private Integer minimumPasswordLength;

        private Boolean requireSymbols;

        private Boolean requireNumbers;

        private Boolean requireUppercaseCharacters;

        private Boolean requireLowercaseCharacters;

        private Boolean allowUsersToChangePassword;

        private Boolean expirePasswords;

        private Integer maxPasswordAge;

        private Integer passwordReusePrevention;

        private Boolean hardExpiry;

        private BuilderImpl() {
        }

        private BuilderImpl(PasswordPolicy model) {
            minimumPasswordLength(model.minimumPasswordLength);
            requireSymbols(model.requireSymbols);
            requireNumbers(model.requireNumbers);
            requireUppercaseCharacters(model.requireUppercaseCharacters);
            requireLowercaseCharacters(model.requireLowercaseCharacters);
            allowUsersToChangePassword(model.allowUsersToChangePassword);
            expirePasswords(model.expirePasswords);
            maxPasswordAge(model.maxPasswordAge);
            passwordReusePrevention(model.passwordReusePrevention);
            hardExpiry(model.hardExpiry);
        }

        public final Integer getMinimumPasswordLength() {
            return minimumPasswordLength;
        }

        public final void setMinimumPasswordLength(Integer minimumPasswordLength) {
            this.minimumPasswordLength = minimumPasswordLength;
        }

        @Override
        @Transient
        public final Builder minimumPasswordLength(Integer minimumPasswordLength) {
            this.minimumPasswordLength = minimumPasswordLength;
            return this;
        }

        public final Boolean getRequireSymbols() {
            return requireSymbols;
        }

        public final void setRequireSymbols(Boolean requireSymbols) {
            this.requireSymbols = requireSymbols;
        }

        @Override
        @Transient
        public final Builder requireSymbols(Boolean requireSymbols) {
            this.requireSymbols = requireSymbols;
            return this;
        }

        public final Boolean getRequireNumbers() {
            return requireNumbers;
        }

        public final void setRequireNumbers(Boolean requireNumbers) {
            this.requireNumbers = requireNumbers;
        }

        @Override
        @Transient
        public final Builder requireNumbers(Boolean requireNumbers) {
            this.requireNumbers = requireNumbers;
            return this;
        }

        public final Boolean getRequireUppercaseCharacters() {
            return requireUppercaseCharacters;
        }

        public final void setRequireUppercaseCharacters(Boolean requireUppercaseCharacters) {
            this.requireUppercaseCharacters = requireUppercaseCharacters;
        }

        @Override
        @Transient
        public final Builder requireUppercaseCharacters(Boolean requireUppercaseCharacters) {
            this.requireUppercaseCharacters = requireUppercaseCharacters;
            return this;
        }

        public final Boolean getRequireLowercaseCharacters() {
            return requireLowercaseCharacters;
        }

        public final void setRequireLowercaseCharacters(Boolean requireLowercaseCharacters) {
            this.requireLowercaseCharacters = requireLowercaseCharacters;
        }

        @Override
        @Transient
        public final Builder requireLowercaseCharacters(Boolean requireLowercaseCharacters) {
            this.requireLowercaseCharacters = requireLowercaseCharacters;
            return this;
        }

        public final Boolean getAllowUsersToChangePassword() {
            return allowUsersToChangePassword;
        }

        public final void setAllowUsersToChangePassword(Boolean allowUsersToChangePassword) {
            this.allowUsersToChangePassword = allowUsersToChangePassword;
        }

        @Override
        @Transient
        public final Builder allowUsersToChangePassword(Boolean allowUsersToChangePassword) {
            this.allowUsersToChangePassword = allowUsersToChangePassword;
            return this;
        }

        public final Boolean getExpirePasswords() {
            return expirePasswords;
        }

        public final void setExpirePasswords(Boolean expirePasswords) {
            this.expirePasswords = expirePasswords;
        }

        @Override
        @Transient
        public final Builder expirePasswords(Boolean expirePasswords) {
            this.expirePasswords = expirePasswords;
            return this;
        }

        public final Integer getMaxPasswordAge() {
            return maxPasswordAge;
        }

        public final void setMaxPasswordAge(Integer maxPasswordAge) {
            this.maxPasswordAge = maxPasswordAge;
        }

        @Override
        @Transient
        public final Builder maxPasswordAge(Integer maxPasswordAge) {
            this.maxPasswordAge = maxPasswordAge;
            return this;
        }

        public final Integer getPasswordReusePrevention() {
            return passwordReusePrevention;
        }

        public final void setPasswordReusePrevention(Integer passwordReusePrevention) {
            this.passwordReusePrevention = passwordReusePrevention;
        }

        @Override
        @Transient
        public final Builder passwordReusePrevention(Integer passwordReusePrevention) {
            this.passwordReusePrevention = passwordReusePrevention;
            return this;
        }

        public final Boolean getHardExpiry() {
            return hardExpiry;
        }

        public final void setHardExpiry(Boolean hardExpiry) {
            this.hardExpiry = hardExpiry;
        }

        @Override
        @Transient
        public final Builder hardExpiry(Boolean hardExpiry) {
            this.hardExpiry = hardExpiry;
            return this;
        }

        @Override
        public PasswordPolicy build() {
            return new PasswordPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
