/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a role that a managed policy is attached to.
 * </p>
 * <p>
 * This data type is used as a response element in the <a>ListEntitiesForPolicy</a> operation.
 * </p>
 * <p>
 * For more information about managed policies, refer to <a
 * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
 * policies</a> in the <i>IAM User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PolicyRole implements SdkPojo, Serializable, ToCopyableBuilder<PolicyRole.Builder, PolicyRole> {
    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleName").getter(getter(PolicyRole::roleName)).setter(setter(Builder::roleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleName").build()).build();

    private static final SdkField<String> ROLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RoleId")
            .getter(getter(PolicyRole::roleId)).setter(setter(Builder::roleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ROLE_NAME_FIELD, ROLE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String roleName;

    private final String roleId;

    private PolicyRole(BuilderImpl builder) {
        this.roleName = builder.roleName;
        this.roleId = builder.roleId;
    }

    /**
     * <p>
     * The name (friendly name, not ARN) identifying the role.
     * </p>
     * 
     * @return The name (friendly name, not ARN) identifying the role.
     */
    public final String roleName() {
        return roleName;
    }

    /**
     * <p>
     * The stable and unique string identifying the role. For more information about IDs, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM identifiers</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * 
     * @return The stable and unique string identifying the role. For more information about IDs, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM identifiers</a> in
     *         the <i>IAM User Guide</i>.
     */
    public final String roleId() {
        return roleId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleName());
        hashCode = 31 * hashCode + Objects.hashCode(roleId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyRole)) {
            return false;
        }
        PolicyRole other = (PolicyRole) obj;
        return Objects.equals(roleName(), other.roleName()) && Objects.equals(roleId(), other.roleId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PolicyRole").add("RoleName", roleName()).add("RoleId", roleId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleName":
            return Optional.ofNullable(clazz.cast(roleName()));
        case "RoleId":
            return Optional.ofNullable(clazz.cast(roleId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PolicyRole, T> g) {
        return obj -> g.apply((PolicyRole) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PolicyRole> {
        /**
         * <p>
         * The name (friendly name, not ARN) identifying the role.
         * </p>
         * 
         * @param roleName
         *        The name (friendly name, not ARN) identifying the role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleName(String roleName);

        /**
         * <p>
         * The stable and unique string identifying the role. For more information about IDs, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM identifiers</a> in the
         * <i>IAM User Guide</i>.
         * </p>
         * 
         * @param roleId
         *        The stable and unique string identifying the role. For more information about IDs, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM identifiers</a>
         *        in the <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleId(String roleId);
    }

    static final class BuilderImpl implements Builder {
        private String roleName;

        private String roleId;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyRole model) {
            roleName(model.roleName);
            roleId(model.roleId);
        }

        public final String getRoleName() {
            return roleName;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Override
        @Transient
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final String getRoleId() {
            return roleId;
        }

        public final void setRoleId(String roleId) {
            this.roleId = roleId;
        }

        @Override
        @Transient
        public final Builder roleId(String roleId) {
            this.roleId = roleId;
            return this;
        }

        @Override
        public PolicyRole build() {
            return new PolicyRole(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
