/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGroupRequest extends IamRequest implements
        ToCopyableBuilder<UpdateGroupRequest.Builder, UpdateGroupRequest> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupName").getter(getter(UpdateGroupRequest::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()).build();

    private static final SdkField<String> NEW_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NewPath").getter(getter(UpdateGroupRequest::newPath)).setter(setter(Builder::newPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewPath").build()).build();

    private static final SdkField<String> NEW_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NewGroupName").getter(getter(UpdateGroupRequest::newGroupName)).setter(setter(Builder::newGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewGroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD,
            NEW_PATH_FIELD, NEW_GROUP_NAME_FIELD));

    private final String groupName;

    private final String newPath;

    private final String newGroupName;

    private UpdateGroupRequest(BuilderImpl builder) {
        super(builder);
        this.groupName = builder.groupName;
        this.newPath = builder.newPath;
        this.newGroupName = builder.newGroupName;
    }

    /**
     * <p>
     * Name of the IAM group to update. If you're changing the name of the group, this is the original name.
     * </p>
     * <p>
     * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of
     * characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of
     * the following characters: _+=,.@-
     * </p>
     * 
     * @return Name of the IAM group to update. If you're changing the name of the group, this is the original name.</p>
     *         <p>
     *         This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string
     *         of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also
     *         include any of the following characters: _+=,.@-
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * New path for the IAM group. Only include this if changing the group's path.
     * </p>
     * <p>
     * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of
     * characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward
     * slashes. In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL
     * character (<code>\u007F</code>), including most punctuation characters, digits, and upper and lowercased letters.
     * </p>
     * 
     * @return New path for the IAM group. Only include this if changing the group's path.</p>
     *         <p>
     *         This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string
     *         of characters consisting of either a forward slash (/) by itself or a string that must begin and end with
     *         forward slashes. In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through
     *         the DEL character (<code>\u007F</code>), including most punctuation characters, digits, and upper and
     *         lowercased letters.
     */
    public final String newPath() {
        return newPath;
    }

    /**
     * <p>
     * New name for the IAM group. Only include this if changing the group's name.
     * </p>
     * <p>
     * IAM user, group, role, and policy names must be unique within the account. Names are not distinguished by case.
     * For example, you cannot create resources named both "MyResource" and "myresource".
     * </p>
     * 
     * @return New name for the IAM group. Only include this if changing the group's name.</p>
     *         <p>
     *         IAM user, group, role, and policy names must be unique within the account. Names are not distinguished by
     *         case. For example, you cannot create resources named both "MyResource" and "myresource".
     */
    public final String newGroupName() {
        return newGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(newPath());
        hashCode = 31 * hashCode + Objects.hashCode(newGroupName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGroupRequest)) {
            return false;
        }
        UpdateGroupRequest other = (UpdateGroupRequest) obj;
        return Objects.equals(groupName(), other.groupName()) && Objects.equals(newPath(), other.newPath())
                && Objects.equals(newGroupName(), other.newGroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateGroupRequest").add("GroupName", groupName()).add("NewPath", newPath())
                .add("NewGroupName", newGroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "NewPath":
            return Optional.ofNullable(clazz.cast(newPath()));
        case "NewGroupName":
            return Optional.ofNullable(clazz.cast(newGroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGroupRequest, T> g) {
        return obj -> g.apply((UpdateGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateGroupRequest> {
        /**
         * <p>
         * Name of the IAM group to update. If you're changing the name of the group, this is the original name.
         * </p>
         * <p>
         * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of
         * characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any
         * of the following characters: _+=,.@-
         * </p>
         * 
         * @param groupName
         *        Name of the IAM group to update. If you're changing the name of the group, this is the original
         *        name.</p>
         *        <p>
         *        This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a
         *        string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can
         *        also include any of the following characters: _+=,.@-
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * New path for the IAM group. Only include this if changing the group's path.
         * </p>
         * <p>
         * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of
         * characters consisting of either a forward slash (/) by itself or a string that must begin and end with
         * forward slashes. In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the
         * DEL character (<code>\u007F</code>), including most punctuation characters, digits, and upper and lowercased
         * letters.
         * </p>
         * 
         * @param newPath
         *        New path for the IAM group. Only include this if changing the group's path.</p>
         *        <p>
         *        This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a
         *        string of characters consisting of either a forward slash (/) by itself or a string that must begin
         *        and end with forward slashes. In addition, it can contain any ASCII character from the ! (
         *        <code>\u0021</code>) through the DEL character (<code>\u007F</code>), including most punctuation
         *        characters, digits, and upper and lowercased letters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newPath(String newPath);

        /**
         * <p>
         * New name for the IAM group. Only include this if changing the group's name.
         * </p>
         * <p>
         * IAM user, group, role, and policy names must be unique within the account. Names are not distinguished by
         * case. For example, you cannot create resources named both "MyResource" and "myresource".
         * </p>
         * 
         * @param newGroupName
         *        New name for the IAM group. Only include this if changing the group's name.</p>
         *        <p>
         *        IAM user, group, role, and policy names must be unique within the account. Names are not distinguished
         *        by case. For example, you cannot create resources named both "MyResource" and "myresource".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newGroupName(String newGroupName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private String groupName;

        private String newPath;

        private String newGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGroupRequest model) {
            super(model);
            groupName(model.groupName);
            newPath(model.newPath);
            newGroupName(model.newGroupName);
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        @Transient
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getNewPath() {
            return newPath;
        }

        public final void setNewPath(String newPath) {
            this.newPath = newPath;
        }

        @Override
        @Transient
        public final Builder newPath(String newPath) {
            this.newPath = newPath;
            return this;
        }

        public final String getNewGroupName() {
            return newGroupName;
        }

        public final void setNewGroupName(String newGroupName) {
            this.newGroupName = newGroupName;
        }

        @Override
        @Transient
        public final Builder newGroupName(String newGroupName) {
            this.newGroupName = newGroupName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGroupRequest build() {
            return new UpdateGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
