/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a successful <a>CreateAccessKey</a> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAccessKeyResponse extends IamResponse implements
        ToCopyableBuilder<CreateAccessKeyResponse.Builder, CreateAccessKeyResponse> {
    private static final SdkField<AccessKey> ACCESS_KEY_FIELD = SdkField.<AccessKey> builder(MarshallingType.SDK_POJO)
            .memberName("AccessKey").getter(getter(CreateAccessKeyResponse::accessKey)).setter(setter(Builder::accessKey))
            .constructor(AccessKey::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_KEY_FIELD));

    private final AccessKey accessKey;

    private CreateAccessKeyResponse(BuilderImpl builder) {
        super(builder);
        this.accessKey = builder.accessKey;
    }

    /**
     * <p>
     * A structure with details about the access key.
     * </p>
     * 
     * @return A structure with details about the access key.
     */
    public final AccessKey accessKey() {
        return accessKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accessKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessKeyResponse)) {
            return false;
        }
        CreateAccessKeyResponse other = (CreateAccessKeyResponse) obj;
        return Objects.equals(accessKey(), other.accessKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAccessKeyResponse").add("AccessKey", accessKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessKey":
            return Optional.ofNullable(clazz.cast(accessKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAccessKeyResponse, T> g) {
        return obj -> g.apply((CreateAccessKeyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateAccessKeyResponse> {
        /**
         * <p>
         * A structure with details about the access key.
         * </p>
         * 
         * @param accessKey
         *        A structure with details about the access key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessKey(AccessKey accessKey);

        /**
         * <p>
         * A structure with details about the access key.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccessKey.Builder} avoiding the need to
         * create one manually via {@link AccessKey#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccessKey.Builder#build()} is called immediately and its result
         * is passed to {@link #accessKey(AccessKey)}.
         * 
         * @param accessKey
         *        a consumer that will call methods on {@link AccessKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessKey(AccessKey)
         */
        default Builder accessKey(Consumer<AccessKey.Builder> accessKey) {
            return accessKey(AccessKey.builder().applyMutation(accessKey).build());
        }
    }

    static final class BuilderImpl extends IamResponse.BuilderImpl implements Builder {
        private AccessKey accessKey;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccessKeyResponse model) {
            super(model);
            accessKey(model.accessKey);
        }

        public final AccessKey.Builder getAccessKey() {
            return accessKey != null ? accessKey.toBuilder() : null;
        }

        public final void setAccessKey(AccessKey.BuilderImpl accessKey) {
            this.accessKey = accessKey != null ? accessKey.build() : null;
        }

        @Override
        public final Builder accessKey(AccessKey accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        @Override
        public CreateAccessKeyResponse build() {
            return new CreateAccessKeyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
