/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a successful <a>GetAccountAuthorizationDetails</a> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAccountAuthorizationDetailsResponse extends IamResponse implements
        ToCopyableBuilder<GetAccountAuthorizationDetailsResponse.Builder, GetAccountAuthorizationDetailsResponse> {
    private static final SdkField<List<UserDetail>> USER_DETAIL_LIST_FIELD = SdkField
            .<List<UserDetail>> builder(MarshallingType.LIST)
            .memberName("UserDetailList")
            .getter(getter(GetAccountAuthorizationDetailsResponse::userDetailList))
            .setter(setter(Builder::userDetailList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserDetailList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<GroupDetail>> GROUP_DETAIL_LIST_FIELD = SdkField
            .<List<GroupDetail>> builder(MarshallingType.LIST)
            .memberName("GroupDetailList")
            .getter(getter(GetAccountAuthorizationDetailsResponse::groupDetailList))
            .setter(setter(Builder::groupDetailList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupDetailList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GroupDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RoleDetail>> ROLE_DETAIL_LIST_FIELD = SdkField
            .<List<RoleDetail>> builder(MarshallingType.LIST)
            .memberName("RoleDetailList")
            .getter(getter(GetAccountAuthorizationDetailsResponse::roleDetailList))
            .setter(setter(Builder::roleDetailList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleDetailList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RoleDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(RoleDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ManagedPolicyDetail>> POLICIES_FIELD = SdkField
            .<List<ManagedPolicyDetail>> builder(MarshallingType.LIST)
            .memberName("Policies")
            .getter(getter(GetAccountAuthorizationDetailsResponse::policies))
            .setter(setter(Builder::policies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ManagedPolicyDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ManagedPolicyDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsTruncated").getter(getter(GetAccountAuthorizationDetailsResponse::isTruncated))
            .setter(setter(Builder::isTruncated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(GetAccountAuthorizationDetailsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_DETAIL_LIST_FIELD,
            GROUP_DETAIL_LIST_FIELD, ROLE_DETAIL_LIST_FIELD, POLICIES_FIELD, IS_TRUNCATED_FIELD, MARKER_FIELD));

    private final List<UserDetail> userDetailList;

    private final List<GroupDetail> groupDetailList;

    private final List<RoleDetail> roleDetailList;

    private final List<ManagedPolicyDetail> policies;

    private final Boolean isTruncated;

    private final String marker;

    private GetAccountAuthorizationDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.userDetailList = builder.userDetailList;
        this.groupDetailList = builder.groupDetailList;
        this.roleDetailList = builder.roleDetailList;
        this.policies = builder.policies;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserDetailList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserDetailList() {
        return userDetailList != null && !(userDetailList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list containing information about IAM users.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserDetailList} method.
     * </p>
     * 
     * @return A list containing information about IAM users.
     */
    public final List<UserDetail> userDetailList() {
        return userDetailList;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupDetailList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGroupDetailList() {
        return groupDetailList != null && !(groupDetailList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list containing information about IAM groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupDetailList} method.
     * </p>
     * 
     * @return A list containing information about IAM groups.
     */
    public final List<GroupDetail> groupDetailList() {
        return groupDetailList;
    }

    /**
     * For responses, this returns true if the service returned a value for the RoleDetailList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRoleDetailList() {
        return roleDetailList != null && !(roleDetailList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list containing information about IAM roles.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoleDetailList} method.
     * </p>
     * 
     * @return A list containing information about IAM roles.
     */
    public final List<RoleDetail> roleDetailList() {
        return roleDetailList;
    }

    /**
     * For responses, this returns true if the service returned a value for the Policies property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPolicies() {
        return policies != null && !(policies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list containing information about managed policies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicies} method.
     * </p>
     * 
     * @return A list containing information about managed policies.
     */
    public final List<ManagedPolicyDetail> policies() {
        return policies;
    }

    /**
     * <p>
     * A flag that indicates whether there are more items to return. If your results were truncated, you can make a
     * subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that
     * IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results
     * available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all
     * your results.
     * </p>
     * 
     * @return A flag that indicates whether there are more items to return. If your results were truncated, you can
     *         make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more
     *         items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there
     *         are more results available. We recommend that you check <code>IsTruncated</code> after every call to
     *         ensure that you receive all your results.
     */
    public final Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the
     * <code>Marker</code> parameter in a subsequent pagination request.
     * </p>
     * 
     * @return When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use
     *         for the <code>Marker</code> parameter in a subsequent pagination request.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUserDetailList() ? userDetailList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupDetailList() ? groupDetailList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRoleDetailList() ? roleDetailList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicies() ? policies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountAuthorizationDetailsResponse)) {
            return false;
        }
        GetAccountAuthorizationDetailsResponse other = (GetAccountAuthorizationDetailsResponse) obj;
        return hasUserDetailList() == other.hasUserDetailList() && Objects.equals(userDetailList(), other.userDetailList())
                && hasGroupDetailList() == other.hasGroupDetailList()
                && Objects.equals(groupDetailList(), other.groupDetailList()) && hasRoleDetailList() == other.hasRoleDetailList()
                && Objects.equals(roleDetailList(), other.roleDetailList()) && hasPolicies() == other.hasPolicies()
                && Objects.equals(policies(), other.policies()) && Objects.equals(isTruncated(), other.isTruncated())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAccountAuthorizationDetailsResponse")
                .add("UserDetailList", hasUserDetailList() ? userDetailList() : null)
                .add("GroupDetailList", hasGroupDetailList() ? groupDetailList() : null)
                .add("RoleDetailList", hasRoleDetailList() ? roleDetailList() : null)
                .add("Policies", hasPolicies() ? policies() : null).add("IsTruncated", isTruncated()).add("Marker", marker())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserDetailList":
            return Optional.ofNullable(clazz.cast(userDetailList()));
        case "GroupDetailList":
            return Optional.ofNullable(clazz.cast(groupDetailList()));
        case "RoleDetailList":
            return Optional.ofNullable(clazz.cast(roleDetailList()));
        case "Policies":
            return Optional.ofNullable(clazz.cast(policies()));
        case "IsTruncated":
            return Optional.ofNullable(clazz.cast(isTruncated()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAccountAuthorizationDetailsResponse, T> g) {
        return obj -> g.apply((GetAccountAuthorizationDetailsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAccountAuthorizationDetailsResponse> {
        /**
         * <p>
         * A list containing information about IAM users.
         * </p>
         * 
         * @param userDetailList
         *        A list containing information about IAM users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userDetailList(Collection<UserDetail> userDetailList);

        /**
         * <p>
         * A list containing information about IAM users.
         * </p>
         * 
         * @param userDetailList
         *        A list containing information about IAM users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userDetailList(UserDetail... userDetailList);

        /**
         * <p>
         * A list containing information about IAM users.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<UserDetail>.Builder} avoiding the
         * need to create one manually via {@link List<UserDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UserDetail>.Builder#build()} is called immediately and its
         * result is passed to {@link #userDetailList(List<UserDetail>)}.
         * 
         * @param userDetailList
         *        a consumer that will call methods on {@link List<UserDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userDetailList(List<UserDetail>)
         */
        Builder userDetailList(Consumer<UserDetail.Builder>... userDetailList);

        /**
         * <p>
         * A list containing information about IAM groups.
         * </p>
         * 
         * @param groupDetailList
         *        A list containing information about IAM groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupDetailList(Collection<GroupDetail> groupDetailList);

        /**
         * <p>
         * A list containing information about IAM groups.
         * </p>
         * 
         * @param groupDetailList
         *        A list containing information about IAM groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupDetailList(GroupDetail... groupDetailList);

        /**
         * <p>
         * A list containing information about IAM groups.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<GroupDetail>.Builder} avoiding the
         * need to create one manually via {@link List<GroupDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GroupDetail>.Builder#build()} is called immediately and its
         * result is passed to {@link #groupDetailList(List<GroupDetail>)}.
         * 
         * @param groupDetailList
         *        a consumer that will call methods on {@link List<GroupDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupDetailList(List<GroupDetail>)
         */
        Builder groupDetailList(Consumer<GroupDetail.Builder>... groupDetailList);

        /**
         * <p>
         * A list containing information about IAM roles.
         * </p>
         * 
         * @param roleDetailList
         *        A list containing information about IAM roles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleDetailList(Collection<RoleDetail> roleDetailList);

        /**
         * <p>
         * A list containing information about IAM roles.
         * </p>
         * 
         * @param roleDetailList
         *        A list containing information about IAM roles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleDetailList(RoleDetail... roleDetailList);

        /**
         * <p>
         * A list containing information about IAM roles.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<RoleDetail>.Builder} avoiding the
         * need to create one manually via {@link List<RoleDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RoleDetail>.Builder#build()} is called immediately and its
         * result is passed to {@link #roleDetailList(List<RoleDetail>)}.
         * 
         * @param roleDetailList
         *        a consumer that will call methods on {@link List<RoleDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #roleDetailList(List<RoleDetail>)
         */
        Builder roleDetailList(Consumer<RoleDetail.Builder>... roleDetailList);

        /**
         * <p>
         * A list containing information about managed policies.
         * </p>
         * 
         * @param policies
         *        A list containing information about managed policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policies(Collection<ManagedPolicyDetail> policies);

        /**
         * <p>
         * A list containing information about managed policies.
         * </p>
         * 
         * @param policies
         *        A list containing information about managed policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policies(ManagedPolicyDetail... policies);

        /**
         * <p>
         * A list containing information about managed policies.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ManagedPolicyDetail>.Builder}
         * avoiding the need to create one manually via {@link List<ManagedPolicyDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ManagedPolicyDetail>.Builder#build()} is called immediately
         * and its result is passed to {@link #policies(List<ManagedPolicyDetail>)}.
         * 
         * @param policies
         *        a consumer that will call methods on {@link List<ManagedPolicyDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policies(List<ManagedPolicyDetail>)
         */
        Builder policies(Consumer<ManagedPolicyDetail.Builder>... policies);

        /**
         * <p>
         * A flag that indicates whether there are more items to return. If your results were truncated, you can make a
         * subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note
         * that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results
         * available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive
         * all your results.
         * </p>
         * 
         * @param isTruncated
         *        A flag that indicates whether there are more items to return. If your results were truncated, you can
         *        make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more
         *        items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when
         *        there are more results available. We recommend that you check <code>IsTruncated</code> after every
         *        call to ensure that you receive all your results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for
         * the <code>Marker</code> parameter in a subsequent pagination request.
         * </p>
         * 
         * @param marker
         *        When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to
         *        use for the <code>Marker</code> parameter in a subsequent pagination request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends IamResponse.BuilderImpl implements Builder {
        private List<UserDetail> userDetailList = DefaultSdkAutoConstructList.getInstance();

        private List<GroupDetail> groupDetailList = DefaultSdkAutoConstructList.getInstance();

        private List<RoleDetail> roleDetailList = DefaultSdkAutoConstructList.getInstance();

        private List<ManagedPolicyDetail> policies = DefaultSdkAutoConstructList.getInstance();

        private Boolean isTruncated;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountAuthorizationDetailsResponse model) {
            super(model);
            userDetailList(model.userDetailList);
            groupDetailList(model.groupDetailList);
            roleDetailList(model.roleDetailList);
            policies(model.policies);
            isTruncated(model.isTruncated);
            marker(model.marker);
        }

        public final List<UserDetail.Builder> getUserDetailList() {
            List<UserDetail.Builder> result = _userDetailListTypeCopier.copyToBuilder(this.userDetailList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserDetailList(Collection<UserDetail.BuilderImpl> userDetailList) {
            this.userDetailList = _userDetailListTypeCopier.copyFromBuilder(userDetailList);
        }

        @Override
        public final Builder userDetailList(Collection<UserDetail> userDetailList) {
            this.userDetailList = _userDetailListTypeCopier.copy(userDetailList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userDetailList(UserDetail... userDetailList) {
            userDetailList(Arrays.asList(userDetailList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userDetailList(Consumer<UserDetail.Builder>... userDetailList) {
            userDetailList(Stream.of(userDetailList).map(c -> UserDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<GroupDetail.Builder> getGroupDetailList() {
            List<GroupDetail.Builder> result = _groupDetailListTypeCopier.copyToBuilder(this.groupDetailList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupDetailList(Collection<GroupDetail.BuilderImpl> groupDetailList) {
            this.groupDetailList = _groupDetailListTypeCopier.copyFromBuilder(groupDetailList);
        }

        @Override
        public final Builder groupDetailList(Collection<GroupDetail> groupDetailList) {
            this.groupDetailList = _groupDetailListTypeCopier.copy(groupDetailList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupDetailList(GroupDetail... groupDetailList) {
            groupDetailList(Arrays.asList(groupDetailList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupDetailList(Consumer<GroupDetail.Builder>... groupDetailList) {
            groupDetailList(Stream.of(groupDetailList).map(c -> GroupDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<RoleDetail.Builder> getRoleDetailList() {
            List<RoleDetail.Builder> result = _roleDetailListTypeCopier.copyToBuilder(this.roleDetailList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoleDetailList(Collection<RoleDetail.BuilderImpl> roleDetailList) {
            this.roleDetailList = _roleDetailListTypeCopier.copyFromBuilder(roleDetailList);
        }

        @Override
        public final Builder roleDetailList(Collection<RoleDetail> roleDetailList) {
            this.roleDetailList = _roleDetailListTypeCopier.copy(roleDetailList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roleDetailList(RoleDetail... roleDetailList) {
            roleDetailList(Arrays.asList(roleDetailList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roleDetailList(Consumer<RoleDetail.Builder>... roleDetailList) {
            roleDetailList(Stream.of(roleDetailList).map(c -> RoleDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ManagedPolicyDetail.Builder> getPolicies() {
            List<ManagedPolicyDetail.Builder> result = ManagedPolicyDetailListTypeCopier.copyToBuilder(this.policies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicies(Collection<ManagedPolicyDetail.BuilderImpl> policies) {
            this.policies = ManagedPolicyDetailListTypeCopier.copyFromBuilder(policies);
        }

        @Override
        public final Builder policies(Collection<ManagedPolicyDetail> policies) {
            this.policies = ManagedPolicyDetailListTypeCopier.copy(policies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(ManagedPolicyDetail... policies) {
            policies(Arrays.asList(policies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(Consumer<ManagedPolicyDetail.Builder>... policies) {
            policies(Stream.of(policies).map(c -> ManagedPolicyDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public GetAccountAuthorizationDetailsResponse build() {
            return new GetAccountAuthorizationDetailsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
