/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a successful <a>ListEntitiesForPolicy</a> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEntitiesForPolicyResponse extends IamResponse implements
        ToCopyableBuilder<ListEntitiesForPolicyResponse.Builder, ListEntitiesForPolicyResponse> {
    private static final SdkField<List<PolicyGroup>> POLICY_GROUPS_FIELD = SdkField
            .<List<PolicyGroup>> builder(MarshallingType.LIST)
            .memberName("PolicyGroups")
            .getter(getter(ListEntitiesForPolicyResponse::policyGroups))
            .setter(setter(Builder::policyGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PolicyGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(PolicyGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PolicyUser>> POLICY_USERS_FIELD = SdkField
            .<List<PolicyUser>> builder(MarshallingType.LIST)
            .memberName("PolicyUsers")
            .getter(getter(ListEntitiesForPolicyResponse::policyUsers))
            .setter(setter(Builder::policyUsers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyUsers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PolicyUser> builder(MarshallingType.SDK_POJO)
                                            .constructor(PolicyUser::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PolicyRole>> POLICY_ROLES_FIELD = SdkField
            .<List<PolicyRole>> builder(MarshallingType.LIST)
            .memberName("PolicyRoles")
            .getter(getter(ListEntitiesForPolicyResponse::policyRoles))
            .setter(setter(Builder::policyRoles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyRoles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PolicyRole> builder(MarshallingType.SDK_POJO)
                                            .constructor(PolicyRole::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsTruncated").getter(getter(ListEntitiesForPolicyResponse::isTruncated))
            .setter(setter(Builder::isTruncated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListEntitiesForPolicyResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_GROUPS_FIELD,
            POLICY_USERS_FIELD, POLICY_ROLES_FIELD, IS_TRUNCATED_FIELD, MARKER_FIELD));

    private final List<PolicyGroup> policyGroups;

    private final List<PolicyUser> policyUsers;

    private final List<PolicyRole> policyRoles;

    private final Boolean isTruncated;

    private final String marker;

    private ListEntitiesForPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policyGroups = builder.policyGroups;
        this.policyUsers = builder.policyUsers;
        this.policyRoles = builder.policyRoles;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the PolicyGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPolicyGroups() {
        return policyGroups != null && !(policyGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of IAM groups that the policy is attached to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicyGroups} method.
     * </p>
     * 
     * @return A list of IAM groups that the policy is attached to.
     */
    public final List<PolicyGroup> policyGroups() {
        return policyGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the PolicyUsers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPolicyUsers() {
        return policyUsers != null && !(policyUsers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of IAM users that the policy is attached to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicyUsers} method.
     * </p>
     * 
     * @return A list of IAM users that the policy is attached to.
     */
    public final List<PolicyUser> policyUsers() {
        return policyUsers;
    }

    /**
     * For responses, this returns true if the service returned a value for the PolicyRoles property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPolicyRoles() {
        return policyRoles != null && !(policyRoles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of IAM roles that the policy is attached to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicyRoles} method.
     * </p>
     * 
     * @return A list of IAM roles that the policy is attached to.
     */
    public final List<PolicyRole> policyRoles() {
        return policyRoles;
    }

    /**
     * <p>
     * A flag that indicates whether there are more items to return. If your results were truncated, you can make a
     * subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that
     * IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results
     * available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all
     * your results.
     * </p>
     * 
     * @return A flag that indicates whether there are more items to return. If your results were truncated, you can
     *         make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more
     *         items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there
     *         are more results available. We recommend that you check <code>IsTruncated</code> after every call to
     *         ensure that you receive all your results.
     */
    public final Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the
     * <code>Marker</code> parameter in a subsequent pagination request.
     * </p>
     * 
     * @return When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use
     *         for the <code>Marker</code> parameter in a subsequent pagination request.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicyGroups() ? policyGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicyUsers() ? policyUsers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicyRoles() ? policyRoles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEntitiesForPolicyResponse)) {
            return false;
        }
        ListEntitiesForPolicyResponse other = (ListEntitiesForPolicyResponse) obj;
        return hasPolicyGroups() == other.hasPolicyGroups() && Objects.equals(policyGroups(), other.policyGroups())
                && hasPolicyUsers() == other.hasPolicyUsers() && Objects.equals(policyUsers(), other.policyUsers())
                && hasPolicyRoles() == other.hasPolicyRoles() && Objects.equals(policyRoles(), other.policyRoles())
                && Objects.equals(isTruncated(), other.isTruncated()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEntitiesForPolicyResponse").add("PolicyGroups", hasPolicyGroups() ? policyGroups() : null)
                .add("PolicyUsers", hasPolicyUsers() ? policyUsers() : null)
                .add("PolicyRoles", hasPolicyRoles() ? policyRoles() : null).add("IsTruncated", isTruncated())
                .add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyGroups":
            return Optional.ofNullable(clazz.cast(policyGroups()));
        case "PolicyUsers":
            return Optional.ofNullable(clazz.cast(policyUsers()));
        case "PolicyRoles":
            return Optional.ofNullable(clazz.cast(policyRoles()));
        case "IsTruncated":
            return Optional.ofNullable(clazz.cast(isTruncated()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEntitiesForPolicyResponse, T> g) {
        return obj -> g.apply((ListEntitiesForPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListEntitiesForPolicyResponse> {
        /**
         * <p>
         * A list of IAM groups that the policy is attached to.
         * </p>
         * 
         * @param policyGroups
         *        A list of IAM groups that the policy is attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyGroups(Collection<PolicyGroup> policyGroups);

        /**
         * <p>
         * A list of IAM groups that the policy is attached to.
         * </p>
         * 
         * @param policyGroups
         *        A list of IAM groups that the policy is attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyGroups(PolicyGroup... policyGroups);

        /**
         * <p>
         * A list of IAM groups that the policy is attached to.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<PolicyGroup>.Builder} avoiding the
         * need to create one manually via {@link List<PolicyGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PolicyGroup>.Builder#build()} is called immediately and its
         * result is passed to {@link #policyGroups(List<PolicyGroup>)}.
         * 
         * @param policyGroups
         *        a consumer that will call methods on {@link List<PolicyGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyGroups(List<PolicyGroup>)
         */
        Builder policyGroups(Consumer<PolicyGroup.Builder>... policyGroups);

        /**
         * <p>
         * A list of IAM users that the policy is attached to.
         * </p>
         * 
         * @param policyUsers
         *        A list of IAM users that the policy is attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyUsers(Collection<PolicyUser> policyUsers);

        /**
         * <p>
         * A list of IAM users that the policy is attached to.
         * </p>
         * 
         * @param policyUsers
         *        A list of IAM users that the policy is attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyUsers(PolicyUser... policyUsers);

        /**
         * <p>
         * A list of IAM users that the policy is attached to.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<PolicyUser>.Builder} avoiding the
         * need to create one manually via {@link List<PolicyUser>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PolicyUser>.Builder#build()} is called immediately and its
         * result is passed to {@link #policyUsers(List<PolicyUser>)}.
         * 
         * @param policyUsers
         *        a consumer that will call methods on {@link List<PolicyUser>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyUsers(List<PolicyUser>)
         */
        Builder policyUsers(Consumer<PolicyUser.Builder>... policyUsers);

        /**
         * <p>
         * A list of IAM roles that the policy is attached to.
         * </p>
         * 
         * @param policyRoles
         *        A list of IAM roles that the policy is attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyRoles(Collection<PolicyRole> policyRoles);

        /**
         * <p>
         * A list of IAM roles that the policy is attached to.
         * </p>
         * 
         * @param policyRoles
         *        A list of IAM roles that the policy is attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyRoles(PolicyRole... policyRoles);

        /**
         * <p>
         * A list of IAM roles that the policy is attached to.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<PolicyRole>.Builder} avoiding the
         * need to create one manually via {@link List<PolicyRole>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PolicyRole>.Builder#build()} is called immediately and its
         * result is passed to {@link #policyRoles(List<PolicyRole>)}.
         * 
         * @param policyRoles
         *        a consumer that will call methods on {@link List<PolicyRole>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyRoles(List<PolicyRole>)
         */
        Builder policyRoles(Consumer<PolicyRole.Builder>... policyRoles);

        /**
         * <p>
         * A flag that indicates whether there are more items to return. If your results were truncated, you can make a
         * subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note
         * that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results
         * available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive
         * all your results.
         * </p>
         * 
         * @param isTruncated
         *        A flag that indicates whether there are more items to return. If your results were truncated, you can
         *        make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more
         *        items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when
         *        there are more results available. We recommend that you check <code>IsTruncated</code> after every
         *        call to ensure that you receive all your results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for
         * the <code>Marker</code> parameter in a subsequent pagination request.
         * </p>
         * 
         * @param marker
         *        When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to
         *        use for the <code>Marker</code> parameter in a subsequent pagination request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends IamResponse.BuilderImpl implements Builder {
        private List<PolicyGroup> policyGroups = DefaultSdkAutoConstructList.getInstance();

        private List<PolicyUser> policyUsers = DefaultSdkAutoConstructList.getInstance();

        private List<PolicyRole> policyRoles = DefaultSdkAutoConstructList.getInstance();

        private Boolean isTruncated;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEntitiesForPolicyResponse model) {
            super(model);
            policyGroups(model.policyGroups);
            policyUsers(model.policyUsers);
            policyRoles(model.policyRoles);
            isTruncated(model.isTruncated);
            marker(model.marker);
        }

        public final List<PolicyGroup.Builder> getPolicyGroups() {
            List<PolicyGroup.Builder> result = PolicyGroupListTypeCopier.copyToBuilder(this.policyGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicyGroups(Collection<PolicyGroup.BuilderImpl> policyGroups) {
            this.policyGroups = PolicyGroupListTypeCopier.copyFromBuilder(policyGroups);
        }

        @Override
        public final Builder policyGroups(Collection<PolicyGroup> policyGroups) {
            this.policyGroups = PolicyGroupListTypeCopier.copy(policyGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyGroups(PolicyGroup... policyGroups) {
            policyGroups(Arrays.asList(policyGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyGroups(Consumer<PolicyGroup.Builder>... policyGroups) {
            policyGroups(Stream.of(policyGroups).map(c -> PolicyGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<PolicyUser.Builder> getPolicyUsers() {
            List<PolicyUser.Builder> result = PolicyUserListTypeCopier.copyToBuilder(this.policyUsers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicyUsers(Collection<PolicyUser.BuilderImpl> policyUsers) {
            this.policyUsers = PolicyUserListTypeCopier.copyFromBuilder(policyUsers);
        }

        @Override
        public final Builder policyUsers(Collection<PolicyUser> policyUsers) {
            this.policyUsers = PolicyUserListTypeCopier.copy(policyUsers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyUsers(PolicyUser... policyUsers) {
            policyUsers(Arrays.asList(policyUsers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyUsers(Consumer<PolicyUser.Builder>... policyUsers) {
            policyUsers(Stream.of(policyUsers).map(c -> PolicyUser.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<PolicyRole.Builder> getPolicyRoles() {
            List<PolicyRole.Builder> result = PolicyRoleListTypeCopier.copyToBuilder(this.policyRoles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicyRoles(Collection<PolicyRole.BuilderImpl> policyRoles) {
            this.policyRoles = PolicyRoleListTypeCopier.copyFromBuilder(policyRoles);
        }

        @Override
        public final Builder policyRoles(Collection<PolicyRole> policyRoles) {
            this.policyRoles = PolicyRoleListTypeCopier.copy(policyRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyRoles(PolicyRole... policyRoles) {
            policyRoles(Arrays.asList(policyRoles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyRoles(Consumer<PolicyRole.Builder>... policyRoles) {
            policyRoles(Stream.of(policyRoles).map(c -> PolicyRole.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public ListEntitiesForPolicyResponse build() {
            return new ListEntitiesForPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
