/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an IAM user, including all the user's policies and all the IAM groups the user is in.
 * </p>
 * <p>
 * This data type is used as a response element in the <a>GetAccountAuthorizationDetails</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserDetail implements SdkPojo, Serializable, ToCopyableBuilder<UserDetail.Builder, UserDetail> {
    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Path")
            .getter(getter(UserDetail::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(UserDetail::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(UserDetail::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(UserDetail::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateDate").getter(getter(UserDetail::createDate)).setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()).build();

    private static final SdkField<List<PolicyDetail>> USER_POLICY_LIST_FIELD = SdkField
            .<List<PolicyDetail>> builder(MarshallingType.LIST)
            .memberName("UserPolicyList")
            .getter(getter(UserDetail::userPolicyList))
            .setter(setter(Builder::userPolicyList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPolicyList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PolicyDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(PolicyDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> GROUP_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("GroupList")
            .getter(getter(UserDetail::groupList))
            .setter(setter(Builder::groupList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AttachedPolicy>> ATTACHED_MANAGED_POLICIES_FIELD = SdkField
            .<List<AttachedPolicy>> builder(MarshallingType.LIST)
            .memberName("AttachedManagedPolicies")
            .getter(getter(UserDetail::attachedManagedPolicies))
            .setter(setter(Builder::attachedManagedPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachedManagedPolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttachedPolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttachedPolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AttachedPermissionsBoundary> PERMISSIONS_BOUNDARY_FIELD = SdkField
            .<AttachedPermissionsBoundary> builder(MarshallingType.SDK_POJO).memberName("PermissionsBoundary")
            .getter(getter(UserDetail::permissionsBoundary)).setter(setter(Builder::permissionsBoundary))
            .constructor(AttachedPermissionsBoundary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsBoundary").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(UserDetail::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD, USER_NAME_FIELD,
            USER_ID_FIELD, ARN_FIELD, CREATE_DATE_FIELD, USER_POLICY_LIST_FIELD, GROUP_LIST_FIELD,
            ATTACHED_MANAGED_POLICIES_FIELD, PERMISSIONS_BOUNDARY_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String path;

    private final String userName;

    private final String userId;

    private final String arn;

    private final Instant createDate;

    private final List<PolicyDetail> userPolicyList;

    private final List<String> groupList;

    private final List<AttachedPolicy> attachedManagedPolicies;

    private final AttachedPermissionsBoundary permissionsBoundary;

    private final List<Tag> tags;

    private UserDetail(BuilderImpl builder) {
        this.path = builder.path;
        this.userName = builder.userName;
        this.userId = builder.userId;
        this.arn = builder.arn;
        this.createDate = builder.createDate;
        this.userPolicyList = builder.userPolicyList;
        this.groupList = builder.groupList;
        this.attachedManagedPolicies = builder.attachedManagedPolicies;
        this.permissionsBoundary = builder.permissionsBoundary;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The path to the user. For more information about paths, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM
     * User Guide</i>.
     * </p>
     * 
     * @return The path to the user. For more information about paths, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
     *         <i>IAM User Guide</i>.
     */
    public final String path() {
        return path;
    }

    /**
     * <p>
     * The friendly name identifying the user.
     * </p>
     * 
     * @return The friendly name identifying the user.
     */
    public final String userName() {
        return userName;
    }

    /**
     * <p>
     * The stable and unique string identifying the user. For more information about IDs, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM
     * User Guide</i>.
     * </p>
     * 
     * @return The stable and unique string identifying the user. For more information about IDs, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
     *         <i>IAM User Guide</i>.
     */
    public final String userId() {
        return userId;
    }

    /**
     * Returns the value of the Arn property for this object.
     * 
     * @return The value of the Arn property for this object.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the user was
     * created.
     * </p>
     * 
     * @return The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
     *         user was created.
     */
    public final Instant createDate() {
        return createDate;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserPolicyList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserPolicyList() {
        return userPolicyList != null && !(userPolicyList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the inline policies embedded in the user.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserPolicyList} method.
     * </p>
     * 
     * @return A list of the inline policies embedded in the user.
     */
    public final List<PolicyDetail> userPolicyList() {
        return userPolicyList;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroupList() {
        return groupList != null && !(groupList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of IAM groups that the user is in.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupList} method.
     * </p>
     * 
     * @return A list of IAM groups that the user is in.
     */
    public final List<String> groupList() {
        return groupList;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttachedManagedPolicies property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAttachedManagedPolicies() {
        return attachedManagedPolicies != null && !(attachedManagedPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the managed policies attached to the user.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttachedManagedPolicies} method.
     * </p>
     * 
     * @return A list of the managed policies attached to the user.
     */
    public final List<AttachedPolicy> attachedManagedPolicies() {
        return attachedManagedPolicies;
    }

    /**
     * <p>
     * The ARN of the policy used to set the permissions boundary for the user.
     * </p>
     * <p>
     * For more information about permissions boundaries, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries
     * for IAM identities </a> in the <i>IAM User Guide</i>.
     * </p>
     * 
     * @return The ARN of the policy used to set the permissions boundary for the user.</p>
     *         <p>
     *         For more information about permissions boundaries, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions
     *         boundaries for IAM identities </a> in the <i>IAM User Guide</i>.
     */
    public final AttachedPermissionsBoundary permissionsBoundary() {
        return permissionsBoundary;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags that are associated with the user. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags that are associated with the user. For more information about tagging, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
     *         <i>IAM User Guide</i>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserPolicyList() ? userPolicyList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupList() ? groupList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAttachedManagedPolicies() ? attachedManagedPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(permissionsBoundary());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserDetail)) {
            return false;
        }
        UserDetail other = (UserDetail) obj;
        return Objects.equals(path(), other.path()) && Objects.equals(userName(), other.userName())
                && Objects.equals(userId(), other.userId()) && Objects.equals(arn(), other.arn())
                && Objects.equals(createDate(), other.createDate()) && hasUserPolicyList() == other.hasUserPolicyList()
                && Objects.equals(userPolicyList(), other.userPolicyList()) && hasGroupList() == other.hasGroupList()
                && Objects.equals(groupList(), other.groupList())
                && hasAttachedManagedPolicies() == other.hasAttachedManagedPolicies()
                && Objects.equals(attachedManagedPolicies(), other.attachedManagedPolicies())
                && Objects.equals(permissionsBoundary(), other.permissionsBoundary()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserDetail").add("Path", path()).add("UserName", userName()).add("UserId", userId())
                .add("Arn", arn()).add("CreateDate", createDate())
                .add("UserPolicyList", hasUserPolicyList() ? userPolicyList() : null)
                .add("GroupList", hasGroupList() ? groupList() : null)
                .add("AttachedManagedPolicies", hasAttachedManagedPolicies() ? attachedManagedPolicies() : null)
                .add("PermissionsBoundary", permissionsBoundary()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        case "UserPolicyList":
            return Optional.ofNullable(clazz.cast(userPolicyList()));
        case "GroupList":
            return Optional.ofNullable(clazz.cast(groupList()));
        case "AttachedManagedPolicies":
            return Optional.ofNullable(clazz.cast(attachedManagedPolicies()));
        case "PermissionsBoundary":
            return Optional.ofNullable(clazz.cast(permissionsBoundary()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserDetail, T> g) {
        return obj -> g.apply((UserDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserDetail> {
        /**
         * <p>
         * The path to the user. For more information about paths, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
         * <i>IAM User Guide</i>.
         * </p>
         * 
         * @param path
         *        The path to the user. For more information about paths, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in
         *        the <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The friendly name identifying the user.
         * </p>
         * 
         * @param userName
         *        The friendly name identifying the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * The stable and unique string identifying the user. For more information about IDs, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
         * <i>IAM User Guide</i>.
         * </p>
         * 
         * @param userId
         *        The stable and unique string identifying the user. For more information about IDs, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in
         *        the <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * Sets the value of the Arn property for this object.
         *
         * @param arn
         *        The new value for the Arn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the user
         * was created.
         * </p>
         * 
         * @param createDate
         *        The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
         *        user was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);

        /**
         * <p>
         * A list of the inline policies embedded in the user.
         * </p>
         * 
         * @param userPolicyList
         *        A list of the inline policies embedded in the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPolicyList(Collection<PolicyDetail> userPolicyList);

        /**
         * <p>
         * A list of the inline policies embedded in the user.
         * </p>
         * 
         * @param userPolicyList
         *        A list of the inline policies embedded in the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPolicyList(PolicyDetail... userPolicyList);

        /**
         * <p>
         * A list of the inline policies embedded in the user.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<PolicyDetail>.Builder} avoiding the
         * need to create one manually via {@link List<PolicyDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PolicyDetail>.Builder#build()} is called immediately and its
         * result is passed to {@link #userPolicyList(List<PolicyDetail>)}.
         * 
         * @param userPolicyList
         *        a consumer that will call methods on {@link List<PolicyDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userPolicyList(List<PolicyDetail>)
         */
        Builder userPolicyList(Consumer<PolicyDetail.Builder>... userPolicyList);

        /**
         * <p>
         * A list of IAM groups that the user is in.
         * </p>
         * 
         * @param groupList
         *        A list of IAM groups that the user is in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupList(Collection<String> groupList);

        /**
         * <p>
         * A list of IAM groups that the user is in.
         * </p>
         * 
         * @param groupList
         *        A list of IAM groups that the user is in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupList(String... groupList);

        /**
         * <p>
         * A list of the managed policies attached to the user.
         * </p>
         * 
         * @param attachedManagedPolicies
         *        A list of the managed policies attached to the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachedManagedPolicies(Collection<AttachedPolicy> attachedManagedPolicies);

        /**
         * <p>
         * A list of the managed policies attached to the user.
         * </p>
         * 
         * @param attachedManagedPolicies
         *        A list of the managed policies attached to the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachedManagedPolicies(AttachedPolicy... attachedManagedPolicies);

        /**
         * <p>
         * A list of the managed policies attached to the user.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<AttachedPolicy>.Builder} avoiding
         * the need to create one manually via {@link List<AttachedPolicy>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttachedPolicy>.Builder#build()} is called immediately and
         * its result is passed to {@link #attachedManagedPolicies(List<AttachedPolicy>)}.
         * 
         * @param attachedManagedPolicies
         *        a consumer that will call methods on {@link List<AttachedPolicy>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachedManagedPolicies(List<AttachedPolicy>)
         */
        Builder attachedManagedPolicies(Consumer<AttachedPolicy.Builder>... attachedManagedPolicies);

        /**
         * <p>
         * The ARN of the policy used to set the permissions boundary for the user.
         * </p>
         * <p>
         * For more information about permissions boundaries, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions
         * boundaries for IAM identities </a> in the <i>IAM User Guide</i>.
         * </p>
         * 
         * @param permissionsBoundary
         *        The ARN of the policy used to set the permissions boundary for the user.</p>
         *        <p>
         *        For more information about permissions boundaries, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions
         *        boundaries for IAM identities </a> in the <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsBoundary(AttachedPermissionsBoundary permissionsBoundary);

        /**
         * <p>
         * The ARN of the policy used to set the permissions boundary for the user.
         * </p>
         * <p>
         * For more information about permissions boundaries, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions
         * boundaries for IAM identities </a> in the <i>IAM User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttachedPermissionsBoundary.Builder}
         * avoiding the need to create one manually via {@link AttachedPermissionsBoundary#builder()}.
         *
         * When the {@link Consumer} completes, {@link AttachedPermissionsBoundary.Builder#build()} is called
         * immediately and its result is passed to {@link #permissionsBoundary(AttachedPermissionsBoundary)}.
         * 
         * @param permissionsBoundary
         *        a consumer that will call methods on {@link AttachedPermissionsBoundary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissionsBoundary(AttachedPermissionsBoundary)
         */
        default Builder permissionsBoundary(Consumer<AttachedPermissionsBoundary.Builder> permissionsBoundary) {
            return permissionsBoundary(AttachedPermissionsBoundary.builder().applyMutation(permissionsBoundary).build());
        }

        /**
         * <p>
         * A list of tags that are associated with the user. For more information about tagging, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM
         * User Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of tags that are associated with the user. For more information about tagging, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
         *        <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags that are associated with the user. For more information about tagging, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM
         * User Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of tags that are associated with the user. For more information about tagging, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
         *        <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags that are associated with the user. For more information about tagging, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM
         * User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String path;

        private String userName;

        private String userId;

        private String arn;

        private Instant createDate;

        private List<PolicyDetail> userPolicyList = DefaultSdkAutoConstructList.getInstance();

        private List<String> groupList = DefaultSdkAutoConstructList.getInstance();

        private List<AttachedPolicy> attachedManagedPolicies = DefaultSdkAutoConstructList.getInstance();

        private AttachedPermissionsBoundary permissionsBoundary;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UserDetail model) {
            path(model.path);
            userName(model.userName);
            userId(model.userId);
            arn(model.arn);
            createDate(model.createDate);
            userPolicyList(model.userPolicyList);
            groupList(model.groupList);
            attachedManagedPolicies(model.attachedManagedPolicies);
            permissionsBoundary(model.permissionsBoundary);
            tags(model.tags);
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getUserName() {
            return userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final List<PolicyDetail.Builder> getUserPolicyList() {
            List<PolicyDetail.Builder> result = _policyDetailListTypeCopier.copyToBuilder(this.userPolicyList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserPolicyList(Collection<PolicyDetail.BuilderImpl> userPolicyList) {
            this.userPolicyList = _policyDetailListTypeCopier.copyFromBuilder(userPolicyList);
        }

        @Override
        public final Builder userPolicyList(Collection<PolicyDetail> userPolicyList) {
            this.userPolicyList = _policyDetailListTypeCopier.copy(userPolicyList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userPolicyList(PolicyDetail... userPolicyList) {
            userPolicyList(Arrays.asList(userPolicyList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userPolicyList(Consumer<PolicyDetail.Builder>... userPolicyList) {
            userPolicyList(Stream.of(userPolicyList).map(c -> PolicyDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getGroupList() {
            if (groupList instanceof SdkAutoConstructList) {
                return null;
            }
            return groupList;
        }

        public final void setGroupList(Collection<String> groupList) {
            this.groupList = _groupNameListTypeCopier.copy(groupList);
        }

        @Override
        public final Builder groupList(Collection<String> groupList) {
            this.groupList = _groupNameListTypeCopier.copy(groupList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupList(String... groupList) {
            groupList(Arrays.asList(groupList));
            return this;
        }

        public final List<AttachedPolicy.Builder> getAttachedManagedPolicies() {
            List<AttachedPolicy.Builder> result = _attachedPoliciesListTypeCopier.copyToBuilder(this.attachedManagedPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachedManagedPolicies(Collection<AttachedPolicy.BuilderImpl> attachedManagedPolicies) {
            this.attachedManagedPolicies = _attachedPoliciesListTypeCopier.copyFromBuilder(attachedManagedPolicies);
        }

        @Override
        public final Builder attachedManagedPolicies(Collection<AttachedPolicy> attachedManagedPolicies) {
            this.attachedManagedPolicies = _attachedPoliciesListTypeCopier.copy(attachedManagedPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedManagedPolicies(AttachedPolicy... attachedManagedPolicies) {
            attachedManagedPolicies(Arrays.asList(attachedManagedPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedManagedPolicies(Consumer<AttachedPolicy.Builder>... attachedManagedPolicies) {
            attachedManagedPolicies(Stream.of(attachedManagedPolicies)
                    .map(c -> AttachedPolicy.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final AttachedPermissionsBoundary.Builder getPermissionsBoundary() {
            return permissionsBoundary != null ? permissionsBoundary.toBuilder() : null;
        }

        public final void setPermissionsBoundary(AttachedPermissionsBoundary.BuilderImpl permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary != null ? permissionsBoundary.build() : null;
        }

        @Override
        public final Builder permissionsBoundary(AttachedPermissionsBoundary permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = _tagListTypeCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = _tagListTypeCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = _tagListTypeCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public UserDetail build() {
            return new UserDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
