/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateOpenIdConnectProviderRequest extends IamRequest implements
        ToCopyableBuilder<CreateOpenIdConnectProviderRequest.Builder, CreateOpenIdConnectProviderRequest> {
    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Url")
            .getter(getter(CreateOpenIdConnectProviderRequest::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final SdkField<List<String>> CLIENT_ID_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ClientIDList")
            .getter(getter(CreateOpenIdConnectProviderRequest::clientIDList))
            .setter(setter(Builder::clientIDList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientIDList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> THUMBPRINT_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ThumbprintList")
            .getter(getter(CreateOpenIdConnectProviderRequest::thumbprintList))
            .setter(setter(Builder::thumbprintList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThumbprintList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateOpenIdConnectProviderRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD,
            CLIENT_ID_LIST_FIELD, THUMBPRINT_LIST_FIELD, TAGS_FIELD));

    private final String url;

    private final List<String> clientIDList;

    private final List<String> thumbprintList;

    private final List<Tag> tags;

    private CreateOpenIdConnectProviderRequest(BuilderImpl builder) {
        super(builder);
        this.url = builder.url;
        this.clientIDList = builder.clientIDList;
        this.thumbprintList = builder.thumbprintList;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The URL of the identity provider. The URL must begin with <code>https://</code> and should correspond to the
     * <code>iss</code> claim in the provider's OpenID Connect ID tokens. Per the OIDC standard, path components are
     * allowed but query parameters are not. Typically the URL consists of only a hostname, like
     * <code>https://server.example.org</code> or <code>https://example.com</code>. The URL should not contain a port
     * number.
     * </p>
     * <p>
     * You cannot register the same provider multiple times in a single Amazon Web Services account. If you try to
     * submit a URL that has already been used for an OpenID Connect provider in the Amazon Web Services account, you
     * will get an error.
     * </p>
     * 
     * @return The URL of the identity provider. The URL must begin with <code>https://</code> and should correspond to
     *         the <code>iss</code> claim in the provider's OpenID Connect ID tokens. Per the OIDC standard, path
     *         components are allowed but query parameters are not. Typically the URL consists of only a hostname, like
     *         <code>https://server.example.org</code> or <code>https://example.com</code>. The URL should not contain a
     *         port number. </p>
     *         <p>
     *         You cannot register the same provider multiple times in a single Amazon Web Services account. If you try
     *         to submit a URL that has already been used for an OpenID Connect provider in the Amazon Web Services
     *         account, you will get an error.
     */
    public final String url() {
        return url;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClientIDList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasClientIDList() {
        return clientIDList != null && !(clientIDList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides a list of client IDs, also known as audiences. When a mobile or web app registers with an OpenID Connect
     * provider, they establish a value that identifies the application. This is the value that's sent as the
     * <code>client_id</code> parameter on OAuth requests.
     * </p>
     * <p>
     * You can register multiple client IDs with the same provider. For example, you might have multiple applications
     * that use the same OIDC provider. You cannot register more than 100 client IDs with a single IAM OIDC provider.
     * </p>
     * <p>
     * There is no defined format for a client ID. The <code>CreateOpenIDConnectProviderRequest</code> operation accepts
     * client IDs up to 255 characters long.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClientIDList} method.
     * </p>
     * 
     * @return Provides a list of client IDs, also known as audiences. When a mobile or web app registers with an OpenID
     *         Connect provider, they establish a value that identifies the application. This is the value that's sent
     *         as the <code>client_id</code> parameter on OAuth requests.</p>
     *         <p>
     *         You can register multiple client IDs with the same provider. For example, you might have multiple
     *         applications that use the same OIDC provider. You cannot register more than 100 client IDs with a single
     *         IAM OIDC provider.
     *         </p>
     *         <p>
     *         There is no defined format for a client ID. The <code>CreateOpenIDConnectProviderRequest</code> operation
     *         accepts client IDs up to 255 characters long.
     */
    public final List<String> clientIDList() {
        return clientIDList;
    }

    /**
     * For responses, this returns true if the service returned a value for the ThumbprintList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasThumbprintList() {
        return thumbprintList != null && !(thumbprintList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of server certificate thumbprints for the OpenID Connect (OIDC) identity provider's server certificates.
     * Typically this list includes only one entry. However, IAM lets you have up to five thumbprints for an OIDC
     * provider. This lets you maintain multiple thumbprints if the identity provider is rotating certificates.
     * </p>
     * <p>
     * The server certificate thumbprint is the hex-encoded SHA-1 hash value of the X.509 certificate used by the domain
     * where the OpenID Connect provider makes its keys available. It is always a 40-character string.
     * </p>
     * <p>
     * You must provide at least one thumbprint when creating an IAM OIDC provider. For example, assume that the OIDC
     * provider is <code>server.example.com</code> and the provider stores its keys at
     * https://keys.server.example.com/openid-connect. In that case, the thumbprint string would be the hex-encoded
     * SHA-1 hash value of the certificate used by <code>https://keys.server.example.com.</code>
     * </p>
     * <p>
     * For more information about obtaining the OIDC provider thumbprint, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/identity-providers-oidc-obtain-thumbprint.html">Obtaining
     * the thumbprint for an OpenID Connect provider</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasThumbprintList} method.
     * </p>
     * 
     * @return A list of server certificate thumbprints for the OpenID Connect (OIDC) identity provider's server
     *         certificates. Typically this list includes only one entry. However, IAM lets you have up to five
     *         thumbprints for an OIDC provider. This lets you maintain multiple thumbprints if the identity provider is
     *         rotating certificates.</p>
     *         <p>
     *         The server certificate thumbprint is the hex-encoded SHA-1 hash value of the X.509 certificate used by
     *         the domain where the OpenID Connect provider makes its keys available. It is always a 40-character
     *         string.
     *         </p>
     *         <p>
     *         You must provide at least one thumbprint when creating an IAM OIDC provider. For example, assume that the
     *         OIDC provider is <code>server.example.com</code> and the provider stores its keys at
     *         https://keys.server.example.com/openid-connect. In that case, the thumbprint string would be the
     *         hex-encoded SHA-1 hash value of the certificate used by <code>https://keys.server.example.com.</code>
     *         </p>
     *         <p>
     *         For more information about obtaining the OIDC provider thumbprint, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/identity-providers-oidc-obtain-thumbprint.html"
     *         >Obtaining the thumbprint for an OpenID Connect provider</a> in the <i>IAM User Guide</i>.
     */
    public final List<String> thumbprintList() {
        return thumbprintList;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags that you want to attach to the new IAM OpenID Connect (OIDC) provider. Each tag consists of a key
     * name and an associated value. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     * <note>
     * <p>
     * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
     * fails and the resource is not created.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags that you want to attach to the new IAM OpenID Connect (OIDC) provider. Each tag consists
     *         of a key name and an associated value. For more information about tagging, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
     *         <i>IAM User Guide</i>.</p> <note>
     *         <p>
     *         If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire
     *         request fails and the resource is not created.
     *         </p>
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(hasClientIDList() ? clientIDList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasThumbprintList() ? thumbprintList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOpenIdConnectProviderRequest)) {
            return false;
        }
        CreateOpenIdConnectProviderRequest other = (CreateOpenIdConnectProviderRequest) obj;
        return Objects.equals(url(), other.url()) && hasClientIDList() == other.hasClientIDList()
                && Objects.equals(clientIDList(), other.clientIDList()) && hasThumbprintList() == other.hasThumbprintList()
                && Objects.equals(thumbprintList(), other.thumbprintList()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateOpenIdConnectProviderRequest").add("Url", url())
                .add("ClientIDList", hasClientIDList() ? clientIDList() : null)
                .add("ThumbprintList", hasThumbprintList() ? thumbprintList() : null).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "ClientIDList":
            return Optional.ofNullable(clazz.cast(clientIDList()));
        case "ThumbprintList":
            return Optional.ofNullable(clazz.cast(thumbprintList()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateOpenIdConnectProviderRequest, T> g) {
        return obj -> g.apply((CreateOpenIdConnectProviderRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateOpenIdConnectProviderRequest> {
        /**
         * <p>
         * The URL of the identity provider. The URL must begin with <code>https://</code> and should correspond to the
         * <code>iss</code> claim in the provider's OpenID Connect ID tokens. Per the OIDC standard, path components are
         * allowed but query parameters are not. Typically the URL consists of only a hostname, like
         * <code>https://server.example.org</code> or <code>https://example.com</code>. The URL should not contain a
         * port number.
         * </p>
         * <p>
         * You cannot register the same provider multiple times in a single Amazon Web Services account. If you try to
         * submit a URL that has already been used for an OpenID Connect provider in the Amazon Web Services account,
         * you will get an error.
         * </p>
         * 
         * @param url
         *        The URL of the identity provider. The URL must begin with <code>https://</code> and should correspond
         *        to the <code>iss</code> claim in the provider's OpenID Connect ID tokens. Per the OIDC standard, path
         *        components are allowed but query parameters are not. Typically the URL consists of only a hostname,
         *        like <code>https://server.example.org</code> or <code>https://example.com</code>. The URL should not
         *        contain a port number. </p>
         *        <p>
         *        You cannot register the same provider multiple times in a single Amazon Web Services account. If you
         *        try to submit a URL that has already been used for an OpenID Connect provider in the Amazon Web
         *        Services account, you will get an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * Provides a list of client IDs, also known as audiences. When a mobile or web app registers with an OpenID
         * Connect provider, they establish a value that identifies the application. This is the value that's sent as
         * the <code>client_id</code> parameter on OAuth requests.
         * </p>
         * <p>
         * You can register multiple client IDs with the same provider. For example, you might have multiple
         * applications that use the same OIDC provider. You cannot register more than 100 client IDs with a single IAM
         * OIDC provider.
         * </p>
         * <p>
         * There is no defined format for a client ID. The <code>CreateOpenIDConnectProviderRequest</code> operation
         * accepts client IDs up to 255 characters long.
         * </p>
         * 
         * @param clientIDList
         *        Provides a list of client IDs, also known as audiences. When a mobile or web app registers with an
         *        OpenID Connect provider, they establish a value that identifies the application. This is the value
         *        that's sent as the <code>client_id</code> parameter on OAuth requests.</p>
         *        <p>
         *        You can register multiple client IDs with the same provider. For example, you might have multiple
         *        applications that use the same OIDC provider. You cannot register more than 100 client IDs with a
         *        single IAM OIDC provider.
         *        </p>
         *        <p>
         *        There is no defined format for a client ID. The <code>CreateOpenIDConnectProviderRequest</code>
         *        operation accepts client IDs up to 255 characters long.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientIDList(Collection<String> clientIDList);

        /**
         * <p>
         * Provides a list of client IDs, also known as audiences. When a mobile or web app registers with an OpenID
         * Connect provider, they establish a value that identifies the application. This is the value that's sent as
         * the <code>client_id</code> parameter on OAuth requests.
         * </p>
         * <p>
         * You can register multiple client IDs with the same provider. For example, you might have multiple
         * applications that use the same OIDC provider. You cannot register more than 100 client IDs with a single IAM
         * OIDC provider.
         * </p>
         * <p>
         * There is no defined format for a client ID. The <code>CreateOpenIDConnectProviderRequest</code> operation
         * accepts client IDs up to 255 characters long.
         * </p>
         * 
         * @param clientIDList
         *        Provides a list of client IDs, also known as audiences. When a mobile or web app registers with an
         *        OpenID Connect provider, they establish a value that identifies the application. This is the value
         *        that's sent as the <code>client_id</code> parameter on OAuth requests.</p>
         *        <p>
         *        You can register multiple client IDs with the same provider. For example, you might have multiple
         *        applications that use the same OIDC provider. You cannot register more than 100 client IDs with a
         *        single IAM OIDC provider.
         *        </p>
         *        <p>
         *        There is no defined format for a client ID. The <code>CreateOpenIDConnectProviderRequest</code>
         *        operation accepts client IDs up to 255 characters long.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientIDList(String... clientIDList);

        /**
         * <p>
         * A list of server certificate thumbprints for the OpenID Connect (OIDC) identity provider's server
         * certificates. Typically this list includes only one entry. However, IAM lets you have up to five thumbprints
         * for an OIDC provider. This lets you maintain multiple thumbprints if the identity provider is rotating
         * certificates.
         * </p>
         * <p>
         * The server certificate thumbprint is the hex-encoded SHA-1 hash value of the X.509 certificate used by the
         * domain where the OpenID Connect provider makes its keys available. It is always a 40-character string.
         * </p>
         * <p>
         * You must provide at least one thumbprint when creating an IAM OIDC provider. For example, assume that the
         * OIDC provider is <code>server.example.com</code> and the provider stores its keys at
         * https://keys.server.example.com/openid-connect. In that case, the thumbprint string would be the hex-encoded
         * SHA-1 hash value of the certificate used by <code>https://keys.server.example.com.</code>
         * </p>
         * <p>
         * For more information about obtaining the OIDC provider thumbprint, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/identity-providers-oidc-obtain-thumbprint.html"
         * >Obtaining the thumbprint for an OpenID Connect provider</a> in the <i>IAM User Guide</i>.
         * </p>
         * 
         * @param thumbprintList
         *        A list of server certificate thumbprints for the OpenID Connect (OIDC) identity provider's server
         *        certificates. Typically this list includes only one entry. However, IAM lets you have up to five
         *        thumbprints for an OIDC provider. This lets you maintain multiple thumbprints if the identity provider
         *        is rotating certificates.</p>
         *        <p>
         *        The server certificate thumbprint is the hex-encoded SHA-1 hash value of the X.509 certificate used by
         *        the domain where the OpenID Connect provider makes its keys available. It is always a 40-character
         *        string.
         *        </p>
         *        <p>
         *        You must provide at least one thumbprint when creating an IAM OIDC provider. For example, assume that
         *        the OIDC provider is <code>server.example.com</code> and the provider stores its keys at
         *        https://keys.server.example.com/openid-connect. In that case, the thumbprint string would be the
         *        hex-encoded SHA-1 hash value of the certificate used by <code>https://keys.server.example.com.</code>
         *        </p>
         *        <p>
         *        For more information about obtaining the OIDC provider thumbprint, see <a href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/identity-providers-oidc-obtain-thumbprint.html"
         *        >Obtaining the thumbprint for an OpenID Connect provider</a> in the <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbprintList(Collection<String> thumbprintList);

        /**
         * <p>
         * A list of server certificate thumbprints for the OpenID Connect (OIDC) identity provider's server
         * certificates. Typically this list includes only one entry. However, IAM lets you have up to five thumbprints
         * for an OIDC provider. This lets you maintain multiple thumbprints if the identity provider is rotating
         * certificates.
         * </p>
         * <p>
         * The server certificate thumbprint is the hex-encoded SHA-1 hash value of the X.509 certificate used by the
         * domain where the OpenID Connect provider makes its keys available. It is always a 40-character string.
         * </p>
         * <p>
         * You must provide at least one thumbprint when creating an IAM OIDC provider. For example, assume that the
         * OIDC provider is <code>server.example.com</code> and the provider stores its keys at
         * https://keys.server.example.com/openid-connect. In that case, the thumbprint string would be the hex-encoded
         * SHA-1 hash value of the certificate used by <code>https://keys.server.example.com.</code>
         * </p>
         * <p>
         * For more information about obtaining the OIDC provider thumbprint, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/identity-providers-oidc-obtain-thumbprint.html"
         * >Obtaining the thumbprint for an OpenID Connect provider</a> in the <i>IAM User Guide</i>.
         * </p>
         * 
         * @param thumbprintList
         *        A list of server certificate thumbprints for the OpenID Connect (OIDC) identity provider's server
         *        certificates. Typically this list includes only one entry. However, IAM lets you have up to five
         *        thumbprints for an OIDC provider. This lets you maintain multiple thumbprints if the identity provider
         *        is rotating certificates.</p>
         *        <p>
         *        The server certificate thumbprint is the hex-encoded SHA-1 hash value of the X.509 certificate used by
         *        the domain where the OpenID Connect provider makes its keys available. It is always a 40-character
         *        string.
         *        </p>
         *        <p>
         *        You must provide at least one thumbprint when creating an IAM OIDC provider. For example, assume that
         *        the OIDC provider is <code>server.example.com</code> and the provider stores its keys at
         *        https://keys.server.example.com/openid-connect. In that case, the thumbprint string would be the
         *        hex-encoded SHA-1 hash value of the certificate used by <code>https://keys.server.example.com.</code>
         *        </p>
         *        <p>
         *        For more information about obtaining the OIDC provider thumbprint, see <a href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/identity-providers-oidc-obtain-thumbprint.html"
         *        >Obtaining the thumbprint for an OpenID Connect provider</a> in the <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbprintList(String... thumbprintList);

        /**
         * <p>
         * A list of tags that you want to attach to the new IAM OpenID Connect (OIDC) provider. Each tag consists of a
         * key name and an associated value. For more information about tagging, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM
         * User Guide</i>.
         * </p>
         * <note>
         * <p>
         * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire
         * request fails and the resource is not created.
         * </p>
         * </note>
         * 
         * @param tags
         *        A list of tags that you want to attach to the new IAM OpenID Connect (OIDC) provider. Each tag
         *        consists of a key name and an associated value. For more information about tagging, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
         *        <i>IAM User Guide</i>.</p> <note>
         *        <p>
         *        If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire
         *        request fails and the resource is not created.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags that you want to attach to the new IAM OpenID Connect (OIDC) provider. Each tag consists of a
         * key name and an associated value. For more information about tagging, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM
         * User Guide</i>.
         * </p>
         * <note>
         * <p>
         * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire
         * request fails and the resource is not created.
         * </p>
         * </note>
         * 
         * @param tags
         *        A list of tags that you want to attach to the new IAM OpenID Connect (OIDC) provider. Each tag
         *        consists of a key name and an associated value. For more information about tagging, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
         *        <i>IAM User Guide</i>.</p> <note>
         *        <p>
         *        If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire
         *        request fails and the resource is not created.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags that you want to attach to the new IAM OpenID Connect (OIDC) provider. Each tag consists of a
         * key name and an associated value. For more information about tagging, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM
         * User Guide</i>.
         * </p>
         * <note>
         * <p>
         * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire
         * request fails and the resource is not created.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the
         * need to create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private String url;

        private List<String> clientIDList = DefaultSdkAutoConstructList.getInstance();

        private List<String> thumbprintList = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOpenIdConnectProviderRequest model) {
            super(model);
            url(model.url);
            clientIDList(model.clientIDList);
            thumbprintList(model.thumbprintList);
            tags(model.tags);
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final Collection<String> getClientIDList() {
            if (clientIDList instanceof SdkAutoConstructList) {
                return null;
            }
            return clientIDList;
        }

        public final void setClientIDList(Collection<String> clientIDList) {
            this.clientIDList = _clientIDListTypeCopier.copy(clientIDList);
        }

        @Override
        public final Builder clientIDList(Collection<String> clientIDList) {
            this.clientIDList = _clientIDListTypeCopier.copy(clientIDList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientIDList(String... clientIDList) {
            clientIDList(Arrays.asList(clientIDList));
            return this;
        }

        public final Collection<String> getThumbprintList() {
            if (thumbprintList instanceof SdkAutoConstructList) {
                return null;
            }
            return thumbprintList;
        }

        public final void setThumbprintList(Collection<String> thumbprintList) {
            this.thumbprintList = _thumbprintListTypeCopier.copy(thumbprintList);
        }

        @Override
        public final Builder thumbprintList(Collection<String> thumbprintList) {
            this.thumbprintList = _thumbprintListTypeCopier.copy(thumbprintList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thumbprintList(String... thumbprintList) {
            thumbprintList(Arrays.asList(thumbprintList));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = _tagListTypeCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = _tagListTypeCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = _tagListTypeCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateOpenIdConnectProviderRequest build() {
            return new CreateOpenIdConnectProviderRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
