/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a successful <a>GetAccessKeyLastUsed</a> request. It is also returned as a member of the
 * <a>AccessKeyMetaData</a> structure returned by the <a>ListAccessKeys</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAccessKeyLastUsedResponse extends IamResponse implements
        ToCopyableBuilder<GetAccessKeyLastUsedResponse.Builder, GetAccessKeyLastUsedResponse> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(GetAccessKeyLastUsedResponse::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<AccessKeyLastUsed> ACCESS_KEY_LAST_USED_FIELD = SdkField
            .<AccessKeyLastUsed> builder(MarshallingType.SDK_POJO).memberName("AccessKeyLastUsed")
            .getter(getter(GetAccessKeyLastUsedResponse::accessKeyLastUsed)).setter(setter(Builder::accessKeyLastUsed))
            .constructor(AccessKeyLastUsed::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessKeyLastUsed").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD,
            ACCESS_KEY_LAST_USED_FIELD));

    private final String userName;

    private final AccessKeyLastUsed accessKeyLastUsed;

    private GetAccessKeyLastUsedResponse(BuilderImpl builder) {
        super(builder);
        this.userName = builder.userName;
        this.accessKeyLastUsed = builder.accessKeyLastUsed;
    }

    /**
     * <p>
     * The name of the IAM user that owns this access key.
     * </p>
     * <p/>
     * 
     * @return The name of the IAM user that owns this access key.
     *         </p>
     */
    public final String userName() {
        return userName;
    }

    /**
     * <p>
     * Contains information about the last time the access key was used.
     * </p>
     * 
     * @return Contains information about the last time the access key was used.
     */
    public final AccessKeyLastUsed accessKeyLastUsed() {
        return accessKeyLastUsed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(accessKeyLastUsed());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccessKeyLastUsedResponse)) {
            return false;
        }
        GetAccessKeyLastUsedResponse other = (GetAccessKeyLastUsedResponse) obj;
        return Objects.equals(userName(), other.userName()) && Objects.equals(accessKeyLastUsed(), other.accessKeyLastUsed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAccessKeyLastUsedResponse").add("UserName", userName())
                .add("AccessKeyLastUsed", accessKeyLastUsed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "AccessKeyLastUsed":
            return Optional.ofNullable(clazz.cast(accessKeyLastUsed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAccessKeyLastUsedResponse, T> g) {
        return obj -> g.apply((GetAccessKeyLastUsedResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAccessKeyLastUsedResponse> {
        /**
         * <p>
         * The name of the IAM user that owns this access key.
         * </p>
         * <p/>
         * 
         * @param userName
         *        The name of the IAM user that owns this access key.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * Contains information about the last time the access key was used.
         * </p>
         * 
         * @param accessKeyLastUsed
         *        Contains information about the last time the access key was used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessKeyLastUsed(AccessKeyLastUsed accessKeyLastUsed);

        /**
         * <p>
         * Contains information about the last time the access key was used.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccessKeyLastUsed.Builder} avoiding the
         * need to create one manually via {@link AccessKeyLastUsed#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccessKeyLastUsed.Builder#build()} is called immediately and its
         * result is passed to {@link #accessKeyLastUsed(AccessKeyLastUsed)}.
         * 
         * @param accessKeyLastUsed
         *        a consumer that will call methods on {@link AccessKeyLastUsed.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessKeyLastUsed(AccessKeyLastUsed)
         */
        default Builder accessKeyLastUsed(Consumer<AccessKeyLastUsed.Builder> accessKeyLastUsed) {
            return accessKeyLastUsed(AccessKeyLastUsed.builder().applyMutation(accessKeyLastUsed).build());
        }
    }

    static final class BuilderImpl extends IamResponse.BuilderImpl implements Builder {
        private String userName;

        private AccessKeyLastUsed accessKeyLastUsed;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccessKeyLastUsedResponse model) {
            super(model);
            userName(model.userName);
            accessKeyLastUsed(model.accessKeyLastUsed);
        }

        public final String getUserName() {
            return userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final AccessKeyLastUsed.Builder getAccessKeyLastUsed() {
            return accessKeyLastUsed != null ? accessKeyLastUsed.toBuilder() : null;
        }

        public final void setAccessKeyLastUsed(AccessKeyLastUsed.BuilderImpl accessKeyLastUsed) {
            this.accessKeyLastUsed = accessKeyLastUsed != null ? accessKeyLastUsed.build() : null;
        }

        @Override
        public final Builder accessKeyLastUsed(AccessKeyLastUsed accessKeyLastUsed) {
            this.accessKeyLastUsed = accessKeyLastUsed;
            return this;
        }

        @Override
        public GetAccessKeyLastUsedResponse build() {
            return new GetAccessKeyLastUsedResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
