/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a successful <a>ListAttachedGroupPolicies</a> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAttachedGroupPoliciesResponse extends IamResponse implements
        ToCopyableBuilder<ListAttachedGroupPoliciesResponse.Builder, ListAttachedGroupPoliciesResponse> {
    private static final SdkField<List<AttachedPolicy>> ATTACHED_POLICIES_FIELD = SdkField
            .<List<AttachedPolicy>> builder(MarshallingType.LIST)
            .memberName("AttachedPolicies")
            .getter(getter(ListAttachedGroupPoliciesResponse::attachedPolicies))
            .setter(setter(Builder::attachedPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachedPolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttachedPolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttachedPolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsTruncated").getter(getter(ListAttachedGroupPoliciesResponse::isTruncated))
            .setter(setter(Builder::isTruncated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListAttachedGroupPoliciesResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHED_POLICIES_FIELD,
            IS_TRUNCATED_FIELD, MARKER_FIELD));

    private final List<AttachedPolicy> attachedPolicies;

    private final Boolean isTruncated;

    private final String marker;

    private ListAttachedGroupPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.attachedPolicies = builder.attachedPolicies;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttachedPolicies property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttachedPolicies() {
        return attachedPolicies != null && !(attachedPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the attached policies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttachedPolicies} method.
     * </p>
     * 
     * @return A list of the attached policies.
     */
    public final List<AttachedPolicy> attachedPolicies() {
        return attachedPolicies;
    }

    /**
     * <p>
     * A flag that indicates whether there are more items to return. If your results were truncated, you can make a
     * subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that
     * IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results
     * available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all
     * your results.
     * </p>
     * 
     * @return A flag that indicates whether there are more items to return. If your results were truncated, you can
     *         make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more
     *         items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there
     *         are more results available. We recommend that you check <code>IsTruncated</code> after every call to
     *         ensure that you receive all your results.
     */
    public final Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the
     * <code>Marker</code> parameter in a subsequent pagination request.
     * </p>
     * 
     * @return When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use
     *         for the <code>Marker</code> parameter in a subsequent pagination request.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAttachedPolicies() ? attachedPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAttachedGroupPoliciesResponse)) {
            return false;
        }
        ListAttachedGroupPoliciesResponse other = (ListAttachedGroupPoliciesResponse) obj;
        return hasAttachedPolicies() == other.hasAttachedPolicies()
                && Objects.equals(attachedPolicies(), other.attachedPolicies())
                && Objects.equals(isTruncated(), other.isTruncated()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAttachedGroupPoliciesResponse")
                .add("AttachedPolicies", hasAttachedPolicies() ? attachedPolicies() : null).add("IsTruncated", isTruncated())
                .add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttachedPolicies":
            return Optional.ofNullable(clazz.cast(attachedPolicies()));
        case "IsTruncated":
            return Optional.ofNullable(clazz.cast(isTruncated()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAttachedGroupPoliciesResponse, T> g) {
        return obj -> g.apply((ListAttachedGroupPoliciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAttachedGroupPoliciesResponse> {
        /**
         * <p>
         * A list of the attached policies.
         * </p>
         * 
         * @param attachedPolicies
         *        A list of the attached policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachedPolicies(Collection<AttachedPolicy> attachedPolicies);

        /**
         * <p>
         * A list of the attached policies.
         * </p>
         * 
         * @param attachedPolicies
         *        A list of the attached policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachedPolicies(AttachedPolicy... attachedPolicies);

        /**
         * <p>
         * A list of the attached policies.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<AttachedPolicy>.Builder} avoiding
         * the need to create one manually via {@link List<AttachedPolicy>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttachedPolicy>.Builder#build()} is called immediately and
         * its result is passed to {@link #attachedPolicies(List<AttachedPolicy>)}.
         * 
         * @param attachedPolicies
         *        a consumer that will call methods on {@link List<AttachedPolicy>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachedPolicies(List<AttachedPolicy>)
         */
        Builder attachedPolicies(Consumer<AttachedPolicy.Builder>... attachedPolicies);

        /**
         * <p>
         * A flag that indicates whether there are more items to return. If your results were truncated, you can make a
         * subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note
         * that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results
         * available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive
         * all your results.
         * </p>
         * 
         * @param isTruncated
         *        A flag that indicates whether there are more items to return. If your results were truncated, you can
         *        make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more
         *        items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when
         *        there are more results available. We recommend that you check <code>IsTruncated</code> after every
         *        call to ensure that you receive all your results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for
         * the <code>Marker</code> parameter in a subsequent pagination request.
         * </p>
         * 
         * @param marker
         *        When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to
         *        use for the <code>Marker</code> parameter in a subsequent pagination request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends IamResponse.BuilderImpl implements Builder {
        private List<AttachedPolicy> attachedPolicies = DefaultSdkAutoConstructList.getInstance();

        private Boolean isTruncated;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAttachedGroupPoliciesResponse model) {
            super(model);
            attachedPolicies(model.attachedPolicies);
            isTruncated(model.isTruncated);
            marker(model.marker);
        }

        public final List<AttachedPolicy.Builder> getAttachedPolicies() {
            List<AttachedPolicy.Builder> result = _attachedPoliciesListTypeCopier.copyToBuilder(this.attachedPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachedPolicies(Collection<AttachedPolicy.BuilderImpl> attachedPolicies) {
            this.attachedPolicies = _attachedPoliciesListTypeCopier.copyFromBuilder(attachedPolicies);
        }

        @Override
        public final Builder attachedPolicies(Collection<AttachedPolicy> attachedPolicies) {
            this.attachedPolicies = _attachedPoliciesListTypeCopier.copy(attachedPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedPolicies(AttachedPolicy... attachedPolicies) {
            attachedPolicies(Arrays.asList(attachedPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedPolicies(Consumer<AttachedPolicy.Builder>... attachedPolicies) {
            attachedPolicies(Stream.of(attachedPolicies).map(c -> AttachedPolicy.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public ListAttachedGroupPoliciesResponse build() {
            return new ListAttachedGroupPoliciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
