/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.services.iam.model.Tag;
import software.amazon.awssdk.services.iam.model._tagListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSamlProviderResponse
extends IamResponse
implements ToCopyableBuilder<Builder, GetSamlProviderResponse> {
    private static final SdkField<String> SAML_METADATA_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SAMLMetadataDocument").getter(GetSamlProviderResponse.getter(GetSamlProviderResponse::samlMetadataDocument)).setter(GetSamlProviderResponse.setter(Builder::samlMetadataDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMLMetadataDocument").build()}).build();
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateDate").getter(GetSamlProviderResponse.getter(GetSamlProviderResponse::createDate)).setter(GetSamlProviderResponse.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()}).build();
    private static final SdkField<Instant> VALID_UNTIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ValidUntil").getter(GetSamlProviderResponse.getter(GetSamlProviderResponse::validUntil)).setter(GetSamlProviderResponse.setter(Builder::validUntil)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidUntil").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(GetSamlProviderResponse.getter(GetSamlProviderResponse::tags)).setter(GetSamlProviderResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAML_METADATA_DOCUMENT_FIELD, CREATE_DATE_FIELD, VALID_UNTIL_FIELD, TAGS_FIELD));
    private final String samlMetadataDocument;
    private final Instant createDate;
    private final Instant validUntil;
    private final List<Tag> tags;

    private GetSamlProviderResponse(BuilderImpl builder) {
        super(builder);
        this.samlMetadataDocument = builder.samlMetadataDocument;
        this.createDate = builder.createDate;
        this.validUntil = builder.validUntil;
        this.tags = builder.tags;
    }

    public final String samlMetadataDocument() {
        return this.samlMetadataDocument;
    }

    public final Instant createDate() {
        return this.createDate;
    }

    public final Instant validUntil() {
        return this.validUntil;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.samlMetadataDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.validUntil());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSamlProviderResponse)) {
            return false;
        }
        GetSamlProviderResponse other = (GetSamlProviderResponse)((Object)obj);
        return Objects.equals(this.samlMetadataDocument(), other.samlMetadataDocument()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.validUntil(), other.validUntil()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetSamlProviderResponse").add("SAMLMetadataDocument", (Object)this.samlMetadataDocument()).add("CreateDate", (Object)this.createDate()).add("ValidUntil", (Object)this.validUntil()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SAMLMetadataDocument": {
                return Optional.ofNullable(clazz.cast(this.samlMetadataDocument()));
            }
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
            case "ValidUntil": {
                return Optional.ofNullable(clazz.cast(this.validUntil()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSamlProviderResponse, T> g) {
        return obj -> g.apply((GetSamlProviderResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private String samlMetadataDocument;
        private Instant createDate;
        private Instant validUntil;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSamlProviderResponse model) {
            super(model);
            this.samlMetadataDocument(model.samlMetadataDocument);
            this.createDate(model.createDate);
            this.validUntil(model.validUntil);
            this.tags(model.tags);
        }

        public final String getSamlMetadataDocument() {
            return this.samlMetadataDocument;
        }

        public final void setSamlMetadataDocument(String samlMetadataDocument) {
            this.samlMetadataDocument = samlMetadataDocument;
        }

        @Override
        @Transient
        public final Builder samlMetadataDocument(String samlMetadataDocument) {
            this.samlMetadataDocument = samlMetadataDocument;
            return this;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        @Transient
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final Instant getValidUntil() {
            return this.validUntil;
        }

        public final void setValidUntil(Instant validUntil) {
            this.validUntil = validUntil;
        }

        @Override
        @Transient
        public final Builder validUntil(Instant validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = _tagListTypeCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = _tagListTypeCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = _tagListTypeCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetSamlProviderResponse build() {
            return new GetSamlProviderResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSamlProviderResponse> {
        public Builder samlMetadataDocument(String var1);

        public Builder createDate(Instant var1);

        public Builder validUntil(Instant var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

