/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iam.model.ContextKeyNamesResultListTypeCopier;
import software.amazon.awssdk.services.iam.model.EvalDecisionDetailsTypeCopier;
import software.amazon.awssdk.services.iam.model.OrganizationsDecisionDetail;
import software.amazon.awssdk.services.iam.model.PermissionsBoundaryDecisionDetail;
import software.amazon.awssdk.services.iam.model.PolicyEvaluationDecisionType;
import software.amazon.awssdk.services.iam.model.ResourceSpecificResult;
import software.amazon.awssdk.services.iam.model.ResourceSpecificResultListTypeCopier;
import software.amazon.awssdk.services.iam.model.Statement;
import software.amazon.awssdk.services.iam.model.StatementListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationResult> {
    private static final SdkField<String> EVAL_ACTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvalActionName").getter(EvaluationResult.getter(EvaluationResult::evalActionName)).setter(EvaluationResult.setter(Builder::evalActionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvalActionName").build()}).build();
    private static final SdkField<String> EVAL_RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvalResourceName").getter(EvaluationResult.getter(EvaluationResult::evalResourceName)).setter(EvaluationResult.setter(Builder::evalResourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvalResourceName").build()}).build();
    private static final SdkField<String> EVAL_DECISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvalDecision").getter(EvaluationResult.getter(EvaluationResult::evalDecisionAsString)).setter(EvaluationResult.setter(Builder::evalDecision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvalDecision").build()}).build();
    private static final SdkField<List<Statement>> MATCHED_STATEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MatchedStatements").getter(EvaluationResult.getter(EvaluationResult::matchedStatements)).setter(EvaluationResult.setter(Builder::matchedStatements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchedStatements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Statement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> MISSING_CONTEXT_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MissingContextValues").getter(EvaluationResult.getter(EvaluationResult::missingContextValues)).setter(EvaluationResult.setter(Builder::missingContextValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MissingContextValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<OrganizationsDecisionDetail> ORGANIZATIONS_DECISION_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OrganizationsDecisionDetail").getter(EvaluationResult.getter(EvaluationResult::organizationsDecisionDetail)).setter(EvaluationResult.setter(Builder::organizationsDecisionDetail)).constructor(OrganizationsDecisionDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationsDecisionDetail").build()}).build();
    private static final SdkField<PermissionsBoundaryDecisionDetail> PERMISSIONS_BOUNDARY_DECISION_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PermissionsBoundaryDecisionDetail").getter(EvaluationResult.getter(EvaluationResult::permissionsBoundaryDecisionDetail)).setter(EvaluationResult.setter(Builder::permissionsBoundaryDecisionDetail)).constructor(PermissionsBoundaryDecisionDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsBoundaryDecisionDetail").build()}).build();
    private static final SdkField<Map<String, String>> EVAL_DECISION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("EvalDecisionDetails").getter(EvaluationResult.getter(EvaluationResult::evalDecisionDetailsAsStrings)).setter(EvaluationResult.setter(Builder::evalDecisionDetailsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvalDecisionDetails").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<ResourceSpecificResult>> RESOURCE_SPECIFIC_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceSpecificResults").getter(EvaluationResult.getter(EvaluationResult::resourceSpecificResults)).setter(EvaluationResult.setter(Builder::resourceSpecificResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSpecificResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceSpecificResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVAL_ACTION_NAME_FIELD, EVAL_RESOURCE_NAME_FIELD, EVAL_DECISION_FIELD, MATCHED_STATEMENTS_FIELD, MISSING_CONTEXT_VALUES_FIELD, ORGANIZATIONS_DECISION_DETAIL_FIELD, PERMISSIONS_BOUNDARY_DECISION_DETAIL_FIELD, EVAL_DECISION_DETAILS_FIELD, RESOURCE_SPECIFIC_RESULTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String evalActionName;
    private final String evalResourceName;
    private final String evalDecision;
    private final List<Statement> matchedStatements;
    private final List<String> missingContextValues;
    private final OrganizationsDecisionDetail organizationsDecisionDetail;
    private final PermissionsBoundaryDecisionDetail permissionsBoundaryDecisionDetail;
    private final Map<String, String> evalDecisionDetails;
    private final List<ResourceSpecificResult> resourceSpecificResults;

    private EvaluationResult(BuilderImpl builder) {
        this.evalActionName = builder.evalActionName;
        this.evalResourceName = builder.evalResourceName;
        this.evalDecision = builder.evalDecision;
        this.matchedStatements = builder.matchedStatements;
        this.missingContextValues = builder.missingContextValues;
        this.organizationsDecisionDetail = builder.organizationsDecisionDetail;
        this.permissionsBoundaryDecisionDetail = builder.permissionsBoundaryDecisionDetail;
        this.evalDecisionDetails = builder.evalDecisionDetails;
        this.resourceSpecificResults = builder.resourceSpecificResults;
    }

    public final String evalActionName() {
        return this.evalActionName;
    }

    public final String evalResourceName() {
        return this.evalResourceName;
    }

    public final PolicyEvaluationDecisionType evalDecision() {
        return PolicyEvaluationDecisionType.fromValue(this.evalDecision);
    }

    public final String evalDecisionAsString() {
        return this.evalDecision;
    }

    public final boolean hasMatchedStatements() {
        return this.matchedStatements != null && !(this.matchedStatements instanceof SdkAutoConstructList);
    }

    public final List<Statement> matchedStatements() {
        return this.matchedStatements;
    }

    public final boolean hasMissingContextValues() {
        return this.missingContextValues != null && !(this.missingContextValues instanceof SdkAutoConstructList);
    }

    public final List<String> missingContextValues() {
        return this.missingContextValues;
    }

    public final OrganizationsDecisionDetail organizationsDecisionDetail() {
        return this.organizationsDecisionDetail;
    }

    public final PermissionsBoundaryDecisionDetail permissionsBoundaryDecisionDetail() {
        return this.permissionsBoundaryDecisionDetail;
    }

    public final Map<String, PolicyEvaluationDecisionType> evalDecisionDetails() {
        return EvalDecisionDetailsTypeCopier.copyStringToEnum(this.evalDecisionDetails);
    }

    public final boolean hasEvalDecisionDetails() {
        return this.evalDecisionDetails != null && !(this.evalDecisionDetails instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> evalDecisionDetailsAsStrings() {
        return this.evalDecisionDetails;
    }

    public final boolean hasResourceSpecificResults() {
        return this.resourceSpecificResults != null && !(this.resourceSpecificResults instanceof SdkAutoConstructList);
    }

    public final List<ResourceSpecificResult> resourceSpecificResults() {
        return this.resourceSpecificResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.evalActionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.evalResourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.evalDecisionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMatchedStatements() ? this.matchedStatements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMissingContextValues() ? this.missingContextValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationsDecisionDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionsBoundaryDecisionDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvalDecisionDetails() ? this.evalDecisionDetailsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceSpecificResults() ? this.resourceSpecificResults() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationResult)) {
            return false;
        }
        EvaluationResult other = (EvaluationResult)obj;
        return Objects.equals(this.evalActionName(), other.evalActionName()) && Objects.equals(this.evalResourceName(), other.evalResourceName()) && Objects.equals(this.evalDecisionAsString(), other.evalDecisionAsString()) && this.hasMatchedStatements() == other.hasMatchedStatements() && Objects.equals(this.matchedStatements(), other.matchedStatements()) && this.hasMissingContextValues() == other.hasMissingContextValues() && Objects.equals(this.missingContextValues(), other.missingContextValues()) && Objects.equals(this.organizationsDecisionDetail(), other.organizationsDecisionDetail()) && Objects.equals(this.permissionsBoundaryDecisionDetail(), other.permissionsBoundaryDecisionDetail()) && this.hasEvalDecisionDetails() == other.hasEvalDecisionDetails() && Objects.equals(this.evalDecisionDetailsAsStrings(), other.evalDecisionDetailsAsStrings()) && this.hasResourceSpecificResults() == other.hasResourceSpecificResults() && Objects.equals(this.resourceSpecificResults(), other.resourceSpecificResults());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationResult").add("EvalActionName", (Object)this.evalActionName()).add("EvalResourceName", (Object)this.evalResourceName()).add("EvalDecision", (Object)this.evalDecisionAsString()).add("MatchedStatements", this.hasMatchedStatements() ? this.matchedStatements() : null).add("MissingContextValues", this.hasMissingContextValues() ? this.missingContextValues() : null).add("OrganizationsDecisionDetail", (Object)this.organizationsDecisionDetail()).add("PermissionsBoundaryDecisionDetail", (Object)this.permissionsBoundaryDecisionDetail()).add("EvalDecisionDetails", this.hasEvalDecisionDetails() ? this.evalDecisionDetailsAsStrings() : null).add("ResourceSpecificResults", this.hasResourceSpecificResults() ? this.resourceSpecificResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EvalActionName": {
                return Optional.ofNullable(clazz.cast(this.evalActionName()));
            }
            case "EvalResourceName": {
                return Optional.ofNullable(clazz.cast(this.evalResourceName()));
            }
            case "EvalDecision": {
                return Optional.ofNullable(clazz.cast(this.evalDecisionAsString()));
            }
            case "MatchedStatements": {
                return Optional.ofNullable(clazz.cast(this.matchedStatements()));
            }
            case "MissingContextValues": {
                return Optional.ofNullable(clazz.cast(this.missingContextValues()));
            }
            case "OrganizationsDecisionDetail": {
                return Optional.ofNullable(clazz.cast(this.organizationsDecisionDetail()));
            }
            case "PermissionsBoundaryDecisionDetail": {
                return Optional.ofNullable(clazz.cast(this.permissionsBoundaryDecisionDetail()));
            }
            case "EvalDecisionDetails": {
                return Optional.ofNullable(clazz.cast(this.evalDecisionDetailsAsStrings()));
            }
            case "ResourceSpecificResults": {
                return Optional.ofNullable(clazz.cast(this.resourceSpecificResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluationResult, T> g) {
        return obj -> g.apply((EvaluationResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String evalActionName;
        private String evalResourceName;
        private String evalDecision;
        private List<Statement> matchedStatements = DefaultSdkAutoConstructList.getInstance();
        private List<String> missingContextValues = DefaultSdkAutoConstructList.getInstance();
        private OrganizationsDecisionDetail organizationsDecisionDetail;
        private PermissionsBoundaryDecisionDetail permissionsBoundaryDecisionDetail;
        private Map<String, String> evalDecisionDetails = DefaultSdkAutoConstructMap.getInstance();
        private List<ResourceSpecificResult> resourceSpecificResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationResult model) {
            this.evalActionName(model.evalActionName);
            this.evalResourceName(model.evalResourceName);
            this.evalDecision(model.evalDecision);
            this.matchedStatements(model.matchedStatements);
            this.missingContextValues(model.missingContextValues);
            this.organizationsDecisionDetail(model.organizationsDecisionDetail);
            this.permissionsBoundaryDecisionDetail(model.permissionsBoundaryDecisionDetail);
            this.evalDecisionDetailsWithStrings(model.evalDecisionDetails);
            this.resourceSpecificResults(model.resourceSpecificResults);
        }

        public final String getEvalActionName() {
            return this.evalActionName;
        }

        public final void setEvalActionName(String evalActionName) {
            this.evalActionName = evalActionName;
        }

        @Override
        public final Builder evalActionName(String evalActionName) {
            this.evalActionName = evalActionName;
            return this;
        }

        public final String getEvalResourceName() {
            return this.evalResourceName;
        }

        public final void setEvalResourceName(String evalResourceName) {
            this.evalResourceName = evalResourceName;
        }

        @Override
        public final Builder evalResourceName(String evalResourceName) {
            this.evalResourceName = evalResourceName;
            return this;
        }

        public final String getEvalDecision() {
            return this.evalDecision;
        }

        public final void setEvalDecision(String evalDecision) {
            this.evalDecision = evalDecision;
        }

        @Override
        public final Builder evalDecision(String evalDecision) {
            this.evalDecision = evalDecision;
            return this;
        }

        @Override
        public final Builder evalDecision(PolicyEvaluationDecisionType evalDecision) {
            this.evalDecision(evalDecision == null ? null : evalDecision.toString());
            return this;
        }

        public final List<Statement.Builder> getMatchedStatements() {
            List<Statement.Builder> result = StatementListTypeCopier.copyToBuilder(this.matchedStatements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMatchedStatements(Collection<Statement.BuilderImpl> matchedStatements) {
            this.matchedStatements = StatementListTypeCopier.copyFromBuilder(matchedStatements);
        }

        @Override
        public final Builder matchedStatements(Collection<Statement> matchedStatements) {
            this.matchedStatements = StatementListTypeCopier.copy(matchedStatements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchedStatements(Statement ... matchedStatements) {
            this.matchedStatements(Arrays.asList(matchedStatements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchedStatements(Consumer<Statement.Builder> ... matchedStatements) {
            this.matchedStatements(Stream.of(matchedStatements).map(c -> (Statement)((Statement.Builder)Statement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getMissingContextValues() {
            if (this.missingContextValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.missingContextValues;
        }

        public final void setMissingContextValues(Collection<String> missingContextValues) {
            this.missingContextValues = ContextKeyNamesResultListTypeCopier.copy(missingContextValues);
        }

        @Override
        public final Builder missingContextValues(Collection<String> missingContextValues) {
            this.missingContextValues = ContextKeyNamesResultListTypeCopier.copy(missingContextValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder missingContextValues(String ... missingContextValues) {
            this.missingContextValues(Arrays.asList(missingContextValues));
            return this;
        }

        public final OrganizationsDecisionDetail.Builder getOrganizationsDecisionDetail() {
            return this.organizationsDecisionDetail != null ? this.organizationsDecisionDetail.toBuilder() : null;
        }

        public final void setOrganizationsDecisionDetail(OrganizationsDecisionDetail.BuilderImpl organizationsDecisionDetail) {
            this.organizationsDecisionDetail = organizationsDecisionDetail != null ? organizationsDecisionDetail.build() : null;
        }

        @Override
        public final Builder organizationsDecisionDetail(OrganizationsDecisionDetail organizationsDecisionDetail) {
            this.organizationsDecisionDetail = organizationsDecisionDetail;
            return this;
        }

        public final PermissionsBoundaryDecisionDetail.Builder getPermissionsBoundaryDecisionDetail() {
            return this.permissionsBoundaryDecisionDetail != null ? this.permissionsBoundaryDecisionDetail.toBuilder() : null;
        }

        public final void setPermissionsBoundaryDecisionDetail(PermissionsBoundaryDecisionDetail.BuilderImpl permissionsBoundaryDecisionDetail) {
            this.permissionsBoundaryDecisionDetail = permissionsBoundaryDecisionDetail != null ? permissionsBoundaryDecisionDetail.build() : null;
        }

        @Override
        public final Builder permissionsBoundaryDecisionDetail(PermissionsBoundaryDecisionDetail permissionsBoundaryDecisionDetail) {
            this.permissionsBoundaryDecisionDetail = permissionsBoundaryDecisionDetail;
            return this;
        }

        public final Map<String, String> getEvalDecisionDetails() {
            if (this.evalDecisionDetails instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.evalDecisionDetails;
        }

        public final void setEvalDecisionDetails(Map<String, String> evalDecisionDetails) {
            this.evalDecisionDetails = EvalDecisionDetailsTypeCopier.copy(evalDecisionDetails);
        }

        @Override
        public final Builder evalDecisionDetailsWithStrings(Map<String, String> evalDecisionDetails) {
            this.evalDecisionDetails = EvalDecisionDetailsTypeCopier.copy(evalDecisionDetails);
            return this;
        }

        @Override
        public final Builder evalDecisionDetails(Map<String, PolicyEvaluationDecisionType> evalDecisionDetails) {
            this.evalDecisionDetails = EvalDecisionDetailsTypeCopier.copyEnumToString(evalDecisionDetails);
            return this;
        }

        public final List<ResourceSpecificResult.Builder> getResourceSpecificResults() {
            List<ResourceSpecificResult.Builder> result = ResourceSpecificResultListTypeCopier.copyToBuilder(this.resourceSpecificResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceSpecificResults(Collection<ResourceSpecificResult.BuilderImpl> resourceSpecificResults) {
            this.resourceSpecificResults = ResourceSpecificResultListTypeCopier.copyFromBuilder(resourceSpecificResults);
        }

        @Override
        public final Builder resourceSpecificResults(Collection<ResourceSpecificResult> resourceSpecificResults) {
            this.resourceSpecificResults = ResourceSpecificResultListTypeCopier.copy(resourceSpecificResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceSpecificResults(ResourceSpecificResult ... resourceSpecificResults) {
            this.resourceSpecificResults(Arrays.asList(resourceSpecificResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceSpecificResults(Consumer<ResourceSpecificResult.Builder> ... resourceSpecificResults) {
            this.resourceSpecificResults(Stream.of(resourceSpecificResults).map(c -> (ResourceSpecificResult)((ResourceSpecificResult.Builder)ResourceSpecificResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public EvaluationResult build() {
            return new EvaluationResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationResult> {
        public Builder evalActionName(String var1);

        public Builder evalResourceName(String var1);

        public Builder evalDecision(String var1);

        public Builder evalDecision(PolicyEvaluationDecisionType var1);

        public Builder matchedStatements(Collection<Statement> var1);

        public Builder matchedStatements(Statement ... var1);

        public Builder matchedStatements(Consumer<Statement.Builder> ... var1);

        public Builder missingContextValues(Collection<String> var1);

        public Builder missingContextValues(String ... var1);

        public Builder organizationsDecisionDetail(OrganizationsDecisionDetail var1);

        default public Builder organizationsDecisionDetail(Consumer<OrganizationsDecisionDetail.Builder> organizationsDecisionDetail) {
            return this.organizationsDecisionDetail((OrganizationsDecisionDetail)((OrganizationsDecisionDetail.Builder)OrganizationsDecisionDetail.builder().applyMutation(organizationsDecisionDetail)).build());
        }

        public Builder permissionsBoundaryDecisionDetail(PermissionsBoundaryDecisionDetail var1);

        default public Builder permissionsBoundaryDecisionDetail(Consumer<PermissionsBoundaryDecisionDetail.Builder> permissionsBoundaryDecisionDetail) {
            return this.permissionsBoundaryDecisionDetail((PermissionsBoundaryDecisionDetail)((PermissionsBoundaryDecisionDetail.Builder)PermissionsBoundaryDecisionDetail.builder().applyMutation(permissionsBoundaryDecisionDetail)).build());
        }

        public Builder evalDecisionDetailsWithStrings(Map<String, String> var1);

        public Builder evalDecisionDetails(Map<String, PolicyEvaluationDecisionType> var1);

        public Builder resourceSpecificResults(Collection<ResourceSpecificResult> var1);

        public Builder resourceSpecificResults(ResourceSpecificResult ... var1);

        public Builder resourceSpecificResults(Consumer<ResourceSpecificResult.Builder> ... var1);
    }
}

