/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyRequest;
import software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyResponse;
import software.amazon.awssdk.services.iam.model.PolicyGroup;
import software.amazon.awssdk.services.iam.model.PolicyRole;
import software.amazon.awssdk.services.iam.model.PolicyUser;

public class ListEntitiesForPolicyIterable
implements SdkIterable<ListEntitiesForPolicyResponse> {
    private final IamClient client;
    private final ListEntitiesForPolicyRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEntitiesForPolicyIterable(IamClient client, ListEntitiesForPolicyRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEntitiesForPolicyResponseFetcher();
    }

    public Iterator<ListEntitiesForPolicyResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PolicyGroup> policyGroups() {
        Function<ListEntitiesForPolicyResponse, Iterator> getIterator = response -> {
            if (response != null && response.policyGroups() != null) {
                return response.policyGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    public final SdkIterable<PolicyUser> policyUsers() {
        Function<ListEntitiesForPolicyResponse, Iterator> getIterator = response -> {
            if (response != null && response.policyUsers() != null) {
                return response.policyUsers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    public final SdkIterable<PolicyRole> policyRoles() {
        Function<ListEntitiesForPolicyResponse, Iterator> getIterator = response -> {
            if (response != null && response.policyRoles() != null) {
                return response.policyRoles().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEntitiesForPolicyResponseFetcher
    implements SyncPageFetcher<ListEntitiesForPolicyResponse> {
        private ListEntitiesForPolicyResponseFetcher() {
        }

        public boolean hasNextPage(ListEntitiesForPolicyResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListEntitiesForPolicyResponse nextPage(ListEntitiesForPolicyResponse previousPage) {
            if (previousPage == null) {
                return ListEntitiesForPolicyIterable.this.client.listEntitiesForPolicy(ListEntitiesForPolicyIterable.this.firstRequest);
            }
            return ListEntitiesForPolicyIterable.this.client.listEntitiesForPolicy((ListEntitiesForPolicyRequest)((Object)ListEntitiesForPolicyIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

