/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.ListRoleTagsRequest;
import software.amazon.awssdk.services.iam.model.ListRoleTagsResponse;
import software.amazon.awssdk.services.iam.model.Tag;

public class ListRoleTagsPublisher
implements SdkPublisher<ListRoleTagsResponse> {
    private final IamAsyncClient client;
    private final ListRoleTagsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRoleTagsPublisher(IamAsyncClient client, ListRoleTagsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRoleTagsPublisher(IamAsyncClient client, ListRoleTagsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRoleTagsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRoleTagsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Tag> tags() {
        Function<ListRoleTagsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tags() != null) {
                return response.tags().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRoleTagsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRoleTagsResponseFetcher
    implements AsyncPageFetcher<ListRoleTagsResponse> {
        private ListRoleTagsResponseFetcher() {
        }

        public boolean hasNextPage(ListRoleTagsResponse previousPage) {
            return previousPage.isTruncated();
        }

        public CompletableFuture<ListRoleTagsResponse> nextPage(ListRoleTagsResponse previousPage) {
            if (previousPage == null) {
                return ListRoleTagsPublisher.this.client.listRoleTags(ListRoleTagsPublisher.this.firstRequest);
            }
            return ListRoleTagsPublisher.this.client.listRoleTags((ListRoleTagsRequest)((Object)ListRoleTagsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

