/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iam.model.CertificationMapTypeCopier;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMfaDeviceResponse
extends IamResponse
implements ToCopyableBuilder<Builder, GetMfaDeviceResponse> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserName").getter(GetMfaDeviceResponse.getter(GetMfaDeviceResponse::userName)).setter(GetMfaDeviceResponse.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> SERIAL_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SerialNumber").getter(GetMfaDeviceResponse.getter(GetMfaDeviceResponse::serialNumber)).setter(GetMfaDeviceResponse.setter(Builder::serialNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SerialNumber").build()}).build();
    private static final SdkField<Instant> ENABLE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EnableDate").getter(GetMfaDeviceResponse.getter(GetMfaDeviceResponse::enableDate)).setter(GetMfaDeviceResponse.setter(Builder::enableDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableDate").build()}).build();
    private static final SdkField<Map<String, String>> CERTIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Certifications").getter(GetMfaDeviceResponse.getter(GetMfaDeviceResponse::certifications)).setter(GetMfaDeviceResponse.setter(Builder::certifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certifications").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD, SERIAL_NUMBER_FIELD, ENABLE_DATE_FIELD, CERTIFICATIONS_FIELD));
    private final String userName;
    private final String serialNumber;
    private final Instant enableDate;
    private final Map<String, String> certifications;

    private GetMfaDeviceResponse(BuilderImpl builder) {
        super(builder);
        this.userName = builder.userName;
        this.serialNumber = builder.serialNumber;
        this.enableDate = builder.enableDate;
        this.certifications = builder.certifications;
    }

    public final String userName() {
        return this.userName;
    }

    public final String serialNumber() {
        return this.serialNumber;
    }

    public final Instant enableDate() {
        return this.enableDate;
    }

    public final boolean hasCertifications() {
        return this.certifications != null && !(this.certifications instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> certifications() {
        return this.certifications;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCertifications() ? this.certifications() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMfaDeviceResponse)) {
            return false;
        }
        GetMfaDeviceResponse other = (GetMfaDeviceResponse)((Object)obj);
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.serialNumber(), other.serialNumber()) && Objects.equals(this.enableDate(), other.enableDate()) && this.hasCertifications() == other.hasCertifications() && Objects.equals(this.certifications(), other.certifications());
    }

    public final String toString() {
        return ToString.builder((String)"GetMfaDeviceResponse").add("UserName", (Object)this.userName()).add("SerialNumber", (Object)this.serialNumber()).add("EnableDate", (Object)this.enableDate()).add("Certifications", this.hasCertifications() ? this.certifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "SerialNumber": {
                return Optional.ofNullable(clazz.cast(this.serialNumber()));
            }
            case "EnableDate": {
                return Optional.ofNullable(clazz.cast(this.enableDate()));
            }
            case "Certifications": {
                return Optional.ofNullable(clazz.cast(this.certifications()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMfaDeviceResponse, T> g) {
        return obj -> g.apply((GetMfaDeviceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private String userName;
        private String serialNumber;
        private Instant enableDate;
        private Map<String, String> certifications = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMfaDeviceResponse model) {
            super(model);
            this.userName(model.userName);
            this.serialNumber(model.serialNumber);
            this.enableDate(model.enableDate);
            this.certifications(model.certifications);
        }

        public final String getUserName() {
            return this.userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getSerialNumber() {
            return this.serialNumber;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final Instant getEnableDate() {
            return this.enableDate;
        }

        public final void setEnableDate(Instant enableDate) {
            this.enableDate = enableDate;
        }

        @Override
        public final Builder enableDate(Instant enableDate) {
            this.enableDate = enableDate;
            return this;
        }

        public final Map<String, String> getCertifications() {
            if (this.certifications instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.certifications;
        }

        public final void setCertifications(Map<String, String> certifications) {
            this.certifications = CertificationMapTypeCopier.copy(certifications);
        }

        @Override
        public final Builder certifications(Map<String, String> certifications) {
            this.certifications = CertificationMapTypeCopier.copy(certifications);
            return this;
        }

        @Override
        public GetMfaDeviceResponse build() {
            return new GetMfaDeviceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMfaDeviceResponse> {
        public Builder userName(String var1);

        public Builder serialNumber(String var1);

        public Builder enableDate(Instant var1);

        public Builder certifications(Map<String, String> var1);
    }
}

