/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SimulatePrincipalPolicyRequest extends IamRequest implements
        ToCopyableBuilder<SimulatePrincipalPolicyRequest.Builder, SimulatePrincipalPolicyRequest> {
    private static final SdkField<String> POLICY_SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicySourceArn").getter(getter(SimulatePrincipalPolicyRequest::policySourceArn))
            .setter(setter(Builder::policySourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicySourceArn").build()).build();

    private static final SdkField<List<String>> POLICY_INPUT_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PolicyInputList")
            .getter(getter(SimulatePrincipalPolicyRequest::policyInputList))
            .setter(setter(Builder::policyInputList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyInputList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PERMISSIONS_BOUNDARY_POLICY_INPUT_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PermissionsBoundaryPolicyInputList")
            .getter(getter(SimulatePrincipalPolicyRequest::permissionsBoundaryPolicyInputList))
            .setter(setter(Builder::permissionsBoundaryPolicyInputList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsBoundaryPolicyInputList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ACTION_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ActionNames")
            .getter(getter(SimulatePrincipalPolicyRequest::actionNames))
            .setter(setter(Builder::actionNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RESOURCE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceArns")
            .getter(getter(SimulatePrincipalPolicyRequest::resourceArns))
            .setter(setter(Builder::resourceArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourcePolicy").getter(getter(SimulatePrincipalPolicyRequest::resourcePolicy))
            .setter(setter(Builder::resourcePolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcePolicy").build()).build();

    private static final SdkField<String> RESOURCE_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceOwner").getter(getter(SimulatePrincipalPolicyRequest::resourceOwner))
            .setter(setter(Builder::resourceOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceOwner").build()).build();

    private static final SdkField<String> CALLER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CallerArn").getter(getter(SimulatePrincipalPolicyRequest::callerArn)).setter(setter(Builder::callerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallerArn").build()).build();

    private static final SdkField<List<ContextEntry>> CONTEXT_ENTRIES_FIELD = SdkField
            .<List<ContextEntry>> builder(MarshallingType.LIST)
            .memberName("ContextEntries")
            .getter(getter(SimulatePrincipalPolicyRequest::contextEntries))
            .setter(setter(Builder::contextEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextEntries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContextEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContextEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_HANDLING_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceHandlingOption").getter(getter(SimulatePrincipalPolicyRequest::resourceHandlingOption))
            .setter(setter(Builder::resourceHandlingOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceHandlingOption").build())
            .build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxItems").getter(getter(SimulatePrincipalPolicyRequest::maxItems)).setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(SimulatePrincipalPolicyRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_SOURCE_ARN_FIELD,
            POLICY_INPUT_LIST_FIELD, PERMISSIONS_BOUNDARY_POLICY_INPUT_LIST_FIELD, ACTION_NAMES_FIELD, RESOURCE_ARNS_FIELD,
            RESOURCE_POLICY_FIELD, RESOURCE_OWNER_FIELD, CALLER_ARN_FIELD, CONTEXT_ENTRIES_FIELD, RESOURCE_HANDLING_OPTION_FIELD,
            MAX_ITEMS_FIELD, MARKER_FIELD));

    private final String policySourceArn;

    private final List<String> policyInputList;

    private final List<String> permissionsBoundaryPolicyInputList;

    private final List<String> actionNames;

    private final List<String> resourceArns;

    private final String resourcePolicy;

    private final String resourceOwner;

    private final String callerArn;

    private final List<ContextEntry> contextEntries;

    private final String resourceHandlingOption;

    private final Integer maxItems;

    private final String marker;

    private SimulatePrincipalPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.policySourceArn = builder.policySourceArn;
        this.policyInputList = builder.policyInputList;
        this.permissionsBoundaryPolicyInputList = builder.permissionsBoundaryPolicyInputList;
        this.actionNames = builder.actionNames;
        this.resourceArns = builder.resourceArns;
        this.resourcePolicy = builder.resourcePolicy;
        this.resourceOwner = builder.resourceOwner;
        this.callerArn = builder.callerArn;
        this.contextEntries = builder.contextEntries;
        this.resourceHandlingOption = builder.resourceHandlingOption;
        this.maxItems = builder.maxItems;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a user, group, or role whose policies you want to include in the simulation. If
     * you specify a user, group, or role, the simulation includes all policies that are associated with that entity. If
     * you specify a user, the simulation also includes all policies that are attached to any groups the user belongs
     * to.
     * </p>
     * <p>
     * The maximum length of the policy document that you can pass in this operation, including whitespace, is listed
     * below. To view the maximum character counts of a managed policy with no whitespaces, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length"
     * >IAM and STS character quotas</a>.
     * </p>
     * <p>
     * For more information about ARNs, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a user, group, or role whose policies you want to include in the
     *         simulation. If you specify a user, group, or role, the simulation includes all policies that are
     *         associated with that entity. If you specify a user, the simulation also includes all policies that are
     *         attached to any groups the user belongs to.</p>
     *         <p>
     *         The maximum length of the policy document that you can pass in this operation, including whitespace, is
     *         listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length"
     *         >IAM and STS character quotas</a>.
     *         </p>
     *         <p>
     *         For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *         (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
     */
    public final String policySourceArn() {
        return policySourceArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the PolicyInputList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPolicyInputList() {
        return policyInputList != null && !(policyInputList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An optional list of additional policy documents to include in the simulation. Each document is specified as a
     * string containing the complete, valid JSON text of an IAM policy.
     * </p>
     * <p>
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of
     * characters consisting of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the ASCII
     * character range
     * </p>
     * </li>
     * <li>
     * <p>
     * The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>
     * )
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicyInputList} method.
     * </p>
     * 
     * @return An optional list of additional policy documents to include in the simulation. Each document is specified
     *         as a string containing the complete, valid JSON text of an IAM policy.</p>
     *         <p>
     *         The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a
     *         string of characters consisting of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of
     *         the ASCII character range
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The printable characters in the Basic Latin and Latin-1 Supplement character set (through
     *         <code>\u00FF</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (
     *         <code>\u000D</code>)
     *         </p>
     *         </li>
     */
    public final List<String> policyInputList() {
        return policyInputList;
    }

    /**
     * For responses, this returns true if the service returned a value for the PermissionsBoundaryPolicyInputList
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasPermissionsBoundaryPolicyInputList() {
        return permissionsBoundaryPolicyInputList != null
                && !(permissionsBoundaryPolicyInputList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IAM permissions boundary policy to simulate. The permissions boundary sets the maximum permissions that the
     * entity can have. You can input only one permissions boundary when you pass a policy to this operation. An IAM
     * entity can only have one permissions boundary in effect at a time. For example, if a permissions boundary is
     * attached to an entity and you pass in a different permissions boundary policy using this parameter, then the new
     * permissions boundary policy is used for the simulation. For more information about permissions boundaries, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries
     * for IAM entities</a> in the <i>IAM User Guide</i>. The policy input is specified as a string containing the
     * complete, valid JSON text of a permissions boundary policy.
     * </p>
     * <p>
     * The maximum length of the policy document that you can pass in this operation, including whitespace, is listed
     * below. To view the maximum character counts of a managed policy with no whitespaces, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length"
     * >IAM and STS character quotas</a>.
     * </p>
     * <p>
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of
     * characters consisting of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the ASCII
     * character range
     * </p>
     * </li>
     * <li>
     * <p>
     * The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>
     * )
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissionsBoundaryPolicyInputList}
     * method.
     * </p>
     * 
     * @return The IAM permissions boundary policy to simulate. The permissions boundary sets the maximum permissions
     *         that the entity can have. You can input only one permissions boundary when you pass a policy to this
     *         operation. An IAM entity can only have one permissions boundary in effect at a time. For example, if a
     *         permissions boundary is attached to an entity and you pass in a different permissions boundary policy
     *         using this parameter, then the new permissions boundary policy is used for the simulation. For more
     *         information about permissions boundaries, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions
     *         boundaries for IAM entities</a> in the <i>IAM User Guide</i>. The policy input is specified as a string
     *         containing the complete, valid JSON text of a permissions boundary policy.</p>
     *         <p>
     *         The maximum length of the policy document that you can pass in this operation, including whitespace, is
     *         listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length"
     *         >IAM and STS character quotas</a>.
     *         </p>
     *         <p>
     *         The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a
     *         string of characters consisting of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of
     *         the ASCII character range
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The printable characters in the Basic Latin and Latin-1 Supplement character set (through
     *         <code>\u00FF</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (
     *         <code>\u000D</code>)
     *         </p>
     *         </li>
     */
    public final List<String> permissionsBoundaryPolicyInputList() {
        return permissionsBoundaryPolicyInputList;
    }

    /**
     * For responses, this returns true if the service returned a value for the ActionNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasActionNames() {
        return actionNames != null && !(actionNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of names of API operations to evaluate in the simulation. Each operation is evaluated for each resource.
     * Each operation must include the service identifier, such as <code>iam:CreateUser</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActionNames} method.
     * </p>
     * 
     * @return A list of names of API operations to evaluate in the simulation. Each operation is evaluated for each
     *         resource. Each operation must include the service identifier, such as <code>iam:CreateUser</code>.
     */
    public final List<String> actionNames() {
        return actionNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceArns() {
        return resourceArns != null && !(resourceArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of ARNs of Amazon Web Services resources to include in the simulation. If this parameter is not provided,
     * then the value defaults to <code>*</code> (all resources). Each API in the <code>ActionNames</code> parameter is
     * evaluated for each resource in this list. The simulation determines the access result (allowed or denied) of each
     * combination and reports it in the response. You can simulate resources that don't exist in your account.
     * </p>
     * <p>
     * The simulation does not automatically retrieve policies for the specified resources. If you want to include a
     * resource policy in the simulation, then you must include the policy as a string in the
     * <code>ResourcePolicy</code> parameter.
     * </p>
     * <p>
     * For more information about ARNs, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * <note>
     * <p>
     * Simulation of resource-based policies isn't supported for IAM roles.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceArns} method.
     * </p>
     * 
     * @return A list of ARNs of Amazon Web Services resources to include in the simulation. If this parameter is not
     *         provided, then the value defaults to <code>*</code> (all resources). Each API in the
     *         <code>ActionNames</code> parameter is evaluated for each resource in this list. The simulation determines
     *         the access result (allowed or denied) of each combination and reports it in the response. You can
     *         simulate resources that don't exist in your account.</p>
     *         <p>
     *         The simulation does not automatically retrieve policies for the specified resources. If you want to
     *         include a resource policy in the simulation, then you must include the policy as a string in the
     *         <code>ResourcePolicy</code> parameter.
     *         </p>
     *         <p>
     *         For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *         (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
     *         </p>
     *         <note>
     *         <p>
     *         Simulation of resource-based policies isn't supported for IAM roles.
     *         </p>
     */
    public final List<String> resourceArns() {
        return resourceArns;
    }

    /**
     * <p>
     * A resource-based policy to include in the simulation provided as a string. Each resource in the simulation is
     * treated as if it had this policy attached. You can include only one resource-based policy in a simulation.
     * </p>
     * <p>
     * The maximum length of the policy document that you can pass in this operation, including whitespace, is listed
     * below. To view the maximum character counts of a managed policy with no whitespaces, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length"
     * >IAM and STS character quotas</a>.
     * </p>
     * <p>
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of
     * characters consisting of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the ASCII
     * character range
     * </p>
     * </li>
     * <li>
     * <p>
     * The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>
     * )
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Simulation of resource-based policies isn't supported for IAM roles.
     * </p>
     * </note>
     * 
     * @return A resource-based policy to include in the simulation provided as a string. Each resource in the
     *         simulation is treated as if it had this policy attached. You can include only one resource-based policy
     *         in a simulation.</p>
     *         <p>
     *         The maximum length of the policy document that you can pass in this operation, including whitespace, is
     *         listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length"
     *         >IAM and STS character quotas</a>.
     *         </p>
     *         <p>
     *         The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a
     *         string of characters consisting of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of
     *         the ASCII character range
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The printable characters in the Basic Latin and Latin-1 Supplement character set (through
     *         <code>\u00FF</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (
     *         <code>\u000D</code>)
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         Simulation of resource-based policies isn't supported for IAM roles.
     *         </p>
     */
    public final String resourcePolicy() {
        return resourcePolicy;
    }

    /**
     * <p>
     * An Amazon Web Services account ID that specifies the owner of any simulated resource that does not identify its
     * owner in the resource ARN. Examples of resource ARNs include an S3 bucket or object. If
     * <code>ResourceOwner</code> is specified, it is also used as the account owner of any <code>ResourcePolicy</code>
     * included in the simulation. If the <code>ResourceOwner</code> parameter is not specified, then the owner of the
     * resources and the resource policy defaults to the account of the identity provided in <code>CallerArn</code>.
     * This parameter is required only if you specify a resource-based policy and account that owns the resource is
     * different from the account that owns the simulated calling user <code>CallerArn</code>.
     * </p>
     * 
     * @return An Amazon Web Services account ID that specifies the owner of any simulated resource that does not
     *         identify its owner in the resource ARN. Examples of resource ARNs include an S3 bucket or object. If
     *         <code>ResourceOwner</code> is specified, it is also used as the account owner of any
     *         <code>ResourcePolicy</code> included in the simulation. If the <code>ResourceOwner</code> parameter is
     *         not specified, then the owner of the resources and the resource policy defaults to the account of the
     *         identity provided in <code>CallerArn</code>. This parameter is required only if you specify a
     *         resource-based policy and account that owns the resource is different from the account that owns the
     *         simulated calling user <code>CallerArn</code>.
     */
    public final String resourceOwner() {
        return resourceOwner;
    }

    /**
     * <p>
     * The ARN of the IAM user that you want to specify as the simulated caller of the API operations. If you do not
     * specify a <code>CallerArn</code>, it defaults to the ARN of the user that you specify in
     * <code>PolicySourceArn</code>, if you specified a user. If you include both a <code>PolicySourceArn</code> (for
     * example, <code>arn:aws:iam::123456789012:user/David</code>) and a <code>CallerArn</code> (for example,
     * <code>arn:aws:iam::123456789012:user/Bob</code>), the result is that you simulate calling the API operations as
     * Bob, as if Bob had David's policies.
     * </p>
     * <p>
     * You can specify only the ARN of an IAM user. You cannot specify the ARN of an assumed role, federated user, or a
     * service principal.
     * </p>
     * <p>
     * <code>CallerArn</code> is required if you include a <code>ResourcePolicy</code> and the
     * <code>PolicySourceArn</code> is not the ARN for an IAM user. This is required so that the resource-based policy's
     * <code>Principal</code> element has a value to use in evaluating the policy.
     * </p>
     * <p>
     * For more information about ARNs, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * 
     * @return The ARN of the IAM user that you want to specify as the simulated caller of the API operations. If you do
     *         not specify a <code>CallerArn</code>, it defaults to the ARN of the user that you specify in
     *         <code>PolicySourceArn</code>, if you specified a user. If you include both a <code>PolicySourceArn</code>
     *         (for example, <code>arn:aws:iam::123456789012:user/David</code>) and a <code>CallerArn</code> (for
     *         example, <code>arn:aws:iam::123456789012:user/Bob</code>), the result is that you simulate calling the
     *         API operations as Bob, as if Bob had David's policies.</p>
     *         <p>
     *         You can specify only the ARN of an IAM user. You cannot specify the ARN of an assumed role, federated
     *         user, or a service principal.
     *         </p>
     *         <p>
     *         <code>CallerArn</code> is required if you include a <code>ResourcePolicy</code> and the
     *         <code>PolicySourceArn</code> is not the ARN for an IAM user. This is required so that the resource-based
     *         policy's <code>Principal</code> element has a value to use in evaluating the policy.
     *         </p>
     *         <p>
     *         For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *         (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
     */
    public final String callerArn() {
        return callerArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContextEntries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasContextEntries() {
        return contextEntries != null && !(contextEntries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of context keys and corresponding values for the simulation to use. Whenever a context key is evaluated in
     * one of the simulated IAM permissions policies, the corresponding value is supplied.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContextEntries} method.
     * </p>
     * 
     * @return A list of context keys and corresponding values for the simulation to use. Whenever a context key is
     *         evaluated in one of the simulated IAM permissions policies, the corresponding value is supplied.
     */
    public final List<ContextEntry> contextEntries() {
        return contextEntries;
    }

    /**
     * <p>
     * Specifies the type of simulation to run. Different API operations that support resource-based policies require
     * different combinations of resources. By specifying the type of simulation to run, you enable the policy simulator
     * to enforce the presence of the required resources to ensure reliable simulation results. If your simulation does
     * not match one of the following scenarios, then you can omit this parameter. The following list shows each of the
     * supported scenario values and the resources that you must define to run the simulation.
     * </p>
     * <p>
     * Each of the Amazon EC2 scenarios requires that you specify instance, image, and security group resources. If your
     * scenario includes an EBS volume, then you must specify that volume as a resource. If the Amazon EC2 scenario
     * includes VPC, then you must supply the network interface resource. If it includes an IP subnet, then you must
     * specify the subnet resource. For more information on the Amazon EC2 scenario options, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported platforms</a>
     * in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>EC2-VPC-InstanceStore</b>
     * </p>
     * <p>
     * instance, image, security group, network interface
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>EC2-VPC-InstanceStore-Subnet</b>
     * </p>
     * <p>
     * instance, image, security group, network interface, subnet
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>EC2-VPC-EBS</b>
     * </p>
     * <p>
     * instance, image, security group, network interface, volume
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>EC2-VPC-EBS-Subnet</b>
     * </p>
     * <p>
     * instance, image, security group, network interface, subnet, volume
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies the type of simulation to run. Different API operations that support resource-based policies
     *         require different combinations of resources. By specifying the type of simulation to run, you enable the
     *         policy simulator to enforce the presence of the required resources to ensure reliable simulation results.
     *         If your simulation does not match one of the following scenarios, then you can omit this parameter. The
     *         following list shows each of the supported scenario values and the resources that you must define to run
     *         the simulation.</p>
     *         <p>
     *         Each of the Amazon EC2 scenarios requires that you specify instance, image, and security group resources.
     *         If your scenario includes an EBS volume, then you must specify that volume as a resource. If the Amazon
     *         EC2 scenario includes VPC, then you must supply the network interface resource. If it includes an IP
     *         subnet, then you must specify the subnet resource. For more information on the Amazon EC2 scenario
     *         options, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported
     *         platforms</a> in the <i>Amazon EC2 User Guide</i>.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>EC2-VPC-InstanceStore</b>
     *         </p>
     *         <p>
     *         instance, image, security group, network interface
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>EC2-VPC-InstanceStore-Subnet</b>
     *         </p>
     *         <p>
     *         instance, image, security group, network interface, subnet
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>EC2-VPC-EBS</b>
     *         </p>
     *         <p>
     *         instance, image, security group, network interface, volume
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>EC2-VPC-EBS-Subnet</b>
     *         </p>
     *         <p>
     *         instance, image, security group, network interface, subnet, volume
     *         </p>
     *         </li>
     */
    public final String resourceHandlingOption() {
        return resourceHandlingOption;
    }

    /**
     * <p>
     * Use this only when paginating results to indicate the maximum number of items you want in the response. If
     * additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is
     * <code>true</code>.
     * </p>
     * <p>
     * If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer
     * results, even when there are more results available. In that case, the <code>IsTruncated</code> response element
     * returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells
     * the service where to continue from.
     * </p>
     * 
     * @return Use this only when paginating results to indicate the maximum number of items you want in the response.
     *         If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element
     *         is <code>true</code>.</p>
     *         <p>
     *         If you do not include this parameter, the number of items defaults to 100. Note that IAM might return
     *         fewer results, even when there are more results available. In that case, the <code>IsTruncated</code>
     *         response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the
     *         subsequent call that tells the service where to continue from.
     */
    public final Integer maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * Use this parameter only when paginating results and only after you receive a response indicating that the results
     * are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to
     * indicate where the next call should start.
     * </p>
     * 
     * @return Use this parameter only when paginating results and only after you receive a response indicating that the
     *         results are truncated. Set it to the value of the <code>Marker</code> element in the response that you
     *         received to indicate where the next call should start.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policySourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicyInputList() ? policyInputList() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasPermissionsBoundaryPolicyInputList() ? permissionsBoundaryPolicyInputList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasActionNames() ? actionNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceArns() ? resourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourcePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(resourceOwner());
        hashCode = 31 * hashCode + Objects.hashCode(callerArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasContextEntries() ? contextEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourceHandlingOption());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimulatePrincipalPolicyRequest)) {
            return false;
        }
        SimulatePrincipalPolicyRequest other = (SimulatePrincipalPolicyRequest) obj;
        return Objects.equals(policySourceArn(), other.policySourceArn()) && hasPolicyInputList() == other.hasPolicyInputList()
                && Objects.equals(policyInputList(), other.policyInputList())
                && hasPermissionsBoundaryPolicyInputList() == other.hasPermissionsBoundaryPolicyInputList()
                && Objects.equals(permissionsBoundaryPolicyInputList(), other.permissionsBoundaryPolicyInputList())
                && hasActionNames() == other.hasActionNames() && Objects.equals(actionNames(), other.actionNames())
                && hasResourceArns() == other.hasResourceArns() && Objects.equals(resourceArns(), other.resourceArns())
                && Objects.equals(resourcePolicy(), other.resourcePolicy())
                && Objects.equals(resourceOwner(), other.resourceOwner()) && Objects.equals(callerArn(), other.callerArn())
                && hasContextEntries() == other.hasContextEntries() && Objects.equals(contextEntries(), other.contextEntries())
                && Objects.equals(resourceHandlingOption(), other.resourceHandlingOption())
                && Objects.equals(maxItems(), other.maxItems()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("SimulatePrincipalPolicyRequest")
                .add("PolicySourceArn", policySourceArn())
                .add("PolicyInputList", hasPolicyInputList() ? policyInputList() : null)
                .add("PermissionsBoundaryPolicyInputList",
                        hasPermissionsBoundaryPolicyInputList() ? permissionsBoundaryPolicyInputList() : null)
                .add("ActionNames", hasActionNames() ? actionNames() : null)
                .add("ResourceArns", hasResourceArns() ? resourceArns() : null).add("ResourcePolicy", resourcePolicy())
                .add("ResourceOwner", resourceOwner()).add("CallerArn", callerArn())
                .add("ContextEntries", hasContextEntries() ? contextEntries() : null)
                .add("ResourceHandlingOption", resourceHandlingOption()).add("MaxItems", maxItems()).add("Marker", marker())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicySourceArn":
            return Optional.ofNullable(clazz.cast(policySourceArn()));
        case "PolicyInputList":
            return Optional.ofNullable(clazz.cast(policyInputList()));
        case "PermissionsBoundaryPolicyInputList":
            return Optional.ofNullable(clazz.cast(permissionsBoundaryPolicyInputList()));
        case "ActionNames":
            return Optional.ofNullable(clazz.cast(actionNames()));
        case "ResourceArns":
            return Optional.ofNullable(clazz.cast(resourceArns()));
        case "ResourcePolicy":
            return Optional.ofNullable(clazz.cast(resourcePolicy()));
        case "ResourceOwner":
            return Optional.ofNullable(clazz.cast(resourceOwner()));
        case "CallerArn":
            return Optional.ofNullable(clazz.cast(callerArn()));
        case "ContextEntries":
            return Optional.ofNullable(clazz.cast(contextEntries()));
        case "ResourceHandlingOption":
            return Optional.ofNullable(clazz.cast(resourceHandlingOption()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SimulatePrincipalPolicyRequest, T> g) {
        return obj -> g.apply((SimulatePrincipalPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamRequest.Builder, SdkPojo, CopyableBuilder<Builder, SimulatePrincipalPolicyRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of a user, group, or role whose policies you want to include in the
         * simulation. If you specify a user, group, or role, the simulation includes all policies that are associated
         * with that entity. If you specify a user, the simulation also includes all policies that are attached to any
         * groups the user belongs to.
         * </p>
         * <p>
         * The maximum length of the policy document that you can pass in this operation, including whitespace, is
         * listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href=
         * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length"
         * >IAM and STS character quotas</a>.
         * </p>
         * <p>
         * For more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param policySourceArn
         *        The Amazon Resource Name (ARN) of a user, group, or role whose policies you want to include in the
         *        simulation. If you specify a user, group, or role, the simulation includes all policies that are
         *        associated with that entity. If you specify a user, the simulation also includes all policies that are
         *        attached to any groups the user belongs to.</p>
         *        <p>
         *        The maximum length of the policy document that you can pass in this operation, including whitespace,
         *        is listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a
         *        href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length"
         *        >IAM and STS character quotas</a>.
         *        </p>
         *        <p>
         *        For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policySourceArn(String policySourceArn);

        /**
         * <p>
         * An optional list of additional policy documents to include in the simulation. Each document is specified as a
         * string containing the complete, valid JSON text of an IAM policy.
         * </p>
         * <p>
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string
         * of characters consisting of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the
         * ASCII character range
         * </p>
         * </li>
         * <li>
         * <p>
         * The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>
         * )
         * </p>
         * </li>
         * <li>
         * <p>
         * The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (
         * <code>\u000D</code>)
         * </p>
         * </li>
         * </ul>
         * 
         * @param policyInputList
         *        An optional list of additional policy documents to include in the simulation. Each document is
         *        specified as a string containing the complete, valid JSON text of an IAM policy.</p>
         *        <p>
         *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a
         *        string of characters consisting of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end
         *        of the ASCII character range
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The printable characters in the Basic Latin and Latin-1 Supplement character set (through
         *        <code>\u00FF</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return
         *        (<code>\u000D</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyInputList(Collection<String> policyInputList);

        /**
         * <p>
         * An optional list of additional policy documents to include in the simulation. Each document is specified as a
         * string containing the complete, valid JSON text of an IAM policy.
         * </p>
         * <p>
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string
         * of characters consisting of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the
         * ASCII character range
         * </p>
         * </li>
         * <li>
         * <p>
         * The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>
         * )
         * </p>
         * </li>
         * <li>
         * <p>
         * The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (
         * <code>\u000D</code>)
         * </p>
         * </li>
         * </ul>
         * 
         * @param policyInputList
         *        An optional list of additional policy documents to include in the simulation. Each document is
         *        specified as a string containing the complete, valid JSON text of an IAM policy.</p>
         *        <p>
         *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a
         *        string of characters consisting of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end
         *        of the ASCII character range
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The printable characters in the Basic Latin and Latin-1 Supplement character set (through
         *        <code>\u00FF</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return
         *        (<code>\u000D</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyInputList(String... policyInputList);

        /**
         * <p>
         * The IAM permissions boundary policy to simulate. The permissions boundary sets the maximum permissions that
         * the entity can have. You can input only one permissions boundary when you pass a policy to this operation. An
         * IAM entity can only have one permissions boundary in effect at a time. For example, if a permissions boundary
         * is attached to an entity and you pass in a different permissions boundary policy using this parameter, then
         * the new permissions boundary policy is used for the simulation. For more information about permissions
         * boundaries, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions
         * boundaries for IAM entities</a> in the <i>IAM User Guide</i>. The policy input is specified as a string
         * containing the complete, valid JSON text of a permissions boundary policy.
         * </p>
         * <p>
         * The maximum length of the policy document that you can pass in this operation, including whitespace, is
         * listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href=
         * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length"
         * >IAM and STS character quotas</a>.
         * </p>
         * <p>
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string
         * of characters consisting of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the
         * ASCII character range
         * </p>
         * </li>
         * <li>
         * <p>
         * The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>
         * )
         * </p>
         * </li>
         * <li>
         * <p>
         * The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (
         * <code>\u000D</code>)
         * </p>
         * </li>
         * </ul>
         * 
         * @param permissionsBoundaryPolicyInputList
         *        The IAM permissions boundary policy to simulate. The permissions boundary sets the maximum permissions
         *        that the entity can have. You can input only one permissions boundary when you pass a policy to this
         *        operation. An IAM entity can only have one permissions boundary in effect at a time. For example, if a
         *        permissions boundary is attached to an entity and you pass in a different permissions boundary policy
         *        using this parameter, then the new permissions boundary policy is used for the simulation. For more
         *        information about permissions boundaries, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions
         *        boundaries for IAM entities</a> in the <i>IAM User Guide</i>. The policy input is specified as a
         *        string containing the complete, valid JSON text of a permissions boundary policy.</p>
         *        <p>
         *        The maximum length of the policy document that you can pass in this operation, including whitespace,
         *        is listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a
         *        href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length"
         *        >IAM and STS character quotas</a>.
         *        </p>
         *        <p>
         *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a
         *        string of characters consisting of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end
         *        of the ASCII character range
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The printable characters in the Basic Latin and Latin-1 Supplement character set (through
         *        <code>\u00FF</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return
         *        (<code>\u000D</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsBoundaryPolicyInputList(Collection<String> permissionsBoundaryPolicyInputList);

        /**
         * <p>
         * The IAM permissions boundary policy to simulate. The permissions boundary sets the maximum permissions that
         * the entity can have. You can input only one permissions boundary when you pass a policy to this operation. An
         * IAM entity can only have one permissions boundary in effect at a time. For example, if a permissions boundary
         * is attached to an entity and you pass in a different permissions boundary policy using this parameter, then
         * the new permissions boundary policy is used for the simulation. For more information about permissions
         * boundaries, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions
         * boundaries for IAM entities</a> in the <i>IAM User Guide</i>. The policy input is specified as a string
         * containing the complete, valid JSON text of a permissions boundary policy.
         * </p>
         * <p>
         * The maximum length of the policy document that you can pass in this operation, including whitespace, is
         * listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href=
         * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length"
         * >IAM and STS character quotas</a>.
         * </p>
         * <p>
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string
         * of characters consisting of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the
         * ASCII character range
         * </p>
         * </li>
         * <li>
         * <p>
         * The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>
         * )
         * </p>
         * </li>
         * <li>
         * <p>
         * The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (
         * <code>\u000D</code>)
         * </p>
         * </li>
         * </ul>
         * 
         * @param permissionsBoundaryPolicyInputList
         *        The IAM permissions boundary policy to simulate. The permissions boundary sets the maximum permissions
         *        that the entity can have. You can input only one permissions boundary when you pass a policy to this
         *        operation. An IAM entity can only have one permissions boundary in effect at a time. For example, if a
         *        permissions boundary is attached to an entity and you pass in a different permissions boundary policy
         *        using this parameter, then the new permissions boundary policy is used for the simulation. For more
         *        information about permissions boundaries, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions
         *        boundaries for IAM entities</a> in the <i>IAM User Guide</i>. The policy input is specified as a
         *        string containing the complete, valid JSON text of a permissions boundary policy.</p>
         *        <p>
         *        The maximum length of the policy document that you can pass in this operation, including whitespace,
         *        is listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a
         *        href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length"
         *        >IAM and STS character quotas</a>.
         *        </p>
         *        <p>
         *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a
         *        string of characters consisting of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end
         *        of the ASCII character range
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The printable characters in the Basic Latin and Latin-1 Supplement character set (through
         *        <code>\u00FF</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return
         *        (<code>\u000D</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsBoundaryPolicyInputList(String... permissionsBoundaryPolicyInputList);

        /**
         * <p>
         * A list of names of API operations to evaluate in the simulation. Each operation is evaluated for each
         * resource. Each operation must include the service identifier, such as <code>iam:CreateUser</code>.
         * </p>
         * 
         * @param actionNames
         *        A list of names of API operations to evaluate in the simulation. Each operation is evaluated for each
         *        resource. Each operation must include the service identifier, such as <code>iam:CreateUser</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionNames(Collection<String> actionNames);

        /**
         * <p>
         * A list of names of API operations to evaluate in the simulation. Each operation is evaluated for each
         * resource. Each operation must include the service identifier, such as <code>iam:CreateUser</code>.
         * </p>
         * 
         * @param actionNames
         *        A list of names of API operations to evaluate in the simulation. Each operation is evaluated for each
         *        resource. Each operation must include the service identifier, such as <code>iam:CreateUser</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionNames(String... actionNames);

        /**
         * <p>
         * A list of ARNs of Amazon Web Services resources to include in the simulation. If this parameter is not
         * provided, then the value defaults to <code>*</code> (all resources). Each API in the <code>ActionNames</code>
         * parameter is evaluated for each resource in this list. The simulation determines the access result (allowed
         * or denied) of each combination and reports it in the response. You can simulate resources that don't exist in
         * your account.
         * </p>
         * <p>
         * The simulation does not automatically retrieve policies for the specified resources. If you want to include a
         * resource policy in the simulation, then you must include the policy as a string in the
         * <code>ResourcePolicy</code> parameter.
         * </p>
         * <p>
         * For more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * <note>
         * <p>
         * Simulation of resource-based policies isn't supported for IAM roles.
         * </p>
         * </note>
         * 
         * @param resourceArns
         *        A list of ARNs of Amazon Web Services resources to include in the simulation. If this parameter is not
         *        provided, then the value defaults to <code>*</code> (all resources). Each API in the
         *        <code>ActionNames</code> parameter is evaluated for each resource in this list. The simulation
         *        determines the access result (allowed or denied) of each combination and reports it in the response.
         *        You can simulate resources that don't exist in your account.</p>
         *        <p>
         *        The simulation does not automatically retrieve policies for the specified resources. If you want to
         *        include a resource policy in the simulation, then you must include the policy as a string in the
         *        <code>ResourcePolicy</code> parameter.
         *        </p>
         *        <p>
         *        For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
         *        </p>
         *        <note>
         *        <p>
         *        Simulation of resource-based policies isn't supported for IAM roles.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArns(Collection<String> resourceArns);

        /**
         * <p>
         * A list of ARNs of Amazon Web Services resources to include in the simulation. If this parameter is not
         * provided, then the value defaults to <code>*</code> (all resources). Each API in the <code>ActionNames</code>
         * parameter is evaluated for each resource in this list. The simulation determines the access result (allowed
         * or denied) of each combination and reports it in the response. You can simulate resources that don't exist in
         * your account.
         * </p>
         * <p>
         * The simulation does not automatically retrieve policies for the specified resources. If you want to include a
         * resource policy in the simulation, then you must include the policy as a string in the
         * <code>ResourcePolicy</code> parameter.
         * </p>
         * <p>
         * For more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * <note>
         * <p>
         * Simulation of resource-based policies isn't supported for IAM roles.
         * </p>
         * </note>
         * 
         * @param resourceArns
         *        A list of ARNs of Amazon Web Services resources to include in the simulation. If this parameter is not
         *        provided, then the value defaults to <code>*</code> (all resources). Each API in the
         *        <code>ActionNames</code> parameter is evaluated for each resource in this list. The simulation
         *        determines the access result (allowed or denied) of each combination and reports it in the response.
         *        You can simulate resources that don't exist in your account.</p>
         *        <p>
         *        The simulation does not automatically retrieve policies for the specified resources. If you want to
         *        include a resource policy in the simulation, then you must include the policy as a string in the
         *        <code>ResourcePolicy</code> parameter.
         *        </p>
         *        <p>
         *        For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
         *        </p>
         *        <note>
         *        <p>
         *        Simulation of resource-based policies isn't supported for IAM roles.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArns(String... resourceArns);

        /**
         * <p>
         * A resource-based policy to include in the simulation provided as a string. Each resource in the simulation is
         * treated as if it had this policy attached. You can include only one resource-based policy in a simulation.
         * </p>
         * <p>
         * The maximum length of the policy document that you can pass in this operation, including whitespace, is
         * listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href=
         * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length"
         * >IAM and STS character quotas</a>.
         * </p>
         * <p>
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string
         * of characters consisting of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the
         * ASCII character range
         * </p>
         * </li>
         * <li>
         * <p>
         * The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>
         * )
         * </p>
         * </li>
         * <li>
         * <p>
         * The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (
         * <code>\u000D</code>)
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * Simulation of resource-based policies isn't supported for IAM roles.
         * </p>
         * </note>
         * 
         * @param resourcePolicy
         *        A resource-based policy to include in the simulation provided as a string. Each resource in the
         *        simulation is treated as if it had this policy attached. You can include only one resource-based
         *        policy in a simulation.</p>
         *        <p>
         *        The maximum length of the policy document that you can pass in this operation, including whitespace,
         *        is listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a
         *        href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length"
         *        >IAM and STS character quotas</a>.
         *        </p>
         *        <p>
         *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a
         *        string of characters consisting of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end
         *        of the ASCII character range
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The printable characters in the Basic Latin and Latin-1 Supplement character set (through
         *        <code>\u00FF</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return
         *        (<code>\u000D</code>)
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        Simulation of resource-based policies isn't supported for IAM roles.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcePolicy(String resourcePolicy);

        /**
         * <p>
         * An Amazon Web Services account ID that specifies the owner of any simulated resource that does not identify
         * its owner in the resource ARN. Examples of resource ARNs include an S3 bucket or object. If
         * <code>ResourceOwner</code> is specified, it is also used as the account owner of any
         * <code>ResourcePolicy</code> included in the simulation. If the <code>ResourceOwner</code> parameter is not
         * specified, then the owner of the resources and the resource policy defaults to the account of the identity
         * provided in <code>CallerArn</code>. This parameter is required only if you specify a resource-based policy
         * and account that owns the resource is different from the account that owns the simulated calling user
         * <code>CallerArn</code>.
         * </p>
         * 
         * @param resourceOwner
         *        An Amazon Web Services account ID that specifies the owner of any simulated resource that does not
         *        identify its owner in the resource ARN. Examples of resource ARNs include an S3 bucket or object. If
         *        <code>ResourceOwner</code> is specified, it is also used as the account owner of any
         *        <code>ResourcePolicy</code> included in the simulation. If the <code>ResourceOwner</code> parameter is
         *        not specified, then the owner of the resources and the resource policy defaults to the account of the
         *        identity provided in <code>CallerArn</code>. This parameter is required only if you specify a
         *        resource-based policy and account that owns the resource is different from the account that owns the
         *        simulated calling user <code>CallerArn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceOwner(String resourceOwner);

        /**
         * <p>
         * The ARN of the IAM user that you want to specify as the simulated caller of the API operations. If you do not
         * specify a <code>CallerArn</code>, it defaults to the ARN of the user that you specify in
         * <code>PolicySourceArn</code>, if you specified a user. If you include both a <code>PolicySourceArn</code>
         * (for example, <code>arn:aws:iam::123456789012:user/David</code>) and a <code>CallerArn</code> (for example,
         * <code>arn:aws:iam::123456789012:user/Bob</code>), the result is that you simulate calling the API operations
         * as Bob, as if Bob had David's policies.
         * </p>
         * <p>
         * You can specify only the ARN of an IAM user. You cannot specify the ARN of an assumed role, federated user,
         * or a service principal.
         * </p>
         * <p>
         * <code>CallerArn</code> is required if you include a <code>ResourcePolicy</code> and the
         * <code>PolicySourceArn</code> is not the ARN for an IAM user. This is required so that the resource-based
         * policy's <code>Principal</code> element has a value to use in evaluating the policy.
         * </p>
         * <p>
         * For more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param callerArn
         *        The ARN of the IAM user that you want to specify as the simulated caller of the API operations. If you
         *        do not specify a <code>CallerArn</code>, it defaults to the ARN of the user that you specify in
         *        <code>PolicySourceArn</code>, if you specified a user. If you include both a
         *        <code>PolicySourceArn</code> (for example, <code>arn:aws:iam::123456789012:user/David</code>) and a
         *        <code>CallerArn</code> (for example, <code>arn:aws:iam::123456789012:user/Bob</code>), the result is
         *        that you simulate calling the API operations as Bob, as if Bob had David's policies.</p>
         *        <p>
         *        You can specify only the ARN of an IAM user. You cannot specify the ARN of an assumed role, federated
         *        user, or a service principal.
         *        </p>
         *        <p>
         *        <code>CallerArn</code> is required if you include a <code>ResourcePolicy</code> and the
         *        <code>PolicySourceArn</code> is not the ARN for an IAM user. This is required so that the
         *        resource-based policy's <code>Principal</code> element has a value to use in evaluating the policy.
         *        </p>
         *        <p>
         *        For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callerArn(String callerArn);

        /**
         * <p>
         * A list of context keys and corresponding values for the simulation to use. Whenever a context key is
         * evaluated in one of the simulated IAM permissions policies, the corresponding value is supplied.
         * </p>
         * 
         * @param contextEntries
         *        A list of context keys and corresponding values for the simulation to use. Whenever a context key is
         *        evaluated in one of the simulated IAM permissions policies, the corresponding value is supplied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextEntries(Collection<ContextEntry> contextEntries);

        /**
         * <p>
         * A list of context keys and corresponding values for the simulation to use. Whenever a context key is
         * evaluated in one of the simulated IAM permissions policies, the corresponding value is supplied.
         * </p>
         * 
         * @param contextEntries
         *        A list of context keys and corresponding values for the simulation to use. Whenever a context key is
         *        evaluated in one of the simulated IAM permissions policies, the corresponding value is supplied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextEntries(ContextEntry... contextEntries);

        /**
         * <p>
         * A list of context keys and corresponding values for the simulation to use. Whenever a context key is
         * evaluated in one of the simulated IAM permissions policies, the corresponding value is supplied.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iam.model.ContextEntry.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iam.model.ContextEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iam.model.ContextEntry.Builder#build()} is called immediately and its
         * result is passed to {@link #contextEntries(List<ContextEntry>)}.
         * 
         * @param contextEntries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iam.model.ContextEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contextEntries(java.util.Collection<ContextEntry>)
         */
        Builder contextEntries(Consumer<ContextEntry.Builder>... contextEntries);

        /**
         * <p>
         * Specifies the type of simulation to run. Different API operations that support resource-based policies
         * require different combinations of resources. By specifying the type of simulation to run, you enable the
         * policy simulator to enforce the presence of the required resources to ensure reliable simulation results. If
         * your simulation does not match one of the following scenarios, then you can omit this parameter. The
         * following list shows each of the supported scenario values and the resources that you must define to run the
         * simulation.
         * </p>
         * <p>
         * Each of the Amazon EC2 scenarios requires that you specify instance, image, and security group resources. If
         * your scenario includes an EBS volume, then you must specify that volume as a resource. If the Amazon EC2
         * scenario includes VPC, then you must supply the network interface resource. If it includes an IP subnet, then
         * you must specify the subnet resource. For more information on the Amazon EC2 scenario options, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported
         * platforms</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>EC2-VPC-InstanceStore</b>
         * </p>
         * <p>
         * instance, image, security group, network interface
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>EC2-VPC-InstanceStore-Subnet</b>
         * </p>
         * <p>
         * instance, image, security group, network interface, subnet
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>EC2-VPC-EBS</b>
         * </p>
         * <p>
         * instance, image, security group, network interface, volume
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>EC2-VPC-EBS-Subnet</b>
         * </p>
         * <p>
         * instance, image, security group, network interface, subnet, volume
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceHandlingOption
         *        Specifies the type of simulation to run. Different API operations that support resource-based policies
         *        require different combinations of resources. By specifying the type of simulation to run, you enable
         *        the policy simulator to enforce the presence of the required resources to ensure reliable simulation
         *        results. If your simulation does not match one of the following scenarios, then you can omit this
         *        parameter. The following list shows each of the supported scenario values and the resources that you
         *        must define to run the simulation.</p>
         *        <p>
         *        Each of the Amazon EC2 scenarios requires that you specify instance, image, and security group
         *        resources. If your scenario includes an EBS volume, then you must specify that volume as a resource.
         *        If the Amazon EC2 scenario includes VPC, then you must supply the network interface resource. If it
         *        includes an IP subnet, then you must specify the subnet resource. For more information on the Amazon
         *        EC2 scenario options, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported
         *        platforms</a> in the <i>Amazon EC2 User Guide</i>.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>EC2-VPC-InstanceStore</b>
         *        </p>
         *        <p>
         *        instance, image, security group, network interface
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>EC2-VPC-InstanceStore-Subnet</b>
         *        </p>
         *        <p>
         *        instance, image, security group, network interface, subnet
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>EC2-VPC-EBS</b>
         *        </p>
         *        <p>
         *        instance, image, security group, network interface, volume
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>EC2-VPC-EBS-Subnet</b>
         *        </p>
         *        <p>
         *        instance, image, security group, network interface, subnet, volume
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceHandlingOption(String resourceHandlingOption);

        /**
         * <p>
         * Use this only when paginating results to indicate the maximum number of items you want in the response. If
         * additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is
         * <code>true</code>.
         * </p>
         * <p>
         * If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer
         * results, even when there are more results available. In that case, the <code>IsTruncated</code> response
         * element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call
         * that tells the service where to continue from.
         * </p>
         * 
         * @param maxItems
         *        Use this only when paginating results to indicate the maximum number of items you want in the
         *        response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code>
         *        response element is <code>true</code>.</p>
         *        <p>
         *        If you do not include this parameter, the number of items defaults to 100. Note that IAM might return
         *        fewer results, even when there are more results available. In that case, the <code>IsTruncated</code>
         *        response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the
         *        subsequent call that tells the service where to continue from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        /**
         * <p>
         * Use this parameter only when paginating results and only after you receive a response indicating that the
         * results are truncated. Set it to the value of the <code>Marker</code> element in the response that you
         * received to indicate where the next call should start.
         * </p>
         * 
         * @param marker
         *        Use this parameter only when paginating results and only after you receive a response indicating that
         *        the results are truncated. Set it to the value of the <code>Marker</code> element in the response that
         *        you received to indicate where the next call should start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private String policySourceArn;

        private List<String> policyInputList = DefaultSdkAutoConstructList.getInstance();

        private List<String> permissionsBoundaryPolicyInputList = DefaultSdkAutoConstructList.getInstance();

        private List<String> actionNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> resourceArns = DefaultSdkAutoConstructList.getInstance();

        private String resourcePolicy;

        private String resourceOwner;

        private String callerArn;

        private List<ContextEntry> contextEntries = DefaultSdkAutoConstructList.getInstance();

        private String resourceHandlingOption;

        private Integer maxItems;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(SimulatePrincipalPolicyRequest model) {
            super(model);
            policySourceArn(model.policySourceArn);
            policyInputList(model.policyInputList);
            permissionsBoundaryPolicyInputList(model.permissionsBoundaryPolicyInputList);
            actionNames(model.actionNames);
            resourceArns(model.resourceArns);
            resourcePolicy(model.resourcePolicy);
            resourceOwner(model.resourceOwner);
            callerArn(model.callerArn);
            contextEntries(model.contextEntries);
            resourceHandlingOption(model.resourceHandlingOption);
            maxItems(model.maxItems);
            marker(model.marker);
        }

        public final String getPolicySourceArn() {
            return policySourceArn;
        }

        public final void setPolicySourceArn(String policySourceArn) {
            this.policySourceArn = policySourceArn;
        }

        @Override
        public final Builder policySourceArn(String policySourceArn) {
            this.policySourceArn = policySourceArn;
            return this;
        }

        public final Collection<String> getPolicyInputList() {
            if (policyInputList instanceof SdkAutoConstructList) {
                return null;
            }
            return policyInputList;
        }

        public final void setPolicyInputList(Collection<String> policyInputList) {
            this.policyInputList = SimulationPolicyListTypeCopier.copy(policyInputList);
        }

        @Override
        public final Builder policyInputList(Collection<String> policyInputList) {
            this.policyInputList = SimulationPolicyListTypeCopier.copy(policyInputList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyInputList(String... policyInputList) {
            policyInputList(Arrays.asList(policyInputList));
            return this;
        }

        public final Collection<String> getPermissionsBoundaryPolicyInputList() {
            if (permissionsBoundaryPolicyInputList instanceof SdkAutoConstructList) {
                return null;
            }
            return permissionsBoundaryPolicyInputList;
        }

        public final void setPermissionsBoundaryPolicyInputList(Collection<String> permissionsBoundaryPolicyInputList) {
            this.permissionsBoundaryPolicyInputList = SimulationPolicyListTypeCopier.copy(permissionsBoundaryPolicyInputList);
        }

        @Override
        public final Builder permissionsBoundaryPolicyInputList(Collection<String> permissionsBoundaryPolicyInputList) {
            this.permissionsBoundaryPolicyInputList = SimulationPolicyListTypeCopier.copy(permissionsBoundaryPolicyInputList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionsBoundaryPolicyInputList(String... permissionsBoundaryPolicyInputList) {
            permissionsBoundaryPolicyInputList(Arrays.asList(permissionsBoundaryPolicyInputList));
            return this;
        }

        public final Collection<String> getActionNames() {
            if (actionNames instanceof SdkAutoConstructList) {
                return null;
            }
            return actionNames;
        }

        public final void setActionNames(Collection<String> actionNames) {
            this.actionNames = ActionNameListTypeCopier.copy(actionNames);
        }

        @Override
        public final Builder actionNames(Collection<String> actionNames) {
            this.actionNames = ActionNameListTypeCopier.copy(actionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionNames(String... actionNames) {
            actionNames(Arrays.asList(actionNames));
            return this;
        }

        public final Collection<String> getResourceArns() {
            if (resourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceArns;
        }

        public final void setResourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceNameListTypeCopier.copy(resourceArns);
        }

        @Override
        public final Builder resourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceNameListTypeCopier.copy(resourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArns(String... resourceArns) {
            resourceArns(Arrays.asList(resourceArns));
            return this;
        }

        public final String getResourcePolicy() {
            return resourcePolicy;
        }

        public final void setResourcePolicy(String resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
        }

        @Override
        public final Builder resourcePolicy(String resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
            return this;
        }

        public final String getResourceOwner() {
            return resourceOwner;
        }

        public final void setResourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
        }

        @Override
        public final Builder resourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
            return this;
        }

        public final String getCallerArn() {
            return callerArn;
        }

        public final void setCallerArn(String callerArn) {
            this.callerArn = callerArn;
        }

        @Override
        public final Builder callerArn(String callerArn) {
            this.callerArn = callerArn;
            return this;
        }

        public final List<ContextEntry.Builder> getContextEntries() {
            List<ContextEntry.Builder> result = ContextEntryListTypeCopier.copyToBuilder(this.contextEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContextEntries(Collection<ContextEntry.BuilderImpl> contextEntries) {
            this.contextEntries = ContextEntryListTypeCopier.copyFromBuilder(contextEntries);
        }

        @Override
        public final Builder contextEntries(Collection<ContextEntry> contextEntries) {
            this.contextEntries = ContextEntryListTypeCopier.copy(contextEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contextEntries(ContextEntry... contextEntries) {
            contextEntries(Arrays.asList(contextEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contextEntries(Consumer<ContextEntry.Builder>... contextEntries) {
            contextEntries(Stream.of(contextEntries).map(c -> ContextEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getResourceHandlingOption() {
            return resourceHandlingOption;
        }

        public final void setResourceHandlingOption(String resourceHandlingOption) {
            this.resourceHandlingOption = resourceHandlingOption;
        }

        @Override
        public final Builder resourceHandlingOption(String resourceHandlingOption) {
            this.resourceHandlingOption = resourceHandlingOption;
            return this;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SimulatePrincipalPolicyRequest build() {
            return new SimulatePrincipalPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
