/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSamlProviderRequest
extends IamRequest
implements ToCopyableBuilder<Builder, UpdateSamlProviderRequest> {
    private static final SdkField<String> SAML_METADATA_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SAMLMetadataDocument").getter(UpdateSamlProviderRequest.getter(UpdateSamlProviderRequest::samlMetadataDocument)).setter(UpdateSamlProviderRequest.setter(Builder::samlMetadataDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMLMetadataDocument").build()}).build();
    private static final SdkField<String> SAML_PROVIDER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SAMLProviderArn").getter(UpdateSamlProviderRequest.getter(UpdateSamlProviderRequest::samlProviderArn)).setter(UpdateSamlProviderRequest.setter(Builder::samlProviderArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMLProviderArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAML_METADATA_DOCUMENT_FIELD, SAML_PROVIDER_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SAMLMetadataDocument", SAML_METADATA_DOCUMENT_FIELD);
            this.put("SAMLProviderArn", SAML_PROVIDER_ARN_FIELD);
        }
    });
    private final String samlMetadataDocument;
    private final String samlProviderArn;

    private UpdateSamlProviderRequest(BuilderImpl builder) {
        super(builder);
        this.samlMetadataDocument = builder.samlMetadataDocument;
        this.samlProviderArn = builder.samlProviderArn;
    }

    public final String samlMetadataDocument() {
        return this.samlMetadataDocument;
    }

    public final String samlProviderArn() {
        return this.samlProviderArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.samlMetadataDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.samlProviderArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSamlProviderRequest)) {
            return false;
        }
        UpdateSamlProviderRequest other = (UpdateSamlProviderRequest)((Object)obj);
        return Objects.equals(this.samlMetadataDocument(), other.samlMetadataDocument()) && Objects.equals(this.samlProviderArn(), other.samlProviderArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSamlProviderRequest").add("SAMLMetadataDocument", (Object)this.samlMetadataDocument()).add("SAMLProviderArn", (Object)this.samlProviderArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SAMLMetadataDocument": {
                return Optional.ofNullable(clazz.cast(this.samlMetadataDocument()));
            }
            case "SAMLProviderArn": {
                return Optional.ofNullable(clazz.cast(this.samlProviderArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSamlProviderRequest, T> g) {
        return obj -> g.apply((UpdateSamlProviderRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String samlMetadataDocument;
        private String samlProviderArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSamlProviderRequest model) {
            super(model);
            this.samlMetadataDocument(model.samlMetadataDocument);
            this.samlProviderArn(model.samlProviderArn);
        }

        public final String getSamlMetadataDocument() {
            return this.samlMetadataDocument;
        }

        public final void setSamlMetadataDocument(String samlMetadataDocument) {
            this.samlMetadataDocument = samlMetadataDocument;
        }

        @Override
        public final Builder samlMetadataDocument(String samlMetadataDocument) {
            this.samlMetadataDocument = samlMetadataDocument;
            return this;
        }

        public final String getSamlProviderArn() {
            return this.samlProviderArn;
        }

        public final void setSamlProviderArn(String samlProviderArn) {
            this.samlProviderArn = samlProviderArn;
        }

        @Override
        public final Builder samlProviderArn(String samlProviderArn) {
            this.samlProviderArn = samlProviderArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSamlProviderRequest build() {
            return new UpdateSamlProviderRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSamlProviderRequest> {
        public Builder samlMetadataDocument(String var1);

        public Builder samlProviderArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

