/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisableOrganizationsRootSessionsResponse extends IamResponse implements
        ToCopyableBuilder<DisableOrganizationsRootSessionsResponse.Builder, DisableOrganizationsRootSessionsResponse> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationId").getter(getter(DisableOrganizationsRootSessionsResponse::organizationId))
            .setter(setter(Builder::organizationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()).build();

    private static final SdkField<List<String>> ENABLED_FEATURES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EnabledFeatures")
            .getter(getter(DisableOrganizationsRootSessionsResponse::enabledFeaturesAsStrings))
            .setter(setter(Builder::enabledFeaturesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledFeatures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD,
            ENABLED_FEATURES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("OrganizationId", ORGANIZATION_ID_FIELD);
                    put("EnabledFeatures", ENABLED_FEATURES_FIELD);
                }
            });

    private final String organizationId;

    private final List<String> enabledFeatures;

    private DisableOrganizationsRootSessionsResponse(BuilderImpl builder) {
        super(builder);
        this.organizationId = builder.organizationId;
        this.enabledFeatures = builder.enabledFeatures;
    }

    /**
     * <p>
     * The unique identifier (ID) of an organization.
     * </p>
     * 
     * @return The unique identifier (ID) of an organization.
     */
    public final String organizationId() {
        return organizationId;
    }

    /**
     * <p>
     * The features you have enabled for centralized root access of member accounts in your organization.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnabledFeatures} method.
     * </p>
     * 
     * @return The features you have enabled for centralized root access of member accounts in your organization.
     */
    public final List<FeatureType> enabledFeatures() {
        return FeaturesListTypeCopier.copyStringToEnum(enabledFeatures);
    }

    /**
     * For responses, this returns true if the service returned a value for the EnabledFeatures property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnabledFeatures() {
        return enabledFeatures != null && !(enabledFeatures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The features you have enabled for centralized root access of member accounts in your organization.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnabledFeatures} method.
     * </p>
     * 
     * @return The features you have enabled for centralized root access of member accounts in your organization.
     */
    public final List<String> enabledFeaturesAsStrings() {
        return enabledFeatures;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnabledFeatures() ? enabledFeaturesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableOrganizationsRootSessionsResponse)) {
            return false;
        }
        DisableOrganizationsRootSessionsResponse other = (DisableOrganizationsRootSessionsResponse) obj;
        return Objects.equals(organizationId(), other.organizationId()) && hasEnabledFeatures() == other.hasEnabledFeatures()
                && Objects.equals(enabledFeaturesAsStrings(), other.enabledFeaturesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisableOrganizationsRootSessionsResponse").add("OrganizationId", organizationId())
                .add("EnabledFeatures", hasEnabledFeatures() ? enabledFeaturesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationId":
            return Optional.ofNullable(clazz.cast(organizationId()));
        case "EnabledFeatures":
            return Optional.ofNullable(clazz.cast(enabledFeaturesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DisableOrganizationsRootSessionsResponse, T> g) {
        return obj -> g.apply((DisableOrganizationsRootSessionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DisableOrganizationsRootSessionsResponse> {
        /**
         * <p>
         * The unique identifier (ID) of an organization.
         * </p>
         * 
         * @param organizationId
         *        The unique identifier (ID) of an organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationId(String organizationId);

        /**
         * <p>
         * The features you have enabled for centralized root access of member accounts in your organization.
         * </p>
         * 
         * @param enabledFeatures
         *        The features you have enabled for centralized root access of member accounts in your organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledFeaturesWithStrings(Collection<String> enabledFeatures);

        /**
         * <p>
         * The features you have enabled for centralized root access of member accounts in your organization.
         * </p>
         * 
         * @param enabledFeatures
         *        The features you have enabled for centralized root access of member accounts in your organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledFeaturesWithStrings(String... enabledFeatures);

        /**
         * <p>
         * The features you have enabled for centralized root access of member accounts in your organization.
         * </p>
         * 
         * @param enabledFeatures
         *        The features you have enabled for centralized root access of member accounts in your organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledFeatures(Collection<FeatureType> enabledFeatures);

        /**
         * <p>
         * The features you have enabled for centralized root access of member accounts in your organization.
         * </p>
         * 
         * @param enabledFeatures
         *        The features you have enabled for centralized root access of member accounts in your organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledFeatures(FeatureType... enabledFeatures);
    }

    static final class BuilderImpl extends IamResponse.BuilderImpl implements Builder {
        private String organizationId;

        private List<String> enabledFeatures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisableOrganizationsRootSessionsResponse model) {
            super(model);
            organizationId(model.organizationId);
            enabledFeaturesWithStrings(model.enabledFeatures);
        }

        public final String getOrganizationId() {
            return organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final Collection<String> getEnabledFeatures() {
            if (enabledFeatures instanceof SdkAutoConstructList) {
                return null;
            }
            return enabledFeatures;
        }

        public final void setEnabledFeatures(Collection<String> enabledFeatures) {
            this.enabledFeatures = FeaturesListTypeCopier.copy(enabledFeatures);
        }

        @Override
        public final Builder enabledFeaturesWithStrings(Collection<String> enabledFeatures) {
            this.enabledFeatures = FeaturesListTypeCopier.copy(enabledFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledFeaturesWithStrings(String... enabledFeatures) {
            enabledFeaturesWithStrings(Arrays.asList(enabledFeatures));
            return this;
        }

        @Override
        public final Builder enabledFeatures(Collection<FeatureType> enabledFeatures) {
            this.enabledFeatures = FeaturesListTypeCopier.copyEnumToString(enabledFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledFeatures(FeatureType... enabledFeatures) {
            enabledFeatures(Arrays.asList(enabledFeatures));
            return this;
        }

        @Override
        public DisableOrganizationsRootSessionsResponse build() {
            return new DisableOrganizationsRootSessionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
