/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GenerateOrganizationsAccessReportRequest extends IamRequest implements
        ToCopyableBuilder<GenerateOrganizationsAccessReportRequest.Builder, GenerateOrganizationsAccessReportRequest> {
    private static final SdkField<String> ENTITY_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityPath").getter(getter(GenerateOrganizationsAccessReportRequest::entityPath))
            .setter(setter(Builder::entityPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityPath").build()).build();

    private static final SdkField<String> ORGANIZATIONS_POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationsPolicyId").getter(getter(GenerateOrganizationsAccessReportRequest::organizationsPolicyId))
            .setter(setter(Builder::organizationsPolicyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationsPolicyId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_PATH_FIELD,
            ORGANIZATIONS_POLICY_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("EntityPath", ENTITY_PATH_FIELD);
                    put("OrganizationsPolicyId", ORGANIZATIONS_POLICY_ID_FIELD);
                }
            });

    private final String entityPath;

    private final String organizationsPolicyId;

    private GenerateOrganizationsAccessReportRequest(BuilderImpl builder) {
        super(builder);
        this.entityPath = builder.entityPath;
        this.organizationsPolicyId = builder.organizationsPolicyId;
    }

    /**
     * <p>
     * The path of the Organizations entity (root, OU, or account). You can build an entity path using the known
     * structure of your organization. For example, assume that your account ID is <code>123456789012</code> and its
     * parent OU ID is <code>ou-rge0-awsabcde</code>. The organization root ID is <code>r-f6g7h8i9j0example</code> and
     * your organization ID is <code>o-a1b2c3d4e5</code>. Your entity path is
     * <code>o-a1b2c3d4e5/r-f6g7h8i9j0example/ou-rge0-awsabcde/123456789012</code>.
     * </p>
     * 
     * @return The path of the Organizations entity (root, OU, or account). You can build an entity path using the known
     *         structure of your organization. For example, assume that your account ID is <code>123456789012</code> and
     *         its parent OU ID is <code>ou-rge0-awsabcde</code>. The organization root ID is
     *         <code>r-f6g7h8i9j0example</code> and your organization ID is <code>o-a1b2c3d4e5</code>. Your entity path
     *         is <code>o-a1b2c3d4e5/r-f6g7h8i9j0example/ou-rge0-awsabcde/123456789012</code>.
     */
    public final String entityPath() {
        return entityPath;
    }

    /**
     * <p>
     * The identifier of the Organizations service control policy (SCP). This parameter is optional.
     * </p>
     * <p>
     * This ID is used to generate information about when an account principal that is limited by the SCP attempted to
     * access an Amazon Web Services service.
     * </p>
     * 
     * @return The identifier of the Organizations service control policy (SCP). This parameter is optional.</p>
     *         <p>
     *         This ID is used to generate information about when an account principal that is limited by the SCP
     *         attempted to access an Amazon Web Services service.
     */
    public final String organizationsPolicyId() {
        return organizationsPolicyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(entityPath());
        hashCode = 31 * hashCode + Objects.hashCode(organizationsPolicyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateOrganizationsAccessReportRequest)) {
            return false;
        }
        GenerateOrganizationsAccessReportRequest other = (GenerateOrganizationsAccessReportRequest) obj;
        return Objects.equals(entityPath(), other.entityPath())
                && Objects.equals(organizationsPolicyId(), other.organizationsPolicyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GenerateOrganizationsAccessReportRequest").add("EntityPath", entityPath())
                .add("OrganizationsPolicyId", organizationsPolicyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EntityPath":
            return Optional.ofNullable(clazz.cast(entityPath()));
        case "OrganizationsPolicyId":
            return Optional.ofNullable(clazz.cast(organizationsPolicyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GenerateOrganizationsAccessReportRequest, T> g) {
        return obj -> g.apply((GenerateOrganizationsAccessReportRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GenerateOrganizationsAccessReportRequest> {
        /**
         * <p>
         * The path of the Organizations entity (root, OU, or account). You can build an entity path using the known
         * structure of your organization. For example, assume that your account ID is <code>123456789012</code> and its
         * parent OU ID is <code>ou-rge0-awsabcde</code>. The organization root ID is <code>r-f6g7h8i9j0example</code>
         * and your organization ID is <code>o-a1b2c3d4e5</code>. Your entity path is
         * <code>o-a1b2c3d4e5/r-f6g7h8i9j0example/ou-rge0-awsabcde/123456789012</code>.
         * </p>
         * 
         * @param entityPath
         *        The path of the Organizations entity (root, OU, or account). You can build an entity path using the
         *        known structure of your organization. For example, assume that your account ID is
         *        <code>123456789012</code> and its parent OU ID is <code>ou-rge0-awsabcde</code>. The organization root
         *        ID is <code>r-f6g7h8i9j0example</code> and your organization ID is <code>o-a1b2c3d4e5</code>. Your
         *        entity path is <code>o-a1b2c3d4e5/r-f6g7h8i9j0example/ou-rge0-awsabcde/123456789012</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityPath(String entityPath);

        /**
         * <p>
         * The identifier of the Organizations service control policy (SCP). This parameter is optional.
         * </p>
         * <p>
         * This ID is used to generate information about when an account principal that is limited by the SCP attempted
         * to access an Amazon Web Services service.
         * </p>
         * 
         * @param organizationsPolicyId
         *        The identifier of the Organizations service control policy (SCP). This parameter is optional.</p>
         *        <p>
         *        This ID is used to generate information about when an account principal that is limited by the SCP
         *        attempted to access an Amazon Web Services service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationsPolicyId(String organizationsPolicyId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private String entityPath;

        private String organizationsPolicyId;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateOrganizationsAccessReportRequest model) {
            super(model);
            entityPath(model.entityPath);
            organizationsPolicyId(model.organizationsPolicyId);
        }

        public final String getEntityPath() {
            return entityPath;
        }

        public final void setEntityPath(String entityPath) {
            this.entityPath = entityPath;
        }

        @Override
        public final Builder entityPath(String entityPath) {
            this.entityPath = entityPath;
            return this;
        }

        public final String getOrganizationsPolicyId() {
            return organizationsPolicyId;
        }

        public final void setOrganizationsPolicyId(String organizationsPolicyId) {
            this.organizationsPolicyId = organizationsPolicyId;
        }

        @Override
        public final Builder organizationsPolicyId(String organizationsPolicyId) {
            this.organizationsPolicyId = organizationsPolicyId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GenerateOrganizationsAccessReportRequest build() {
            return new GenerateOrganizationsAccessReportRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
