/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAccountAuthorizationDetailsRequest extends IamRequest implements
        ToCopyableBuilder<GetAccountAuthorizationDetailsRequest.Builder, GetAccountAuthorizationDetailsRequest> {
    private static final SdkField<List<String>> FILTER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Filter")
            .getter(getter(GetAccountAuthorizationDetailsRequest::filterAsStrings))
            .setter(setter(Builder::filterWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxItems").getter(getter(GetAccountAuthorizationDetailsRequest::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(GetAccountAuthorizationDetailsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD, MAX_ITEMS_FIELD,
            MARKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Filter", FILTER_FIELD);
                    put("MaxItems", MAX_ITEMS_FIELD);
                    put("Marker", MARKER_FIELD);
                }
            });

    private final List<String> filter;

    private final Integer maxItems;

    private final String marker;

    private GetAccountAuthorizationDetailsRequest(BuilderImpl builder) {
        super(builder);
        this.filter = builder.filter;
        this.maxItems = builder.maxItems;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * A list of entity types used to filter the results. Only the entities that match the types you specify are
     * included in the output. Use the value <code>LocalManagedPolicy</code> to include customer managed policies.
     * </p>
     * <p>
     * The format for this parameter is a comma-separated (if more than one) list of strings. Each string value in the
     * list must be one of the valid values listed below.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilter} method.
     * </p>
     * 
     * @return A list of entity types used to filter the results. Only the entities that match the types you specify are
     *         included in the output. Use the value <code>LocalManagedPolicy</code> to include customer managed
     *         policies.</p>
     *         <p>
     *         The format for this parameter is a comma-separated (if more than one) list of strings. Each string value
     *         in the list must be one of the valid values listed below.
     */
    public final List<EntityType> filter() {
        return _entityListTypeCopier.copyStringToEnum(filter);
    }

    /**
     * For responses, this returns true if the service returned a value for the Filter property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilter() {
        return filter != null && !(filter instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of entity types used to filter the results. Only the entities that match the types you specify are
     * included in the output. Use the value <code>LocalManagedPolicy</code> to include customer managed policies.
     * </p>
     * <p>
     * The format for this parameter is a comma-separated (if more than one) list of strings. Each string value in the
     * list must be one of the valid values listed below.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilter} method.
     * </p>
     * 
     * @return A list of entity types used to filter the results. Only the entities that match the types you specify are
     *         included in the output. Use the value <code>LocalManagedPolicy</code> to include customer managed
     *         policies.</p>
     *         <p>
     *         The format for this parameter is a comma-separated (if more than one) list of strings. Each string value
     *         in the list must be one of the valid values listed below.
     */
    public final List<String> filterAsStrings() {
        return filter;
    }

    /**
     * <p>
     * Use this only when paginating results to indicate the maximum number of items you want in the response. If
     * additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is
     * <code>true</code>.
     * </p>
     * <p>
     * If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer
     * results, even when there are more results available. In that case, the <code>IsTruncated</code> response element
     * returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells
     * the service where to continue from.
     * </p>
     * 
     * @return Use this only when paginating results to indicate the maximum number of items you want in the response.
     *         If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element
     *         is <code>true</code>.</p>
     *         <p>
     *         If you do not include this parameter, the number of items defaults to 100. Note that IAM might return
     *         fewer results, even when there are more results available. In that case, the <code>IsTruncated</code>
     *         response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the
     *         subsequent call that tells the service where to continue from.
     */
    public final Integer maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * Use this parameter only when paginating results and only after you receive a response indicating that the results
     * are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to
     * indicate where the next call should start.
     * </p>
     * 
     * @return Use this parameter only when paginating results and only after you receive a response indicating that the
     *         results are truncated. Set it to the value of the <code>Marker</code> element in the response that you
     *         received to indicate where the next call should start.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFilter() ? filterAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountAuthorizationDetailsRequest)) {
            return false;
        }
        GetAccountAuthorizationDetailsRequest other = (GetAccountAuthorizationDetailsRequest) obj;
        return hasFilter() == other.hasFilter() && Objects.equals(filterAsStrings(), other.filterAsStrings())
                && Objects.equals(maxItems(), other.maxItems()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAccountAuthorizationDetailsRequest").add("Filter", hasFilter() ? filterAsStrings() : null)
                .add("MaxItems", maxItems()).add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filter":
            return Optional.ofNullable(clazz.cast(filterAsStrings()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetAccountAuthorizationDetailsRequest, T> g) {
        return obj -> g.apply((GetAccountAuthorizationDetailsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetAccountAuthorizationDetailsRequest> {
        /**
         * <p>
         * A list of entity types used to filter the results. Only the entities that match the types you specify are
         * included in the output. Use the value <code>LocalManagedPolicy</code> to include customer managed policies.
         * </p>
         * <p>
         * The format for this parameter is a comma-separated (if more than one) list of strings. Each string value in
         * the list must be one of the valid values listed below.
         * </p>
         * 
         * @param filter
         *        A list of entity types used to filter the results. Only the entities that match the types you specify
         *        are included in the output. Use the value <code>LocalManagedPolicy</code> to include customer managed
         *        policies.</p>
         *        <p>
         *        The format for this parameter is a comma-separated (if more than one) list of strings. Each string
         *        value in the list must be one of the valid values listed below.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterWithStrings(Collection<String> filter);

        /**
         * <p>
         * A list of entity types used to filter the results. Only the entities that match the types you specify are
         * included in the output. Use the value <code>LocalManagedPolicy</code> to include customer managed policies.
         * </p>
         * <p>
         * The format for this parameter is a comma-separated (if more than one) list of strings. Each string value in
         * the list must be one of the valid values listed below.
         * </p>
         * 
         * @param filter
         *        A list of entity types used to filter the results. Only the entities that match the types you specify
         *        are included in the output. Use the value <code>LocalManagedPolicy</code> to include customer managed
         *        policies.</p>
         *        <p>
         *        The format for this parameter is a comma-separated (if more than one) list of strings. Each string
         *        value in the list must be one of the valid values listed below.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterWithStrings(String... filter);

        /**
         * <p>
         * A list of entity types used to filter the results. Only the entities that match the types you specify are
         * included in the output. Use the value <code>LocalManagedPolicy</code> to include customer managed policies.
         * </p>
         * <p>
         * The format for this parameter is a comma-separated (if more than one) list of strings. Each string value in
         * the list must be one of the valid values listed below.
         * </p>
         * 
         * @param filter
         *        A list of entity types used to filter the results. Only the entities that match the types you specify
         *        are included in the output. Use the value <code>LocalManagedPolicy</code> to include customer managed
         *        policies.</p>
         *        <p>
         *        The format for this parameter is a comma-separated (if more than one) list of strings. Each string
         *        value in the list must be one of the valid values listed below.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Collection<EntityType> filter);

        /**
         * <p>
         * A list of entity types used to filter the results. Only the entities that match the types you specify are
         * included in the output. Use the value <code>LocalManagedPolicy</code> to include customer managed policies.
         * </p>
         * <p>
         * The format for this parameter is a comma-separated (if more than one) list of strings. Each string value in
         * the list must be one of the valid values listed below.
         * </p>
         * 
         * @param filter
         *        A list of entity types used to filter the results. Only the entities that match the types you specify
         *        are included in the output. Use the value <code>LocalManagedPolicy</code> to include customer managed
         *        policies.</p>
         *        <p>
         *        The format for this parameter is a comma-separated (if more than one) list of strings. Each string
         *        value in the list must be one of the valid values listed below.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(EntityType... filter);

        /**
         * <p>
         * Use this only when paginating results to indicate the maximum number of items you want in the response. If
         * additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is
         * <code>true</code>.
         * </p>
         * <p>
         * If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer
         * results, even when there are more results available. In that case, the <code>IsTruncated</code> response
         * element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call
         * that tells the service where to continue from.
         * </p>
         * 
         * @param maxItems
         *        Use this only when paginating results to indicate the maximum number of items you want in the
         *        response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code>
         *        response element is <code>true</code>.</p>
         *        <p>
         *        If you do not include this parameter, the number of items defaults to 100. Note that IAM might return
         *        fewer results, even when there are more results available. In that case, the <code>IsTruncated</code>
         *        response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the
         *        subsequent call that tells the service where to continue from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        /**
         * <p>
         * Use this parameter only when paginating results and only after you receive a response indicating that the
         * results are truncated. Set it to the value of the <code>Marker</code> element in the response that you
         * received to indicate where the next call should start.
         * </p>
         * 
         * @param marker
         *        Use this parameter only when paginating results and only after you receive a response indicating that
         *        the results are truncated. Set it to the value of the <code>Marker</code> element in the response that
         *        you received to indicate where the next call should start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private List<String> filter = DefaultSdkAutoConstructList.getInstance();

        private Integer maxItems;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountAuthorizationDetailsRequest model) {
            super(model);
            filterWithStrings(model.filter);
            maxItems(model.maxItems);
            marker(model.marker);
        }

        public final Collection<String> getFilter() {
            if (filter instanceof SdkAutoConstructList) {
                return null;
            }
            return filter;
        }

        public final void setFilter(Collection<String> filter) {
            this.filter = _entityListTypeCopier.copy(filter);
        }

        @Override
        public final Builder filterWithStrings(Collection<String> filter) {
            this.filter = _entityListTypeCopier.copy(filter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterWithStrings(String... filter) {
            filterWithStrings(Arrays.asList(filter));
            return this;
        }

        @Override
        public final Builder filter(Collection<EntityType> filter) {
            this.filter = _entityListTypeCopier.copyEnumToString(filter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filter(EntityType... filter) {
            filter(Arrays.asList(filter));
            return this;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAccountAuthorizationDetailsRequest build() {
            return new GetAccountAuthorizationDetailsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
