/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetServiceLastAccessedDetailsWithEntitiesRequest extends IamRequest
        implements
        ToCopyableBuilder<GetServiceLastAccessedDetailsWithEntitiesRequest.Builder, GetServiceLastAccessedDetailsWithEntitiesRequest> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobId")
            .getter(getter(GetServiceLastAccessedDetailsWithEntitiesRequest::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<String> SERVICE_NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceNamespace").getter(getter(GetServiceLastAccessedDetailsWithEntitiesRequest::serviceNamespace))
            .setter(setter(Builder::serviceNamespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNamespace").build()).build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxItems").getter(getter(GetServiceLastAccessedDetailsWithEntitiesRequest::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(GetServiceLastAccessedDetailsWithEntitiesRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD,
            SERVICE_NAMESPACE_FIELD, MAX_ITEMS_FIELD, MARKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("JobId", JOB_ID_FIELD);
                    put("ServiceNamespace", SERVICE_NAMESPACE_FIELD);
                    put("MaxItems", MAX_ITEMS_FIELD);
                    put("Marker", MARKER_FIELD);
                }
            });

    private final String jobId;

    private final String serviceNamespace;

    private final Integer maxItems;

    private final String marker;

    private GetServiceLastAccessedDetailsWithEntitiesRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.serviceNamespace = builder.serviceNamespace;
        this.maxItems = builder.maxItems;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * The ID of the request generated by the <code>GenerateServiceLastAccessedDetails</code> operation.
     * </p>
     * 
     * @return The ID of the request generated by the <code>GenerateServiceLastAccessedDetails</code> operation.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The service namespace for an Amazon Web Services service. Provide the service namespace to learn when the IAM
     * entity last attempted to access the specified service.
     * </p>
     * <p>
     * To learn the service namespace for a service, see <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html"
     * >Actions, resources, and condition keys for Amazon Web Services services</a> in the <i>IAM User Guide</i>. Choose
     * the name of the service to view details for that service. In the first paragraph, find the service prefix. For
     * example, <code>(service prefix: a4b)</code>. For more information about service namespaces, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces"
     * >Amazon Web Services service namespaces</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * 
     * @return The service namespace for an Amazon Web Services service. Provide the service namespace to learn when the
     *         IAM entity last attempted to access the specified service.</p>
     *         <p>
     *         To learn the service namespace for a service, see <a href=
     *         "https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html"
     *         >Actions, resources, and condition keys for Amazon Web Services services</a> in the <i>IAM User
     *         Guide</i>. Choose the name of the service to view details for that service. In the first paragraph, find
     *         the service prefix. For example, <code>(service prefix: a4b)</code>. For more information about service
     *         namespaces, see <a href=
     *         "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces"
     *         >Amazon Web Services service namespaces</a> in the <i>Amazon Web Services General Reference</i>.
     */
    public final String serviceNamespace() {
        return serviceNamespace;
    }

    /**
     * <p>
     * Use this only when paginating results to indicate the maximum number of items you want in the response. If
     * additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is
     * <code>true</code>.
     * </p>
     * <p>
     * If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer
     * results, even when there are more results available. In that case, the <code>IsTruncated</code> response element
     * returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells
     * the service where to continue from.
     * </p>
     * 
     * @return Use this only when paginating results to indicate the maximum number of items you want in the response.
     *         If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element
     *         is <code>true</code>.</p>
     *         <p>
     *         If you do not include this parameter, the number of items defaults to 100. Note that IAM might return
     *         fewer results, even when there are more results available. In that case, the <code>IsTruncated</code>
     *         response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the
     *         subsequent call that tells the service where to continue from.
     */
    public final Integer maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * Use this parameter only when paginating results and only after you receive a response indicating that the results
     * are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to
     * indicate where the next call should start.
     * </p>
     * 
     * @return Use this parameter only when paginating results and only after you receive a response indicating that the
     *         results are truncated. Set it to the value of the <code>Marker</code> element in the response that you
     *         received to indicate where the next call should start.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(serviceNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServiceLastAccessedDetailsWithEntitiesRequest)) {
            return false;
        }
        GetServiceLastAccessedDetailsWithEntitiesRequest other = (GetServiceLastAccessedDetailsWithEntitiesRequest) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(serviceNamespace(), other.serviceNamespace())
                && Objects.equals(maxItems(), other.maxItems()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetServiceLastAccessedDetailsWithEntitiesRequest").add("JobId", jobId())
                .add("ServiceNamespace", serviceNamespace()).add("MaxItems", maxItems()).add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "ServiceNamespace":
            return Optional.ofNullable(clazz.cast(serviceNamespace()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetServiceLastAccessedDetailsWithEntitiesRequest, T> g) {
        return obj -> g.apply((GetServiceLastAccessedDetailsWithEntitiesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetServiceLastAccessedDetailsWithEntitiesRequest> {
        /**
         * <p>
         * The ID of the request generated by the <code>GenerateServiceLastAccessedDetails</code> operation.
         * </p>
         * 
         * @param jobId
         *        The ID of the request generated by the <code>GenerateServiceLastAccessedDetails</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The service namespace for an Amazon Web Services service. Provide the service namespace to learn when the IAM
         * entity last attempted to access the specified service.
         * </p>
         * <p>
         * To learn the service namespace for a service, see <a href=
         * "https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html"
         * >Actions, resources, and condition keys for Amazon Web Services services</a> in the <i>IAM User Guide</i>.
         * Choose the name of the service to view details for that service. In the first paragraph, find the service
         * prefix. For example, <code>(service prefix: a4b)</code>. For more information about service namespaces, see
         * <a href=
         * "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces"
         * >Amazon Web Services service namespaces</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param serviceNamespace
         *        The service namespace for an Amazon Web Services service. Provide the service namespace to learn when
         *        the IAM entity last attempted to access the specified service.</p>
         *        <p>
         *        To learn the service namespace for a service, see <a href=
         *        "https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html"
         *        >Actions, resources, and condition keys for Amazon Web Services services</a> in the <i>IAM User
         *        Guide</i>. Choose the name of the service to view details for that service. In the first paragraph,
         *        find the service prefix. For example, <code>(service prefix: a4b)</code>. For more information about
         *        service namespaces, see <a href=
         *        "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces"
         *        >Amazon Web Services service namespaces</a> in the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNamespace(String serviceNamespace);

        /**
         * <p>
         * Use this only when paginating results to indicate the maximum number of items you want in the response. If
         * additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is
         * <code>true</code>.
         * </p>
         * <p>
         * If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer
         * results, even when there are more results available. In that case, the <code>IsTruncated</code> response
         * element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call
         * that tells the service where to continue from.
         * </p>
         * 
         * @param maxItems
         *        Use this only when paginating results to indicate the maximum number of items you want in the
         *        response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code>
         *        response element is <code>true</code>.</p>
         *        <p>
         *        If you do not include this parameter, the number of items defaults to 100. Note that IAM might return
         *        fewer results, even when there are more results available. In that case, the <code>IsTruncated</code>
         *        response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the
         *        subsequent call that tells the service where to continue from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        /**
         * <p>
         * Use this parameter only when paginating results and only after you receive a response indicating that the
         * results are truncated. Set it to the value of the <code>Marker</code> element in the response that you
         * received to indicate where the next call should start.
         * </p>
         * 
         * @param marker
         *        Use this parameter only when paginating results and only after you receive a response indicating that
         *        the results are truncated. Set it to the value of the <code>Marker</code> element in the response that
         *        you received to indicate where the next call should start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private String jobId;

        private String serviceNamespace;

        private Integer maxItems;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServiceLastAccessedDetailsWithEntitiesRequest model) {
            super(model);
            jobId(model.jobId);
            serviceNamespace(model.serviceNamespace);
            maxItems(model.maxItems);
            marker(model.marker);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getServiceNamespace() {
            return serviceNamespace;
        }

        public final void setServiceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
        }

        @Override
        public final Builder serviceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetServiceLastAccessedDetailsWithEntitiesRequest build() {
            return new GetServiceLastAccessedDetailsWithEntitiesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
